﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Diagnostics;


using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>プロジェクトプロパティ表示画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.5.0][2014/11/01][新規作成]</para>
    /// </remarks>
    public partial class McDotNetProjectPropertyDispForm : HySDotNetForm
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetNewProjectForm csNewProjectForm = new McDotNetNewProjectForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        public McDotNetProjectPropertyDispForm()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetProjectPropertyDispForm csNewForm = new McDotNetProjectPropertyDispForm(csModelInfoList);</para>
        /// </example>
        /// <param name="csPrjctInfo">プロジェクト情報</param>
        /// <param name="csModelInfoList">リンクリスト</param>
        /// <returns>McDotNetProjectPropertyDispForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>★派生クラス側は必ず本コンストラクターを実装する★</para>
        /// </remarks>
        public McDotNetProjectPropertyDispForm(McProjectInfData csPrjctInfo, List<McProjectModelInfo> csModelInfoList)
        {
            InitializeComponent();  // <-- 画面を表示させる為に必ず必要 ●必須●
            Init(csPrjctInfo, csModelInfoList);
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>ヘルプボタンクリック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HelButton_click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_PROJECT_0013, null);
        }

        /// <summary><para>method outline:</para>
        /// <para>初期設定（画面表示）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Init(csPrjctInfo, csModelInfoList);</para>
        /// </example>
        /// <param name="csPrjctInfo">プロジェクト情報</param>
        /// <param name="csModelInfoList">リンクリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Init(McProjectInfData csPrjctInfo, List<McProjectModelInfo> csModelInfoList)
        {
            McProjectModelInfo csModelInfo = null;  // モデル一覧リスト情報
            TreeNode[] csTreeRoot = null;           // ツリーコントロール
            TreeNode csTreeNode = null;             // 要素モデル名称：
            TreeNode csTreeNodeSub1 = null;         // ＤＬＬ名称：
            TreeNode csTreeNodeSub2 = null;         // ファクトリー識別子：
            TreeNode csTreeNodeSub3 = null;         // 使用数
            TreeNode csTreeNodeSub4 = null;         // 名前空間：
            TreeNode csTreeNodeSub5 = null;         // モデル作成者：
            TreeNode csTreeNodeSub6 = null;         // モデル概要：
            TreeNode csTreeNodeSub7 = null;         // 読み込みファイル名
            TreeNode csTreeNodeSub8 = null;         // 読み込みファイル名（詳細）

            // ---------------------------------------------
            // プロジェクト情報作成
            // ---------------------------------------------
            TextProGrName.Text = csPrjctInfo.GetProjectGroupName().ToString();  // プロジェクトグループ名
            TextProName.Text = csPrjctInfo.GetProjectName().ToString();         // プロジェクト名
            TextManager.Text = csPrjctInfo.GetAdminName().ToString();           // 管理者名
            TextType.Text = csPrjctInfo.GetModelType().ToString();              // 種別
            TextObject.Text = csPrjctInfo.GetModelTarget().ToString();          // 対象

            // ---------------------------------------------
            // 使用要素モデル情報作成
            // ---------------------------------------------
            treeViewModel.Nodes.Clear();
            csTreeRoot = new TreeNode[csModelInfoList.Count()];

            for (int i = 0; i < csModelInfoList.Count(); i++)
            {
                // モデル一覧リスト情報
                csModelInfo = csModelInfoList[i];

                // 要素モデル名称
                if (csModelInfo.m_sModelName == null)
                {
                    continue;
                }

                if (csModelInfo.m_sModelName.Length == 0)
                {
                    csModelInfo.m_sModelName = "?";
                }
                csTreeNode = new TreeNode(csModelInfo.m_sModelName);

                csTreeNodeSub1 = new TreeNode(Properties.McDotNetViewerResources.PROJECT_PROP_DLL + csModelInfo.m_sDLLName);
                csTreeNodeSub2 = new TreeNode(Properties.McDotNetViewerResources.PROJECT_PROP_FACTORY + csModelInfo.m_sFactoryID);
                csTreeNodeSub3 = new TreeNode(Properties.McDotNetViewerResources.PROJECT_PROP_COUNT + csModelInfo.m_lUsedNumber.ToString());
                csTreeNodeSub4 = new TreeNode(Properties.McDotNetViewerResources.PROJECT_PROP_NAMESPACE + csModelInfo.m_sNameSpace);
                csTreeNodeSub5 = new TreeNode(Properties.McDotNetViewerResources.PROJECT_PROP_CREATOR + csModelInfo.m_csCreator);
                csTreeNodeSub6 = new TreeNode(Properties.McDotNetViewerResources.PROJECT_PROP_SUMMARY + csModelInfo.m_csSummary);
                csTreeNodeSub7 = new TreeNode(Properties.McDotNetViewerResources.PROJECT_PROP_READFILE);
                csTreeNodeSub8 = null;

                for (int j = 0; j < csModelInfo.m_csReadFileList.Count(); j++)
                {
                    if (csModelInfo.m_csReadFileList[j].Length == 0)
                    {
                        continue;
                    }
                    csTreeNodeSub8 = new TreeNode(csModelInfo.m_csReadFileList[j]);
                    csTreeNodeSub7.Nodes.Add(csTreeNodeSub8);
                }

                csTreeNode.Nodes.Add(csTreeNodeSub1);
                csTreeNode.Nodes.Add(csTreeNodeSub2);
                csTreeNode.Nodes.Add(csTreeNodeSub3);
                csTreeNode.Nodes.Add(csTreeNodeSub4);
                csTreeNode.Nodes.Add(csTreeNodeSub5);
                csTreeNode.Nodes.Add(csTreeNodeSub6);
                csTreeNode.Nodes.Add(csTreeNodeSub7);

                // 展開
                csTreeNode.Expand();
                csTreeNodeSub7.Expand();

                if (csTreeNodeSub8 == null)
              //if (csModelInfo.m_csMdlInf.GetDivision() == McModelLibraryDefine.DIVISION_OUTPUT_MODEL)
                {
                    // 出力モデルの場合は使用ファイルを表示しない
                    csTreeNode.Nodes.Remove(csTreeNodeSub7);
                }

                // ノードを追加
                csTreeRoot[i] = csTreeNode;
            }

            // ノードを追加
            treeViewModel.Nodes.AddRange(csTreeRoot);
        }
    }
}
