﻿// <summary>ソースコード：ＨＹＭＣＯプロジェクト登録画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.Tool;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.Interface;

using CommonMP.HYMCO.CoreImpl.Tool.Msg;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>プロジェクト登録画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public partial class McDotNetProjectRegistForm : HySDotNetForm
    {
        /// <summary>
        /// 登録データクラスインスタンス
        /// </summary>
        private McProjectInfData m_csProjectData;

        /// <summary>ログ出力用クラス名称</summary>
        static private readonly string LOG_CLASS_NAME = "McDotNetProjectRegistForm";

        ///// <summary>エラーメッセージタイトル </summary>
        //static private readonly string ERROR_MSGBOX_TITLE = "エラー";

        /// <summary>メッセージボックスタイトル『プロジェクト管理機能』</summary>
        static private readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_PROJECT_MANAGEMENT");

        ///// <summary>メッセージ「期間入力異常」 </summary>
        //static private readonly string MSG_ERROR_PERIOD_DATE = "期間の指定が正しくありません。";
		/// <summary>メッセージ『期間の指定が正しくありません。』 </summary>
        static private readonly string MSG_ERROR_PERIOD_DATE = HysMessage.GetString("HYS_MSG_WARNING_PERIOD_DATE");

        ///// <summary>メッセージ「プロジェクト名入力異常」 </summary>
        //static private readonly string MSG_ERROR_PROJECT_NAME = "プロジェクト名に使用できない文字が含まれています。\n禁止文字　" + @"\ / : , ; * ? "" < > |";
		/// <summary>メッセージ『プロジェクト名に使用できない文字が含まれています。\n 禁止文字　\ / : , ; * ? |</summary>
		static private readonly string MSG_ERROR_PROJECT_NAME = McMessage.GetString("MC_MSG_WARNING_PROJECT_NAME");

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetProjectRegistForm csProjectRegistForm = new McDotNetProjectRegistForm(csScreen, csFormData);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <param name="csPrjData">プロジェクト管理データクラス</param>
        /// <returns>McDotNetProjectRegistForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetProjectRegistForm(HySScreen csScreen, McProjectInfData csPrjData)
        {
            InitializeComponent();
            m_csScreen = csScreen;
            m_csProjectData = csPrjData; // データクラスのインスタンスをセット

            // プロジェクト情報を画面に設定 
            ShowProjectData();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ShowProjectData();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ShowProjectData()
        {
            // 対応するコントロールに値を設定
// Ver1.1 追加 >>>
            if ((object)m_csProjectData.GetProjectGroupName() != null)
            {
                // プロジェクトグループ名
                ProjectGroupBox.Text = m_csProjectData.GetProjectGroupName().ToString();
            }
// Ver1.1 追加 <<<
            if ((object)m_csProjectData.GetProjectName() != null)
            {
                // プロジェクト名
                ProjectNameBox.Text = m_csProjectData.GetProjectName().ToString();
            }
            if ((object)m_csProjectData.GetAdminName() != null)
            {
                // 管理者名
                AdminNameBox.Text = m_csProjectData.GetAdminName().ToString();
            }
            if ((object)m_csProjectData.GetModelType() != null)
            {
                // 種別
                KindBox.Text = m_csProjectData.GetModelType().ToString();
            }
            if ((object)m_csProjectData.GetModelTarget() != null)
            {
                // 対象
                TartgetBox.Text = m_csProjectData.GetModelTarget().ToString();
            }
            if ((object)m_csProjectData.GetModelCalcType() != null)
            {
                // モデル
                ModelBox.Text = m_csProjectData.GetModelCalcType().ToString();
            }
            if ((object)m_csProjectData.GetModelSubject() != null)
            {
                // 件名
                SubjectBox.Text = m_csProjectData.GetModelSubject().ToString();
            }
            if ((object)m_csProjectData.GetModelSituation() != null)
            {
                // ケース名
                CaseNameBox.Text = m_csProjectData.GetModelSituation().ToString();
            }
            if (m_csProjectData.GetModelPeriodType() == McProjectInfData.ModelPeriodType.REGULARITY)
            {
                // 期間種別
                PeriodComboBox.SelectedIndex = 2;

                // 期間
                PeriodFromDateTimePicker.Enabled = false;
                PeriodToDateTimePicker.Enabled = false;
            }
            else if (m_csProjectData.GetModelPeriodType() == McProjectInfData.ModelPeriodType.PERIOD)
            {
                // 期間種別
                PeriodComboBox.SelectedIndex = 1;

                // 期間
                PeriodFromDateTimePicker.Value = DateTime.Parse(HySCalendar.GetString((HySTime)m_csProjectData.GetModelPeriod().GetFrom(), 0).ToString());
                PeriodFromDateTimePicker.Enabled = true;
                PeriodToDateTimePicker.Value = DateTime.Parse(HySCalendar.GetString((HySTime)m_csProjectData.GetModelPeriod().GetTo(), 0).ToString());
                PeriodToDateTimePicker.Enabled = true;
            }
            else if (m_csProjectData.GetModelPeriodType() == McProjectInfData.ModelPeriodType.NonType)
            {
                // 期間種別
                PeriodComboBox.SelectedIndex = 0;

                // 期間
                PeriodFromDateTimePicker.Enabled = false;
                PeriodToDateTimePicker.Enabled = false;
            }
            if ((object)m_csProjectData.GetThresholdCondition1() != null)
            {
                // 境界条件１
                Boundaries1Box.Text = m_csProjectData.GetThresholdCondition1().ToString();
            }
            if ((object)m_csProjectData.GetThresholdCondition2() != null)
            {
                // 境界条件２
                Boundaries2Box.Text = m_csProjectData.GetThresholdCondition2().ToString();
            }
            if ((object)m_csProjectData.GetThresholdCondition3() != null)
            {
                // 境界条件３
                Boundaries3Box.Text = m_csProjectData.GetThresholdCondition3().ToString();
            }
            if ((object)m_csProjectData.GetThresholdCondition4() != null)
            {
                // 境界条件４
                Boundaries4Box.Text = m_csProjectData.GetThresholdCondition4().ToString();
            }
            if ((object)m_csProjectData.GetThresholdCondition5() != null)
            {
                // 境界条件５
                Boundaries5Box.Text = m_csProjectData.GetThresholdCondition5().ToString();
            }
            if ((object)m_csProjectData.GetCondition1() != null)
            {
                // 条件１
                Condition1Box.Text = m_csProjectData.GetCondition1().ToString();
            }
            if ((object)m_csProjectData.GetCondition2() != null)
            {
                // 条件２
                Condition2Box.Text = m_csProjectData.GetCondition2().ToString();
            }
            if ((object)m_csProjectData.GetCondition3() != null)
            {
                // 条件３
                Condition3Box.Text = m_csProjectData.GetCondition3().ToString();
            }
            if ((object)m_csProjectData.GetCondition4() != null)
            {
                // 条件４
                Condition4Box.Text = m_csProjectData.GetCondition4().ToString();
            }
            if ((object)m_csProjectData.GetCondition5() != null)
            {
                // 条件５
                Condition5Box.Text = m_csProjectData.GetCondition5().ToString();
            }
            if ((object)m_csProjectData.GetCreateDate() != null)
            {
                // 作成日
                CreateDate.Value = DateTime.Parse(HySCalendar.GetString(m_csProjectData.GetCreateDate(), 0).ToString());
            }
            if ((object)m_csProjectData.GetComment() != null)
            {
                // 備考
                CommentBox.Text = m_csProjectData.GetComment().ToString();
            }
        }

        /// <summary><para>method outline</para>
        /// <para>登録</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Registration_Button.Click += new System.EventHandler(this.Registration);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Registration(object sender, EventArgs e)
        {
            string strErrMsg;
            // プロジェクト名称の取得 
            HySString csPrjName = new HySString(this.ProjectNameBox.Text);
            HySEventObject csEvent = null;

            // 期間入力チェック
            if (PeriodComboBox.SelectedIndex == 1)
            {
                long lYear = (long)(PeriodFromDateTimePicker.Value.Year);
                long lMonth = (long)(PeriodFromDateTimePicker.Value.Month);
                long lDate = (long)(PeriodFromDateTimePicker.Value.Day);
                HySTime csFromTime = HySCalendar.CreateTime(lYear, lMonth, lDate, 0L, 0L, 0L);
                lYear = (long)(PeriodToDateTimePicker.Value.Year);
                lMonth = (long)(PeriodToDateTimePicker.Value.Month);
                lDate = (long)(PeriodToDateTimePicker.Value.Day);
                HySTime csToTime = HySCalendar.CreateTime(lYear, lMonth, lDate, 0L, 0L, 0L);
                if ((csFromTime.Before(csToTime) == false) && (csFromTime.Equals(csToTime) == false))
                {
                    //MessageBox.Show(MSG_ERROR_PERIOD_DATE, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    MessageBox.Show(MSG_ERROR_PERIOD_DATE, MSGBOX_TITLE,MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return;
                }
            }

            string sErrCharacter = @"\/:,;*?""<>|";
            if (ProjectNameBox.Text.IndexOfAny(sErrCharacter.ToCharArray()) != -1)
            {
                //MessageBox.Show(MSG_ERROR_PROJECT_NAME, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                MessageBox.Show(MSG_ERROR_PROJECT_NAME, MSGBOX_TITLE,MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return;
            }

            // プロジェクト名称が変更されたかチェックする
            if (m_csProjectData.GetProjectName().Equal(csPrjName) == false)
            {
                // プロジェクト情報クラス作成
                McProjectInfData csRegistPrjInf = new McProjectInfData();

                // 入力情報の設定
                GetInputData(csRegistPrjInf);

                // DBコピー登録イベント生成
                csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DB_REGISTER, m_csProjectData.GetProjectID());
                csEvent.SetSubEventNo(McDefine.HYM_LIBRARY_COPY_REGISTER);
                csEvent.SetData((HySDataRoot)csRegistPrjInf);
               // ver1.5 エラートレース日本語対応
                strErrMsg = Properties.McDotNetViewerResources.STATEMENT_CMND_DB_REGST_NG + "(HYM_LIBRARY_COPY_REGISTER)";
               // strErrMsg = "PutEvent CMND_DB_REGISTER(HYM_LIBRARY_COPY_REGISTER) is failed.";
            }
            else
            {
                // 元のプロジェクト情報インスタンスを使う
                // 入力情報の設定
                GetInputData(m_csProjectData);

                // DB登録イベント生成
                csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DB_REGISTER, m_csProjectData.GetProjectID());
               // ver1.5 エラートレース日本語対応
                strErrMsg = Properties.McDotNetViewerResources.STATEMENT_CMND_DB_REGST_NG;
               // strErrMsg = "PutEvent CMND_DB_REGISTER is failed.";
            }
            // シミュレータ種別設定
            csEvent.SetToSimKind(m_csProjectData.GetSimulatorKind());
            // イベント送信
            if (false == this.PutEvent(csEvent))
            {
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "Registration", strErrMsg);
            } 
            Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>入力情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> this.GetInputData(csPrjInfData); </para>
        /// </example>
        /// <param name="csPrjInfData">プロジェクト情報クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GetInputData(McProjectInfData csPrjInfData)
        {
// Ver1.1 追加 >>>
            // プロジェクトグループ名称
            HySString csStr = new HySString(ProjectGroupBox.Text);
            csPrjInfData.SetProjectGroupName(csStr);
// Ver1.1 追加 <<<
            // プロジェクト名称
            csStr = new HySString(ProjectNameBox.Text);
            csPrjInfData.SetProjectName(csStr);
            // 管理者名
            csStr = new HySString(AdminNameBox.Text);
            csPrjInfData.SetAdminName(csStr);
            // 種別
            csStr = new HySString(KindBox.Text);
            csPrjInfData.SetModelType(csStr);
            // 対象
            csStr = new HySString(TartgetBox.Text);
            csPrjInfData.SetModelTarget(csStr);
            // モデル
            csStr = new HySString(ModelBox.Text);
            csPrjInfData.SetModelCalcType(csStr);
            // 件名
            csStr = new HySString(SubjectBox.Text);
            csPrjInfData.SetModelSubject(csStr);
            // ケース名
            csStr = new HySString(CaseNameBox.Text);
            csPrjInfData.SetModelSituation(csStr);
            if (PeriodComboBox.SelectedIndex == 2)
            {
                // 期間種別
                csPrjInfData.SetModelPeriodType(McProjectInfData.ModelPeriodType.REGULARITY);

                // 期間
                csPrjInfData.SetModelPeriod(null);
            }
            else if (PeriodComboBox.SelectedIndex == 1)
            {
                // 期間種別
                csPrjInfData.SetModelPeriodType(McProjectInfData.ModelPeriodType.PERIOD);

                // 期間
                long lFromYear = (long)(PeriodFromDateTimePicker.Value.Year);
                long lFromMonth = (long)(PeriodFromDateTimePicker.Value.Month);
                long lFromDate = (long)(PeriodFromDateTimePicker.Value.Day);
                long lToYear = (long)(PeriodToDateTimePicker.Value.Year);
                long lToMonth = (long)(PeriodToDateTimePicker.Value.Month);
                long lToDate = (long)(PeriodToDateTimePicker.Value.Day);
                csPrjInfData.SetModelPeriod(new McRange(HySCalendar.CreateTime(lFromYear, lFromMonth, lFromDate, 0L, 0L, 0L), HySCalendar.CreateTime(lToYear, lToMonth, lToDate, 0L, 0L, 0L)));
            }
            else
            {
                // 期間種別
                csPrjInfData.SetModelPeriodType(McProjectInfData.ModelPeriodType.NonType);

                // 期間
                csPrjInfData.SetModelPeriod(null);
            }
            // 境界条件１
            csStr = new HySString(Boundaries1Box.Text);
            csPrjInfData.SetThresholdCondition1(csStr);
            // 境界条件２
            csStr = new HySString(Boundaries2Box.Text);
            csPrjInfData.SetThresholdCondition2(csStr);
            // 境界条件３
            csStr = new HySString(Boundaries3Box.Text);
            csPrjInfData.SetThresholdCondition3(csStr);
            // 境界条件４
            csStr = new HySString(Boundaries4Box.Text);
            csPrjInfData.SetThresholdCondition4(csStr);
            // 境界条件５
            csStr = new HySString(Boundaries5Box.Text);
            csPrjInfData.SetThresholdCondition5(csStr);
            // 条件１
            csStr = new HySString(Condition1Box.Text);
            csPrjInfData.SetCondition1(csStr);
            // 条件２
            csStr = new HySString(Condition2Box.Text);
            csPrjInfData.SetCondition2(csStr);
            // 条件３
            csStr = new HySString(Condition3Box.Text);
            csPrjInfData.SetCondition3(csStr);
            // 条件４
            csStr = new HySString(Condition4Box.Text);
            csPrjInfData.SetCondition4(csStr);
            // 条件５
            csStr = new HySString(Condition5Box.Text);
            csPrjInfData.SetCondition5(csStr);

            // 作成日
            long lYear = (long)(CreateDate.Value.Year);
            long lMonth = (long)(CreateDate.Value.Month);
            long lDate = (long)(CreateDate.Value.Day);
            HySTime csTime = HySCalendar.CreateTime(lYear, lMonth, lDate, 0L, 0L, 0L);
            csPrjInfData.SetCreateDate(csTime);

            // 備考
            csStr = new HySString(CommentBox.Text);
            csPrjInfData.SetComment(csStr);
        }

        /// <summary><para>method outline</para>
        /// <para>キャンセルクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Cancel_Button.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel(object sender, EventArgs e)
        {
            Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public override Boolean PutEvent(HySSysEvent csEvent)
        {
            Boolean bRtn = false;

            // 処理(スクリーンクラスのPutEventをコールする)
            bRtn = m_csScreen.PutEvent(csEvent);

            return bRtn;
        }

// Ver1.1 追加 >>>
        /// <summary><para>method outline</para>
        /// <para>プロジェクトグループ名称入力変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ProjectGroupBox_TextChanged.TextChanged += new System.EventHandler(this.ProjectGroupBox_TextChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ProjectGroupBox_TextChanged(object sender, EventArgs e)
        {
            ChangeRegistButtonEnabled();
        }
// Ver1.1 追加 <<<

        /// <summary><para>method outline</para>
        /// <para>プロジェクト名称入力変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ProjectNameBox.TextChanged += new System.EventHandler(this.ProjectNameBox_TextChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ProjectNameBox_TextChanged(object sender, EventArgs e)
        {
            // 必須項目のチェック
            ChangeRegistButtonEnabled();
        }

        /// <summary><para>method outline</para>
        /// <para>管理者名入力変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.AdminNameBox.TextChanged += new System.EventHandler(this.AdminName_TextChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AdminName_TextChanged(object sender, EventArgs e)
        {
            // 必須項目のチェック
            ChangeRegistButtonEnabled();
        }

        /// <summary><para>method outline</para>
        /// <para>登録ボタン有効無効変更</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ChangeRegistButtonEnabled();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>必須項目が入力されていないときに登録ボタンを押せなくする</para>
        /// </remarks>
        private void ChangeRegistButtonEnabled()
        {
            // 必須項目が入力されていない場合、登録ボタンを非活性にする
            if ((AdminNameBox.Text != string.Empty) && (ProjectNameBox.Text != string.Empty) && (ProjectGroupBox.Text != string.Empty))     // Ver1.1 修正
            {
                Registration_Button.Enabled = true;
            }
            else
            {
                Registration_Button.Enabled = false;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>期間種別選択変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>PeriodComboBox_SelectedIndexChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PeriodComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (PeriodComboBox.SelectedIndex == 1)
            {
                PeriodFromDateTimePicker.Enabled = true;
                PeriodToDateTimePicker.Enabled = true;
            }
            else
            {
                PeriodFromDateTimePicker.Enabled = false;
                PeriodToDateTimePicker.Enabled = false;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_PROJECT_0003,
                        ((HySDotNetViewer)((McDotNetProjectCtlScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }
    }
}