﻿// <summary>ソースコード：ＨＹＭＣＯプロジェクト保存画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.CoreImpl.Data.Tool;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.Interface;

using CommonMP.HYMCO.CoreImpl.Tool.Msg;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>プロジェクト保存画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/09][新規作成]</para>
    /// </remarks>
    public partial class McDotNetProjectSaveForm : HySDotNetForm
    {
        /// <summary>
        /// 登録データクラスインスタンス
        /// </summary>
        private McProjectInfData m_csProjectData;

        ///// <summary>ログ出力用クラス名称</summary>
        static private readonly string LOG_CLASS_NAME = "McDotNetProjectSaveForm";

        ///// <summary>エラーメッセージタイトル </summary>
        //static private readonly string ERROR_MSGBOX_TITLE = "エラー";

        /// <summary>メッセージボックスタイトル『プロジェクト管理機能』</summary>
        static private readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_PROJECT_MANAGEMENT");

        ///// <summary>メッセージ「期間入力異常」 </summary>
        //static private readonly string MSG_ERROR_PERIOD_DATE = "期間の指定が正しくありません。";
		/// <summary>メッセージ『期間の指定が正しくありません。』 </summary>
        static private readonly string MSG_ERROR_PERIOD_DATE = HysMessage.GetString("HYS_MSG_WARNING_PERIOD_DATE");

        ///// <summary>メッセージ「プロジェクト名入力異常」 </summary>
        //static private readonly string MSG_ERROR_PROJECT_NAME = "プロジェクト名に使用できない文字が含まれています。\n禁止文字　" + @"\ / : , ; * ? "" < > |";
		/// <summary>メッセージ『プロジェクト名に使用できない文字が含まれています。\n 禁止文字　\ / : , ; * ? |</summary>
		static private readonly string MSG_ERROR_PROJECT_NAME = McMessage.GetString("MC_MSG_WARNING_PROJECT_NAME");

        ///// <summary>メッセージ「同一プロジェクト名」 </summary>
        //static private readonly string MSG_ERROR_PERIOD_DATE = "既に同一名称のプロジェクト名が存在します。";
        static private readonly string MSG_ERROR_PROJECT_EXIST = McMessage.GetString("MC_MSG_WARNING_PROJECT_EXIST");
        ///// <summary>メッセージ「同一ファイル名」 </summary>
        //static private readonly string MSG_ERROR_PERIOD_DATE = "既に同一名称のファイルが存在します。上書きしてよろしいですか？";
        static private readonly string MSG_MSG_INFO_FILE_EXIST = McMessage.GetString("MC_MSG_INFO_FILE_EXIST");

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetProjectSaveForm csProjectSaveForm = new McDotNetProjectSaveForm(csScreen, csFormData);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <param name="csPrjData">プロジェクト管理データクラス</param>
        /// <returns>McDotNetProjectSaveForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetProjectSaveForm(HySScreen csScreen, McProjectInfData csPrjData)
        {
            InitializeComponent();
            m_csScreen = csScreen;
            m_csProjectData = csPrjData; // データクラスのインスタンスをセット

            // プロジェクト情報を画面に設定 
            ShowProjectData();
            // Ver1.1改良 操作性改善
            Label2.Visible = false;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ShowProjectData();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ShowProjectData()
        {
            // 対応するコントロールに値を設定
            if ((object)m_csProjectData.GetProjectGroupName() != null)
            {
                // プロジェクトグループ名
                ProjectGroupBox.Text = m_csProjectData.GetProjectGroupName().ToString();
            }
            if ((object)m_csProjectData.GetProjectName() != null)
            {
                // プロジェクト名
                ProjectNameBox.Text = m_csProjectData.GetProjectName().ToString();
            }
            if ((object)m_csProjectData.GetAdminName() != null)
            {
                // 管理者名
                AdminNameBox.Text = m_csProjectData.GetAdminName().ToString();
            }
            if ((object)m_csProjectData.GetModelType() != null)
            {
                // 種別
                KindBox.Text = m_csProjectData.GetModelType().ToString();
            }
            if ((object)m_csProjectData.GetModelTarget() != null)
            {
                // 対象
                TartgetBox.Text = m_csProjectData.GetModelTarget().ToString();
            }
            if ((object)m_csProjectData.GetModelCalcType() != null)
            {
                // モデル
                ModelBox.Text = m_csProjectData.GetModelCalcType().ToString();
            }
            if ((object)m_csProjectData.GetModelSubject() != null)
            {
                // 件名
                SubjectBox.Text = m_csProjectData.GetModelSubject().ToString();
            }
            if ((object)m_csProjectData.GetModelSituation() != null)
            {
                // ケース名
                CaseNameBox.Text = m_csProjectData.GetModelSituation().ToString();
            }
            if (m_csProjectData.GetModelPeriodType() == McProjectInfData.ModelPeriodType.REGULARITY)
            {
                // 期間種別
                PeriodComboBox.SelectedIndex = 2;

                // 期間
                PeriodFromDateTimePicker.Enabled = false;
                PeriodToDateTimePicker.Enabled = false;
            }
            else if (m_csProjectData.GetModelPeriodType() == McProjectInfData.ModelPeriodType.PERIOD)
            {
                // 期間種別
                PeriodComboBox.SelectedIndex = 1;

                // 期間
                PeriodFromDateTimePicker.Value = DateTime.Parse(HySCalendar.GetString((HySTime)m_csProjectData.GetModelPeriod().GetFrom(), 0).ToString());
                PeriodFromDateTimePicker.Enabled = true;
                PeriodToDateTimePicker.Value = DateTime.Parse(HySCalendar.GetString((HySTime)m_csProjectData.GetModelPeriod().GetTo(), 0).ToString());
                PeriodToDateTimePicker.Enabled = true;
            }
            else if (m_csProjectData.GetModelPeriodType() == McProjectInfData.ModelPeriodType.NonType)
            {
                // 期間種別
                PeriodComboBox.SelectedIndex = 0;

                // 期間
                PeriodFromDateTimePicker.Enabled = false;
                PeriodToDateTimePicker.Enabled = false;
            }
            if ((object)m_csProjectData.GetThresholdCondition1() != null)
            {
                // 境界条件１
                Boundaries1Box.Text = m_csProjectData.GetThresholdCondition1().ToString();
            }
            if ((object)m_csProjectData.GetThresholdCondition2() != null)
            {
                // 境界条件２
                Boundaries2Box.Text = m_csProjectData.GetThresholdCondition2().ToString();
            }
            if ((object)m_csProjectData.GetThresholdCondition3() != null)
            {
                // 境界条件３
                Boundaries3Box.Text = m_csProjectData.GetThresholdCondition3().ToString();
            }
            if ((object)m_csProjectData.GetThresholdCondition4() != null)
            {
                // 境界条件４
                Boundaries4Box.Text = m_csProjectData.GetThresholdCondition4().ToString();
            }
            if ((object)m_csProjectData.GetThresholdCondition5() != null)
            {
                // 境界条件５
                Boundaries5Box.Text = m_csProjectData.GetThresholdCondition5().ToString();
            }
            if ((object)m_csProjectData.GetCondition1() != null)
            {
                // 条件１
                Condition1Box.Text = m_csProjectData.GetCondition1().ToString();
            }
            if ((object)m_csProjectData.GetCondition2() != null)
            {
                // 条件２
                Condition2Box.Text = m_csProjectData.GetCondition2().ToString();
            }
            if ((object)m_csProjectData.GetCondition3() != null)
            {
                // 条件３
                Condition3Box.Text = m_csProjectData.GetCondition3().ToString();
            }
            if ((object)m_csProjectData.GetCondition4() != null)
            {
                // 条件４
                Condition4Box.Text = m_csProjectData.GetCondition4().ToString();
            }
            if ((object)m_csProjectData.GetCondition5() != null)
            {
                // 条件５
                Condition5Box.Text = m_csProjectData.GetCondition5().ToString();
            }
            if ((object)m_csProjectData.GetCreateDate() != null)
            {
                // 作成日
                CreateDate.Value = DateTime.Parse(HySCalendar.GetString(m_csProjectData.GetCreateDate(), 0).ToString());
            }
            if ((object)m_csProjectData.GetComment() != null)
            {
                // 備考
                CommentBox.Text = m_csProjectData.GetComment().ToString();
            }
        }

        /// <summary><para>method outline</para>
        /// <para>保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Save_Button.Click += new System.EventHandler(this.SaveProject);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SaveProject(object sender, EventArgs e)
        {
            /*****/
            string strErrMsg;
            // プロジェクト名称の取得 
            HySString csPrjName = new HySString(this.ProjectNameBox.Text);
            HySString csPrjGrName = new HySString(this.ProjectGroupBox.Text);
            HySEventObject csEvent = null;

            // 期間入力チェック
            if (PeriodComboBox.SelectedIndex == 1)
            {
                long lYear = (long)(PeriodFromDateTimePicker.Value.Year);
                long lMonth = (long)(PeriodFromDateTimePicker.Value.Month);
                long lDate = (long)(PeriodFromDateTimePicker.Value.Day);
                HySTime csFromTime = HySCalendar.CreateTime(lYear, lMonth, lDate, 0L, 0L, 0L);
                lYear = (long)(PeriodToDateTimePicker.Value.Year);
                lMonth = (long)(PeriodToDateTimePicker.Value.Month);
                lDate = (long)(PeriodToDateTimePicker.Value.Day);
                HySTime csToTime = HySCalendar.CreateTime(lYear, lMonth, lDate, 0L, 0L, 0L);
                if ((csFromTime.Before(csToTime) == false) && (csFromTime.Equals(csToTime) == false))
                {
                    //MessageBox.Show(MSG_ERROR_PERIOD_DATE, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    MessageBox.Show(MSG_ERROR_PERIOD_DATE, MSGBOX_TITLE,MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return;
                }
            }

            string sErrCharacter = @"\/:,;*?""<>|";
            if (ProjectNameBox.Text.IndexOfAny(sErrCharacter.ToCharArray()) != -1)
            {
                //MessageBox.Show(MSG_ERROR_PROJECT_NAME, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                MessageBox.Show(MSG_ERROR_PROJECT_NAME, MSGBOX_TITLE,MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return;
            }

            // プロジェクトグループ名、プロジェクト名称が変更されたかチェックする
            bool  bReDrawFlg = m_csProjectData.GetProjectGroupName().Equal(csPrjGrName);
            if (m_csProjectData.GetProjectName().Equal(csPrjName) == false || bReDrawFlg == false)
            {
                // モデル管理画面で既に使用されているプロジェクト名のチェック
                if (((McDotNetProjectCtlScreen)m_csScreen).IsManageProject(csPrjGrName.ToString() + "_" + csPrjName.ToString()) == true)
                {
                    MessageBox.Show(MSG_ERROR_PROJECT_EXIST, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return;
                }

                // 上書き保存チェック
                HySString csFileName = HySEnvInf.GetDataHomeDirectory() + "\\" + csPrjGrName + "\\" + csPrjName + ".cmprj";
                HySFile csFile = new HySFile(csFileName);
                if (csFile.Exist() == true)
                {// 既に同一ファイル有り。
                    if (MessageBox.Show(MSG_MSG_INFO_FILE_EXIST, MSGBOX_TITLE, MessageBoxButtons.OKCancel) == DialogResult.Cancel)
                    {// 保存キャンセル
                        return;
                    }
                }

                // プロジェクト情報クラス作成
                McProjectInfData csRegistPrjInf = new McProjectInfData();

                // 入力情報の設定
                GetInputData(csRegistPrjInf);

                // ファイル保存イベント生成
                csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_PROJECT_SAVE, m_csProjectData.GetProjectID());
                csEvent.SetSubEventNo(McDefine.HYMCO_PROJECT_SAVE_NEW);
                csEvent.SetData((HySDataRoot)csRegistPrjInf);
               // ver1.5 エラートレース日本語対応
                strErrMsg = Properties.McDotNetViewerResources.STATEMENT_CMND_DB_REGST_NG + "(HYM_LIBRARY_COPY_REGISTER)";
               // strErrMsg = "PutEvent CMND_DB_REGISTER(HYM_LIBRARY_COPY_REGISTER) is failed.";

                if (bReDrawFlg == false)
                {
                    // プロジェクト名が変更となった場合には、新しくプロジェクトグループ等を作成する
                    HySEventObject csJobEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_NEW_SIMULATOR_CREATE, McDefine.HYMCO_PROJECT_NEW);
                    csJobEventObj.SetSubData(csRegistPrjInf);
                    m_csScreen.GetViewerJob().EventCallback(csJobEventObj);
                }
            }
            else
            {
                // 元のプロジェクト情報インスタンスを使う
                // 入力情報の設定
                GetInputData(m_csProjectData);

                // 登録イベント生成
                csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_PROJECT_SAVE, m_csProjectData.GetProjectID());
                csEvent.SetSubEventNo(McDefine.HYMCO_PROJECT_SAVE);
               // ver1.5 エラートレース日本語対応
                strErrMsg = Properties.McDotNetViewerResources.STATEMENT_CMND_DB_REGST_NG;
               // strErrMsg = "PutEvent CMND_DB_REGISTER is failed.";
            }

            // メニューマスク＆マウスカーソル変更（時計マーク）
            ((HySDotNetViewer)((McDotNetProjectCtlScreen)m_csScreen).GetViewer()).GetMainForm().SetMaskPatern(HySDotNetViewerDefine.EventKind.IN_PROCESS);
            ((HySDotNetViewer)((McDotNetProjectCtlScreen)m_csScreen).GetViewer()).GetMainForm().Cursor = Cursors.WaitCursor;
            System.Threading.Thread.Sleep(300);

            // シミュレータ種別設定
            csEvent.SetToSimKind(m_csProjectData.GetSimulatorKind());
            // イベント送信
            if (false == this.PutEvent(csEvent))
            {
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "SaveProject", strErrMsg);
            } 

            Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>入力情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> this.GetInputData(csPrjInfData); </para>
        /// </example>
        /// <param name="csPrjInfData">プロジェクト情報クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GetInputData(McProjectInfData csPrjInfData)
        {
            //プロジェクトグループ名の取得
            csPrjInfData.SetProjectGroupName(new HySString(this.ProjectGroupBox.Text));
            // プロジェクト名称
            HySString csStr = new HySString(this.ProjectNameBox.Text);
            csPrjInfData.SetProjectName(csStr);
            // 管理者名
            csStr = new HySString(this.AdminNameBox.Text);
            csPrjInfData.SetAdminName(csStr);
            // 種別
            csStr = new HySString(this.KindBox.Text);
            csPrjInfData.SetModelType(csStr);
            // 対象
            csStr = new HySString(this.TartgetBox.Text);
            csPrjInfData.SetModelTarget(csStr);
            // モデル
            csStr = new HySString(this.ModelBox.Text);
            csPrjInfData.SetModelCalcType(csStr);
            // 件名
            csStr = new HySString(this.SubjectBox.Text);
            csPrjInfData.SetModelSubject(csStr);
            // ケース名
            csStr = new HySString(this.CaseNameBox.Text);
            csPrjInfData.SetModelSituation(csStr);
            if (PeriodComboBox.SelectedIndex == 2)
            {
                // 期間種別
                csPrjInfData.SetModelPeriodType(McProjectInfData.ModelPeriodType.REGULARITY);

                // 期間
                csPrjInfData.SetModelPeriod(null);
            }
            else if (PeriodComboBox.SelectedIndex == 1)
            {
                // 期間種別
                csPrjInfData.SetModelPeriodType(McProjectInfData.ModelPeriodType.PERIOD);

                // 期間
                long lFromYear = (long)(PeriodFromDateTimePicker.Value.Year);
                long lFromMonth = (long)(PeriodFromDateTimePicker.Value.Month);
                long lFromDate = (long)(PeriodFromDateTimePicker.Value.Day);
                long lToYear = (long)(PeriodToDateTimePicker.Value.Year);
                long lToMonth = (long)(PeriodToDateTimePicker.Value.Month);
                long lToDate = (long)(PeriodToDateTimePicker.Value.Day);
                csPrjInfData.SetModelPeriod(new McRange(HySCalendar.CreateTime(lFromYear, lFromMonth, lFromDate, 0L, 0L, 0L), HySCalendar.CreateTime(lToYear, lToMonth, lToDate, 0L, 0L, 0L)));
            }
            else
            {
                // 期間種別
                csPrjInfData.SetModelPeriodType(McProjectInfData.ModelPeriodType.NonType);

                // 期間
                csPrjInfData.SetModelPeriod(null);
            }
            // 境界条件１
            csStr = new HySString(Boundaries1Box.Text);
            csPrjInfData.SetThresholdCondition1(csStr);
            // 境界条件２
            csStr = new HySString(Boundaries2Box.Text);
            csPrjInfData.SetThresholdCondition2(csStr);
            // 境界条件３
            csStr = new HySString(Boundaries3Box.Text);
            csPrjInfData.SetThresholdCondition3(csStr);
            // 境界条件４
            csStr = new HySString(Boundaries4Box.Text);
            csPrjInfData.SetThresholdCondition4(csStr);
            // 境界条件５
            csStr = new HySString(Boundaries5Box.Text);
            csPrjInfData.SetThresholdCondition5(csStr);
            // 条件１
            csStr = new HySString(Condition1Box.Text);
            csPrjInfData.SetCondition1(csStr);
            // 条件２
            csStr = new HySString(Condition2Box.Text);
            csPrjInfData.SetCondition2(csStr);
            // 条件３
            csStr = new HySString(Condition3Box.Text);
            csPrjInfData.SetCondition3(csStr);
            // 条件４
            csStr = new HySString(Condition4Box.Text);
            csPrjInfData.SetCondition4(csStr);
            // 条件５
            csStr = new HySString(Condition5Box.Text);
            csPrjInfData.SetCondition5(csStr);

            // 作成日
            long lYear = (long)(CreateDate.Value.Year);
            long lMonth = (long)(CreateDate.Value.Month);
            long lDate = (long)(CreateDate.Value.Day);
            HySTime csTime = HySCalendar.CreateTime(lYear, lMonth, lDate, 0L, 0L, 0L);
            csPrjInfData.SetCreateDate(csTime);

            // 備考
            csStr = new HySString(CommentBox.Text);
            csPrjInfData.SetComment(csStr);
        }

        /// <summary><para>method outline</para>
        /// <para>キャンセルクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Cancel_Button.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel(object sender, EventArgs e)
        {
            Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public override Boolean PutEvent(HySSysEvent csEvent)
        {
            Boolean bRtn = false;

            // 処理(スクリーンクラスのPutEventをコールする)
            bRtn = m_csScreen.PutEvent(csEvent);

            return bRtn;
        }

        /// <summary><para>method outline</para>
        /// <para>プロジェクトグループ名称入力変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ProjectGroupBox.TextChanged += new System.EventHandler(this.ProjectGroupBox_TextChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ProjectGroupBox_TextChanged(object sender, EventArgs e)
        {
            // 必須項目のチェック
            ChangeSaveButtonEnabled();
        }

        /// <summary><para>method outline</para>
        /// <para>プロジェクト名称入力変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ProjectNameBox.TextChanged += new System.EventHandler(this.ProjectNameBox_TextChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ProjectNameBox_TextChanged(object sender, EventArgs e)
        {
            // 必須項目のチェック
            ChangeSaveButtonEnabled();
        }

        /// <summary><para>method outline</para>
        /// <para>管理者名入力変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.AdminNameBox.TextChanged += new System.EventHandler(this.AdminName_TextChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void AdminName_TextChanged(object sender, EventArgs e)
        {
            // 必須項目のチェック
            ChangeSaveButtonEnabled();
        }

        /// <summary><para>method outline</para>
        /// <para>登録ボタン有効無効変更</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ChangeSaveButtonEnabled();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>必須項目が入力されていないときに登録ボタンを押せなくする</para>
        /// </remarks>
        private void ChangeSaveButtonEnabled()
        {
            // 必須項目が入力されていない場合、登録ボタンを非活性にする
            //if ((AdminNameBox.Text != string.Empty) && (ProjectNameBox.Text != string.Empty) && (ProjectGroupBox.Text != string.Empty))
            // Ver1.1改良 操作性改善
            if ((ProjectNameBox.Text != string.Empty) && (ProjectGroupBox.Text != string.Empty))
            {
                Save_Button.Enabled = true;
            }
            else
            {
                Save_Button.Enabled = false;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>期間種別選択変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>PeriodComboBox_SelectedIndexChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PeriodComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (PeriodComboBox.SelectedIndex == 1)
            {
                PeriodFromDateTimePicker.Enabled = true;
                PeriodToDateTimePicker.Enabled = true;
            }
            else
            {
                PeriodFromDateTimePicker.Enabled = false;
                PeriodToDateTimePicker.Enabled = false;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_PROJECT_0008,
                        ((HySDotNetViewer)((McDotNetProjectCtlScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }

        /// <summary><para>method outline</para>
        /// <para>参照ボタンイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SelectFile(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SelectFile(object sender, EventArgs e)
        {
            McDotNetProjectFileDialog csOpenFileDlg = new McDotNetProjectFileDialog(HySEnvInf.GetDataHomeDirectory(), new HySString(ProjectGroupBox.Text), new HySString(ProjectNameBox.Text));

            if (csOpenFileDlg.ShowDialog() == DialogResult.OK)
            {// ファイル指定あり
                ProjectGroupBox.Text = csOpenFileDlg.GetProjectGroupName().ToString();
                ProjectNameBox.Text = csOpenFileDlg.GetProjectName().ToString();
            }
        }

    }
}