﻿// <summary>ソースコード：ＨＹＭＣＯプロジェクト検索画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.DBA;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.Tool;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYSSOP.Interface;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>検索画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public partial class McDotNetProjectSearchForm : HySDotNetForm
    {

        /// <summary>
        /// 検索条件データクラス
        /// </summary>
        protected HySQueryCtlData m_csQueryCtlData;

        //定数定義
        /// <summary>日付指定「指定日期間」</summary>
        static private readonly string DATE_TERM = Properties.McDotNetViewerResources.DATE_TERM;
        /// <summary>日付指定「指定日当日」</summary>
        static private readonly string DATE_TARGET = Properties.McDotNetViewerResources.DATE_TARGET;
        /// <summary>日付指定「指定日以降」</summary>
        static private readonly string DATE_AFTER = Properties.McDotNetViewerResources.DATE_AFTER;
        /// <summary>日付指定「指定日以前」</summary>
        static private readonly string DATE_BEFORE = Properties.McDotNetViewerResources.DATE_BEFORE;
        /// <summary>日付指定「期間」</summary>
        static private readonly string DATE_PERIOD = Properties.McDotNetViewerResources.DATE_PERIOD;

        ///// <summary>エラーメッセージタイトル </summary>
        //static private readonly string ERROR_MSGBOX_TITLE = "エラー";

        /// <summary>メッセージボックスタイトル『プロジェクト管理機能』</summary>
        static private readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_PROJECT_MANAGEMENT");

        ///// <summary>メッセージ「期間入力異常」 </summary>
        //static private readonly string MSG_ERROR_PERIOD_DATE = "期間の指定が正しくありません。";
		/// <summary>メッセージ『期間の指定が正しくありません。』</summary>
        static private readonly string MSG_ERROR_PERIOD_DATE = HysMessage.GetString("HYS_MSG_WARNING_PERIOD_DATE");
        ///// <summary>メッセージ「登録日指定異常」 </summary>
        //static private readonly string MSG_ERROR_REGIST_DATE = "登録日の指定が正しくありません。";
		/// <summary>メッセージ『登録日の指定が正しくありません。』 </summary>
		static private readonly string MSG_ERROR_REGIST_DATE = McMessage.GetString("MC_MSG_WARNING_REGIST_DATE");
        ///// <summary>メッセージ「更新日指定異常」 </summary>
        //static private readonly string MSG_ERROR_UPDATE_DATE = "更新日の指定が正しくありません。";
		/// <summary>メッセージ『更新日の指定が正しくありません。』 </summary>
        static private readonly string MSG_ERROR_UPDATE_DATE = McMessage.GetString("MC_MSG_WARNING_UPDATE_DATE");

        /// <summary>ログ出力用クラス名称</summary>
        static private readonly string LOG_CLASS_NAME = "McDotNetProjectSearchForm";

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetProjectSearchForm csProjectSearchForm = new McDotNetProjectSearchForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>McDotNetProjectSearchForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetProjectSearchForm(HySScreen csScreen)
        {
            InitializeComponent();
            m_csScreen = csScreen;
            m_csQueryCtlData = null;

        }

        /// <summary><para>method outline</para>
        /// <para>検索ボタン押下</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Search_Button.Click += new System.EventHandler(this.Search);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Search(object sender, EventArgs e)
        {

            //検索条件のセット
            if (SetSearchCondition() == false)
            {
                return;
            }

            // DB検索（プロジェクトリスト)イベント生成 
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DB_QUERY);
            HySID csDataID = new HySID(new HySString("")+ new HySString("")+ new HySString(McDefine.PROJECTSCREEN_ID));
            //csEvent.SetSuppID(csDataID);
            csEvent.SetSubData(csDataID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            csEvent.SetSubEventNo(HySLibraryMngDefine.DB_QUERY_DATA_LIST);
            csEvent.SetData(m_csQueryCtlData);
            //csEvent.SetSubData(HySLibraryMngDefine.DB_KIND_PROJECT_DATA);
            csEvent.SetSuppID(HySLibraryMngDefine.DB_KIND_PROJECT_DATA);
            if (false == this.PutEvent(csEvent))
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "Search", Properties.McDotNetViewerResources.STATEMENT_CMND_DB_QUERY_LIST_NG );
               // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "Search", "PutEvent CMND_DB_QUERY(DB_QUERY_DATA_LIST) is failed.");
            }

            // 画面を閉じる
            Close();
        }

        /// <summary><para>method outline</para>
        /// <para>キャンセルクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Cancel_Button.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel(object sender, EventArgs e)
        {
            Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSysUnit.PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public override Boolean PutEvent(HySSysEvent csEvent)
        {
            Boolean bRtn = false;

            // 処理(スクリーンクラスのPutEventをコール)
            bRtn = m_csScreen.PutEvent(csEvent);

            return bRtn;
        }

        /// <summary><para>method outline</para>
        /// <para>登録日チェックボックス選択変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.RegistDateCheckBox.CheckedChanged += new System.EventHandler(this.RegistDate_CheckedChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RegistDate_CheckedChanged(object sender, EventArgs e)
        {
            // 登録日指定あり
            if (RegistDateCheckBox.Checked == true)
            {
                // 登録日設定有効
                ChangeDateControlEnabled(RegistDateComboBox, RegistStartDateTimePicker, RegistEndDateTimePicker, RegistDateFromLabel);
            }
            else
            {
                // 登録日設定無効
                SetDateControlEnabled(RegistDateComboBox, RegistStartDateTimePicker, RegistEndDateTimePicker, RegistDateFromLabel, false, false, false, false);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>更新日チェックボックス選択変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.UpdateDateCheckBox.CheckedChanged += new System.EventHandler(this.UpdateDate_CheckedChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UpdateDate_CheckedChanged(object sender, EventArgs e)
        {
            // 更新日指定あり
            if (UpdateDateCheckBox.Checked == true)
            {
                // 更新日設定有効
                ChangeDateControlEnabled(UpdateDateComboBox, UpdateStartDateTimePicker, UpdateEndDateTimePicker, UpdateDateFromLabel);
            }
            else
            {
                // 更新日設定無効
                SetDateControlEnabled(UpdateDateComboBox, UpdateStartDateTimePicker, UpdateEndDateTimePicker, UpdateDateFromLabel, false, false, false, false);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>登録日期間指定コンボボックス選択変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.DateSelectComboBox.SelectedIndexChanged += new System.EventHandler(this.RegistDate_SelectedIndexChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void RegistDate_SelectedIndexChanged(object sender, EventArgs e)
        {
            ChangeDateControlEnabled(RegistDateComboBox, RegistStartDateTimePicker, RegistEndDateTimePicker, RegistDateFromLabel);
        }

        /// <summary><para>method outline</para>
        /// <para>更新日期間指定コンボボックス選択変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.UpdateDateComboBox.SelectedIndexChanged += new System.EventHandler(this.UpdateDate_SelectedIndexChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UpdateDate_SelectedIndexChanged(object sender, EventArgs e)
        {
            ChangeDateControlEnabled(UpdateDateComboBox, UpdateStartDateTimePicker, UpdateEndDateTimePicker, UpdateDateFromLabel);
        }

        /// <summary><para>method outline</para>
        /// <para>日付条件入力コントロール有効無効変更処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ChangeDateControlEnabled(csComboBox, csStartDate,  csEndDate, csLabel);</para>
        /// </example>
        /// <param name="csComboBox">指定法コンボボックス</param>
        /// <param name="csStartDate">開始日付入力</param>
        /// <param name="csEndDate">終了日付入力</param>
        /// <param name="csLabel">期間ラベル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ChangeDateControlEnabled(ComboBox csComboBox, DateTimePicker csStartDate, DateTimePicker csEndDate, Label csLabel)
        {
            // コンボボックスで選択されているアイテムによりコントロールの有効無効を切り替える

            // 指定日期間
            if (csComboBox.Text == DATE_TERM)
            {
                SetDateControlEnabled(csComboBox, csStartDate, csEndDate, csLabel, true, true, true, true);
            }
            // 指定日当日
            else if (csComboBox.Text == DATE_TARGET)
            {
                SetDateControlEnabled(csComboBox, csStartDate, csEndDate, csLabel, true, true, false, false);
            }
            // 指定日以前
            else if (csComboBox.Text == DATE_BEFORE)
            {
                SetDateControlEnabled(csComboBox, csStartDate, csEndDate, csLabel, true, false, true, true);
            }
            // 指定日以降
            else if (csComboBox.Text == DATE_AFTER)
            {
                SetDateControlEnabled(csComboBox, csStartDate, csEndDate, csLabel, true, true, false, true);
            }
            else
            {
                SetDateControlEnabled(csComboBox, csStartDate, csEndDate, csLabel, true, false, false, false);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>日付条件入力コントロール有効無効設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.SetDateControlEnabled(csComboBox, csStartDate, csEndDate, csLabel, true, true, true, true);</para>
        /// </example>
        /// <param name="csComboBox">指定法コンボボックス</param>
        /// <param name="csStartDate">開始日付入力</param>
        /// <param name="csEndDate">終了日付入力</param>
        /// <param name="csLabel">期間ラベル</param>
        /// <param name="isComboBox">指定法コンボボックス有効可否</param>
        /// <param name="isStartDate">開始日付入力有効可否</param>
        /// <param name="isEndDate">終了日日付入力有効可否</param>
        /// <param name="isLabel">期間ラベル有効可否</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetDateControlEnabled(ComboBox csComboBox, DateTimePicker csStartDate, DateTimePicker csEndDate, Label csLabel,
                                           Boolean isComboBox, Boolean isStartDate, Boolean isEndDate, Boolean isLabel)
        {
            csComboBox.Enabled = isComboBox;
            csStartDate.Enabled = isStartDate;
            csEndDate.Enabled = isEndDate;
            csLabel.Enabled = isLabel;
        }

        /// <summary><para>method outline</para>
        /// <para>日付条件チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = CheckDateCondition(csFromTime, csToTime, strTerm);</para>
        /// </example>
        /// <param name="csFromTime">範囲開始日</param>
        /// <param name="csToTime">範囲終了日</param>
        /// <param name="strTerm">指定方法文字列</param>
        /// <returns>true:正常 false:入力エラー</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean CheckDateCondition(HySTime csFromTime, HySTime csToTime, string strTerm)
        {
            // 指定方法が「指定日期間」の場合かつ開始日、終了日に矛盾がある場合エラー
            if (((strTerm == DATE_TERM) || (strTerm == DATE_PERIOD)) && (csFromTime.Before(csToTime) == false) && (csFromTime.Equals(csToTime) == false))
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>日付条件設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = SetDateCondition(csProjectQueryFieldNames, csFromTimePicker, csToTimePicker, csDateComboBox);</para>
        /// </example>
        /// <param name="csProjectQueryFieldNames">検索条件フィールド名</param>
        /// <param name="csFromTimePicker">範囲開始日選択コントロール</param>
        /// <param name="csToTimePicker">範囲終了日選択コントロール</param>
        /// <param name="csDateComboBox">指定方法選択コンボボックス</param>
        /// <returns>true:正常 false:入力エラー</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean SetDateCondition(HySString csProjectQueryFieldNames,
            DateTimePicker csFromTimePicker, DateTimePicker csToTimePicker, ComboBox csDateComboBox)
        {
            // 入力情報の取得
            HySTime csFromTime = GetTimeFromDateTimePicker(csFromTimePicker);
            HySTime csToTime = GetTimeFromDateTimePicker(csToTimePicker);
            string strTerm = csDateComboBox.Text;

            // 条件チェック
            if (CheckDateCondition(csFromTime, csToTime, strTerm) == false)
            {
                return false;
            }

            // 指定日期間
            if (strTerm == DATE_PERIOD)
            {
                McRange csPeriodRange = new McRange(csFromTime, csToTime);
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(csProjectQueryFieldNames, typeof(McRange), HySQueryCompareMode.BETWEEN, csPeriodRange));
            }
            // 指定日期間
            else if (strTerm == DATE_TERM)
            {
                HySTime[] csTimeRange = new HySTime[2];
                csTimeRange[0] = csFromTime;
                csTimeRange[1] = csToTime;
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(csProjectQueryFieldNames, typeof(HySTime), HySQueryCompareMode.BETWEEN, csTimeRange));
            }
            // 指定日当日
            else if (strTerm == DATE_TARGET)
            {
                // 終了日を開始日と同じにする
                HySTime[] csTimeRange = new HySTime[2];
                csTimeRange[0] = csFromTime;
                csTimeRange[1] = csFromTime;
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(csProjectQueryFieldNames, typeof(HySTime), HySQueryCompareMode.BETWEEN, csTimeRange));
            }
            // 指定日以前
            else if (strTerm == DATE_BEFORE)
            {
                // 開始日をnullにする
                HySTime[] csTimeRange = new HySTime[2];
                csTimeRange[0] = null;
                csTimeRange[1] = csToTime;
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(csProjectQueryFieldNames, typeof(HySTime), HySQueryCompareMode.BETWEEN, csTimeRange));
            }
            // 指定日以降
            else if (strTerm == DATE_AFTER)
            {
                // 終了日をnullにする
                HySTime[] csTimeRange = new HySTime[2];
                csTimeRange[0] = csFromTime;
                csTimeRange[1] = null;
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(csProjectQueryFieldNames, typeof(HySTime), HySQueryCompareMode.BETWEEN, csTimeRange));
            }

            return true;
        }

        /// <summary><para>method outline</para>
        /// <para>検索条件設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = SetSearchCondition()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常 false:入力エラー</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean SetSearchCondition()
        {
            // 検索条件クラスの生成
            m_csQueryCtlData = new HySQueryCtlData();
            m_csQueryCtlData.SetIsMetaDataOnly(true); // メタデータのみ取得

            // 期間設定
            if (PeriodComboBox.SelectedIndex == 1)
            {
                // 設定処理
                if (SetDateCondition(McProjectQueryFieldNames.MODEL_PERIOD, PeriodFromDateTimePicker, PeriodToDateTimePicker, PeriodComboBox) == false)
                {
                    //MessageBox.Show(MSG_ERROR_PERIOD_DATE, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    MessageBox.Show(MSG_ERROR_PERIOD_DATE,MSGBOX_TITLE,MessageBoxButtons.OK,MessageBoxIcon.Exclamation);
                    return false;
                }
            }
            // 登録日設定
            if (RegistDateCheckBox.Checked == true)
            {
                // 設定処理
                if (SetDateCondition(McProjectQueryFieldNames.REGISTRATION_DATE, RegistStartDateTimePicker, RegistEndDateTimePicker, RegistDateComboBox) == false)
                {
                    //MessageBox.Show(MSG_ERROR_REGIST_DATE, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    MessageBox.Show(MSG_ERROR_REGIST_DATE, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return false;
                }
            }
            // 更新日設定
            if (UpdateDateCheckBox.Checked == true)
            {
                // 設定処理
                if (SetDateCondition(McProjectQueryFieldNames.UPDATE_DATE, UpdateStartDateTimePicker, UpdateEndDateTimePicker, UpdateDateComboBox) == false)
                {
                    //MessageBox.Show(MSG_ERROR_UPDATE_DATE, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    MessageBox.Show(MSG_ERROR_UPDATE_DATE, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return false;
                }
            }

// Ver1.1 追加 >>>
            // プロジェクト名の取得
            HySString csProjectGroup = new HySString(this.ProjectGroupBox.Text);
// Ver1.1 追加 <<<
            // プロジェクト名の取得
            HySString csProjectName = new HySString(this.ProjectNameBox.Text);
            // 管理者名の取得
            HySString csAdminName = new HySString(this.AdminNameBox.Text);
            // 種別の取得
            HySString csKindValue = new HySString(this.KindBox.Text);
            // 対象の取得
            HySString csTargetValue = new HySString(this.TargetBox.Text);
            // モデルの取得
            HySString csModelValue = new HySString(this.ModelBox.Text);
            // 件名の取得
            HySString csSubjectValue = new HySString(this.SubjectBox.Text);
            // ケース名の取得
            HySString csCaseNameValue = new HySString(this.CaseNameBox.Text);
            // 境界条件１の取得
            HySString csBoundaries1Value = new HySString(this.Boundaries1Box.Text);
            // 境界条件２の取得
            HySString csBoundaries2Value = new HySString(this.Boundaries2Box.Text);
            // 境界条件３の取得
            HySString csBoundaries3Value = new HySString(this.Boundaries3Box.Text);
            // 境界条件４の取得
            HySString csBoundaries4Value = new HySString(this.Boundaries4Box.Text);
            // 境界条件５の取得
            HySString csBoundaries5Value = new HySString(this.Boundaries5Box.Text);
            // 条件１の取得
            HySString csCondition1Value = new HySString(this.Condition1Box.Text);
            // 条件２の取得
            HySString csCondition2Value = new HySString(this.Condition2Box.Text);
            // 条件３の取得
            HySString csCondition3Value = new HySString(this.Condition3Box.Text);
            // 条件４の取得
            HySString csCondition4Value = new HySString(this.Condition4Box.Text);
            // 条件５の取得
            HySString csCondition5Value = new HySString(this.Condition5Box.Text);

// Ver1.1 追加 >>>
            // プロジェクトグループ名設定
            if (csProjectName != string.Empty)
            {
                //★★★★★　検索キー追加必要。　ＤＢ処理へ検索処理追加必要。
//                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.PROJECT_GROUP, typeof(HySString), HySQueryCompareMode.EQUALS, csProjectGroup));
            }
// Ver1.1 追加 <<<
            // プロジェクト名設定
            if (csProjectName != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.PROJECT_NAME, typeof(HySString), HySQueryCompareMode.EQUALS, csProjectName));
            }
            // 管理者名設定
            if (csAdminName != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.MANAGER_NAME, typeof(HySString), HySQueryCompareMode.EQUALS, csAdminName));
            }
            // 種別設定
            if (csKindValue != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.MODEL_TYPE, typeof(HySString), HySQueryCompareMode.EQUALS, csKindValue));
            }
            // 対象設定
            if (csTargetValue != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.MODEL_TARGET, typeof(HySString), HySQueryCompareMode.EQUALS, csTargetValue));
            }
            // モデル設定
            if (csModelValue != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.MODEL_CALC_TYPE, typeof(HySString), HySQueryCompareMode.EQUALS, csModelValue));
            }
            // 件名設定
            if (csSubjectValue != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.MODEL_SUBJECT, typeof(HySString), HySQueryCompareMode.EQUALS, csSubjectValue));
            }
            // ケース名設定
            if (csCaseNameValue != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.MODEL_SITUATION, typeof(HySString), HySQueryCompareMode.EQUALS, csCaseNameValue));
            }
            // 期間種別設定
            if (PeriodComboBox.SelectedIndex == 1)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.MODEL_PERIOD_TYPE, typeof(McProjectInfData.ModelPeriodType), HySQueryCompareMode.EQUALS, McProjectInfData.ModelPeriodType.PERIOD));
            }
            else if (PeriodComboBox.SelectedIndex == 2)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.MODEL_PERIOD_TYPE, typeof(McProjectInfData.ModelPeriodType), HySQueryCompareMode.EQUALS, McProjectInfData.ModelPeriodType.REGULARITY));
            }
            // 境界条件１設定
            if (csBoundaries1Value != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.THRESHOLD_CONDITION1, typeof(HySString), HySQueryCompareMode.EQUALS, csBoundaries1Value));
            }
            // 境界条件２設定
            if (csBoundaries2Value != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.THRESHOLD_CONDITION2, typeof(HySString), HySQueryCompareMode.EQUALS, csBoundaries2Value));
            }
            // 境界条件３設定
            if (csBoundaries3Value != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.THRESHOLD_CONDITION3, typeof(HySString), HySQueryCompareMode.EQUALS, csBoundaries3Value));
            }
            // 境界条件４設定
            if (csBoundaries4Value != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.THRESHOLD_CONDITION4, typeof(HySString), HySQueryCompareMode.EQUALS, csBoundaries4Value));
            }
            // 境界条件５設定
            if (csBoundaries5Value != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.THRESHOLD_CONDITION5, typeof(HySString), HySQueryCompareMode.EQUALS, csBoundaries5Value));
            }
            // 条件１設定
            if (csCondition1Value != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.CONDITION1, typeof(HySString), HySQueryCompareMode.EQUALS, csCondition1Value));
            }
            // 条件２設定
            if (csCondition2Value != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.CONDITION2, typeof(HySString), HySQueryCompareMode.EQUALS, csCondition2Value));
            }
            // 条件３設定
            if (csCondition3Value != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.CONDITION3, typeof(HySString), HySQueryCompareMode.EQUALS, csCondition3Value));
            }
            // 条件４設定
            if (csCondition4Value != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.CONDITION4, typeof(HySString), HySQueryCompareMode.EQUALS, csCondition4Value));
            }
            // 条件５設定
            if (csCondition5Value != string.Empty)
            {
                m_csQueryCtlData.SetQueryEntryData(new HySQueryEntryData(McProjectQueryFieldNames.CONDITION5, typeof(HySString), HySQueryCompareMode.EQUALS, csCondition5Value));
            }

            return true;
        }

        /// <summary><para>method outline</para>
        /// <para>日付入力コントロール入力値変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySTime csTime = GetTimeFromDateTimePicker( csControl );</para>
        /// </example>
        /// <param name="csControl">日付入力コントロール</param>
        /// <returns>内部時刻クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private HySTime GetTimeFromDateTimePicker(DateTimePicker csControl)
        {
            long lYear = (long)(csControl.Value.Year);
            long lMonth = (long)(csControl.Value.Month);
            long lDate = (long)(csControl.Value.Day);
            return HySCalendar.CreateTime(lYear, lMonth, lDate, 0L, 0L, 0L);
        }

        /// <summary><para>method outline</para>
        /// <para>期間種別選択変更イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>PeriodComboBox_SelectedIndexChanged(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PeriodComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (PeriodComboBox.SelectedIndex == 1)
            {
                PeriodFromDateTimePicker.Enabled = true;
                PeriodToDateTimePicker.Enabled = true;
            }
            else
            {
                PeriodFromDateTimePicker.Enabled = false;
                PeriodToDateTimePicker.Enabled = false;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_PROJECT_0004,
                        ((HySDotNetViewer)((McDotNetProjectCtlScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }
    }
}
