﻿// <summary>ソースコード：ＨＹＭＣＯプロジェクト検索結果画面クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;


namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>検索結果画面</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public partial class McDotNetProjectSearchResultForm : HySDotNetForm
    {

        //定数定義
        ///// <summary>詳細画面タイトル </summary>
        //static private readonly string FORM_TITLE_PROJECT_DETAIL = "プロジェクト詳細";
        ///// <summary>通常メッセージタイトル </summary>
        //static private readonly string MSGBOX_TITLE = "水・物質循環解析ソフトウェア共通基盤　CommonMP";
		/// <summary>メッセージタイトル『プロジェクト管理機能』</summary>
        static private readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_PROJECT_MANAGEMENT");
        ///// <summary>エラーメッセージタイトル </summary>
        //static private readonly string ERROR_MSGBOX_TITLE = "エラー";
        ///// <summary>メッセージ「プロジェクトオープン異常」</summary>
        //static private readonly string MSG_ERROR_OPEN_PROJECT = "同一IDのプロジェクトが既に開かれています。";
		/// <summary>メッセージ『同一IDのプロジェクトが既に開かれています。\nプロジェクト名：』</summary>
		static private readonly string MSG_ERROR_OPEN_PROJECT = McMessage.GetString("MC_MSG_WARNING_OPEN_PROJECT");
        ///// <summary>メッセージ「プロジェクト削除確認」 </summary>
        //static private readonly string MSG_CONFILM_DB_DELETE = "選択されたプロジェクトをDBから削除しますか?";
		/// <summary>メッセージ『選択されたプロジェクトをDBから削除しますか？』 </summary>
		static private readonly string MSG_CONFILM_DB_DELETE = McMessage.GetString("MC_MSG_QUESTION_CONFILM_DELETE");
        ///// <summary>メッセージ「削除完了」 </summary>
        //static private readonly string MSG_COMPLETE_DB_DELETE = "削除が完了しました。";
		/// <summary>メッセージ『削除が完了しました。』 </summary>
		static private readonly string MSG_COMPLETE_DB_DELETE = McMessage.GetString("MC_MSG_INFO_COMPLETE_DELETE");
        ///// <summary>メッセージ「エクスポート完了」 </summary>
        //static private readonly string MSG_COMPLETE_DB_EXPORT = "エクスポートが完了しました。";
		/// <summary>メッセージ『エクスポートが完了しました。』 </summary>
        static private readonly string MSG_COMPLETE_DB_EXPORT = McMessage.GetString("MC_MSG_INFO_COMPLETE_EXPORT");
        /// <summary>ログ出力用クラス名称</summary>
        static private readonly string LOG_CLASS_NAME = "McDotNetProjectSearchResultForm";
        
        /// <summary>
        /// 検索結果リスト情報
        /// </summary>
        private HySStockDataList m_csStockDataList;

        /// <summary>プロジェクト管理画面フォーム</summary>
        private McDotNetProjectCtlForm m_csPrjCtlForm;     

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetProjectSearchResultForm csProjectSearchResultForm = new McDotNetProjectSearchResultForm(csScreen, csListData, csPrjCtlForm);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <param name="csListData">検索結果リストデータ</param>
        /// <param name="csPrjCtlForm">プロジェクト管理画面フォーム</param>
        /// <returns>McDotNetProjectSearchResultForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetProjectSearchResultForm(HySScreen csScreen, HySStockDataList csListData, McDotNetProjectCtlForm csPrjCtlForm)
        {
            InitializeComponent();
            // メンバ変数の設定
            m_csScreen = csScreen;
            m_csStockDataList = csListData;
            m_csPrjCtlForm = csPrjCtlForm;

            // 検索結果を表に設定する
            this.SetSearchResult();

        }

        /// <summary><para>method outline</para>
        /// <para>開くボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Open_Button.Click += new System.EventHandler(this.Open);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Open(object sender, EventArgs e)
        {
            // 選択行番号の取得
            int iRowNo = GetSelectedRowIndex();

            // 対象のプロジェクト情報取得
            McProjectInfData csProjectInf = (McProjectInfData)SearchResultGridView.Rows[iRowNo].Cells[25].Value;

            // プロジェクトIDの重複チェック
            HySString csPrcID = (HySString)csProjectInf.GetProjectID().GetString();
            HySString csPrcKind = (HySString)csProjectInf.GetSimulatorKind().GetString();
            HySString csPrcKey = csPrcKind + csPrcID;

            if (m_csPrjCtlForm.CheckProjectIsOpen(csPrcKey) == false) 
            {
                // プロジェクト検索(個別)イベント生成 
                HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DB_QUERY);
                HySID csDataID = csProjectInf.GetProjectID();
                //csEvent.SetSuppID(csDataID);
                csEvent.SetData(csDataID);
                csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
                csEvent.SetSubEventNo(HySLibraryMngDefine.DB_QUERY_DATA);
                //csEvent.SetSubData(HySLibraryMngDefine.DB_KIND_PROJECT_DATA);
                csEvent.SetSuppID(HySLibraryMngDefine.DB_KIND_PROJECT_DATA);
                if (false == this.PutEvent(csEvent))
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "Open", Properties.McDotNetViewerResources.STATEMENT_CMND_DB_QUERY_DATA_NG );
                   // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "Open", "PutEvent CMND_DB_QUERY(DB_QUERY_DATA) is failed.");
                }

                // メニューマスク＆マウスカーソル変更（時計マーク）
                ((HySDotNetViewer)((McDotNetProjectCtlScreen)m_csScreen).GetViewer()).GetMainForm().SetMaskPatern(HySDotNetViewerDefine.EventKind.IN_PROCESS);
                ((HySDotNetViewer)((McDotNetProjectCtlScreen)m_csScreen).GetViewer()).GetMainForm().Cursor = Cursors.WaitCursor;

                // 画面クローズ
                Close();
            }
            else
            {
                //MessageBox.Show(MSG_ERROR_OPEN_PROJECT, ERROR_MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
				//MessageBox.Show(MSG_ERROR_OPEN_PROJECT, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
				HySString msgboxMsg = new HySString(MSG_ERROR_OPEN_PROJECT);
				msgboxMsg += csProjectInf.GetProjectName().ToString();
				MessageBox.Show(msgboxMsg.ToString(), MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return;
            }

        }

        /// <summary><para>method outline</para>
        /// <para>削除ボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Delete_Button.Click += new System.EventHandler(this.Delete);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Delete(object sender, EventArgs e)
        {
            if (MessageBox.Show(MSG_CONFILM_DB_DELETE, MSGBOX_TITLE, MessageBoxButtons.OKCancel, MessageBoxIcon.Question) == DialogResult.OK)
            {
                // 削除対象のプロジェクト情報編集
                HySDataLinkedList csDeleteList = new HySDataLinkedList();
                McProjectInfData csProjectInf = null;
                for (int iLp = 0; iLp < SearchResultGridView.SelectedRows.Count; iLp++)
                {
                    // 対象のプロジェクト情報取得
                    csProjectInf = (McProjectInfData)SearchResultGridView.SelectedRows[iLp].Cells[25].Value;
                    csDeleteList.AddLast(csProjectInf.GetProjectID());
                }

                // DB削除イベント生成 
                HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DB_DELETE);
                csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
                csEvent.SetData(csDeleteList);
                csEvent.SetSubEventNo(HySLibraryMngDefine.DB_DELETE_DATA_LIST_BY_ID);
                //csEvent.SetSubData(HySLibraryMngDefine.DB_KIND_PROJECT_DATA);
                csEvent.SetSuppID(HySLibraryMngDefine.DB_KIND_PROJECT_DATA);
                if (false == this.PutEvent(csEvent))
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "Delete", 
                        Properties.McDotNetViewerResources.STATEMENT_CMND_DB_DEL_NG );
                   // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "Delete", "PutEvent CMND_DB_DELETE is failed.");
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>キャンセルクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Cancel_Button.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel(object sender, EventArgs e)
        {
            // 画面クローズ
            Close();
        }

        /// <summary><para>method outline</para>
        /// <para>検索結果設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.SetSearchResult();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetSearchResult()
        {
            // 検索結果リストに格納されているプロジェクト情報を表に設定する
            for (int i = 0; i < m_csStockDataList.GetCount(); i++)
            {
                McProjectInfData csProjectInf = (McProjectInfData)((HySStockData)m_csStockDataList.GetData(i)).GetData();
                
                // 行追加
                SearchResultGridView.Rows.Add();
                // プロジェクト名の設定
                if ((object)csProjectInf.GetProjectName() != null)
                {
                    SearchResultGridView.Rows[i].Cells[0].Value = (csProjectInf.GetProjectName()).ToString();
                }
                // 管理者名の設定
                if ((object)csProjectInf.GetAdminName() != null)
                {
                    SearchResultGridView.Rows[i].Cells[1].Value = (csProjectInf.GetAdminName()).ToString();
                }
                // 種別の設定
                if ((object)csProjectInf.GetModelType() != null)
                {
                    SearchResultGridView.Rows[i].Cells[2].Value = (csProjectInf.GetModelType()).ToString();
                }
                // 対象の設定
                if ((object)csProjectInf.GetModelTarget() != null)
                {
                    SearchResultGridView.Rows[i].Cells[3].Value = (csProjectInf.GetModelTarget()).ToString();
                }
                // モデルの設定
                if ((object)csProjectInf.GetModelCalcType() != null)
                {
                    SearchResultGridView.Rows[i].Cells[4].Value = (csProjectInf.GetModelCalcType()).ToString();
                }
                // 件名の設定
                if ((object)csProjectInf.GetModelSubject() != null)
                {
                    SearchResultGridView.Rows[i].Cells[5].Value = (csProjectInf.GetModelSubject()).ToString();
                }
                // ケース名の設定
                if ((object)csProjectInf.GetModelSituation() != null)
                {
                    SearchResultGridView.Rows[i].Cells[6].Value = (csProjectInf.GetModelSituation()).ToString();
                }
                // 期間の設定
                if (csProjectInf.GetModelPeriodType() == McProjectInfData.ModelPeriodType.REGULARITY)
                {
                    // 定常
                    SearchResultGridView.Rows[i].Cells[7].Value = Properties.McDotNetViewerResources.DATE_ROUTINE;
                }
                else if (csProjectInf.GetModelPeriodType() == McProjectInfData.ModelPeriodType.PERIOD)
                {
                    // 期間
                    string strFrom = HySCalendar.GetString(((HySTime)csProjectInf.GetModelPeriod().GetFrom()), HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString();
                    string strTo = HySCalendar.GetString(((HySTime)csProjectInf.GetModelPeriod().GetTo()), HySCalendar.FORMAT.lSW_LOCAL_YEAR).ToString();
                    string strCreate = strFrom.Substring(0, strFrom.IndexOf(" ")) +
                        Properties.McDotNetViewerResources.DATE_TO +
                        strTo.Substring(0, strTo.IndexOf(" "));
                    SearchResultGridView.Rows[i].Cells[7].Value = strCreate;
                }
                // 境界条件１の設定
                if ((object)csProjectInf.GetThresholdCondition1() != null)
                {
                    SearchResultGridView.Rows[i].Cells[8].Value = (csProjectInf.GetThresholdCondition1()).ToString();
                }
                // 境界条件２の設定
                if ((object)csProjectInf.GetThresholdCondition2() != null)
                {
                    SearchResultGridView.Rows[i].Cells[9].Value = (csProjectInf.GetThresholdCondition2()).ToString();
                }
                // 境界条件３の設定
                if ((object)csProjectInf.GetThresholdCondition3() != null)
                {
                    SearchResultGridView.Rows[i].Cells[10].Value = (csProjectInf.GetThresholdCondition3()).ToString();
                }
                // 境界条件４の設定
                if ((object)csProjectInf.GetThresholdCondition4() != null)
                {
                    SearchResultGridView.Rows[i].Cells[11].Value = (csProjectInf.GetThresholdCondition4()).ToString();
                }
                // 境界条件５の設定
                if ((object)csProjectInf.GetThresholdCondition5() != null)
                {
                    SearchResultGridView.Rows[i].Cells[12].Value = (csProjectInf.GetThresholdCondition5()).ToString();
                }
                // 条件１の設定
                if ((object)csProjectInf.GetCondition1() != null)
                {
                    SearchResultGridView.Rows[i].Cells[13].Value = (csProjectInf.GetCondition1()).ToString();
                }
                // 条件２の設定
                if ((object)csProjectInf.GetCondition2() != null)
                {
                    SearchResultGridView.Rows[i].Cells[14].Value = (csProjectInf.GetCondition2()).ToString();
                }
                // 条件３の設定
                if ((object)csProjectInf.GetCondition3() != null)
                {
                    SearchResultGridView.Rows[i].Cells[15].Value = (csProjectInf.GetCondition3()).ToString();
                }
                // 条件４の設定
                if ((object)csProjectInf.GetCondition4() != null)
                {
                    SearchResultGridView.Rows[i].Cells[16].Value = (csProjectInf.GetCondition4()).ToString();
                }
                // 条件５の設定
                if ((object)csProjectInf.GetCondition5() != null)
                {
                    SearchResultGridView.Rows[i].Cells[17].Value = (csProjectInf.GetCondition5()).ToString();
                }
                // 計算開始時刻
                if ((object)csProjectInf.GetStartSimuTime() != null)
                {
                    //SearchResultGridView.Rows[i].Cells[18].Value = (HySCalendar.ToString(csProjectInf.GetStartSimuTime(), 0));
                    SearchResultGridView.Rows[i].Cells[18].Value = (HySCalendar.ToString(csProjectInf.GetStartSimuTime(), HySCalendar.FORMAT.lSW_LOCAL_YEAR));
                }
                // 計算終了時刻
                if ((object)csProjectInf.GetEndSimuTime() != null)
                {
                    //SearchResultGridView.Rows[i].Cells[19].Value = (HySCalendar.ToString(csProjectInf.GetEndSimuTime(), 0));
                    SearchResultGridView.Rows[i].Cells[19].Value = (HySCalendar.ToString(csProjectInf.GetEndSimuTime(), HySCalendar.FORMAT.lSW_LOCAL_YEAR));
                }
                // 計算中断時刻
                if ((object)csProjectInf.GetSuspendTime() != null)
                {
                    //SearchResultGridView.Rows[i].Cells[20].Value = (HySCalendar.ToString(csProjectInf.GetSuspendTime(), 0));
                    SearchResultGridView.Rows[i].Cells[20].Value = (HySCalendar.ToString(csProjectInf.GetSuspendTime(), HySCalendar.FORMAT.lSW_LOCAL_YEAR));
                }
                // 備考の設定
                if ((object)csProjectInf.GetComment() != null)
                {
                    SearchResultGridView.Rows[i].Cells[21].Value = (csProjectInf.GetComment()).ToString();
                }
                // 作成日の設定
                if ((object)csProjectInf.GetCreateDate() != null)
                {
                    //string strCreate = (HySCalendar.ToString(csProjectInf.GetCreateDate(), 0)).ToString();
                    string strCreate = (HySCalendar.ToString(csProjectInf.GetCreateDate(), HySCalendar.FORMAT.lSW_LOCAL_YEAR)).ToString();
                    SearchResultGridView.Rows[i].Cells[22].Value = strCreate.Substring(0, strCreate.IndexOf(" "));
                }
                // 登録日
                if ((object)csProjectInf.GetRegistDate() != null)
                {
                    //string strRegist = (HySCalendar.ToString(csProjectInf.GetRegistDate(), 0));
                    string strRegist = (HySCalendar.ToString(csProjectInf.GetRegistDate(), HySCalendar.FORMAT.lSW_LOCAL_YEAR));
                    SearchResultGridView.Rows[i].Cells[23].Value = strRegist.Substring(0, strRegist.IndexOf(" "));
                }
                // 更新日
                if ((object)csProjectInf.GetUpdateDate() != null)
                {
                    //string strUpdate = (HySCalendar.ToString(csProjectInf.GetUpdateDate(), 0));
                    string strUpdate = (HySCalendar.ToString(csProjectInf.GetUpdateDate(), HySCalendar.FORMAT.lSW_LOCAL_YEAR));
                    SearchResultGridView.Rows[i].Cells[24].Value = strUpdate.Substring(0, strUpdate.IndexOf(" "));
                }
                // プロジェクトデータを非表示列に設定
                SearchResultGridView.Rows[i].Cells[25].Value = csProjectInf;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>選択行番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>int iRowNo = GetSelectedRowIndex();</para>
        /// </example>
        /// <returns>-1:選択行無し　0以上:選択行番号(0相対)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private int GetSelectedRowIndex()
        {
            int iRtn = -1;
            if (SearchResultGridView.SelectedRows.Count != 0)
            {
                iRtn = SearchResultGridView.SelectedRows[0].Index;
            }
            return iRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>削除報告コールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CallBackNoticeDelete(); </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void CallBackNoticeDelete()
        {
            HySDataLinkedList csWorkList = new HySDataLinkedList();

            // 削除されたプロジェクトをリストから削除
            for (int iLp = 0; iLp < SearchResultGridView.SelectedRows.Count; iLp++)
            {
                // 削除行の登録
                csWorkList.AddLast(((McProjectInfData)SearchResultGridView.SelectedRows[iLp].Cells[25].Value).GetProjectID());
            }
            for (long lLp = 0; lLp < csWorkList.GetCount(); lLp++)
            {
                for (int iLp = 0; iLp < SearchResultGridView.RowCount; iLp++)
                {
                    if (((HySID)csWorkList.GetData(lLp)).Equals(((McProjectInfData)SearchResultGridView.Rows[iLp].Cells[25].Value).GetProjectID()) == true)
                    {
                        // 行の削除
                        SearchResultGridView.Rows.RemoveAt(iLp);
                        break;
                    }
                }
            }
            MessageBox.Show(MSG_COMPLETE_DB_DELETE, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        /// <summary><para>method outline</para>
        /// <para>表選択状態変更時イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.SearchResultGridView.SelectionChanged += new System.EventHandler(this.SearchResultGridView_SelectionChanged);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プロジェクト選択状態のみ実行可能なボタンの制御を行う</para>
        /// </remarks>
        private void SearchResultGridView_SelectionChanged(object sender, EventArgs e)
        {
            // 選択状態の行がない場合は「エクスポート」「開く」「削除」ボタンを非活性にする
            if (SearchResultGridView.SelectedRows.Count == 0)
            {
                Export_Button.Enabled = false;
                Open_Button.Enabled = false;
                Delete_Button.Enabled = false;
            }
            else
            {
                Export_Button.Enabled = true;
                if (SearchResultGridView.SelectedRows.Count > 1)
                {
                    Open_Button.Enabled = false;
                }
                else
                {
                    Open_Button.Enabled = true;
                }
                Delete_Button.Enabled = true;
            }
        }


        /// <summary><para>method outline</para>
        /// <para>表ダブルクリック選択イベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.SearchResultGridView.DoubleClick += new System.EventHandler(this.SearchResultGridView_DoubleClick);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">DataGridViewCellEventArgs</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プロジェクト選択状態のみ実行可能なボタンの制御を行う</para>
        /// </remarks>
        private void SearchResultGridView_DoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex < 0)
            {
                return;
            }

            // 選択状態の行がない場合は「エクスポート」「開く」「削除」ボタンを非活性にする
            if (SearchResultGridView.SelectedRows.Count == 0)
            {
                Export_Button.Enabled = false;
                Open_Button.Enabled = false;
                Delete_Button.Enabled = false;
            }
            else
            {
                Export_Button.Enabled = true;
                Open_Button.Enabled = true;
                Delete_Button.Enabled = true;
                this.Open(sender, e);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>エクスポートボタンクリック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.Export_Button.Click += new System.EventHandler(this.Delete);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Export(object sender, EventArgs e)
        {
            const string csFileExt = ".prjdb";

            saveFileDialog1.FileName = "ExportData";
            saveFileDialog1.Filter = Properties.McDotNetViewerResources.FILE_DLG_FILTER_PRJDB;  //"プロジェクトデータファイル (*.prjdb)|*.prjdb"
            saveFileDialog1.AddExtension = true;
            saveFileDialog1.Title = Properties.McDotNetViewerResources.FILE_DLG_TITLE_SAVE_PROJECT; //"プロジェクトデータファイル保存先選択"
            saveFileDialog1.RestoreDirectory = true;

            if (saveFileDialog1.ShowDialog(this) == DialogResult.OK)
            {
                string csFilePath = saveFileDialog1.FileName;
                if (Path.GetExtension(csFilePath) != csFileExt)
                {
                    csFilePath += csFileExt;
                }

                // エクスポートイベント生成 
                HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DB_COMMON);
                csEvent.SetSubEventNo(McDefine.HYM_PRJDATA_EXPORT);
                csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
                HySString csSavePath = new HySString(csFilePath);
                csEvent.SetData(csSavePath);
                HySDataLinkedList csExportList = new HySDataLinkedList();
                McProjectInfData csProjectInf = null;
                for (int iLp = 0; iLp < SearchResultGridView.SelectedRows.Count; iLp++)
                {
                    // 対象のプロジェクト情報取得
                    csProjectInf = (McProjectInfData)SearchResultGridView.SelectedRows[iLp].Cells[25].Value;
                    csExportList.AddLast(csProjectInf.GetProjectID());
                }
                csEvent.SetSubData(csExportList);
                if (false == this.PutEvent(csEvent))
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "Export", 
                        Properties.McDotNetViewerResources.STATEMENT_CMND_DB_COMMON_NG );
                   // HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "Export", "PutEvent CMND_DB_COMMON is failed.");
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>エクスポート報告コールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CallBackNoticeDelete(); </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void CallBackNoticeExport()
        {
            MessageBox.Show(MSG_COMPLETE_DB_EXPORT, MSGBOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Help_Button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Help_Button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_PROJECT_0005,
                        ((HySDotNetViewer)((McDotNetProjectCtlScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }
    }
}
