// <summary>ソースコード：シミュレーター使用関連情報生成制御フォーム</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.Tool;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;    
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>シミュレーター使用関連情報生成制御フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public partial class McDotNetModelGenerateCtlForm : HySDotNetForm
    {
        /// <summary>制御するクリーン </summary>
        protected McDotNetModelGenerateCtlScreen m_csDataGenerateCtlScreen = null;
        /// <summary>手入力画面一覧 </summary>
        protected HySDataLinkedList m_csMdlDataGenScreenList = null;
        /// <summary>モデルジェネレーター一覧 </summary>
        protected HySDataLinkedList m_csMdlGenList = null;
        /// <summary>リストボックス選択文字列 </summary>
        public string m_csMdlGenClickString = null;

        ///// <summary> モデルジェネレーターフォーム</summary>
        //protected McDotNetModelDataGeneratorFormBase m_csMGSDataSelectForm = null;

        /// <summary>定義ファイルパス</summary>
        private static HySString DEF_PATH = new HySString("\\temp");

        /// <summary>生成構造定義ファイルパス格納用</summary>
        private HySString m_csFullPath = HySEnvInf.GetHomeDirectory() + DEF_PATH;

        /// <summary>テキストボックスのツールチップ用</summary>
        private ToolTip toolTipMsg = new ToolTip();

        //定数定義
        ///// <summary>ライブラリプロパティ名称　「モデル名称」 </summary>
        //static protected readonly String PROPERTY_MODELNAME = Properties.McDotNetViewerResources.PROPERTY_MODELNAME;
        // ↓↓↓　リソースファイルに定義予定。現在は固定
        /// <summary>ライブラリプロパティ名称　「ツール名称」 </summary>
        static protected readonly String PROPERTY_TOOLNAME = Properties.McDotNetViewerResources.PROPERTY_TOOLNAME; //"ツール名称";
        /// <summary>ライブラリプロパティ名称　「画面名称」 </summary>
        static protected readonly String PROPERTY_DISPNAME = Properties.McDotNetViewerResources.PROPERTY_SCREENNAME; //"画面名称";
        // ↑↑↑
        /// <summary>ライブラリプロパティ名称　「作成者」 </summary>
        static protected readonly String PROPERTY_CREATOR = Properties.McDotNetViewerResources.PROPERTY_CREATOR;
        /// <summary>ライブラリプロパティ名称　「バージョン」 </summary>
        static protected readonly String PROPERTY_VERSION = Properties.McDotNetViewerResources.PROPERTY_VERSION;
        /// <summary>ライブラリプロパティ名称　「概要」 </summary>
        static protected readonly String PROPERTY_SUMMARY = Properties.McDotNetViewerResources.PROPERTY_SUMMARY;
        /// <summary>ライブラリプロパティ名称　「名称」 </summary>
        static protected readonly String PROPERTY_NAME = Properties.McDotNetViewerResources.PROPERTY_NAME;

        /// <summary>ライブラリ管理 プロパティグリッド高さ</summary>
        static protected readonly int SUMMARY_ROW_HEIGHT = 52;
        /// <summary>ライブラリ管理 項目グリッド高さ</summary>
        static protected readonly int ITEMROW_HEIGHT = 18;

        /// <summary>モデル名称プロパティ </summary>
        protected string m_sModelName;
        /// <summary>作成者プロパティ </summary>
        protected string m_sCreatorInf;
        /// <summary>バージョンプロパティ </summary>
        protected string m_sVersionInf;
        /// <summary>概要プロパティ </summary>
        protected string m_sSummaryInf;

        /// <summary>モデル情報格納用 </summary>
        protected McModelInfo m_csModelInfo=null;

        /// <summary>コンボボックスで選択されたモデルジェネレーター情報 </summary>
        protected McModelInfo m_csComboModelInfo = null;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetNewProjectForm csNewProjectForm = new McDotNetNewProjectForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McDotNetModelGenerateCtlForm()
        {
            InitializeComponent();
        }
              
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetNewProjectForm csNewProjectForm = new McDotNetNewProjectForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>McDotNetNewProjectForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetModelGenerateCtlForm(HySScreen csScreen)
        {
            InitializeComponent();
            m_csScreen = csScreen;
            DataCompInit();                     // 概要説明欄初期化
            PropertyDataCompInit();

            // 作成開始ボタンを活性とし、中断ボタンを非活性とする
            this.ModelConstructionStart.Enabled = true;
            this.BreakModelConstruction.Enabled = false;

            // 閉じるボタンを活性
            this.CloseButton.Enabled = true;

            m_csDataGenerateCtlScreen = csScreen as McDotNetModelGenerateCtlScreen; // 便利の為

        }
        /// <summary><para>method outline:</para>
        /// <para>モデルジェネレーター固有画面の情報リストを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelGeneratorScreenList(csMdlDataGenScreenList)</para>
        /// </example>
        /// <param name="csMdlDataGenScreenList">モデルジェネレーター固有画面の情報リスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void SetModelGeneratorScreenList(HySDataLinkedList csMdlDataGenScreenList)
        {
            m_csMdlDataGenScreenList = csMdlDataGenScreenList;

        }
        /// <summary><para>method outline:</para>
        /// <para>手入力画面一覧の情報リストを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelSettingScreenList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void SetModelSettingScreenList()
        {
            // リストボックスクリア
            this.listBox1.Items.Clear();

            // モデル数分ループ
            for (int iCnt = 0; iCnt < m_csMdlDataGenScreenList.GetCount(); iCnt++)
            {
                // クリア処理
                PropertyDataCompInit();

                // モデル情報取得
                m_csModelInfo = m_csMdlDataGenScreenList.GetData(iCnt) as McModelInfo;

                if( ((m_csModelInfo.GetLibraryID()).GetString()).ToString() == "HYMCO.MdlGenScreenCommonLIB" )
                {
                    SetPropertyDataComp();
                    // モデル情報表示
                    this.listBox1.Items.Add(m_sModelName);
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル作成クラスの情報リストを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelNetworkGeneratorInfoList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void SetModelNetworkGeneratorInfoList()
        {
            // コンボボックスクリア
            this.comboBox1.Items.Clear();
            this.comboBox1.Text = "";

            // モデル数分ループ
            for (int iCnt = 0; iCnt < m_csMdlGenList.GetCount(); iCnt++)
            {
                // クリア処理
                PropertyDataCompInit();

                // モデル情報取得
                m_csModelInfo = m_csMdlGenList.GetData(iCnt) as McModelInfo;
                SetPropertyDataComp();

                // モデル情報表示
                this.comboBox1.Items.Add(m_sModelName);
            }
            this.comboBox1.Refresh();

            // モデル情報クリア
            PropertyDataCompInit();

            // モデル情報表示
            DataGridView2.Rows[0].Cells[1].Value = m_sModelName;    // モデル名称
            DataGridView2.Rows[1].Cells[1].Value = m_sCreatorInf;   // 作成者プロパティ
            DataGridView2.Rows[2].Cells[1].Value = m_sVersionInf;   // バージョンプロパティ
            DataGridView2.Rows[3].Cells[1].Value = m_sSummaryInf;   // 概要プロパティ
            // 選択解除
            DataGridView2.ClearSelection();
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル作成クラスコンボボックスの選択位置を返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SelectComboBoxIndex()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>選択位置</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal int SelectComboBoxIndex()
        {
            return(this.comboBox1.SelectedIndex);
        }
        /// <summary><para>method outline:</para>
        /// <para>生成構造定義ファイル名を返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SelectComboBoxIndex()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファイル名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal string GetTextBoxName()
        {
            return (this.textBox1.Text);
        }
        /// <summary><para>method outline:</para>
        /// <para>手入力画面一覧の情報リストをクリアする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetStateDispMDGSetScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void SetStateDispMDGSetScreen()
        {
            //手入力画面表示開始ボタン無効
            //DispMDGSetScreen.Enabled = false;

            PropertyDataCompInit();

            // モデル情報表示
            DataGridView1.Rows[0].Cells[1].Value = m_sModelName;    // モデル名称
            DataGridView1.Rows[1].Cells[1].Value = m_sCreatorInf;   // 作成者プロパティ
            DataGridView1.Rows[2].Cells[1].Value = m_sVersionInf;   // バージョンプロパティ
            DataGridView1.Rows[3].Cells[1].Value = m_sSummaryInf;   // 概要プロパティ

            // 選択解除
            DataGridView1.ClearSelection();
            
        }

        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラスの情報リストを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelNetworkGeneratorList(csMdlGenList)</para>
        /// </example>
        /// <param name="csMdlGenList">演算要素モデルネットワーク生成クラスの情報リスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void SetModelNetworkGeneratorList(HySDataLinkedList csMdlGenList)
        {
            m_csMdlGenList = csMdlGenList;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>フォームローディング</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetGISDataGenerateCtlForm_Load( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetGISDataGenerateCtlForm_Load(object sender, EventArgs e)
        {
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>クローズ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Close_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Close_Click(object sender, EventArgs e)
        {
            // 画面非表示時のデータクリア
            this.HideDataClear();
            // 画面非表示
            m_csDataGenerateCtlScreen.HideScreen();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面非表示時のデータクリア</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HideDataClear()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HideDataClear()
        {
            McModelDataGenerationInfo csMDGInfo = m_csDataGenerateCtlScreen.GetMdlGenerationInfo();
            csMDGInfo.Clear();
            HySDataHashTable csLblTbl = m_csDataGenerateCtlScreen.GetMdlDataDispLabel();
            csLblTbl.ClearAllObject();
            this.textBox1.Clear();
            this.toolTipMsg.RemoveAll(); // ツールチップ削除
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルジェネレーション開始</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ModelConstructionStart_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ModelConstructionStart_Click(object sender, EventArgs e)
        {
            if (m_csDataGenerateCtlScreen.ModelConstructionStart() == true)
            {
                // 作成開始ボタンを非活性とし、中断ボタンを活性とする
                this.ModelConstructionStart.Enabled = false;
                this.BreakModelConstruction.Enabled = true;

                // 閉じるボタンを非活性
                this.CloseButton.Enabled = false;

                // カーソルを砂時計にする。
                if (this.MdiParent != null)
                {
                    this.MdiParent.Cursor = Cursors.WaitCursor;
                }
                else
                {
                    this.Cursor = Cursors.WaitCursor;
                }
            }
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>標高値標準データ作成開始（ＧＩＳへ依頼）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GISWaterLevelDataGenerationStart_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GISDataGenerationStart_Click(object sender, EventArgs e)
        {
            m_csDataGenerateCtlScreen.GISDataGenerationStart();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>手入力画面の表示開始</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DispMDGSetScreen_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DispMDGSetScreen_Click(object sender, EventArgs e)
        {
            // モデルが選択されているか
            if (this.comboBox1.SelectedIndex != -1)
            {
                if (listBox1.SelectedIndex != -1)
                {

                    // リストより選択されている画面を
                    // 表示開始する
                    m_csMdlGenClickString = listBox1.SelectedItem.ToString();

                    // 実験用仮処理
                    McModelInfo csScreenInfo = m_csMdlDataGenScreenList.GetData(0) as McModelInfo;

                    // モデル数分ループ
                    for (int iJcnt = 0; iJcnt < m_csMdlDataGenScreenList.GetCount(); iJcnt++)
                    {
                        // モデル情報取得
                        m_csModelInfo = m_csMdlDataGenScreenList.GetData(iJcnt) as McModelInfo;

                        SetPropertyDataComp();

                        if (m_csMdlGenClickString == m_sModelName)
                        {
                            csScreenInfo = m_csModelInfo;
                            break;
                        }
                    }
                    m_csDataGenerateCtlScreen.DispMdlDataGenScreen(csScreenInfo);
                }
                else
                {
                    //MessageBox.Show("モデル用データ手入力画面が選択されていません。", "エラーメッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    MessageBox.Show(McMessage.GetString("MC_MSG_ERROR_MG_SELECT_DATASCRREN"), McMessage.GetString("MC_MSG_TITLE_ERROR_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
            else
            {
                //MessageBox.Show("モデル構造定義生成ツールが選択されていません。", "エラーメッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                MessageBox.Show(McMessage.GetString("MC_MSG_ERROR_MG_SELECT_DATATOOL"), McMessage.GetString("MC_MSG_TITLE_ERROR_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>リスト文字列取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>string sList = GetListString( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal string GetListString()
        {
            return m_csMdlGenClickString;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル作成中断</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>BreakModelConstruction_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void BreakModelConstruction_Click(object sender, EventArgs e)
        {
            m_csDataGenerateCtlScreen.BreakModelConstruction();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>リスト選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>listBox1_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void listBox1_Click(object sender, EventArgs e)
        {
            // 手入力画面表示開始ボタン有効
            //DispMDGSetScreen.Enabled = true;

            // クリア処理
            PropertyDataCompInit();

            if (listBox1.SelectedIndex == -1)
            {
                return;
            }

            // モデル情報取得
            m_csMdlGenClickString = listBox1.SelectedItem.ToString();

            // モデル数分ループ
            for (int iJcnt = 0; iJcnt < m_csMdlDataGenScreenList.GetCount(); iJcnt++)
            {
                // モデル情報取得
                m_csModelInfo = m_csMdlDataGenScreenList.GetData(iJcnt) as McModelInfo;

                SetPropertyDataComp();

                if (listBox1.SelectedItem.ToString() == m_sModelName)
                {
                    break;
                }
            }

            // モデル情報表示
            DataGridView1.Rows[0].Cells[1].Value = m_sModelName;    // モデル名称
            DataGridView1.Rows[1].Cells[1].Value = m_sCreatorInf;   // 作成者プロパティ
            DataGridView1.Rows[2].Cells[1].Value = m_sVersionInf;   // バージョンプロパティ
            DataGridView1.Rows[3].Cells[1].Value = m_sSummaryInf;   // 概要プロパティ

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>概要説明欄初期化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>DataCompInit()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataCompInit()
        {
            long lcount;
            DataGridViewRow row;

            // 演算要素プロパティ初期表示
            for (lcount = 0; lcount < 4; lcount++)
            {
                DataGridView1.Rows.Add();
            }
            DataGridView1.Rows[0].Cells[0].Value = PROPERTY_DISPNAME;
            DataGridView1.Rows[1].Cells[0].Value = PROPERTY_CREATOR;
            DataGridView1.Rows[2].Cells[0].Value = PROPERTY_VERSION;
            DataGridView1.Rows[3].Cells[0].Value = PROPERTY_SUMMARY;
            row = DataGridView1.Rows[3];
            row.Height = SUMMARY_ROW_HEIGHT;
            DataGridView1.Rows[3].DefaultCellStyle.WrapMode = DataGridViewTriState.True;

            // 演算要素プロパティ初期表示
            for (lcount = 0; lcount < 4; lcount++)
            {
                DataGridView2.Rows.Add();
            }
            DataGridView2.Rows[0].Cells[0].Value = PROPERTY_TOOLNAME;
            DataGridView2.Rows[1].Cells[0].Value = PROPERTY_CREATOR;
            DataGridView2.Rows[2].Cells[0].Value = PROPERTY_VERSION;
            DataGridView2.Rows[3].Cells[0].Value = PROPERTY_SUMMARY;
            row = DataGridView2.Rows[3];
            row.Height = SUMMARY_ROW_HEIGHT;
            DataGridView2.Rows[3].DefaultCellStyle.WrapMode = DataGridViewTriState.True;

            // 選択解除
            DataGridView1.ClearSelection();
            DataGridView2.ClearSelection();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>概要説明欄プロパティ初期化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PropertyDataCompInit(　)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PropertyDataCompInit()
        {
            m_sModelName = null;
            m_sCreatorInf = null;
            m_sVersionInf = null;
            m_sSummaryInf = null;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>概要説明欄プロパティ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetPropertyDataComp(　)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SetPropertyDataComp()
        {
            //プロパティ情報が設定されているかどうかチェック
            if (m_csModelInfo.GetModelName() != "") // モデル名称プロパティ格納
            {
                m_sModelName = m_csModelInfo.GetModelName().ToString();
            }
            if (m_csModelInfo.GetCreatorInf() != "") // 作成者プロパティ格納
            {
                m_sCreatorInf = m_csModelInfo.GetCreatorInf().ToString();
            }
            if (m_csModelInfo.GetVersionInf() != "") // バージョンプロパティ格納
            {
                m_sVersionInf = m_csModelInfo.GetVersionInf().ToString();
            }
            if (m_csModelInfo.GetSummaryInf() != "") // 概要プロパティ格納
            {
                m_sSummaryInf = m_csModelInfo.GetSummaryInf().ToString();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じるイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelGenerateCtlForm_FormClosing( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetModelGenerateCtlForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            // ユーザーインターフェイスによるクローズか
            if( e.CloseReason.Equals(CloseReason.UserClosing))
            {
                e.Cancel = true;
                if (this.CloseButton.Enabled == true)
                {
                    this.HideDataClear();
                    m_csDataGenerateCtlScreen.HideScreen();
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HelpJump_button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODELGEN_0001,
                        ((HySDotNetViewer)((McDotNetModelGenerateCtlScreen)m_csScreen).GetViewer()).GetMainForm().Parent);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンボボックス選択終了</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>comboBox1_SelectionChangeCommitted( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void comboBox1_SelectionChangeCommitted(object sender, EventArgs e)
        {
            // クリア処理
            PropertyDataCompInit();

            // モデル情報取得
            int iCnt = this.comboBox1.SelectedIndex;
            if (iCnt != -1)
            {
                m_csComboModelInfo = m_csMdlGenList.GetData(iCnt) as McModelInfo;
                m_csModelInfo = m_csMdlGenList.GetData(iCnt) as McModelInfo;
                SetPropertyDataComp();

                // モデル情報表示
                DataGridView2.Rows[0].Cells[1].Value = m_sModelName;    // モデル名称
                DataGridView2.Rows[1].Cells[1].Value = m_sCreatorInf;   // 作成者プロパティ
                DataGridView2.Rows[2].Cells[1].Value = m_sVersionInf;   // バージョンプロパティ
                DataGridView2.Rows[3].Cells[1].Value = m_sSummaryInf;   // 概要プロパティ

                // リストボックスクリア
                this.listBox1.Items.Clear();

                // モデル数分ループ
                for (int iJcnt = 0; iJcnt < m_csMdlDataGenScreenList.GetCount(); iJcnt++)
                {
                    // クリア処理
                    PropertyDataCompInit();

                    // モデル情報取得
                    m_csModelInfo = m_csMdlDataGenScreenList.GetData(iJcnt) as McModelInfo;

                    if ( m_csModelInfo.GetLibraryID().Equals(McDotNetCommonDef.COMMON_MODEL_GEN_MANULAL_SCREEN_FACTORY_LIB_ID) == true
                         || m_csModelInfo.GetLibraryID().Equals(m_csComboModelInfo.GetLibraryID()) == true)
                    {
                        SetPropertyDataComp();
                        // モデル情報表示
                        this.listBox1.Items.Add(m_sModelName);

                    }
                }
                // 手入力画面一覧の情報リストをクリア
                SetStateDispMDGSetScreen();

                // 画面で選択されあたモデルジェネレータを設定する
                this.m_csDataGenerateCtlScreen.SetModelGenerationInfo(m_csComboModelInfo);
                this.m_csDataGenerateCtlScreen.MakeInitialModelGenerationDataSetList();
                if (this.FileListGridView.Rows.Count > 0)
                {
                    // 既にファイル一覧が表示されている場合、汎用データ種別の設定は残す
                    this.UpdataFielNameHashList();
                }
                this.UpdataFileList();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>作成開始ボタンの状態を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ButtonStatusSet()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void ButtonStatusSet()
        {
            // 作成開始ボタンを活性とし、中断ボタンを非活性とする
            this.ModelConstructionStart.Enabled = true;
            this.BreakModelConstruction.Enabled = false;

            // 閉じるボタンを活性
            this.CloseButton.Enabled = true;

            // カーソルをデフォルトにする。
            if (this.MdiParent != null)
            {
                this.MdiParent.Cursor = Cursors.Default;
            }
            else
            {
                this.Cursor = Cursors.Default;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ハッシュテーブルのファイル名称更新処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> UpdataFielNameHashList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void UpdataFielNameHashList()
        {
            McModelDataGenerationInfo csMDGInfo = m_csDataGenerateCtlScreen.GetMdlGenerationInfo();
            HySDataHashTable csLblTbl = m_csDataGenerateCtlScreen.GetMdlDataDispLabel();

            // ファイル一覧の画面情報をハッシュテーブルに格納
            int iRowCnt = this.FileListGridView.Rows.Count;

            HySDataLinkedList csList = csLblTbl.GetKeyList(); // キーリスト一覧取得
            HySID[] csID = null;
            if (csList is HySDataLinkedList)
            {
                long lPosNum = csList.GetCount(); // 一覧表件数取得
                if (lPosNum > 0)
                {  // 登録データがある場合
                    csID = new HySID[lPosNum];
                    for (int iLp = 0; iLp < lPosNum; iLp++)
                    {  // 登録データ件数分繰り返す
                        // ハッシュテーブルのデータ種別取得
                        HySString csPosID = csList.GetData((long)iLp) as HySString;
                        HySString csHashName = (HySString)csLblTbl.GetObject(csPosID);
                        string csHashDataKind = csHashName.ToString();

                        // 一覧件数分ループ
                        for (int iRow = 0; iRow < iRowCnt; iRow++)
                        {
                            // 一覧のデータ種別取得
                            string csGridDataKind = this.FileListGridView.Rows[iRow].Cells[0].Value.ToString();

                            if (csGridDataKind == csHashDataKind)
                            {
                                if (this.FileListGridView.Rows[iRow].Cells[1].Value != null
                                    && this.FileListGridView.Rows[iRow].Cells[1].Value.ToString() != "")
                                {
                                    // 一覧のファイル名をハッシュテーブルにセット
                                    string csGridFileName = this.FileListGridView.Rows[iRow].Cells[1].Value.ToString();
                                    csMDGInfo.SetInfo(csPosID.ToString(), csGridFileName);
                                }
                                break;
                            }
                        }
                    }
                }
            }
        }
        
        /// <summary><para>method outline:</para>
        /// <para>ファイル一覧更新処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> UpdataFileList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void UpdataFileList()
        {
            this.FileListGridView.Rows.Clear();

            List<string> csHashSortList = new List<string>();
            McModelDataGenerationInfo csMDGInfo = m_csDataGenerateCtlScreen.GetMdlGenerationInfo();
            HySID[] csID = null;

            HySDataHashTable csLblTbl = m_csDataGenerateCtlScreen.GetMdlDataDispLabel();
            HySDataLinkedList csList = csLblTbl.GetKeyList(); // キーリスト一覧取得
            if (csList is HySDataLinkedList)
            {
                long lPosNum = csList.GetCount(); // 一覧表件数取得
                if (lPosNum > 0)
                {  // 登録データがある場合
                    csID = new HySID[lPosNum];
                    for (int iLp = 0; iLp < lPosNum; iLp++)
                    {  // 登録データ件数分繰り返す
                        HySString csPosID = csList.GetData((long)iLp) as HySString;
                        // ハッシュテーブルをリストに設定
                        csHashSortList.Add(csPosID.ToString());

                    }
                }
            }
            // リストをソート
            csHashSortList.Sort();

            int iListCnt = csHashSortList.Count;

            for (int iCnt = 0; iCnt < iListCnt; iCnt++)
            {
                HySString csPosID = new HySString(csHashSortList[iCnt].ToString());
                if (csPosID is HySString)
                {  // データが有る場合
                    HySString sLabel = (HySString)csLblTbl.GetObject(csPosID);

                    HySString sParameterFileName = new HySString("");
                    csMDGInfo.GetInfo(csPosID, ref sParameterFileName);

                    this.FileListGridView.Rows.Add();       // 行追加
                    this.FileListGridView.Rows[iCnt].Cells[0].Value = sLabel.ToString();
                    this.FileListGridView.Rows[iCnt].Cells[1].Value = sParameterFileName.ToString();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>データグリッドビュークリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClearGridView()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void ClearGridView()
        {
            this.FileListGridView.Rows.Clear();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル一覧選定開始</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Settingbutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Settingbutton_Click(object sender, EventArgs e)
        {
            // モデルが選択されているか
            if (this.comboBox1.SelectedIndex != -1)
            {
                m_csDataGenerateCtlScreen.DispMdlDataGenSelectScreen(m_csComboModelInfo);
            }
            else
            {
                //MessageBox.Show("モデル構造定義生成ツールが選択されていません。", "エラーメッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                MessageBox.Show(McMessage.GetString("MC_MSG_ERROR_MG_SELECT_DATATOOL"), McMessage.GetString("MC_MSG_TITLE_ERROR_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイルセレクトボタン</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Openbutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Openbutton_Click(object sender, EventArgs e)
        {
            SaveFileDialog saveFileDialog1 = new SaveFileDialog();
            saveFileDialog1.InitialDirectory = this.m_csFullPath.ToString();
            saveFileDialog1.Filter = Properties.McDotNetViewerResources.FILE_DLG_FILTER_XML; //"ＸＭＬファイル(*.xml)|*.xml";
            saveFileDialog1.FilterIndex = 1;
            saveFileDialog1.RestoreDirectory = true;

            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                string csFilePath = saveFileDialog1.FileName;
                this.textBox1.Text = csFilePath;

                // ファイル名称部分削除
                int iIndex = csFilePath.LastIndexOf("\\");
                string csFolderPath = csFilePath.Remove(iIndex);
                // フォルダを覚えておく
                this.m_csFullPath.SetChar(csFolderPath);

                // ツールチップ表示
                if (csFilePath != "")
                {
                    //表示までの時間を0にする
                    //マウスポインタがコントロールの上にきた瞬間にメッセージが表示される
                    this.toolTipMsg.InitialDelay = 0;
                                        
                    //textBox1にツールチップを表示するように設定する
                    this.toolTipMsg.SetToolTip(this.textBox1, csFilePath);
                }
            }
            saveFileDialog1.Dispose();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>マウスポインタがコントロール領域から離れた</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>textBox1_MouseLeave( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void textBox1_MouseLeave(object sender, EventArgs e)
        {
            // 時間が経過してToolTipが消えた後、再びそのコントロールにマウスを移動させても
            // ToolTipが表示されない件の対策
            this.toolTipMsg.Active = false;
            this.toolTipMsg.Active = true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>アクティブ時イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelGenerateCtlForm_Activated( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetModelGenerateCtlForm_Activated(object sender, EventArgs e)
        {
            base.HySDotNetForm_Activated(sender, e);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>非アクティブ時イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelGenerateCtlForm_Deactivate( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetModelGenerateCtlForm_Deactivate(object sender, EventArgs e)
        {
            base.HySDotNetForm_Deactivate(sender, e);
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCutEvent()
        {
            // Cut処理
            if (this.ActiveControl.Name == "comboBox1")
            {
                if (comboBox1.SelectedText != string.Empty)
                {
                    Clipboard.SetText(comboBox1.SelectedText);
                    comboBox1.SelectedText = string.Empty;
                }
            }
            else if (this.ActiveControl.Name == "comboBox2")
            {
                if (comboBox2.SelectedText != string.Empty)
                {
                    Clipboard.SetText(comboBox2.SelectedText);
                    comboBox2.SelectedText = string.Empty;
                }
            }

        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCopyEvent()
        {
            // Copy処理
            if (this.ActiveControl.Name == "comboBox1")
            {
                if (comboBox1.SelectedText != string.Empty)
                {
                    Clipboard.SetText(comboBox1.SelectedText);
                }
            }
            else if (this.ActiveControl.Name == "comboBox2")
            {
                if (comboBox2.SelectedText != string.Empty)
                {
                    Clipboard.SetText(comboBox2.SelectedText);
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticePasteEvent()
        {
            // Paste処理
            if (this.ActiveControl.Name == "comboBox1")
            {
                comboBox1.SelectedText = Clipboard.GetText();
            }
            else if (this.ActiveControl.Name == "comboBox2")
            {
                comboBox2.SelectedText = Clipboard.GetText();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeDeleteEvent()
        {
            // Del処理
            if (this.ActiveControl.Name == "comboBox1")
            {
                if (comboBox1.SelectionLength == 0)
                {
                    // カーソル直後の1文字削除処理
                    comboBox1.SelectionLength = 1;
                }
                // 選択済文字列の削除処理
                comboBox1.SelectedText = string.Empty;
            }
            else if (this.ActiveControl.Name == "comboBox2")
            {
                if (comboBox2.SelectionLength == 0)
                {
                    // カーソル直後の1文字削除処理
                    comboBox2.SelectionLength = 1;
                }
                // 選択済文字列の削除処理
                comboBox2.SelectedText = string.Empty;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeAllSelectEvent()
        {
            // AllSelect処理
            if (this.ActiveControl.Name == "comboBox1")
            {
                comboBox1.SelectAll();
            }
            else if (this.ActiveControl.Name == "comboBox2")
            {
                comboBox2.SelectAll();
            }
        }

    }
}