﻿// <summary>ソースコード：ラッパーモデル情報編集制御フォーム</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
//using CommonMP.HYSSOP.Interface.HSController;
//using CommonMP.HYSSOP.Interface.HSData;
//using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
//using CommonMP.HYMCO.Interface;
//using CommonMP.HYMCO.CoreImpl.Data;
//using CommonMP.HYMCO.CoreImpl.Data.Tool;
//using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
//using CommonMP.HYMCO.CoreImpl.Tool.Msg;
//using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ラッパーモデル情報編集制御フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public partial class McDotNetWrapperModelInfoEditCtlForm : HySDotNetForm
    {
        /// <summary>ライブラリプロパティ名称　「モデル名称」 </summary>
        static protected readonly String PROPERTY_MODELNAME = Properties.McDotNetViewerResources.PROPERTY_MODELNAME;
        /// <summary>ライブラリプロパティ名称　「作成者」 </summary>
        static protected readonly String PROPERTY_CREATOR = Properties.McDotNetViewerResources.PROPERTY_CREATOR;
        /// <summary>ライブラリプロパティ名称　「バージョン」 </summary>
        static protected readonly String PROPERTY_VERSION = Properties.McDotNetViewerResources.PROPERTY_VERSION;
        /// <summary>ライブラリプロパティ名称　「概要」 </summary>
        static protected readonly String PROPERTY_SUMMARY = Properties.McDotNetViewerResources.PROPERTY_SUMMARY;
        
        /// <summary>制御するクリーン </summary>
        protected McDotNetWrapperModelInfoEditCtlScreen m_csWrapperModelInfoEditCtlScreen = null;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetWrapperModelInfoEditCtlForm csWrapperModelInfoEditCtlForm = new McDotNetWrapperModelInfoEditCtlForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        public McDotNetWrapperModelInfoEditCtlForm()
        {
            InitializeComponent();
        }
               
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetWrapperModelInfoEditCtlForm csWrapperModelInfoEditCtlForm = new McDotNetWrapperModelInfoEditCtlForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>McDotNetNewProjectForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetWrapperModelInfoEditCtlForm(HySScreen csScreen)
        {
            InitializeComponent();
            m_csScreen = csScreen;

            m_csWrapperModelInfoEditCtlScreen = csScreen as McDotNetWrapperModelInfoEditCtlScreen; // 便利の為

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>フォームローディング</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetWrapperModelInfoEditCtlForm_Load( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetWrapperModelInfoEditCtlForm_Load(object sender, EventArgs e)
        {
            string sIconKey = "";
            long lcount = 0;
            for (lcount = 0; lcount < 4; lcount++)
            {
                ModelInfo_dataGridView.Rows.Add();
            }
            ModelInfo_dataGridView.Rows[0].Cells[0].Value = PROPERTY_MODELNAME;
            ModelInfo_dataGridView.Rows[1].Cells[0].Value = PROPERTY_CREATOR;
            ModelInfo_dataGridView.Rows[2].Cells[0].Value = PROPERTY_VERSION;
            ModelInfo_dataGridView.Rows[3].Height *= 3;
            ModelInfo_dataGridView.Rows[3].DefaultCellStyle.WrapMode = DataGridViewTriState.True;
            ModelInfo_dataGridView.Rows[3].Cells[0].Value = PROPERTY_SUMMARY;
            ModelInfo_dataGridView.Rows[3].Cells[1].Value = "フォートランラッパーテストモデル。出力パターン：下流端出力、１次元縦断データ出力";
            HySString csHome = HySEnvInf.GetHomeDirectory();
            string sIconName = csHome.ToString() + "\\ModelIcon\\Default.ico";
            //listView1.LargeImageList = imageList1;
            Icon sIcon = new Icon(sIconName);
            sIconKey = imageList1.Images.Count.ToString();
            imageList1.Images.Add(sIconKey, sIcon);
            //listView1.Items.Add("河道モデル", sIconKey);
            listView1.Items.Add("Default", sIconKey);
            sIconName = csHome.ToString() + "\\ModelIcon\\Unknown.ico";
            sIcon = new Icon(sIconName);
            sIconKey = imageList1.Images.Count.ToString();
            imageList1.Images.Add(sIconKey, sIcon);
            //listView1.Items.Add("河道モデル", sIconKey);
            listView1.Items.Add("Unknown", sIconKey);
            sIconName = csHome.ToString() + "\\ModelIcon\\Lane.ico";
            sIcon = new Icon(sIconName);
            sIconKey = imageList1.Images.Count.ToString();
            imageList1.Images.Add(sIconKey, sIcon);
            //listView1.Items.Add("河道モデル", sIconKey);
            listView1.Items.Add("Lane", sIconKey);
            sIconName = csHome.ToString() + "\\ModelIcon\\Basin.ico";
            sIcon = new Icon(sIconName);
            sIconKey = imageList1.Images.Count.ToString();
            imageList1.Images.Add(sIconKey, sIcon);
            //listView1.Items.Add("河道モデル", sIconKey);
            listView1.Items.Add("Basin", sIconKey);
            sIconName = csHome.ToString() + "\\ModelIcon\\DefaultModel.ico";
            sIcon = new Icon(sIconName);
            sIconKey = imageList1.Images.Count.ToString();
            imageList1.Images.Add(sIconKey, sIcon);
            //listView1.Items.Add("一般モデル", sIconKey);
            listView1.Items.Add("DefaultModel", sIconKey);
            sIconName = csHome.ToString() + "\\ModelIcon\\FortranModel.ico";
            sIcon = new Icon(sIconName);
            sIconKey = imageList1.Images.Count.ToString();
            imageList1.Images.Add(sIconKey, sIcon);
            //listView1.Items.Add("フォートランモデル", sIconKey);
            listView1.Items.Add("FortranModel", sIconKey);
            //listView2.LargeImageList = imageList2;
            sIconName = csHome.ToString() + "\\ModelIcon\\folder_close.ico";
            sIcon = new Icon(sIconName);
            sIconKey = imageList2.Images.Count.ToString();
            imageList2.Images.Add(sIconKey, sIcon);
            listView2.Items.Add("水文", sIconKey);
            sIconKey = imageList2.Images.Count.ToString();
            imageList2.Images.Add(sIconKey, sIcon);
            listView2.Items.Add("河川", sIconKey);
            sIconKey = imageList2.Images.Count.ToString();
            imageList2.Images.Add(sIconKey, sIcon);
            listView2.Items.Add("ダム／発電", sIconKey);
            sIconKey = imageList2.Images.Count.ToString();
            imageList2.Images.Add(sIconKey, sIcon);
            listView2.Items.Add("用排水／地下水", sIconKey);
            sIconKey = imageList2.Images.Count.ToString();
            imageList2.Images.Add(sIconKey, sIcon);
            listView2.Items.Add("海岸／港湾", sIconKey);
            sIconKey = imageList2.Images.Count.ToString();
            imageList2.Images.Add(sIconKey, sIcon);
            listView2.Items.Add("水循環", sIconKey);
            sIconKey = imageList2.Images.Count.ToString();
            imageList2.Images.Add(sIconKey, sIcon);
            listView2.Items.Add("経済関連", sIconKey);
            sIconKey = imageList2.Images.Count.ToString();
            imageList2.Images.Add(sIconKey, sIcon);
            listView2.Items.Add("その他", sIconKey);
            sIconKey = imageList2.Images.Count.ToString();
            imageList2.Images.Add(sIconKey, sIcon);
            listView2.Items.Add("演算制御", sIconKey);
            sIconKey = imageList2.Images.Count.ToString();
            imageList2.Images.Add(sIconKey, sIcon);
            listView2.Items.Add("サンプルモデル等", sIconKey);
            sIconKey = imageList3.Images.Count.ToString();
            imageList3.Images.Add(sIconKey, sIcon);
            listView3.Items.Add("河川", sIconKey);
            sIconName = csHome.ToString() + "\\ModelIcon\\FortranModel.ico";
            sIcon = new Icon(sIconName);
            sIconKey = imageList4.Images.Count.ToString();
            imageList4.Images.Add(sIconKey, sIcon);
            //listView4.Items.Add("フォートランモデル", sIconKey);
            listView4.Items.Add("FortranModel", sIconKey);
            DllName_textBox.Text = "McFortranModelTPL.dll";
            Manual_textBox.Text = "McFortranModelTPL.pdf";
            for (lcount = 0; lcount < 1; lcount++)
            {
                dataGridView5.Rows.Add();
            }
            dataGridView5.Rows[0].Cells[0].Value = "上流端流入";
            dataGridView5.Rows[0].Cells[1].Value = "ポイント時系列情報";
            dataGridView5.Rows[0].Cells[2].Value = 1;
            dataGridView5.Rows[0].Cells[3].Value = "";
            for (lcount = 0; lcount < 1; lcount++)
            {
                dataGridView6.Rows.Add();
            }
            dataGridView6.Rows[0].Cells[0].Value = 1;
            dataGridView6.Rows[0].Cells[1].Value = "流量";
            dataGridView6.Rows[0].Cells[2].Value = "流量";
            dataGridView6.Rows[0].Cells[3].Value = "m3/sec";
            for (lcount = 0; lcount < 2; lcount++)
            {
                dataGridView8.Rows.Add();
            }
            dataGridView8.Rows[0].Cells[0].Value = "下流端出力";
            dataGridView8.Rows[0].Cells[1].Value = "ポイント時系列情報";
            dataGridView8.Rows[0].Cells[2].Value = 1;
            dataGridView8.Rows[0].Cells[3].Value = "";
            dataGridView8.Rows[1].Cells[0].Value = "断面出力";
            dataGridView8.Rows[1].Cells[1].Value = "１次元配列時系列情報";
            dataGridView8.Rows[1].Cells[2].Value = 64;
            dataGridView8.Rows[1].Cells[3].Value = "";
            for (lcount = 0; lcount < 3; lcount++)
            {
                dataGridView7.Rows.Add();
            }
            dataGridView7.Rows[0].Cells[0].Value = 1;
            dataGridView7.Rows[0].Cells[1].Value = "流量";
            dataGridView7.Rows[0].Cells[2].Value = "流量";
            dataGridView7.Rows[0].Cells[3].Value = "m3/sec";
            dataGridView7.Rows[1].Cells[0].Value = 2;
            dataGridView7.Rows[1].Cells[1].Value = "水位";
            dataGridView7.Rows[1].Cells[2].Value = "水位";
            dataGridView7.Rows[1].Cells[3].Value = "m";
            dataGridView7.Rows[2].Cells[0].Value = 3;
            dataGridView7.Rows[2].Cells[1].Value = "流速";
            dataGridView7.Rows[2].Cells[2].Value = "流速";
            dataGridView7.Rows[2].Cells[3].Value = "m/sec";
            for (lcount = 0; lcount < 1; lcount++)
            {
                dataGridView1.Rows.Add();
            }
            dataGridView1.Rows[0].Cells[0].Value = 1;
            dataGridView1.Rows[0].Cells[1].Value = "モデル内セル分割数+1";
            dataGridView1.Rows[0].Cells[2].Value = 51;
            for (lcount = 0; lcount < 4; lcount++)
            {
                dataGridView2.Rows.Add();
            }
            dataGridView2.Rows[0].Cells[0].Value = 1;
            dataGridView2.Rows[0].Cells[1].Value = "粗度";
            dataGridView2.Rows[0].Cells[2].Value = "0.03";
            dataGridView2.Rows[1].Cells[0].Value = 2;
            dataGridView2.Rows[1].Cells[1].Value = "川幅[m]";
            dataGridView2.Rows[1].Cells[2].Value = "200";
            dataGridView2.Rows[2].Cells[0].Value = 3;
            dataGridView2.Rows[2].Cells[1].Value = "川長[m]";
            dataGridView2.Rows[2].Cells[2].Value = "100000";
            dataGridView2.Rows[3].Cells[0].Value = 4;
            dataGridView2.Rows[3].Cells[1].Value = "河床勾配";
            dataGridView2.Rows[3].Cells[2].Value = "0.00005";
            for (lcount = 0; lcount < 3; lcount++)
            {
                dataGridView4.Rows.Add();
            }
            dataGridView4.Rows[0].Cells[0].Value = 1;
            dataGridView4.Rows[0].Cells[1].Value = "初期水位";
            dataGridView4.Rows[0].Cells[2].Value = "1";
            dataGridView4.Rows[1].Cells[0].Value = 2;
            dataGridView4.Rows[1].Cells[1].Value = "初期流量";
            dataGridView4.Rows[1].Cells[2].Value = "0.01";
            dataGridView4.Rows[2].Cells[0].Value = 3;
            dataGridView4.Rows[2].Cells[1].Value = "初期流速";
            dataGridView4.Rows[2].Cells[2].Value = "0.01";

            //listView1.LargeImageList.Images.Add(new Icon("C:\\DEVEROPE\CommonMP\Source\HYMCO\OptionImpl\ModelDeveloperStandardEdition\bin\ModelIcon\Basin.ico"));
            //listView1.LargeImageList.Images.Add(new Icon(@"C:\DEVEROPE\CommonMP\Source\HYMCO\OptionImpl\ModelDeveloperStandardEdition\bin\ModelIcon\DefaultModel.ico"));
            //listView1.Items.Add(new Icon(@,"C:\DEVEROPE\CommonMP\Source\HYMCO\OptionImpl\ModelDeveloperStandardEdition\bin\ModelIcon\Circulation.ico");
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>アクティブ時イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetWrapperModelInfoEditCtlForm_Activate( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetWrapperModelInfoEditCtlForm_Activate(object sender, EventArgs e)
        {
            base.HySDotNetForm_Activated(sender, e);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>非アクティブ時イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetWrapperModelInfoEditCtlForm_Deactivate( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetWrapperModelInfoEditCtlForm_Deactivate(object sender, EventArgs e)
        {
            base.HySDotNetForm_Deactivate(sender, e);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じるイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelGenerateCtlForm_FormClosing( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McDotNetModelGenerateCtlForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            // ユーザーインターフェイスによるクローズか
            if (e.CloseReason.Equals(CloseReason.UserClosing))
            {
                e.Cancel = true;
                m_csWrapperModelInfoEditCtlScreen.HideScreen();
            }
        }

        private void Add_Prpty_Int_button_Click(object sender, EventArgs e)
        {
            //McDotNetWrapperModelParaSetForm csParaSet = new McDotNetWrapperModelParaSetForm();
            //csParaSet.Text = "整数パラメータ設定画面";
            //csParaSet.ShowDialog();
        }

        private void button12_Click(object sender, EventArgs e)
        {
            //McDotNetWrapperModelRcvSndPtnSetForm csRcvSndPtnSet = new McDotNetWrapperModelRcvSndPtnSetForm();
            //csRcvSndPtnSet.Text = "受信パターン設定画面";
            //csRcvSndPtnSet.ShowDialog();
        }

        private void button15_Click(object sender, EventArgs e)
        {
            //McDotNetWrapperModelRcvSndPtnSetForm csRcvSndPtnSet = new McDotNetWrapperModelRcvSndPtnSetForm();
            //csRcvSndPtnSet.Text = "送信パターン設定画面";
            //csRcvSndPtnSet.ShowDialog();
        }

        private void comboBox4_SelectedIndexChanged(object sender, EventArgs e)
        {
            groupBox15.Text = comboBox4.SelectedItem + "配列数";
            if (comboBox4.SelectedIndex == 0)
            {
                textBox10.Text = "1";
                textBox9.Text = "";
                label20.Text = "１次元";
                label19.Text = "２次元";
            }
            else if (comboBox4.SelectedIndex >= 1 && comboBox4.SelectedIndex <= 2)
            {
                textBox10.Text = "";
                textBox9.Text = "";
                label20.Text = "１次元";
                label19.Text = "２次元";
            }
            else
            {
                textBox10.Text = "";
                textBox9.Text = "";
                label20.Text = "緯度方向";
                label19.Text = "経度方向";
            }
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            groupBox10.Text = comboBox1.SelectedItem + "配列数";
            if (comboBox1.SelectedIndex == 0)
            {
                textBox7.Text = "1";
                //textBox8.Text = "";
                label16.Text = "１次元";
                label17.Text = "２次元";
            }
            else if (comboBox1.SelectedIndex >= 1 && comboBox1.SelectedIndex <= 2)
            {
                //textBox7.Text = "";
                //textBox8.Text = "";
                label16.Text = "１次元";
                label17.Text = "２次元";
            }
            else
            {
                //textBox7.Text = "";
                //textBox8.Text = "";
                label16.Text = "緯度方向";
                label17.Text = "経度方向";
            }
        }

        private void dataGridView5_SelectionChanged(object sender, EventArgs e)
        {
            int iLoop = 0;
            if (dataGridView5.SelectedRows.Count > 0)
            {
                for(iLoop=0;iLoop<comboBox1.Items.Count;iLoop++)
                {
                    if(comboBox1.Items[iLoop].ToString() == dataGridView5.SelectedRows[0].Cells[1].Value.ToString())
                    {
                        comboBox1.SelectedIndex = iLoop;
                        break;
                    }
                }
                textBox5.Text = dataGridView5.SelectedRows[0].Cells[0].Value.ToString();
                textBox7.Text = dataGridView5.SelectedRows[0].Cells[2].Value.ToString();
                textBox8.Text = dataGridView5.SelectedRows[0].Cells[3].Value.ToString();
                textBox27.Text = dataGridView5.SelectedRows[0].Cells[0].Value.ToString();
            }
        }

        private void dataGridView8_SelectionChanged(object sender, EventArgs e)
        {
            int iLoop = 0;
            if (dataGridView8.SelectedRows.Count > 0)
            {
                for (iLoop = 0; iLoop < comboBox4.Items.Count; iLoop++)
                {
                    if (comboBox4.Items[iLoop].ToString() == dataGridView8.SelectedRows[0].Cells[1].Value.ToString())
                    {
                        comboBox4.SelectedIndex = iLoop;
                        break;
                    }
                }
                textBox12.Text = dataGridView8.SelectedRows[0].Cells[0].Value.ToString();
                textBox10.Text = dataGridView8.SelectedRows[0].Cells[2].Value.ToString();
                textBox9.Text = dataGridView8.SelectedRows[0].Cells[3].Value.ToString();
                textBox28.Text = dataGridView8.SelectedRows[0].Cells[0].Value.ToString();
            }
        }

        private void dataGridView7_SelectionChanged(object sender, EventArgs e)
        {
            int iLoop = 0;
            if (dataGridView7.SelectedRows.Count > 0)
            {
                for (iLoop = 0; iLoop < comboBox3.Items.Count; iLoop++)
                {
                    if (comboBox3.Items[iLoop].ToString() == dataGridView7.SelectedRows[0].Cells[2].Value.ToString())
                    {
                        comboBox3.SelectedIndex = iLoop;
                        break;
                    }
                }
                textBox11.Text = dataGridView7.SelectedRows[0].Cells[1].Value.ToString();
                textBox14.Text = dataGridView7.SelectedRows[0].Cells[3].Value.ToString();
            }
        }

        private void dataGridView6_SelectionChanged(object sender, EventArgs e)
        {
            int iLoop = 0;
            if (dataGridView6.SelectedRows.Count > 0)
            {
                for (iLoop = 0; iLoop < comboBox2.Items.Count; iLoop++)
                {
                    if (comboBox2.Items[iLoop].ToString() == dataGridView6.SelectedRows[0].Cells[2].Value.ToString())
                    {
                        comboBox2.SelectedIndex = iLoop;
                        break;
                    }
                }
                textBox6.Text = dataGridView6.SelectedRows[0].Cells[1].Value.ToString();
                textBox13.Text = dataGridView6.SelectedRows[0].Cells[3].Value.ToString();
            }
        }

        private void dataGridView1_SelectionChanged(object sender, EventArgs e)
        {
            if (dataGridView1.SelectedRows.Count > 0)
            {
                textBox15.Text = dataGridView1.SelectedRows[0].Cells[0].Value.ToString();
                textBox16.Text = dataGridView1.SelectedRows[0].Cells[1].Value.ToString();
                textBox17.Text = dataGridView1.SelectedRows[0].Cells[2].Value.ToString();
            }
        }

        private void dataGridView2_SelectionChanged(object sender, EventArgs e)
        {
            if (dataGridView2.SelectedRows.Count > 0)
            {
                textBox23.Text = dataGridView2.SelectedRows[0].Cells[0].Value.ToString();
                textBox22.Text = dataGridView2.SelectedRows[0].Cells[1].Value.ToString();
                textBox21.Text = dataGridView2.SelectedRows[0].Cells[2].Value.ToString();
            }
        }

        private void dataGridView3_SelectionChanged(object sender, EventArgs e)
        {
            if (dataGridView3.SelectedRows.Count > 0)
            {
                textBox26.Text = dataGridView3.SelectedRows[0].Cells[0].Value.ToString();
                textBox25.Text = dataGridView3.SelectedRows[0].Cells[1].Value.ToString();
                textBox24.Text = dataGridView3.SelectedRows[0].Cells[2].Value.ToString();
            }
        }

        private void dataGridView4_SelectionChanged(object sender, EventArgs e)
        {
            if (dataGridView4.SelectedRows.Count > 0)
            {
                textBox20.Text = dataGridView4.SelectedRows[0].Cells[0].Value.ToString();
                textBox19.Text = dataGridView4.SelectedRows[0].Cells[1].Value.ToString();
                textBox18.Text = dataGridView4.SelectedRows[0].Cells[2].Value.ToString();
            }
        }

        private void Close_button_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void button10_Click(object sender, EventArgs e)
        {
            //Icon sIcon = new Icon(@"C:\CommonMP\Program2008\CommonMP\Execute\ModelIcon\FortranModel.ico");
            Icon sIcon = null;
            //string sIconKey = imageList4.Images.Count.ToString();
            string sIconKey = null;
            string sIconName = null;
            openFileDialog1.Filter = "アイコンファイル(*.ico)|*.ico";
            if (openFileDialog1.ShowDialog(this.Owner) == DialogResult.OK)
            {
                char[] cWork = null;
                sIcon = new Icon(openFileDialog1.FileName);
                int iIndex = openFileDialog1.FileName.LastIndexOf("\\");
                int iNCopy = openFileDialog1.FileName.Length - iIndex - 5;
                cWork = new Char[iNCopy + 1];
                sIconName = openFileDialog1.FileName.Substring(iIndex + 1, iNCopy);
                if (imageList4.Images.Count == 0)
                {
                    sIconKey = imageList4.Images.Count.ToString();
                    imageList4.Images.Add(sIconKey, sIcon);
                    listView4.Items.Add(sIconName, sIconKey);
                }
                else
                {
                    imageList4.Images.Clear();
                    listView4.Items.Clear();
                    sIconKey = imageList4.Images.Count.ToString();
                    imageList4.Images.Add(sIconKey, sIcon);
                    listView4.Items.Add(sIconName, sIconKey);
                }
            }
        }
   }
}
