﻿// <summary>ソースコード：モデル生成情報設定フォームクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;


namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>モデルジェネレータ個別モデル用設定画面標準フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public partial class McMdlGenDataCmnSelectForm : McModelGeneratorDataSelectScreenFormBase
    {
        /// <summary>定義ファイルパス</summary>
        private static HySString DEF_PATH = new HySString("\\temp\\ModelGenerator");

        /// <summary>コンボボックスで選択されたモデルジェネレーターが必要とする情報リスト </summary>
        private HySDataLinkedList m_csMdlGenDataListScreen = null;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McMdlGenDataCmnSelectForm()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        public McMdlGenDataCmnSelectForm()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル生成に必要なデータのリストの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNeedDataList(HySDataLinkedList csNeedDataList) </para>
        /// </example>
        /// <param name="csNeedDataList">モデル生成に必要なデータのリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetNeedDataList(HySDataLinkedList csNeedDataList)
        {
            m_csMdlGenDataListScreen = csNeedDataList;
        }

        /// <summary> <para>method outline:</para>
        /// <para>データグリッドビューヘッダー部設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetHeaderDataGridView() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetHeaderDataGridView()
        {
            dataGridView1.ColumnCount = 2;

            dataGridView1.Columns[0].Width = 150;
            dataGridView1.Columns[0].HeaderText = Properties.McDotNetViewerResources.ITEM_DATA_TYPE; //"データ種別";
            dataGridView1.Columns[0].ReadOnly = true;

            dataGridView1.Columns[1].Width = 500;
            dataGridView1.Columns[1].HeaderText = Properties.McDotNetViewerResources.ITEM_FILE_NAME; //"ファイル名";
            dataGridView1.Columns[1].ReadOnly = true;
        }

        /// <summary> <para>method outline:</para>
        /// <para>データグリッドビューデータ部設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetDataGridView() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDataGridView()
        {
            McModelDataGenerationInfo csMDGInfo = this.GetMdlGenerationInfo();
            List<string> csHashSortList = new List<string>();

            // ソートするためリストに格納
            long lGridListCnt = m_csMdlGenDataListScreen.GetCount();
            m_csMdlGenDataListScreen.SetCursorFirst();
            for (int iCnt = 0; iCnt < lGridListCnt; iCnt++)
            {
                McMdlGenNeedData csNeedData = (McMdlGenNeedData)m_csMdlGenDataListScreen.GetCursorData();
                string csModelKind = csNeedData.GetModelKind().ToString();    // データ種別

                // リストに設定
                csHashSortList.Add(csModelKind);

                m_csMdlGenDataListScreen.MoveCursorNext();
            }

            // リストをソート
            csHashSortList.Sort();

            // ソートしたリストで画面表示
            int iListCnt = csHashSortList.Count;
            for (int iCnt = 0; iCnt < iListCnt; iCnt++)
            {
                string csHashStr = csHashSortList[iCnt].ToString();

                m_csMdlGenDataListScreen.SetCursorFirst();
                for (int iDtCnt = 0; iDtCnt < lGridListCnt; iDtCnt++)
                {
                    McMdlGenNeedData csNeedData = (McMdlGenNeedData)m_csMdlGenDataListScreen.GetCursorData();

                    //string csLibraryID = csNeedData.GetLibraryID().ToString();    // 含まれるファクトリＩＤ
                    string csModelKind = csNeedData.GetModelKind().ToString();    // データ種別
                    string csModelName = csNeedData.GetModelName().ToString();    // 表示する時の名称

                    if (csHashStr == csModelKind)
                    {
                        HySString csPosID = new HySString(csModelKind);
                        HySString sParameterFileName = new HySString("");
                        csMDGInfo.GetInfo(csNeedData.GetModelKind(), ref sParameterFileName);

                        dataGridView1.Rows.Add();       // 行追加
                        dataGridView1.Rows[iCnt].Cells[0].Value = csModelName;    // 表示する時の名称表示
                        dataGridView1.Rows[iCnt].Cells[1].Value = sParameterFileName.ToString();    // ファイル名表示
                        break;
                    }

                    m_csMdlGenDataListScreen.MoveCursorNext();
                }
            }

            // カレントセル初期化
            dataGridView1.Focus();
            dataGridView1.CurrentCell = dataGridView1[0, 0];

        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Insertbutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Setbutton_Click(object sender, EventArgs e)
        {
            // パラメーター削除
            McModelDataGenerationInfo csMDGInfo = this.GetMdlGenerationInfo();
            csMDGInfo.Clear();

            HySDataHashTable csLblTbl = this.m_csCtlScreen.GetMdlDataDispLabel();
            csLblTbl.ClearAllObject();


            // 画面情報をハッシュテーブルに格納
            int iRowCnt = dataGridView1.Rows.Count;
            long lGridListCnt = m_csMdlGenDataListScreen.GetCount();
            for (int iRow = 0; iRow < iRowCnt; iRow++)
            {
                string csGetModelName = dataGridView1.Rows[iRow].Cells[0].Value.ToString();

                m_csMdlGenDataListScreen.SetCursorFirst();
                for (int iCnt = 0; iCnt < lGridListCnt; iCnt++)
                {
                    McMdlGenNeedData csNeedData = (McMdlGenNeedData)m_csMdlGenDataListScreen.GetCursorData();

                    //string csLibraryID = csNeedData.GetLibraryID().ToString();    // 含まれるファクトリＩＤ
                    string csModelKind = csNeedData.GetModelKind().ToString();    // データ種別
                    string csModelName = csNeedData.GetModelName().ToString();    // 表示する時の名称

                    if (csGetModelName == csModelName)
                    {
                        string csFileName = "";
                        if (dataGridView1.Rows[iCnt].Cells[1].Value != null)
                        {
                            csFileName = dataGridView1.Rows[iRow].Cells[1].Value.ToString();
                        }

                        // パラメーター設定
                        this.AddInfo(csModelKind, csModelName, csFileName);

                        break;
                    }
                    m_csMdlGenDataListScreen.MoveCursorNext();
                }
            }
            
            // 画面閉じる
            this.Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>取消</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Insertbutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancelbutton_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じるイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McMdlGenDataCmnSelectForm_FormClosing( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McMdlGenDataCmnSelectForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            this.NoticeFileDataSet();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セルをクリックした場合</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>dataGridView1_CellDoubleClick( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void dataGridView1_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            DataGridView dgv = (DataGridView)sender;
            if (e.ColumnIndex > -1 && e.RowIndex > -1)
            {
                if (dgv.Columns[e.ColumnIndex] is DataGridViewTextBoxColumn)
                {   // テキストボックス列か
                    //if (dgv.Columns[e.ColumnIndex].HeaderText.ToString() == "ファイル名")
                    if (dgv.Columns[e.ColumnIndex].HeaderText.ToString() == Properties.McDotNetViewerResources.ITEM_FILE_NAME)
                    {
                        OpenFileDialog openFileDialog1 = new OpenFileDialog();

                        HySString csFullPath = HySEnvInf.GetHomeDirectory() + DEF_PATH;
                        openFileDialog1.InitialDirectory = csFullPath.ToString();
                        openFileDialog1.Filter = Properties.McDotNetViewerResources.FILE_DLG_FILTER_CSVXML + "|" + Properties.McDotNetViewerResources.FILE_DLG_FILTER_ALLFILES; //"CSV XMLファイル(*.csv *.xml)|*.csv;*.xml|すべてのファイル(*.*)|*.*";
                        openFileDialog1.FilterIndex = 1;
                        openFileDialog1.RestoreDirectory = true;

                        if (openFileDialog1.ShowDialog() == DialogResult.OK)
                        {
                            dgv.Rows[e.RowIndex].Cells[e.ColumnIndex].Value = openFileDialog1.FileName;
                        }
                        openFileDialog1.Dispose();

                        // 更新
                        dataGridView1.RefreshEdit();
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Deletebutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Deletebutton_Click(object sender, EventArgs e)
        {
            int iRowCnt = dataGridView1.Rows.Count;
            for (int iRow = 0; iRow < iRowCnt; iRow++)
            {
                int iCellCnt = dataGridView1.Rows[iRow].Cells.Count;

                for (int iCell = 0; iCell < iCellCnt; iCell++)
                {
                    if (dataGridView1.Rows[iRow].Cells[iCell].Selected == true)
                    {
                        //if (dataGridView1.Columns[iCell].HeaderText.ToString() == "ファイル名")
                        //{
                        //    dataGridView1.Rows[iRow].Cells[iCell].Value = "";
                        //}
                        dataGridView1.Rows[iRow].Cells[1].Value = "";
                    }
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HelpJump_button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODELGEN_0004, null);
        }

    }
}