﻿// <summary>ソースコード：ＨＹＭＣＯモデルジェネレータ個別モデル用設定画面フォーム親クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.Tool;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;
using CommonMP.HYSSOP.CoreImpl.HSTools.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルジェネレータ個別モデル用設定画面フォーム親クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public partial class McModelGeneratorDataSelectScreenFormBase : HySDotNetForm // : Form
    {
        /// <summary> モデルジェネレーション制御スクリーン</summary>
        protected McDotNetModelGenerateCtlScreen m_csCtlScreen = null;

        /// <summary> モデル生成用情報選択設定画面（スクリーン） </summary>
        protected McModelGeneratorDataSelectScreenBase m_csMDGSelectScreen = null;

        /// <summary> <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McModelGeneratorDataSelectScreenFormBase csForm = new McModelGeneratorDataSelectScreenFormBase()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetModelDataGeneratorFormBase 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelGeneratorDataSelectScreenFormBase()
        {
            InitializeComponent();
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルジェネレータ制御スクリーン設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCtlScreen(csCtlScreen)</para>
        /// </example>
        /// <param name="csCtlScreen">モデルジェネレータ制御スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCtlScreen(McDotNetModelGenerateCtlScreen csCtlScreen)
        {
            m_csCtlScreen = csCtlScreen;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル生成用情報選択設定画面スクリーン設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetMdlDataGenScreen(csMDGSelectScreen)</para>
        /// </example>
        /// <param name="csMDGSelectScreen">モデル生成用情報選択設定画面スクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetMdlDataSelectScreen(McModelGeneratorDataSelectScreenBase csMDGSelectScreen)
        {
            m_csMDGSelectScreen = csMDGSelectScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルジェネレーション制御スクリーン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetModelGenerateCtlScreen csScreen = GetCtlScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetModelGenerateCtlScreen モデルジェネレーション制御スクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual McDotNetModelGenerateCtlScreen GetCtlScreen()
        {
            return m_csCtlScreen;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル生成用情報選択設定画面（スクリーン）取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McModelGeneratorDataSelectScreenBase csScreen = GetMdlDtSelectScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelGeneratorDataSelectScreenBase モデル生成用情報選択設定画面（スクリーン）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual McModelGeneratorDataSelectScreenBase GetMdlDtSelectScreen()
        {
            return m_csMDGSelectScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddInfo(sKey, sParameterFileName) </para>
        /// </example>
        /// <param name="sKey">情報引出し用キー</param>
        /// <param name="sLabel">表示ラベル名称</param>
        /// <param name="sParameterFileName">情報格納ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddInfo(string sKey, string sLabel, string sParameterFileName)
        {
            McModelDataGenerationInfo csMldInf = this.GetMdlGenerationInfo();
            if (csMldInf != null)
            {
                csMldInf.AddInfo(sKey, sParameterFileName);

                HySDataHashTable csLblTbl = m_csCtlScreen.GetMdlDataDispLabel();
                csLblTbl.AddObject(new HySString(sKey), new HySString(sLabel));
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInfo(sKey, sParameterFileName) </para>
        /// </example>
        /// <param name="sKey">情報引出し用キー</param>
        /// <param name="sParameterFileName">情報格納ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual void SetInfo(string sKey, string sParameterFileName)
        {
            McModelDataGenerationInfo csMldInf = this.GetMdlGenerationInfo();
            if (csMldInf != null)
            {
                csMldInf.SetInfo(sKey, sParameterFileName);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>情報格納ファイル名を削除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteInfo(sKey) </para>
        /// </example>
        /// <param name="sKey">キー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual void DeleteInfo(string sKey)
        {
            McModelDataGenerationInfo csMldInf = this.GetMdlGenerationInfo();
            if (csMldInf != null)
            {
                csMldInf.DeleteInfo(sKey);

                HySDataHashTable csLblTbl = m_csCtlScreen.GetMdlDataDispLabel();
                csLblTbl.DeleteData(new HySString(sKey));
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル生成情報設定情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McModelDataGenerationInfo csData = GetMdlGenerationInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelDataGenerationInfo モデル生成情報設定情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelDataGenerationInfo GetMdlGenerationInfo()
        {
            return m_csCtlScreen.GetMdlGenerationInfo();
        }

        /// <summary><para>method outline:</para>
        /// <para>個別情報設定通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeFileDataSet(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>個別情報設画面にて「ＯＫ」ボタン押下時に発行</para>
        /// </remarks>
        protected virtual void NoticeFileDataSet()
        {
            m_csMDGSelectScreen.NoticeFileDataSet();
        }
        
        /// <summary><para>method outline:</para>
        /// <para>モデル種別を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetModelModeKindBase(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual string GetModelModeKindBase()
        {
            return m_csCtlScreen.GetModelModeKind();
        }

    }
}