﻿// <summary>ソースコード：ＨＹＭＣＯライブラリ管理画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.LibraryCtl;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>ライブラリ管理画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McDotNetLibraryCtlScreen : HySDotNetScreen
    {

        //定数定義
        /// <summary>ライブラリ管理画面タイトル 「ライブラリ管理」</summary>
        static private readonly HySString FORM_TITLE_LIBRARY_CONTROL = new HySString(Properties.McDotNetViewerResources.FORM_TITLE_LIBRARY_CONTROL);
        ///// <summary>画面幅基準</summary>
        //static private readonly int SCREEN_WIDTH_CRITERION = 1280;
        /// <summary>ライブラリ管理画面幅</summary>
        static private readonly int FORM_WIDTH_LIBRARY = 360;
        ///// <summary>ライブラリ管理画面高さ</summary>
        //static private readonly int FORM_HEIGHT_LIBRARY = 610;
        ///// <summary>ライブラリ管理デフォルト画面幅</summary>
        //static private readonly int FORM_WIDTH_LIBRARY_DEFAULT = 360;
        ///// <summary>ライブラリ管理デフォルト画面高さ</summary>
        //static private readonly int FORM_HEIGHT_LIBRARY_DEFAULT = 355;
        /// <summary>画面配置デスクトップ座標X</summary>
        static private int DESKTOP_LOCATION_X = 0;
        /// <summary>画面配置デスクトップ座標Y</summary>
        static private readonly int DESKTOP_LOCATION_Y = 310;
        /// <summary>ライブラリ管理画面高さ調整値</summary>
        static private readonly int FORM_HEIGHT_LIBRARY_ADJUSTED_VALUE = 428;
        /// <summary>画面配置デスクトップ座標X調整値</summary>
        static private readonly int DESKTOP_LOCATION_X_ADJUSTED_VALUE = 8;
        /// <summary>画面配置デスクトップ座標Y調整値</summary>
        static private readonly int DESKTOP_LOCATION_Y_ADJUSTED_VALUE = 56;

        //メンバ変数
        /// <summary>ライブラリ管理フォーム</summary>
        protected McDotNetLibraryCtlForm m_csLibraryCtlForm;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetLibraryCtlScreen csScreen = new McDotNetLibraryCtlScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetLibraryCtlScreen 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetLibraryCtlScreen()
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            //画面サイズにあわせて表示
            Point point = new Point();
            point.X = 0;
            point.Y = 0;
            Rectangle rect;
            rect = Screen.GetBounds(point);

            //m_csLibraryCtlForm = new McDotNetLibraryCtlForm(this);
            //if (rect.Width >= SCREEN_WIDTH_CRITERION)
            //{
            //    //m_csLibraryCtlForm = new McDotNetLibraryCtlForm(this);
            //    m_csLibraryCtlForm.Width = FORM_WIDTH_LIBRARY;
            //    m_csLibraryCtlForm.Height = FORM_HEIGHT_LIBRARY;
            //}
            //else
            //{
            //    //m_csLibraryCtlForm = new McDotNetLibraryCtlDefaultForm(this);
            //    m_csLibraryCtlForm.Width = FORM_WIDTH_LIBRARY_DEFAULT;
            //    m_csLibraryCtlForm.Height = FORM_HEIGHT_LIBRARY_DEFAULT;
            //}
            //m_csLibraryCtlForm.Text = FORM_TITLE_LIBRARY_CONTROL.ToString();
            //m_csLibraryCtlForm.StartPosition = FormStartPosition.Manual;
            //m_csLibraryCtlForm.SetDesktopLocation(DESKTOP_LOCATION_X, DESKTOP_LOCATION_Y);

            m_csLibraryCtlForm = new McDotNetLibraryCtlForm(this);

            // 画面サイズからライブラリフォームの高さを調整する。
            m_csLibraryCtlForm.Height = rect.Height - FORM_HEIGHT_LIBRARY_ADJUSTED_VALUE;

            m_csLibraryCtlForm.Width = FORM_WIDTH_LIBRARY;
            m_csLibraryCtlForm.Text = FORM_TITLE_LIBRARY_CONTROL.ToString();
            m_csLibraryCtlForm.StartPosition = FormStartPosition.Manual;
            //m_csLibraryCtlForm.SetDesktopLocation(DESKTOP_LOCATION_X, DESKTOP_LOCATION_Y);
            // 右端に表示
            Size desktopSize = System.Windows.Forms.SystemInformation.WorkingArea.Size;
            DESKTOP_LOCATION_X = desktopSize.Width - m_csLibraryCtlForm.Size.Width;
            m_csLibraryCtlForm.SetDesktopLocation(DESKTOP_LOCATION_X - DESKTOP_LOCATION_X_ADJUSTED_VALUE, DESKTOP_LOCATION_Y_ADJUSTED_VALUE + DESKTOP_LOCATION_Y);
            //縦方向リサイズ設定
            m_csLibraryCtlForm.MaximumSize = new Size(FORM_WIDTH_LIBRARY, rect.Height);
            m_csLibraryCtlForm.MinimumSize = new Size(FORM_WIDTH_LIBRARY, 0);
            // 常に最前面表示
            m_csLibraryCtlForm.BringToFront();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            this.SetViewerJob(m_csDotNetVeiewer.GetViewerJob(McDefine.SIMULATOR_KIND.GetString()));
            // 常に最前面表示
            m_csLibraryCtlForm.Owner = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();
            //m_csLibraryCtlForm.MdiParent = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ画面表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ShowScreen() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            m_csLibraryCtlForm.Show();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            m_csLibraryCtlForm.Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ画面初期配置表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            Point point = new Point();
            point.X = 0;
            point.Y = 0;
            Rectangle rect;
            rect = Screen.GetBounds(point);

            //if (rect.Width >= SCREEN_WIDTH_CRITERION)
            //{
            //    m_csLibraryCtlForm.Width = FORM_WIDTH_LIBRARY;
            //    m_csLibraryCtlForm.Height = FORM_HEIGHT_LIBRARY;
            //}
            //else
            //{
            //    m_csLibraryCtlForm.Width = FORM_WIDTH_LIBRARY_DEFAULT;
            //    m_csLibraryCtlForm.Height = FORM_HEIGHT_LIBRARY_DEFAULT;
            //}

            // 画面サイズからライブラリフォームの高さを調整する。
            m_csLibraryCtlForm.Height = rect.Height - FORM_HEIGHT_LIBRARY_ADJUSTED_VALUE;

            m_csLibraryCtlForm.Width = FORM_WIDTH_LIBRARY;
            m_csLibraryCtlForm.StartPosition = FormStartPosition.Manual;
            //m_csLibraryCtlForm.SetDesktopLocation(DESKTOP_LOCATION_X, DESKTOP_LOCATION_Y);
            // 右端に表示
            m_csLibraryCtlForm.SetDesktopLocation(DESKTOP_LOCATION_X - DESKTOP_LOCATION_X_ADJUSTED_VALUE, DESKTOP_LOCATION_Y_ADJUSTED_VALUE + DESKTOP_LOCATION_Y);
            m_csLibraryCtlForm.WindowState = FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NormalizeScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NormalizeScreen()
        {
            m_csLibraryCtlForm.WindowState = FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>MenuCallBack( lCallBackNumber )</para>
        /// </example>
        /// <param name="lCallBackNumber">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void MenuCallBack(long lCallBackNumber)
        {
            Boolean bPutEvent = false;
            if (lCallBackNumber == McDefine.HYMCO_LIBRARY_SET)
            {
                bPutEvent = this.PutEventRequestSet();
                if (bPutEvent == false)
                {
                   // ver1.5 エラートレース日本語対応 
                    HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlScreen.MenuCallBack",
                        Properties.McDotNetViewerResources.STATEMENT_SEND_FAILURE + "(" + Properties.McDotNetViewerResources.STATEMENT_CONFIG +")");
                   // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlScreen.MenuCallBack", "イベント送信失敗(設定)");
                }
            }
            else if (lCallBackNumber == McDefine.HYMCO_LIBRARY_RELEASE)
            {
                bPutEvent = this.PutEventRequestDel();
                if (bPutEvent == false)
                {
                   // ver1.5 エラートレース日本語対応 
                    HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlScreen.MenuCallBack",
                        Properties.McDotNetViewerResources.STATEMENT_SEND_FAILURE + "(" + Properties.McDotNetViewerResources.STATEMENT_CANCEL + ")");
                   // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlScreen.MenuCallBack", "イベント送信失敗(解除)");
                }
            }
            else
            {
            }          
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override bool EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            HySID csID = ((HySEventObject)csEvent).GetSuppID();
            long lEventNo = ((HySEventObject)csEvent).GetEventNo();
            long lSubEventNo = ((HySEventObject)csEvent).GetSubEventNo();
            
            if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {
                // モデル管理画面からのライブラリ設定要求
                if (lSubEventNo == McDefine.HYM_MODEL_LIBRARY_SETUP_REQUEST)
                {
                    bRtn = this.PutEventRequestSet();
                    if (bRtn == false)
                    {
                       // ver1.5 エラートレース日本語対応 
                        HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlScreen.EventCallback",
                            Properties.McDotNetViewerResources.STATEMENT_SEND_FAILURE + "(" + Properties.McDotNetViewerResources.STATEMENT_CONFIG + ")");
                       // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlScreen.EventCallback", "イベント送信失敗(設定)");
                    }
                }
                else if (lSubEventNo == McDefine.HYM_MODEL_LIBRARY_TAB1_CHANGE)
                {
                    m_csLibraryCtlForm.DispTabChange(0);
                }
                else if (lSubEventNo == McDefine.HYM_MODEL_LIBRARY_TAB2_CHANGE)
                {
                    m_csLibraryCtlForm.DispTabChange(1);
                }
                else if (lSubEventNo == McDefine.HYM_MODEL_LIBRARY_TAB3_CHANGE)
                {
                    m_csLibraryCtlForm.DispTabChange(2);
                }
                else if (lSubEventNo == McDefine.HYM_MODEL_LIBRARY_TAB4_CHANGE)
                {
                    m_csLibraryCtlForm.DispTabChange(3);
                }
                else if (lSubEventNo == McDefine.HYM_MODEL_LIBRARY_TREE_REQUEST)
                {
                    bRtn = this.PutEventRequestTreeData();
                    if (bRtn == false)
                    {
                       // ver1.5 エラートレース日本語対応
                        HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlScreen.EventCallback",
                           Properties.McDotNetViewerResources.STATEMENT_SEND_FAILURE + "(" + Properties.McDotNetViewerResources.STATEMENT_TREE_DATA + ")");
                       // HySLog.LogOut(HySLog.ONLINE, "McDotNetLibraryCtlScreen.EventCallback", "イベント送信失敗(ツリーデータ)");
                    }
                }
            }
            else if(lEventNo == HySEventObject.CMND_BROADCAST_SCREEN)
            {
                //if (lSubEventNo == McDefine.HYM_ACTIVE_PROJECT_NAME_SETUP_INFORMATION)
                if (lSubEventNo == McDefine.HYM_ACTIVE_PROJECT_NAME_SETUP_INFORMATION || lSubEventNo == McDefine.HYM_CLOSED_PROJECT_NAME_SETUP_INFORMATION)
                {
                    HySSimulationDataContainer csContainer = (HySSimulationDataContainer)((HySEventObject)csEvent).GetData();
                    if (csContainer != null)
                    {
                        if (this.IsActiveProject(csID))
                        {   // アクティブプロジェクトの場合
                            m_csLibraryCtlForm.ModelAssignment(true);
                            McSimulationStatus csStatus = (McSimulationStatus)csContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                            if (csStatus.GetCalcStatus() == McSimulationStatus.CalculationStatus.CALCULATING)
                            {   // シュミレーション計算状態が「計算中」の場合
                                m_csLibraryCtlForm.ModelAssignment(false);
                            }
                        }
                    }
                    else
                    {
                        m_csLibraryCtlForm.ModelAssignment(false);
                    }
                }      
            }
            else if (lEventNo == HySEventObject.NOTICE_START_SIMULATION)
            {
                // フォームの状態を更新
                this.UpdateFormStatusByProject(csID, false);
            }
            else if (lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION ||
                     lEventNo == HySEventObject.NOTICE_STOP_SIMULATION ||
                     lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND ||
                     lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION)
            {
                // フォームの状態を更新
                this.UpdateFormStatusByProject(csID, true);
            }
            else if (lEventNo == HySEventObject.ARBITRARY_EVENT)
            {
                if (lSubEventNo == McDefine.HYM_NOTICE_DATACONTAINER_SET)
                {
                    // フォームの状態を更新
                    this.UpdateFormStatusByProject(csID, true);
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        override public Boolean PutEvent(HySSysEvent csEvent)
        {
            ((HySEventObject)csEvent).SetToSimKind(McDefine.SIMULATOR_KIND);
            return m_csDotNetVeiewer.PutEvent(csEvent);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面要求イベント送信（設定）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = PutEventRequestSet( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean PutEventRequestSet()
        {
            HySViewerJob csViewerJob = this.GetViewerJob();
            HySID csID = ((McDotNetViewerJob)csViewerJob).GetActiveProject();
            if ((object)csID == null)
            {
                return false;
            }

            McModelInfo csModelInfo = m_csLibraryCtlForm.GetModelInfo();
            if (csModelInfo == null)
            {
                return false;
            }

            long lSubEventNo = m_csLibraryCtlForm.GetSubEventNo();

            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON);
            csEventObject.SetSubEventNo(lSubEventNo);
            csEventObject.SetSuppID(csID);
            csEventObject.SetToSimKind(m_csKindID);
            csEventObject.SetData(csModelInfo);
            return PutEvent(csEventObject);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面要求イベント送信（解除）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = PutEventRequestDel() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean PutEventRequestDel()
        {
            HySViewerJob csViewerJob = this.GetViewerJob();
            HySID csID = ((McDotNetViewerJob)csViewerJob).GetActiveProject();
            if ((object)csID == null)
            {
                return false;
            }

            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON, McDefine.HYM_LIBRARY_DATA_CANCEL);
            csEventObject.SetSuppID(csID);
            csEventObject.SetToSimKind(m_csKindID);
            return PutEvent(csEventObject);
        }

        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            //イベントからサブデータを取得
            HySDataRoot csSubData = ((HySEventObject)csEvent).GetSubData();
            //TreeView作成処理コール
            m_csLibraryCtlForm.CreateTreeView(csSubData);
        }

        /// <summary><para>method outline:</para>
        /// <para>アクティブなプロジェクトを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csActiveProjectID = GetActiveProject( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>アクティブなプロジェクトの識別子。アクティブなプロジェクトが無い場合はnullを返す。</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private HySID GetActiveProject()
        {
            // アクティブプロジェクトのIDを識別子を取得
            HySViewerJob csViewerJob = this.GetViewerJob();
            return ((McDotNetViewerJob)csViewerJob).GetActiveProject();
        }

        /// <summary><para>method outline:</para>
        /// <para>アクティブプロジェクトであるかを判定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool isActiveProject = IsActiveProject( ) </para>
        /// </example>
        /// <param name="csID">プロジェクト識別子</param>
        /// <returns>true:=アクティブプロジェクト, false:=非アクティブプロジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool IsActiveProject(HySID csID)
        {
            HySID actID = this.GetActiveProject();
            return actID != null && csID.Equals(actID);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面の状態をプロジェクトに応じて更新する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> UpdateFormStatusByProject( ) </para>
        /// </example>
        /// <param name="csID">プロジェクト識別子</param>
        /// <param name="bModelAssignment">設定/解除処理の有効/無効フラグ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void UpdateFormStatusByProject(HySID csID, bool bModelAssignment)
        {
            if (this.IsActiveProject(csID))
            {   // アクティブプロジェクトの場合
                m_csLibraryCtlForm.ModelAssignment(bModelAssignment);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面要求イベント送信（ツリーデータ）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = PutEventRequestTreeData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean PutEventRequestTreeData()
        {
            HySViewerJob csViewerJob = this.GetViewerJob();
            HySID csID = ((McDotNetViewerJob)csViewerJob).GetActiveProject();
            if ((object)csID == null)
            {
                return false;
            }

            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
            csEventObject.SetSubEventNo(McDefine.HYM_MODEL_LIBRARY_TREE_DATA);
            csEventObject.SetSuppID(csID);
            csEventObject.SetToSimKind(m_csKindID);
            csEventObject.SetData(m_csLibraryCtlForm.GetTreeData());
            return PutEvent(csEventObject);
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリインストール情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McLibraryInstallInfoData csLibraryInstallInfoData = GetLibraryInstallInfoData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ライブラリインストール情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLibraryInstallInfoData GetLibraryInstallInfoData()
        {
            return m_csLibraryCtlForm.GetLibraryInstallInfoData();
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteLibrary() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void DeleteLibrary()
        {
            m_csLibraryCtlForm.DeleteLibrary();
        }
    }
}
