﻿// <summary>ソースコード：データマージモデルプロパティスクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>データマージモデルプロパティスクリーンクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/17][新規作成]</para>
    /// </remarks>
    public class McDotNetDataMergeModelPropertyScreen : McDotNetModelCellPropertyScreenBase
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetDataMergeModelPropertyScreen csScreen = new McDotNetDataMergeModelPropertyScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetDataMergeModelPropertyScreen()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            m_csCellModelProperty = csInfo as McDataMergePropertyInfo;
        }

        ///// <summary><para>method outline:</para>
        ///// <para>モデル初期情報を設定する</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>SetModelInitialInfo(csInfo)</para>
        ///// </example>
        ///// <param name="csInfo">モデル初期情報</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public override void SetModelInitialInfo(McPropertyInfoRoot csInfo)
        //{
        //    m_csModelIntialInfo = csInfo as McDataMergeInitialInfo;
        //}

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csPropertyForm = new McDotNetDataMergeModelPropertyForm();
            m_csPropertyForm.SetScreen(this);
            ((McDotNetDataMergeModelPropertyForm)m_csPropertyForm).SetElementName(m_csElementName);
            ((McDotNetDataMergeModelPropertyForm)m_csPropertyForm).SetModelPropertyInfo((McDataMergePropertyInfo)m_csCellModelProperty);
            ((McDotNetDataMergeModelPropertyForm)m_csPropertyForm).EditParameter();

            // 登録されたプロジェクト名称を取得し、表示する。
            m_csPropertyForm.Text = Properties.McDotNetViewerResources.FORM_TITLE_PARAMETER + m_csModelCtlScreen.GetProjectName().ToString() + ":" + m_csElementID.ToString();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面リフレッシュ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> RefreshmentForm( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void RefreshmentForm()
        {
            ((McDotNetDataMergeModelPropertyForm)m_csPropertyForm).SetElementName(m_csElementName);
            ((McDotNetDataMergeModelPropertyForm)m_csPropertyForm).SetModelPropertyInfo((McDataMergePropertyInfo)m_csCellModelProperty);
            ((McDotNetDataMergeModelPropertyForm)m_csPropertyForm).EditParameter();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面消去前処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> BeforeCloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:画面クローズ可　false:画面クローズ不可</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool BeforeCloseScreen()
        {
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            if (((McDotNetDataMergeModelPropertyForm)m_csPropertyForm).ParaSet_Check() == true)
            {// 設定値に異常がある場合
                m_csPropertyForm.Activate();

                return false;
            }

            if (((McDotNetDataMergeModelPropertyForm)m_csPropertyForm).ParaModify_Check(false, ref bChangeFlg1, ref bChangeFlg2) == true)
            {// 変更がある場合
                m_csPropertyForm.Activate();

                // 変更情報登録確認
                DialogResult result = MessageBox.Show(MSG_DATA_SET, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (result == DialogResult.Yes)
                {// 登録選択の場合
                    // 登録
                    ((McDotNetDataMergeModelPropertyForm)m_csPropertyForm).ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

                    if (bChangeFlg2 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        PropertyInfoSet(true);
                    }
                    else if (bChangeFlg1 == true)
                    {// 変更がある場合
                        // プロパティ情報設定イベント送信要求
                        ReqPropertyInfoSetEvent();
                    }
                }
            }

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ詳細画面生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetModelCellPropertyDetailBaseForm csPropertyDetailForm = CreatePropertyDetailForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>プロパティ詳細画面</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McDotNetModelCellPropertyDetailBaseForm CreatePropertyDetailForm()
        {
            return null;
        }
    }
}
