﻿// <summary>ソースコード：セル型モデルプロパティスクリーン基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.FigureUnity;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>セル型モデルプロパティスクリーン基底クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/07][新規作成]</para>
    /// </remarks>
    abstract public class McDotNetModelCellPropertyScreenBase : McDotNetModelPropertyScreenBase
    {
        /// <summary> セル型モデルのプロパティ情報 </summary>
        protected McCellModelPropertyInfo m_csCellModelProperty = null;

        /// <summary> 連接モデルプロパティ表示要求 </summary>
        protected bool m_bJunctureModelPropertyDispReq = false;

        /// <summary> 連接要素ID </summary>
        protected HySIdentifier m_csJunctureElementID = null;

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            m_csCellModelProperty = csInfo as McCellModelPropertyInfo;
            base.SetModelPropertyInfo(csInfo);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csPropertyForm = new McDotNetModelCellPropertyForm();
            m_csPropertyForm.SetScreen(this);
            ((McDotNetModelCellPropertyForm)m_csPropertyForm).SetElementName(m_csElementName);
            ((McDotNetModelCellPropertyForm)m_csPropertyForm).SetModelPropertyInfo(m_csCellModelProperty);
            ((McDotNetModelCellPropertyForm)m_csPropertyForm).SetModelInitialInfo(m_csModelIntialInfo);
            ((McDotNetModelCellPropertyForm)m_csPropertyForm).EditParameter();

            // 登録されたプロジェクト名称を取得し、表示する。
            // "パラメータ設定"
            m_csPropertyForm.Text = Properties.McDotNetViewerResources.FORM_TITLE_PARAMETER + m_csModelCtlScreen.GetProjectName().ToString() + ":" + m_csElementID.ToString();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面リフレッシュ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> RefreshmentForm( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void RefreshmentForm()
        {
            ((McDotNetModelCellPropertyForm)m_csPropertyForm).SetElementName(m_csElementName);
            ((McDotNetModelCellPropertyForm)m_csPropertyForm).SetModelPropertyInfo(m_csCellModelProperty);
            ((McDotNetModelCellPropertyForm)m_csPropertyForm).SetModelInitialInfo(m_csModelIntialInfo);
            ((McDotNetModelCellPropertyForm)m_csPropertyForm).EditParameter();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面消去前処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> BeforeCloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:画面クローズ可　false:画面クローズ不可</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool BeforeCloseScreen()
        {
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            if (((McDotNetModelCellPropertyForm)m_csPropertyForm).ParaSet_Check() == true)
            {// 設定値に異常がある場合
                m_csPropertyForm.Activate();

                return false;
            }

            if (((McDotNetModelCellPropertyForm)m_csPropertyForm).ParaModify_Check(false, ref bChangeFlg1, ref bChangeFlg2) == true)
            {// 変更がある場合
                m_csPropertyForm.Activate();

                // 変更情報登録確認
                DialogResult result = MessageBox.Show(MSG_DATA_SET, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (result == DialogResult.Yes)
                {// 登録選択の場合
                    // 登録
                    ((McDotNetModelCellPropertyForm)m_csPropertyForm).ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

                    if (bChangeFlg2 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        PropertyInfoSet(true);
                    }
                    else if (bChangeFlg1 == true)
                    {// 変更がある場合
                        // プロパティ情報設定イベント送信要求
                        ReqPropertyInfoSetEvent();
                    }
                }
            }

            return true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>連接モデルプロパティ表示要求</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> JunctureModelPropertyDispReq(csElementID) </para>
        /// </example>
        /// <param name="csElementID">プロパティ表示要素ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void JunctureModelPropertyDispReq(HySIdentifier csElementID)
        {
            m_csJunctureElementID = csElementID;
            m_bJunctureModelPropertyDispReq = true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>連接要素選択表示要求</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> JunctureElementSelectDispReq(csElementID) </para>
        /// </example>
        /// <param name="csElementID">選択表示要素ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void JunctureElementSelectDispReq(HySIdentifier csElementID)
        {
            m_csModelCtlScreen.SelectiveDisplaySpecifiedElement(csElementID);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ詳細画面生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetModelCellPropertyDetailBaseForm csPropertyDetailForm = CreatePropertyDetailForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>プロパティ詳細画面</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>独自のプロパティ詳細画面を生成する時はオーバーライドすること</para>
        /// </remarks>
        public abstract McDotNetModelCellPropertyDetailBaseForm CreatePropertyDetailForm();
        //{
        //    // 詳細画面生成
        //    return new McDotNetModelCellPropertyDetailBaseForm();
        //}

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            m_csPropertyForm.TopMost = false;
            m_csPropertyForm.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            m_csPropertyForm.ShowDialog();

            if (m_bJunctureModelPropertyDispReq == true)
            {// 連接モデルプロパティ表示要求がある場合
                m_csModelCtlScreen.ShowModelPropertyScreen(m_csJunctureElementID);
            }
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループ名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csGrpName = GetProjectGroupName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  プロジェクトグループ名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySString GetProjectGroupName()
        {
            string sPrjName = "";
            McPropertyInfo csMdlPrtpy = m_csCellModelProperty as McPropertyInfo;
            if (csMdlPrtpy != null)
            {
                HySCommonInfoHash.GetCorrespond(McDefine.PROJECT_GROUP_NAME, csMdlPrtpy.GetOwnerProjectID(), ref sPrjName);
            }
            return new HySString(sPrjName);
        }
        */
    }
}
