﻿// <summary>ソースコード：ＨＹＭＣＯモデル管理画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
//★★★★★★★★★★★★★★★★★★★★★
// Ver1.4で追加(GIS起動及び表示操作の簡略化
//★★★★★★★★★★★★★★★★★★★★★
using Microsoft.VisualBasic;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.FigureUnity;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer.Data;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>モデル管理画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/10/01][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/05][メソッド追加]
    /// </para>
    /// </remarks>
    public class McDotNetModelCtlScreen : HySDotNetScreen
    {
        //定数定義
        /// <summary>モデル管理画面タイトル 「モデル管理」</summary>
        static private readonly HySString FORM_TITLE_MODEL_CONTROL = new HySString(Properties.McDotNetViewerResources.FORM_TITLE_MODEL_CONTROL);
        /// <summary>画面配置デスクトップ座標X</summary>
        static private readonly int DESKTOP_LOCATION_X = 0;
        /// <summary>画面配置デスクトップ座標Y</summary>
        static private readonly int DESKTOP_LOCATION_Y = 0;
        /// <summary>モデル管理画面幅調整値</summary>
        static private readonly int FORM_WIDTH_MODEL_ADJUSTED_VALUE = 375;
        /// <summary>モデル管理画面高さ調整値</summary>
        static private readonly int FORM_HEIGHT_MODEL_ADJUSTED_VALUE = 118;

        //メンバ変数
        /// <summary>モデル管理フォーム</summary>
        protected McDotNetModelCtlForm m_csModelCtlForm;

        /// <summary>プロジェクト名称</summary>
        protected HySString m_csProjectName;

        /// <summary>プロジェクト情報</summary>
        protected McProjectInfData m_csProjectInfData = null;

        /// <summary>プロジェクト情報</summary>
        protected HySSimulationDataContainer m_csDataContainer;

        /// <summary>搭載スクリーン数</summary>
        protected long m_lScreenNum = 0;

        /// <summary>スクリーン識別管理ハッシュテーブル</summary>
        protected Hashtable m_csScreenTbl;

        /// <summary>スクリーン識別キー管理リスト</summary>
        protected IList m_csScreenKeyList;

        /// <summary>プロパティ表示要素ハッシュテーブル</summary>
        protected Hashtable m_csModelTbl;

        /// <summary>プロパティ表示要素モデル保存ハッシュテーブル</summary>
        protected Hashtable m_csModelInfoTbl;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelCtlScreen csScreen = new McDotNetModelCtlScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetModelCtlScreen()
        {
            m_csScreenTbl = new Hashtable();    // スクリーン管理用ハッシュテーブル
            m_lScreenNum = 0;                   // 搭載スクリーン数
            m_csScreenKeyList = new ArrayList();// スクリーン管理用キーリスト
            m_csModelTbl = new Hashtable();     // プロパティ表示要素ハッシュテーブル
            m_csModelInfoTbl = new Hashtable(); // プロパティ表示要素モデル保存ハッシュテーブル
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelCtlScreen csScreen = new McDotNetModelCtlScreen(csDotNetViewr)</para>
        /// </example>
        /// <param name="csDotNetViewr">メインビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetModelCtlScreen(HySViewer csDotNetViewr)
        {
            m_csDotNetVeiewer = csDotNetViewr;
            this.SetViewerJob(m_csDotNetVeiewer.GetViewerJob(McDefine.SIMULATOR_KIND.GetString()));
            this.Initialize();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySScreen.Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            //画面サイズにあわせて表示
            System.Drawing.Point point = new System.Drawing.Point();
            point.X = 0;
            point.Y = 0;
            System.Drawing.Rectangle rect;
            rect = System.Windows.Forms.Screen.GetBounds(point);

            m_csModelCtlForm = new McDotNetModelCtlForm(this);

            // 画面サイズからモデルフォームの幅を調整する。
            m_csModelCtlForm.Width = rect.Width - FORM_WIDTH_MODEL_ADJUSTED_VALUE;
            // 画面サイズからモデルフォームの高さを調整する。
            m_csModelCtlForm.Height = rect.Height - FORM_HEIGHT_MODEL_ADJUSTED_VALUE;

            // リサイズ最大サイズ設定
            m_csModelCtlForm.MaximumSize = new Size(rect.Width, rect.Height);

            m_csModelCtlForm.StartPosition = FormStartPosition.Manual;
            m_csModelCtlForm.SetDesktopLocation(DESKTOP_LOCATION_X, DESKTOP_LOCATION_Y);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySScreen.Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
            // 全スクリーンの終了処理を実行
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {// 搭載スクリーン数ループ
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {// スクリーンがあった場合
                    csScreen.Terminate();
                    csScreen = null;
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySScreen.SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            this.SetViewerJob(m_csDotNetVeiewer.GetViewerJob(McDefine.SIMULATOR_KIND.GetString()));
            m_csModelCtlForm.MdiParent = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();

            this.PutEventRequestTreeReq();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySScreen.ShowScreen() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            m_csModelCtlForm.Show();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySScreen.CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            m_csModelCtlForm.SetCloseScreenFlg();
            m_csModelCtlForm.Close();

            m_csModelCtlForm.Dispose();
            // メモリリーク改善
            m_csModelCtlForm = null;

            ((HySDotNetViewerJob)this.GetViewerJob()).DeleteScreen(this);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル画面初期配置表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySScreen.InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            System.Drawing.Point point = new System.Drawing.Point();
            point.X = 0;
            point.Y = 0;
            System.Drawing.Rectangle rect;
            rect = System.Windows.Forms.Screen.GetBounds(point);

            // 画面サイズからモデルフォームの幅を調整する。
            m_csModelCtlForm.Width = rect.Width - FORM_WIDTH_MODEL_ADJUSTED_VALUE;
            // 画面サイズからモデルフォームの高さを調整する。
            m_csModelCtlForm.Height = rect.Height - FORM_HEIGHT_MODEL_ADJUSTED_VALUE;

            m_csModelCtlForm.SetDesktopLocation(DESKTOP_LOCATION_X, DESKTOP_LOCATION_Y);
            m_csModelCtlForm.WindowState = FormWindowState.Normal;
            m_csModelCtlForm.SimpleMapDispInitial();

            McDotNetModelPropertyScreenBase csScreen = null;
            HySString csPrcKey = null;
            // プロパティ画面を全て初期配置表示する
            for (long lLoop = 0; lLoop < m_lScreenNum; lLoop++)
            {// 搭載スクリーン数ループ
                csPrcKey = (HySString)m_csScreenKeyList[(int)lLoop];
                csScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csPrcKey];
                csScreen.InitiateScreen();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NormalizeScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NormalizeScreen()
        {
            m_csModelCtlForm.WindowState = FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル演算中フラグ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = GetCalculationFlg( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true  : 演算中、false : 非演算</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean GetCalculationFlg()
        {
            Boolean bRtn = false;
            if (m_csDataContainer != null)
            {
                McSimulationStatus csStatus = (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                if (csStatus.GetCalcStatus() == McSimulationStatus.CalculationStatus.CALCULATING)
                {// 計算中の場合
                    bRtn = true;
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面をアクティブ化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ActivateForm()
        {
            if (this.IsActive() == true)
            {// 自身がアクティブの場合
                // カレントモデル画面のみアクティブ化する
                m_csModelCtlForm.Activate();
                this.ChangeMenuStatus();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>メニュー状態変更</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ChangeMenuStatus( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ChangeMenuStatus()
        {
            if (m_csDataContainer != null)
            {// プロジェクト情報がある場合
                McSimulationStatus csSimSts = (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                if (csSimSts.GetModelModStatus() == McSimulationStatus.ModelModificationStatus.MODIFIED_CONSTRUCTION_NOT_REQUIRED)
                {// 変更有(モデル構築不要)の場合
                }
                if (csSimSts.GetModelConStatus() == McSimulationStatus.ModelConstructionStatus.CONSTRUCTED)
                {// モデル構築済の場合
                }
                if (csSimSts.GetCalcStatus() == McSimulationStatus.CalculationStatus.CALCULATING)           // 計算中
                {// 計算中の場合
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_START);
                }
                else if (csSimSts.GetCalcStatus() == McSimulationStatus.CalculationStatus.INITIAL)          // 未計算
                {// 未計算の場合
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.INITIALIZE);
                    if (((HySDotNetViewer)m_csDotNetVeiewer).GetCalculationFlg() == true)
                    {// モデル演算中の場合
                        ((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_MULTI);
                    }
                }
                else if (csSimSts.GetCalcStatus() == McSimulationStatus.CalculationStatus.FINISHED)         // 計算終了
                {// 計算終了の場合
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_END);
                    if (((HySDotNetViewer)m_csDotNetVeiewer).GetCalculationFlg() == true)
                    {// モデル演算中の場合
                        ((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_MULTI);
                    }
                }
                else if (csSimSts.GetCalcStatus() == McSimulationStatus.CalculationStatus.FINISHED_STOP)    // 計算強制終了
                {// 計算強制終了の場合
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_STOP);
                    if (((HySDotNetViewer)m_csDotNetVeiewer).GetCalculationFlg() == true)
                    {// モデル演算中の場合
                        ((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_MULTI);
                    }
                }
                else if (csSimSts.GetCalcStatus() == McSimulationStatus.CalculationStatus.INTERRUPTED)      // 計算中断
                {// 計算中断の場合
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_STOP);
                    if (((HySDotNetViewer)m_csDotNetVeiewer).GetCalculationFlg() == true)
                    {// モデル演算中の場合
                        ((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.CAL_MULTI);
                    }
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル画面再表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySScreen.ReDrawScreen( csID ) </para>
        /// </example>
        /// <param name="csID">データ識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ReDrawScreen(HySID csID)
        {
            m_csID = csID;
            m_csModelCtlForm.Text = FORM_TITLE_MODEL_CONTROL.ToString() + " - " + m_csProjectName.ToString();

            //★★★ ↓↓↓↓↓
　          // 「メニュー」－「ウィンドウ」－画面名称が更新されないため、暫定対策
            m_csModelCtlForm.Hide();
            m_csModelCtlForm.Show();
            //★★★ ↑↑↑↑↑
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetScreen.MenuCallBack(lCallBackNumber)</para>
        /// </example>
        /// <param name="lCallBackNumber">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void MenuCallBack(long lCallBackNumber)
        {
            m_csModelCtlForm.MenuCallBack(lCallBackNumber);
        }

        /// <summary><para>method outline:</para>
        /// <para>フォーカスオンスクリーン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = GetFocusOnScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>アクティブスクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySScreen GetFocusOnScreen()
        {
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            HySScreen csScreenResult = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {// 搭載スクリーン数ループ
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey];
                if (csScreen != null)
                {// スクリーンがあった場合
                    if (((HySDotNetScreen)csScreen).IsFocusOn() == true)
                    {// フォーカスオンの場合
                        csScreenResult = csScreen;
                        break;
                    }
                }
            }
            return csScreenResult;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>アクティブ報告</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySScreen.NoticeActive( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeActive()
        {
            // ステータスが計算中、中断中であれば、再アクティブ化する。 
            // 計算状況取得要求イベント

            base.NoticeActive();

            McDotNetModelPropertyScreenBase csScreen = null;
            HySString csPrcKey = null;

            if (this.IsActive() != true)
            {// 自身がアクティブではない場合
                // 自スクリーンのアクティブ化
                this.SetScreenStatus(true);

                // 自スクリーンの初期配置表示
                //this.NormalizeScreen();

                // プロパティ画面を全て表示する
                for (long lLoop = 0; lLoop < m_lScreenNum; lLoop++)
                {// 搭載スクリーン数ループ
                    csPrcKey = (HySString)m_csScreenKeyList[(int)lLoop];
                    csScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csPrcKey];
                    csScreen.ShowScreen();
                }

                // モデル管理画面からプロジェクト管理画面にアクティブなプロジェクト名を渡す 
                HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_BROADCAST_SCREEN);
                csEventObject.SetSubEventNo(McDefine.HYM_ACTIVE_PROJECT_NAME_SETUP_INFORMATION);
                csEventObject.SetToSimKind(m_csKindID);
                csEventObject.SetSuppID(m_csID);
                csEventObject.SetData(m_csDataContainer);
                // 他のスクリーンを非アクティブにする。
                ((HySDotNetViewerJob)m_csVJob).AllScreenStatusSet(csEventObject);
                this.PutEvent(csEventObject);

                this.ChangeMenuStatus();

                // 簡易マップ表示
                m_csModelCtlForm.SimpleMapVisibleChange(true);
            }
            else
            {// 自身がアクティブの場合
                if (m_csModelCtlForm.WindowState == FormWindowState.Minimized)
                {// 最小化されている場合
                    this.NormalizeScreen();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>アクティブ／非アクティブ状態セット</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetScreenStatus( bStatus ) </para>
        /// </example>
        /// <param name="bStatus">状態</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetScreenStatus(Boolean bStatus)
        {
            McDotNetModelPropertyScreenBase csScreen = null;
            HySString csPrcKey = null;

            m_bActive = bStatus;
            if (m_bActive == false)
            {// デアクティブの場合
                // プロパティ画面を全て消去する
                for (long lLoop = 0; lLoop < m_lScreenNum; lLoop++)
                {// 搭載スクリーン数ループ
                    csPrcKey = (HySString)m_csScreenKeyList[(int)lLoop];
                    csScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csPrcKey];
                    csScreen.HideScreen();
                }

                // 簡易マップ表示
                if (m_csModelCtlForm != null)
                {
                    m_csModelCtlForm.SimpleMapVisibleChange(false);
                }
            }
            else
            {
                // Ver1.2追加：マルチスレッド動作対応
                // メイン画面のステータス表示更新処理
                // シミュレーション状態取得
                if (m_csDataContainer != null)
                {
                    McSimulationStatus csSimulationStatus = (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                    McSimulationStatus.CalculationStatus sState = csSimulationStatus.GetCalcStatus();
                    HySID csSimID = (HySID)m_csDataContainer.GetID();
                    HySEventObject csEvent = new HySEventObject(HySEventObject.OBJID_VIEWER, HySEventObject.ARBITRARY_EVENT);
                    // シミュレータIDの設定
                    csEvent.SetSuppID(csSimID);
                    // SimKindの設定
                    csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
                    // 状態に応じて付加イベント選択
                    if (sState == McSimulationStatus.CalculationStatus.CALCULATING)
                    {
                        csEvent.SetEventNo(HySEventObject.NOTICE_START_SIMULATION);
                    }
                    else if (sState == McSimulationStatus.CalculationStatus.FINISHED)
                    {
                        csEvent.SetEventNo(HySEventObject.NOTICE_COMPLETE_SIMULATION);
                    }
                    else if (sState == McSimulationStatus.CalculationStatus.FINISHED_STOP)
                    {
                        csEvent.SetEventNo(HySEventObject.NOTICE_STOP_SIMULATION);
                    }
                    else if (sState == McSimulationStatus.CalculationStatus.INTERRUPTED)
                    {
                        csEvent.SetEventNo(HySEventObject.NOTICE_PAUSE_SIMULATION);
                    }
                    else if (sState == McSimulationStatus.CalculationStatus.INITIAL)
                    {
                        // Do Nothing
                    }
                    // ステータス表示
                    ((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).DispStatus(csEvent);
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>クローズド報告</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySScreen.NoticeClosed() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void NoticeClosed()
        {
            McDotNetModelPropertyScreenBase csScreen = null;
            HySString csPrcKey = null;
            int iCount = 0;
            long lLoopNum = m_lScreenNum;
            // プロパティ画面を全てクローズする
            for (long lLoop = 0; lLoop < lLoopNum; lLoop++)
            {// 搭載スクリーン数ループ
                csPrcKey = (HySString)m_csScreenKeyList[iCount];
                csScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csPrcKey];
                csScreen.CloseScreen();
                m_csScreenKeyList.Remove(csPrcKey);
                m_csScreenTbl.Remove(csPrcKey);
                m_lScreenNum -= 1;
                csPrcKey = null;
                csScreen = null;
            }

            /*
            // モデル管理画面からグラフスクリーンに画面消去要求
            HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_CLOSE_SCREEN);
            csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
            csEventObj.SetSubData(m_csID);
            csEventObj.SetSuppID(m_csID);
            this.PutEvent(csEventObj);
            */

            // モデル管理画面からグラフスクリーンに画面消去要求
            // モデル管理画面からプロジェクト管理画面にクローズしたプロジェクト名を渡す
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_BROADCAST_SCREEN);
            csEventObject.SetSubEventNo(McDefine.HYM_CLOSED_PROJECT_NAME_SETUP_INFORMATION);
            csEventObject.SetToSimKind(m_csKindID);
            csEventObject.SetSuppID(m_csID);
            this.PutEvent(csEventObject);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト保存済みチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bRtn = IsSavedProject( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true  : 保存済み、false : 未保存</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean IsSavedProject()
        {
            Boolean bRtn = true;
            McSimulationStatus csSimStatus = (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
            if (csSimStatus.GetModelSaveStatus() == McSimulationStatus.ModelSaveStatus.UNSAVED)
            {// 未保存の場合
                bRtn = false;
            }
            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面要求イベント送信（設定）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> PutEventRequestSet( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PutEventRequestSet()
        {
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
            csEventObject.SetSubEventNo(McDefine.HYM_MODEL_LIBRARY_SETUP_REQUEST);
            HySID csID = new HySID(McDefine.LIBRARYSCREEN_ID);
            csEventObject.SetSuppID(csID);
            csEventObject.SetToSimKind(m_csKindID);
            this.PutEvent(csEventObject);
        }

        //★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(GIS起動及び表示操作の簡略化
        //★★★★★★★★★★★★★★★★★★★★★
        /// <summary>
        /// <para>method outline:</para>
        /// <para>GIS起動とアクティブ化</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>StartorActiveGIS()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void StartorActiveGIS()
        {
            // GIS実行体名称取得
            string GISName = GetGISName();

            // GISプロセスを取得
            System.Diagnostics.Process[] ps = System.Diagnostics.Process.GetProcessesByName(GISName);
            if (0 == ps.Length)
            {
                // GIS起動イベントを作成
                HySEventObject csLclEventObj = MakeGISStartEvent();
                // メインビューアにイベントを送信
                m_csDotNetVeiewer.PutEvent(csLclEventObj);
            }
            else
            {
                try
                {
                    // GISプロセスがあった場合GISウィンドウを最前面に表示
                    Microsoft.VisualBasic.Interaction.AppActivate(ps[0].Id);
                }
                catch (Exception ex)
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McDotNetModelCtlScreen", "StartorActiveGIS", 
                        Properties.McDotNetViewerResources.STATEMENT_CATCH_EXCEPTION_EVENT + ex.Message);
                   // HySLog.LogOut(HySLog.ONLINE, "McDotNetModelCtlScreen", "StartorActiveGIS", "Catch Exception Event: " + ex.Message);
                }
            }
        }

        //★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(GIS起動及び表示操作の簡略化
        //★★★★★★★★★★★★★★★★★★★★★
        /// <summary>
        /// <para>method outline:</para>
        /// <para>GISアプリ名称取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>getGISName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>GIS名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected static String GetGISName()
        {
            // DioVISTA.iniファイルへのパスを取得
            HySString csDataHomeIniFileName = HySEnvInf.GetHomeDirectory() + "\\conf\\DioVista.ini";
            // DioVISTA.iniファイルの内容を格納
            HySIniFile csIniFile = new HySIniFile(csDataHomeIniFileName);
            // DioVISTA.iniファイル中から、exeファイルへのパスを取得
            HySString csGISFilePath = csIniFile.GetValue(new HySString("DIOVISTA_PATH"));

            // パス中の最後の'\'の位置を取得
            int lastEn = csGISFilePath.ToString().LastIndexOf('\\');
            // パス中の最後の'.'の位置を取得
            int lastDot = csGISFilePath.ToString().LastIndexOf('.');
            // パス中の最後の'\'及び'.'の位置からexeファイルの名前を取得
            string GISName = csGISFilePath.ToString().Substring(lastEn + 1, ((lastDot - 1) - (lastEn + 1) + 1));
            return GISName;
        }

        //★★★★★★★★★★★★★★★★★★★★★
        // Ver1.4で追加(GIS起動及び表示操作の簡略化
        //★★★★★★★★★★★★★★★★★★★★★
        /// <summary>
        /// <para>method outline:</para>
        /// <para>GIS起動イベント設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetGISStartInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>イベントオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected static HySEventObject MakeGISStartEvent()
        {
            // イベントオブジェクトに情報を設定
            HySEventObject csLclEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISP_SCREEN);
            // 付加データに背景図表示を設定
            csLclEventObj.SetData(HySDefine.DISP_FORM_GIS_BASEMAP);
            // 送り先シミュレータ種別識別子設定
            csLclEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
            return csLclEventObj;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビルド要求イベント送信</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> PutEventRequestBuild( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PutEventRequestBuild()
        {
            if (m_csProjectInfData != null)
            {// プロジェクト情報がある場合
                // シミュレーションモデル構築開始指示イベント生成 
                HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_MODEL_CONSTRUCTION);
                csEvent.SetSuppID(m_csProjectInfData.GetProjectID());
                csEvent.SetToSimKind(m_csProjectInfData.GetSimulatorKind());
                this.PutEvent(csEvent);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ設定通知イベント送信</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> PutEventParaSet(ElmID, McModelInfo)</para>
        /// </example>
        /// <param name="ElmID">要素ID</param>
        /// <param name="McModelInfo">モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PutEventParaSet(HySID ElmID, McModelInfo McModelInfo)
        {
            if (m_csProjectInfData != null && McModelInfo != null)
            {// プロジェクト情報およびモデル情報がある場合
                HySEventObject csEvent = new HySEventObject(
                      HySSysEvent.OBJID_SIMULATOR,              // <= 行き先はシミュレーター
                      HySEventObject.CMND_SIMULATION_COMMON,    // イベント番号は、シミュレーション関連一般指示
                      McDefine.MODEL_PROPERTY_SET);             // 補足イベント番号は、プロパティ設定通知

                csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);    // シミュレーター種別は、ＯＨＹＭＯＳ
                csEvent.SetSuppID(m_csProjectInfData.GetProjectID());  // ＩＤは対象プロジェクトのＩＤ
                csEvent.SetData(McModelInfo);                   // 対象エレメントに設定されている　McModelInfo
                csEvent.SetSubData(ElmID);                      // 補足データにプロパティを設定する要素または接続のＩＤを設定

                this.PutEvent(csEvent);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル構造定義ファイル(XML)読み込み要求イベント送信</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> PutEventRequestStructFileRead(sFilePath) </para>
        /// </example>
        /// <param name="sFilePath">読み込みファイルパス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PutEventRequestStructFileRead(HySString sFilePath)
        {
            if (m_csProjectInfData != null && (object)sFilePath != null)
            {// プロジェクト情報および読み込みファイルパスがある場合
                // モデル構造定義ファイル(XML)読み込み要求イベント生成 
                HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_SIMULATION_COMMON, McDefine.HYM_STRUCT_FILE_READ_REQUEST);
                csEvent.SetSuppID(m_csProjectInfData.GetProjectID());
                csEvent.SetToSimKind(m_csProjectInfData.GetSimulatorKind());
                csEvent.SetData(sFilePath);
                this.PutEvent(csEvent);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル構造定義ファイル(XML)書き出し要求イベント送信</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> PutEventRequestStructFileWrite(sFilePath) </para>
        /// </example>
        /// <param name="sFilePath">書き出しファイルパス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PutEventRequestStructFileWrite(HySString sFilePath)
        {
            if (m_csProjectInfData != null && (object)sFilePath != null)
            {// プロジェクト情報および書き出しファイルパスがある場合
                // モデル構造定義ファイル(XML)書き出し要求イベント生成 
                HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_SIMULATION_COMMON, McDefine.HYM_STRUCT_FILE_WRITE_REQUEST);
                csEvent.SetSuppID(m_csProjectInfData.GetProjectID());
                csEvent.SetToSimKind(m_csProjectInfData.GetSimulatorKind());
                csEvent.SetData(sFilePath);
                this.PutEvent(csEvent);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>シミュレーション状態保持クラス変更通知</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SimulationStatusModifyInformation() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SimulationStatusModifyInformation()
        {
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_BROADCAST_SCREEN);
            csEventObject.SetSubEventNo(McDefine.HYM_SIMULATION_STATUS_MODIFY_INFORMATION);
            csEventObject.SetToSimKind(m_csKindID);
            csEventObject.SetSuppID(m_csProjectInfData.GetProjectID());
            this.PutEvent(csEventObject);

            this.ChangeMenuStatus();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySScreen.EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override bool EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            HySEventObject csEventObj = null;
            long lEventNo = ((HySEventObject)csEvent).GetEventNo();
            long lSubEventNo = ((HySEventObject)csEvent).GetSubEventNo();
            HySID csID = ((HySEventObject)csEvent).GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();
            if (lEventNo == HySEventObject.ARBITRARY_EVENT)
            {// 任意イベントの場合
                if (lSubEventNo == McDefine.HYM_DATACONTAINER_SEND)     // データコンテナ送信
                {// データコンテナ送信の場合
                    // データコンテナから要素間接続情報及びモデルチェック情報を取得
                    m_csDataContainer = (HySSimulationDataContainer)((HySEventObject)csEvent).GetData();
                    McStructInfo csStructInfo = (McStructInfo)m_csDataContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO);
                    // 操作性改善（描画オフ処理）
                    m_csModelCtlForm.CheckModelDispOff(csStructInfo);
                    McStructCheckData csStructCheckData = (McStructCheckData)m_csDataContainer.GetData(McDefine.HYM_DATA_CHECK_INFO);

                    m_csProjectInfData = (McProjectInfData)m_csDataContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
                    m_csProjectName = m_csProjectInfData.GetDispProjectName();
                    m_csModelCtlForm.SetStructInfo(csStructInfo);
                    m_csModelCtlForm.SetStructCheckData(csStructCheckData);

                    // モデルアイコン表示更新（計算コントロール）
                    McSimulationStatus csSimulationStatus = (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                    m_csModelCtlForm.SetMask(csSimulationStatus.GetCalcStatus(), false);

                    this.ReDrawScreen((HySID)m_csDataContainer.GetID());

                    // 画面のアクティブ化依頼
                    ((HySDotNetViewerJob)m_csVJob).ActivateAllScreen();

                    // カーソルをデフォルトに戻す。
                    ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm().Cursor = Cursors.Default;

                    // 業務にデータコンテナ設定報告を送信
                    csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.ARBITRARY_EVENT);
                    csEventObj.SetToSimKind(csSimKind);
                    csEventObj.SetSuppID(csID);
                    csEventObj.SetSubEventNo(McDefine.HYM_NOTICE_DATACONTAINER_SET);
                    bRtn = this.PutEvent(csEventObj);
                }
                else if (lSubEventNo == McDefine.HYM_MODELLOG_DISP_REQUEST) // プロジェクト（モデル管理画面）を開いた際の演算ログ表示
                {// 演算ログ出力要求の場合
                    m_csModelCtlForm.ClearModelLogData();           //演算ログクリア
                    McModelLogData csLogData = (McModelLogData)m_csDataContainer.GetData(McDefine.HYM_DATA_LOG_INFO);
                    m_csModelCtlForm.SetModelLogData(csLogData);    //演算ログ表示
                    bRtn = true;
                }
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {// 画面関連一般指示の場合
                if (lSubEventNo == McDefine.HYM_ELEMENT_MODEL_SET)                          // 要素モデル設定
                {// 要素モデル設定の場合
                    m_csModelCtlForm.ElementModelSet((McModelInfo)((HySEventObject)csEvent).GetData());
                    bRtn = true;
                }
                else if (lSubEventNo == McDefine.HYM_INPUT_DATA_SET)                        // 入力データ設定
                {// 入力データ設定の場合
                    m_csModelCtlForm.InputDataSet((McModelInfo)((HySEventObject)csEvent).GetData());
                    bRtn = true;
                }
                else if (lSubEventNo == McDefine.HYM_OUTPUT_DATA_SET)                       // 出力データ設定
                {// 出力データ設定の場合
                    m_csModelCtlForm.OutputDataSet((McModelInfo)((HySEventObject)csEvent).GetData());
                    bRtn = true;
                }
                else if (lSubEventNo == McDefine.HYM_TRANSMISSION_INFORMATION_TYPE_SET)     // 伝送情報型設定
                {// 伝送情報型設定の場合
                    m_csModelCtlForm.TransInfoTypeSet((McModelInfo)((HySEventObject)csEvent).GetData());
                    bRtn = true;
                }
                else if (lSubEventNo == McDefine.HYM_LIBRARY_DATA_CANCEL)                   // ライブラリ設定情報解除
                {// ライブラリ設定情報解除の場合
                    m_csModelCtlForm.LibraryDataCancel();
                    bRtn = true;
                }
                else if (lSubEventNo == McDefine.HYM_NOTICE_MODEL_SCREEN_ACTIVE)
                {// アクティブ通知の場合
                    m_csModelCtlForm.ActiveModelForm();                                     // アクティブ化
                    this.SetScreenStatus(true);

                    // 他のスクリーンを非アクティブにする。
                    ((HySDotNetViewerJob)m_csVJob).AllScreenStatusSet(csEvent);

                    bRtn = true;
                }
                else if (lSubEventNo == McDefine.HYM_NOTICE_STRUCT_FILE_READ_REQUEST)       // モデル構造定義ファイル(XML)読み込み完了
                {// モデル構造定義ファイル(XML)読み込み完了の場合
                    McStructInfo csStructInfo = (McStructInfo)m_csDataContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO);
                    // 操作性改善（描画オフ処理）
                    m_csModelCtlForm.CheckModelDispOff(csStructInfo);
                    m_csModelCtlForm.SetStructInfo(csStructInfo);

                    McStructCheckData csStructCheckData = (McStructCheckData)m_csDataContainer.GetData(McDefine.HYM_DATA_CHECK_INFO);
                    for (int iLp = (int)csStructCheckData.GetCheckDataCount() - 1; iLp >= 0; iLp--)
                    {// チェックデータ数ループ
                        csStructCheckData.RemoveCheckData(iLp);
                    }
                    m_csModelCtlForm.SetStructCheckData(csStructCheckData);

                    // モデルアイコン表示更新（計算コントロール）
                    McSimulationStatus csSimulationStatus = (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                    csSimulationStatus.SetModelConStatus(McSimulationStatus.ModelConstructionStatus.NOT_CONSTRUCTED);
                    csSimulationStatus.SetModelModStatus(McSimulationStatus.ModelModificationStatus.MODIFIED_CONSTRUCTION_REQUIRED);
                    csSimulationStatus.SetModelSaveStatus(McSimulationStatus.ModelSaveStatus.UNSAVED);
                    csSimulationStatus.SetCalcStatus(McSimulationStatus.CalculationStatus.INITIAL);
                    m_csModelCtlForm.SetMask(csSimulationStatus.GetCalcStatus(), false);

                    this.ChangeMenuStatus();

                    bRtn = true;
                }
                else if (lSubEventNo == McDefine.HYM_NOTICE_STRUCT_FILE_WRITE_REQUEST)      // モデル構造定義ファイル(XML)書き出し完了
                {// モデル構造定義ファイル(XML)書き出し完了の場合
                    bRtn = true;
                }
                else if (lSubEventNo == McDefine.HYM_HISTORY_FILE_UPDATE_REQUEST)           // ヒストリーファイル更新要求通知
                {// ヒストリーファイル更新要求通知の場合
                    m_csModelCtlForm.HistoryFileUpdate();
                }
                else if (lSubEventNo == McDefine.HYM_INCORPORATE_PROJECT)                   // プロジェクト取り込み（プロジェクト読み込み完了）通知
                {// プロジェクト取り込みの場合
                    HySSimulationDataContainer csDataContainer = (HySSimulationDataContainer)((HySEventObject)csEvent).GetData();
                    McStructInfo csStructInfo = (McStructInfo)csDataContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO);
                    McProjectInfData csProjectInfData = (McProjectInfData)csDataContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
                    HySString csProjectName = csProjectInfData.GetProjectName();
                    HySFactoryManager csFactoryManager = ((HySViewerBase)m_csDotNetVeiewer).GetFactoryManager();
                    McFigureUnityFactory csFigUnityFact = null;
                    long lFctNo = csFactoryManager.GetFactoryNum();
                    for (long lLp = 0; lLp < lFctNo; lLp++)
                    {// ファクトリ数ループ
                        csFigUnityFact = csFactoryManager.GetFactory(lLp) as McFigureUnityFactory;
                        if (csFigUnityFact != null)
                        {// ファクトリクラスがあった場合
                            break;
                        }
                    }
                    if (csFigUnityFact != null)
                    {// ファクトリクラスがあった場合
                        McModelFactorySet csModelFactory = csFigUnityFact.GetModelFactorySet();
                        m_csModelCtlForm.ProjectIncorporateProjectLoad(csProjectName, csStructInfo, csModelFactory);
                    }
                }
                else if (lSubEventNo == McDefine.HYM_MODEL_LIBRARY_TREE_DATA)               // ライブラリ管理画面表示ツリー情報
                {// ライブラリ管理画面表示ツリー情報の場合
                    // ポップアップメニュー生成（ライブラリツリー）
                    m_csModelCtlForm.PopupMenuMakeLibraryTree((McTreeData)((HySEventObject)csEvent).GetData());
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION ||
                lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION ||
                lEventNo == HySEventObject.NOTICE_START_SIMULATION ||
                lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION ||
                lEventNo == HySEventObject.NOTICE_STOP_SIMULATION ||
                lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION ||
                lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND ||
                lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION)
            {
                if (m_csID.Equals(csID) == true)
                {// IDが一致した場合
                    if (lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION ||
                        lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION)                   // ビルド終了（シミュレーションモデル作成終了報告(正常/異常)）
                    {// シミュレーションモデル作成終了報告(正常/異常)の場合
                        //★★★★★★★★★★★★★★★★★
                        // Ver1.4で追加(伝送情報の事前作成)
                        //★★★★★★★★★★★★★★★★★
                        // ここで明示的な解放(2回目)
                        GC.Collect();// 1回目で回収対象としてマークしたオブジェクトを此処で破棄する
                        McSimulationStatus csSimulationStatus = (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                        if (lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION)
                        {// シミュレーションモデル作成終了報告(正常)の場合
                            m_csModelCtlForm.SetMask(csSimulationStatus.GetCalcStatus(), false);
                        }
                        else
                        {// シミュレーションモデル作成終了報告(異常)の場合
                            m_csModelCtlForm.SetMask(csSimulationStatus.GetCalcStatus(), true);
                        }
                        m_csModelCtlForm.ClearModelLogData();   //演算ログクリア
                        // チェックデータの表示編集中に、コンテナ側のチェックデータの内容が変えられてしまう可能性があるため、別インスタンスの情報で表示編集を行うようにする。
                        McStructCheckData csStructCheckData = (McStructCheckData)HySDataDuplicate.DupliCateData(m_csDataContainer.GetData(McDefine.HYM_DATA_CHECK_INFO));
                        m_csModelCtlForm.SetStructCheckData(csStructCheckData);
                        m_csModelCtlForm.HistoryFileUpdateModelConstruction();
                        bRtn = true;
                    }
                    else if (lEventNo == HySEventObject.NOTICE_START_SIMULATION)                    // 演算実行（シミュレーション計算開始報告）
                    {// シミュレーション計算開始報告の場合
                        // チェックデータの表示編集中に、コンテナ側のチェックデータの内容が変えられてしまう可能性があるため、別インスタンスの情報で表示編集を行うようにする。
                        McStructCheckData csStructCheckData = (McStructCheckData)HySDataDuplicate.DupliCateData(m_csDataContainer.GetData(McDefine.HYM_DATA_CHECK_INFO));
                        m_csModelCtlForm.SetStructCheckData(csStructCheckData);
                        McSimulationStatus csSimulationStatus = (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                        m_csModelCtlForm.SetMask(csSimulationStatus.GetCalcStatus(), true);
                        m_csModelCtlForm.HistoryFileUpdateModelConstruction();
                        bRtn = true;
                    }
                    else if (lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION)               // リセット（シミュレーション初期化完了報告）
                    {// シミュレーション初期化完了報告の場合
                        McSimulationStatus csSimulationStatus = (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                        if (lSubEventNo == McDefine.HYM_OK_SUBEVENT)
                        {// OKの場合
                            m_csModelCtlForm.SetMask(csSimulationStatus.GetCalcStatus(), false);
                            m_csModelCtlForm.ClearModelLogData();   //演算ログクリア
                        }
                        else
                        {// OK以外の場合
                            m_csModelCtlForm.SetMask(csSimulationStatus.GetCalcStatus(), true);
                            m_csModelCtlForm.ClearModelLogData();   //演算ログクリア
                            McModelLogData csLogData = (McModelLogData)m_csDataContainer.GetData(McDefine.HYM_DATA_LOG_INFO);
                            m_csModelCtlForm.SetModelLogData(csLogData);    //演算ログ表示
                            // チェックデータの表示編集中に、コンテナ側のチェックデータの内容が変えられてしまう可能性があるため、別インスタンスの情報で表示編集を行うようにする。
                            McStructCheckData csStructCheckData = (McStructCheckData)HySDataDuplicate.DupliCateData(m_csDataContainer.GetData(McDefine.HYM_DATA_CHECK_INFO));
                            m_csModelCtlForm.SetStructCheckData(csStructCheckData);
                        }
                        m_csModelCtlForm.HistoryFileUpdateModelConstruction();
                        bRtn = true;
                    }
                    else if (lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION ||
                            lEventNo == HySEventObject.NOTICE_STOP_SIMULATION ||
                            lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND ||
                            lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION)                  // 中断/終了/強制終了
                    {
                        McSimulationStatus csSimulationStatus = (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                        m_csModelCtlForm.SetMask(csSimulationStatus.GetCalcStatus(), true);
// start of Add Ver1.1
                        McStructCheckData csStructCheckData = (McStructCheckData)HySDataDuplicate.DupliCateData(m_csDataContainer.GetData(McDefine.HYM_DATA_CHECK_INFO));
                        m_csModelCtlForm.SetStructCheckData(csStructCheckData);
// end of Add Ver1.1
                        m_csModelCtlForm.ClearModelLogData();           //演算ログクリア
                        McModelLogData csLogData = (McModelLogData)m_csDataContainer.GetData(McDefine.HYM_DATA_LOG_INFO);
                        m_csModelCtlForm.SetModelLogData(csLogData);    //演算ログ表示
                        m_csModelCtlForm.HistoryFileUpdateModelConstruction();
                        bRtn = true;
                    }
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_DISPLY_OK)      // 画面報告
            {// 画面関連一般報告(正常報告)の場合
                if (lSubEventNo == HySDispDefine.NOTICE_SCREEN_CLOSE)  // 計算結果モニタ画面クローズ完了通知
                {// 画面関連一般サブ要因(画面終了)の場合
                    m_csModelCtlForm.LineGraphScreenClose(csID);
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_RUN_COMPLETE ||
                      lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_EXIT_COMPLETE)
            {
                // バックグラウンド操作化
                if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_RUN_COMPLETE)
                {
                    m_csModelCtlForm.ChangeSimulationButtonStatus(false);
                }
                else if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_EXIT_COMPLETE)
                {
                    if (((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).IsDBToolRun() == false)
                    {
                        m_csModelCtlForm.ChangeSimulationButtonStatus(true);
                    }
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_RUN_COMPLETE ||
                      lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_EXIT_COMPLETE)
            {
                // バックグラウンド操作化
                if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_RUN_COMPLETE)
                {
                    m_csModelCtlForm.ChangeSimulationButtonStatus(false);
                }
                else if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_EXIT_COMPLETE)
                {
                    if (((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).IsDBToolRun() == false)
                    {
                        m_csModelCtlForm.ChangeSimulationButtonStatus(true);
                    }
                }
            }

            // 計算結果モニタ画面にイベント転送
            Boolean bMoniterPutEvent = this.MoniterPutEvent(csEvent);

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetScreen.PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        override public Boolean PutEvent(HySSysEvent csEvent)
        {
            ((HySEventObject)csEvent).SetToSimKind(McDefine.SIMULATOR_KIND);
            return m_csDotNetVeiewer.PutEvent(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>要素名称・ID表示設定取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetScreen.GetDispKind() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GetDispKind()
        {
            m_csModelCtlForm.DispKindChangeID(((HySDotNetViewer)m_csDotNetVeiewer).GetCheckOnFlg(McDefine.HYMCO_MODEL_DISP_ID_ON));
            m_csModelCtlForm.DispKindChangeName(((HySDotNetViewer)m_csDotNetVeiewer).GetCheckOnFlg(McDefine.HYMCO_MODEL_DISP_NAME_ON));
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループ名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csString =  GetProjectGroupName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString プロジェクトグループ名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetProjectGroupName()
        {
            HySString csRtn = new HySString("");
            if (m_csProjectInfData != null)
            {
                csRtn = m_csProjectInfData.GetProjectGroupName();
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csString =  GetProjectName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString プロジェクト名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySString GetProjectName()
        {
            return m_csProjectName;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトID取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csString = GetProjectID() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString プロジェクトID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetProjectID()
        {
            return (HySString)m_csProjectInfData.GetProjectID().GetString();
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション状態保持情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSimulationStatus csSimulationStatus = GetSimulationStatusData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSimulationStatus シミュレーション状態保持情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McSimulationStatus GetSimulationStatusData()
        {
            return (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション状態保持情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSimulationStatusData(csSimulationStatusData) </para>
        /// </example>
        /// <param name="csSimulationStatusData">シミュレーション状態保持情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSimulationStatusData(McSimulationStatus csSimulationStatusData)
        {
            McSimulationStatus csSimulationStatus = (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
            csSimulationStatus.SetModelConStatus(csSimulationStatusData.GetModelConStatus());
            csSimulationStatus.SetModelModStatus(csSimulationStatusData.GetModelModStatus());
            csSimulationStatus.SetModelSaveStatus(csSimulationStatusData.GetModelSaveStatus());
            csSimulationStatus.SetCalcStatus(csSimulationStatusData.GetCalcStatus());
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ設定画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ShowModelPropertyScreen(csElement)</para>
        /// </example>
        /// <param name="csElement">エレメント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowModelPropertyScreen(McGraphicsElement csElement)
        {
            McDotNetModelPropertyScreenBase csScreen = null;
            McDotNetModelPropertyScreenBase csOldScreen = null;
            HySString csKey = null;
            for (long lLoop = 0; lLoop < m_lScreenNum; lLoop++)
            {// 搭載スクリーン数ループ
                csKey = (HySString)m_csScreenKeyList[(int)lLoop];
                if (csKey.Equal((HySString)csElement.GetID().GetString()) == true)
                {// キー情報が一致した場合
                    csScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csKey];
                    csScreen.ActivateForm();
                    return;
                }
            }

            if (csElement.GetModelInfo().GetModelKind().GetString().ToString() != string.Empty)
            {// モデル種別がある場合
                // モデルが設定されている場合のみ表示する
                McDotNetViewerJob csMcViewJob = m_csVJob as McDotNetViewerJob;
                csScreen = csMcViewJob.CreatePropertyScreen(m_csKindID, m_csID, csElement.GetModelInfo().GetLibraryID(), csElement.GetModelInfo().GetModelKind()) as McDotNetModelPropertyScreenBase;
                if (csScreen == null)
                {// スクリーン未生成の場合
                    McPropertyInfo csPrptyInf = csElement.GetModelInfo().GetPropertyInfo() as McPropertyInfo;

                    if (csPrptyInf != null)
                    {// プロパティ情報がある場合
                        if (csPrptyInf is McCellModelPropertyInfo)
                        {   // セル型モデルプロパティ表示／設定情報クラスならば
                            csScreen = new McDotNetModelCellPropertyScreen();
                        }
                        else if (csPrptyInf is McGeoMeshTranInfoPropertyInfo)
                        {   // ＧＩＳ型プロパティ表示／設定情報クラスならば
                            csScreen = new McDotNetTranInfoGeoPropertyScreen();
                        }
                        else if (csPrptyInf is McCellArrayTranInfoPropertyInfo)
                        {   // セル型伝送情報プロパティ表示／設定情報クラスならば
                            csScreen = new McDotNetTranInfoCellPropertyScreen();
                        }
                        else
                        {   // 標準形のプロパティ情報ならば
                            csScreen = new McDotNetModelPropertyScreen();
                        }
                        csScreen.SetSimKind(m_csKindID);    // 種別識別子設定
                        csScreen.SetID(m_csID);             // データ識別子設定
                    }
                }
                if (csScreen != null)
                {// スクリーン生成の場合
                    if (m_lScreenNum > 0)
                    {// 搭載スクリーン数が０より大きい場合
                        csKey = (HySString)m_csScreenKeyList[0];
                        csOldScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csKey];
                        if (csOldScreen.BeforeCloseScreen() == false)
                        {// クローズ不可の場合
                            return;
                        }
                        csOldScreen.CloseScreen();
                    }

                    // スクリーン生成正常／管理情報登録
                    m_csScreenTbl[csElement.GetID().GetString()] = csScreen;
                    m_csModelTbl[csElement.GetID().GetString()] = csElement;
                    m_csModelInfoTbl[csElement.GetID().GetString()] = (McModelInfo)HySDataDuplicate.DupliCateData(csElement.GetModelInfo());
                    m_lScreenNum += 1;
                    m_csScreenKeyList.Add(csElement.GetID().GetString());

                    // スクリーン生成正常／画面表示実行
                    csScreen.SetElementDataID((HySID)csElement.GetID());
                    csScreen.SetElementName(csElement.GetElementName());
                    csScreen.SetModelPropertyInfo(csElement.GetModelInfo().GetPropertyInfo());
                    csScreen.SetModelInitialInfo(csElement.GetModelInfo().GetInitialInfo());
                    csScreen.SetModelCtlScreen(this);
                    csScreen.Initialize();
                    csScreen.SetViewer(m_csDotNetVeiewer);
                    csScreen.ShowScreen();
                }
                else
                {// スクリーン未生成の場合
                    // プロパティ画面の設定がモデル側から提供されていない事を通知する
                    //  メッセージボックスまたは、ステータス
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ設定画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ShowModelPropertyScreen(csStructInfo)</para>
        /// </example>
        /// <param name="csStructInfo">要素間接続情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowModelPropertyScreen(McStructInfo csStructInfo)
        {
            McDotNetModelPropertyScreenBase csScreen = null;
            McDotNetModelPropertyScreenBase csOldScreen = null;
            HySString csKey = null;
            for (long lLoop = 0; lLoop < m_lScreenNum; lLoop++)
            {// 搭載スクリーン数ループ
                csKey = (HySString)m_csScreenKeyList[(int)lLoop];
                if (csKey.Equal((HySString)csStructInfo.GetID().GetString()) == true)
                {// キー情報が一致した場合
                    csScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csKey];
                    csScreen.ActivateForm();
                    return;
                }
            }

            if (csStructInfo.GetModelInfo().GetModelKind().GetString().ToString() != string.Empty)
            {// モデル種別がある場合
                McDotNetViewerJob csMcViewJob = m_csVJob as McDotNetViewerJob;
                csScreen = csMcViewJob.CreatePropertyScreen(m_csKindID, m_csID, csStructInfo.GetModelInfo().GetLibraryID(), csStructInfo.GetModelInfo().GetModelKind()) as McDotNetModelPropertyScreenBase;
                if (csScreen != null)
                {// スクリーン生成の場合
                    if (m_lScreenNum > 0)
                    {// 搭載スクリーン数が０より大きい場合
                        csKey = (HySString)m_csScreenKeyList[0];
                        csOldScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csKey];
                        if (csOldScreen.BeforeCloseScreen() == false)
                        {// クローズ不可の場合
                            return;
                        }
                        csOldScreen.CloseScreen();
                    }

                    // スクリーン生成正常／管理情報登録
                    m_csScreenTbl[csStructInfo.GetID().GetString()] = csScreen;
                    m_csModelTbl[csStructInfo.GetID().GetString()] = csStructInfo;
                    m_csModelInfoTbl[csStructInfo.GetID().GetString()] = (McModelInfo)HySDataDuplicate.DupliCateData(csStructInfo.GetModelInfo());
                    m_lScreenNum += 1;
                    m_csScreenKeyList.Add(csStructInfo.GetID().GetString());

                    // スクリーン生成正常／画面表示実行
                    csScreen.SetElementDataID((HySID)csStructInfo.GetID());
                    csScreen.SetElementName(m_csProjectName);
                    csScreen.SetModelPropertyInfo(csStructInfo.GetModelInfo().GetPropertyInfo());
                    csScreen.SetModelCtlScreen(this);
                    csScreen.Initialize();
                    csScreen.SetViewer(m_csDotNetVeiewer);
                    csScreen.ShowScreen();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ設定画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ShowModelPropertyScreen(csElementID)</para>
        /// </example>
        /// <param name="csElementID">エレメントID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ShowModelPropertyScreen(HySIdentifier csElementID)
        {
            McGraphicsElement csElement = m_csModelCtlForm.SearchSelectElement(csElementID);
            if (csElement != null)
            {// 検索できた場合
                ShowModelPropertyScreen(csElement);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>指定要素選択表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SelectiveDisplaySpecifiedElement(csElementID)</para>
        /// </example>
        /// <param name="csElementID">エレメントID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SelectiveDisplaySpecifiedElement(HySIdentifier csElementID)
        {
            m_csModelCtlForm.SearchSelectElement(csElementID);
        }

        /// <summary><para>method outline</para>
        /// <para>プロパティ設定画面表示要素情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataRoot csPropertyDispElement = GetPropertyDispElement( csString )</para>
        /// </example>
        /// <param name="csString">スクリーン識別情報</param>
        /// <returns>HySDataRoot プロパティ設定画面表示要素情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataRoot GetPropertyDispElement(HySString csString)
        {
            HySString csPrcKey = null;
            HySDataRoot csDataRoot = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {// 搭載スクリーン数ループ
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                if (csPrcKey.Equal(csString) == true)
                {// キー情報が一致した場合
                    csDataRoot = (HySDataRoot)m_csModelTbl[csPrcKey];
                    break;
                }
            }

            return csDataRoot;
        }

        /// <summary><para>method outline</para>
        /// <para>タイムステップ最大値取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double dTimeStepMax = GetTimeStepMaxValue()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double タイムステップ最大値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetTimeStepMaxValue()
        {
            double dTimeStepMax = 0.0;

            HySTime csStartTime = m_csProjectInfData.GetStartSimuTime();
            HySTime csGoalTime = m_csProjectInfData.GetEndSimuTime();

            dTimeStepMax = csGoalTime.GetTime() - csStartTime.GetTime();

            return dTimeStepMax;
        }

        /// <summary><para>method outline</para>
        /// <para>プロパティ管理画面クローズ時のScreen削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteScreen( csString )</para>
        /// </example>
        /// <param name="csString">スクリーン識別情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プロパティ管理画面のクローズ化に伴うスクリーンインスタンス削除処理</para>
        /// </remarks>
        public void DeleteScreen(HySString csString)
        {
            McDotNetModelPropertyScreenBase csScreen = null;
            csScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csString];
            if (csScreen != null)
            {// スクリーンがあった場合
                m_csScreenTbl.Remove(csString);
                m_csModelTbl.Remove(csString);
                m_csModelInfoTbl.Remove(csString);
                m_csScreenKeyList.Remove(csString);
                m_lScreenNum--;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>プロパティ管理画面クローズ要求</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PropetyScreenClose( csElmentID )</para>
        /// </example>
        /// <param name="csElmentID">クローズ要素ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PropetyScreenClose(HySIdentifier csElmentID)
        {
            HySString csPrcKey = null;
            McDotNetModelPropertyScreenBase csScreen = null;
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {// 搭載スクリーン数ループ
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                if (csPrcKey.Equal((HySString)csElmentID.GetString()) == true)
                {// キー情報が一致した場合
                    csScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csPrcKey];
                    csScreen.CloseScreen();
                    break;
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>プロパティ管理画面クローズ要求</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PropetyScreenClose(  )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PropetyScreenClose()
        {
            HySString csPrcKey = null;
            McDotNetModelPropertyScreenBase csScreen = null;
            for (long lLp = m_lScreenNum; lLp > 0; lLp--)
            {// 搭載スクリーン数ループ
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csPrcKey];
                csScreen.CloseScreen();
            }
        }

        /// <summary><para>method outline</para>
        /// <para>プロパティ管理画面リフレッシュ要求</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RefreshmentPropety( csElmentID )</para>
        /// </example>
        /// <param name="csElmentID">クローズ要素ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void RefreshmentPropety(HySIdentifier csElmentID)
        {
            HySString csPrcKey = null;
            McDotNetModelPropertyScreenBase csScreen = null;
            McGraphicsElement csElement = null;
            for (long lLp = 0; lLp < m_lScreenNum; lLp++)
            {// 搭載スクリーン数ループ
                csPrcKey = (HySString)m_csScreenKeyList[(int)lLp];
                if (csElmentID != null)
                {// IDがある場合
                    if (csPrcKey.Equal((HySString)csElmentID.GetString()) == true)
                    {// キー情報が一致した場合
                        csScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csPrcKey];
                        csElement = m_csModelTbl[csPrcKey] as McGraphicsElement;
                        if (csElement != null)
                        {// 要素情報があった場合
                            m_csModelInfoTbl[csPrcKey] = (McModelInfo)HySDataDuplicate.DupliCateData(csElement.GetModelInfo());
                            csScreen.SetElementName(csElement.GetElementName());
                            csScreen.SetModelPropertyInfo(csElement.GetModelInfo().GetPropertyInfo());
                            csScreen.SetModelInitialInfo(csElement.GetModelInfo().GetInitialInfo());
                        }
                        csScreen.RefreshmentForm();
                        break;
                    }
                }
                else
                {// IDがない場合
                    csScreen = (McDotNetModelPropertyScreenBase)m_csScreenTbl[csPrcKey];
                    csElement = m_csModelTbl[csPrcKey] as McGraphicsElement;
                    if (csElement != null)
                    {// 要素情報があった場合
                        m_csModelInfoTbl[csPrcKey] = (McModelInfo)HySDataDuplicate.DupliCateData(csElement.GetModelInfo());
                        csScreen.SetElementName(csElement.GetElementName());
                        csScreen.SetModelPropertyInfo(csElement.GetModelInfo().GetPropertyInfo());
                        csScreen.SetModelInitialInfo(csElement.GetModelInfo().GetInitialInfo());
                    }
                    csScreen.RefreshmentForm();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ情報設定イベント送信要求</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ReqPropertyInfoSetEvent(csElementID)</para>
        /// </example>
        /// <param name="csElementID">エレメントID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ReqPropertyInfoSetEvent(HySID csElementID)
        {
            McGraphicsElement csElement = m_csModelTbl[csElementID.GetString()] as McGraphicsElement;
            if (csElement != null)
            {// 要素情報があった場合
                //プロパティ設定通知イベント送信
                McModelInfo csModelInfo = csElement.GetModelInfo();
                this.PutEventParaSet(csElementID, csModelInfo);

                // 再編集
                m_csModelCtlForm.PropertyListEdit(0, false);

                // モデル管理リフレッシュ
                m_csModelCtlForm.RefreshmentModelCtlForm();

                //復元データ編集
                McHistoryData csHistoryData = new McHistoryData();
                csHistoryData.Kind = McHistoryData.OperationKind.PROPERTY_CHANGE;
                List<object> csHistoryDataWork = new List<object>();
                csHistoryDataWork.Add(csElementID);
                csHistoryDataWork.Add((McModelInfo)m_csModelInfoTbl[csElementID.GetString()]);
                csHistoryDataWork.Add((McModelInfo)HySDataDuplicate.DupliCateData(csElement.GetModelInfo()));
                csHistoryDataWork.Add(false);
                csHistoryDataWork.Add(true);
                csHistoryData.HistoryData = csHistoryDataWork;

                //復元ポイント記録
                m_csModelCtlForm.ReconstructionPointSave(false, csHistoryData);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ情報設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PropertyInfoSet(csElementID, bSetMode)</para>
        /// </example>
        /// <param name="csElementID">エレメントID</param>
        /// <param name="bSetMode">変更モード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PropertyInfoSet(HySID csElementID, bool bSetMode)
        {
            // 再編集
            m_csModelCtlForm.PropertyListEdit(0, false);

            // モデル管理リフレッシュ
            m_csModelCtlForm.RefreshmentModelCtlForm();

            //復元データ編集
            McHistoryData csHistoryData = new McHistoryData();
            csHistoryData.Kind = McHistoryData.OperationKind.PROPERTY_CHANGE;
            List<object> csHistoryDataWork = new List<object>();
            csHistoryDataWork.Add(csElementID);
            csHistoryDataWork.Add((McModelInfo)m_csModelInfoTbl[csElementID.GetString()]);
            if (m_csModelTbl[csElementID.GetString()] is McGraphicsElement)
            {// McGraphicsElement型の場合
                csHistoryDataWork.Add((McModelInfo)HySDataDuplicate.DupliCateData(((McGraphicsElement)m_csModelTbl[csElementID.GetString()]).GetModelInfo()));
                csHistoryDataWork.Add(false);
            }
            else if (m_csModelTbl[csElementID.GetString()] is McStructInfo)
            {// McStructInfo型の場合
                csHistoryDataWork.Add((McModelInfo)HySDataDuplicate.DupliCateData(((McStructInfo)m_csModelTbl[csElementID.GetString()]).GetModelInfo()));
                csHistoryDataWork.Add(true);
            }
            csHistoryDataWork.Add(false);
            csHistoryData.HistoryData = csHistoryDataWork;

            if (bSetMode == true)
            {// ビルド要変更の場合
                //復元ポイント記録
                m_csModelCtlForm.ReconstructionPointSave(true, csHistoryData);
            }
            else
            {// ビルド不要変更の場合
                //復元ポイント記録
                m_csModelCtlForm.ReconstructionPointSave(false, csHistoryData);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>折れ線グラフ表示アクティブイベント送信要求</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LineGraphScreenActiveEvent(csElementID)</para>
        /// </example>
        /// <param name="csElementID">エレメントID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void LineGraphScreenActiveEvent(HySIdentifier csElementID)
        {
            // 表示イベント生成
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            csEvent.SetFrom(HySSysEvent.OBJID_SIMULATOR);
            csEvent.SetFromSimKind(McDefine.SIMULATOR_KIND);
            csEvent.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
            csEvent.SetData(HySDefine.DISP_FORM_MONITER);
            csEvent.SetSuppID((HySID)this.GetID());
            csEvent.SetResponseInfo((HySID)csElementID);
            csEvent.SetSubEventNo(HySDispDefine.NOTICE_ACTIVE_EVENT);
            m_csDotNetVeiewer.PutEvent(csEvent);
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>折れ線グラフ表示イベント送信要求</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LineGraphScreenDispEvent(csElementID,csPatternID)</para>
        /// </example>
        /// <param name="csElementID">エレメントID</param>
        /// <param name="csPatternID">モデル種別リスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void LineGraphScreenDispEvent(HySIdentifier csElementID, HySDataLinkedList csPatternID)
        {
            // 表示イベント生成
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISP_SCREEN);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            csEvent.SetFrom(HySSysEvent.OBJID_SIMULATOR);
            csEvent.SetFromSimKind(McDefine.SIMULATOR_KIND);
            csEvent.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
            csEvent.SetData(HySDefine.DISP_FORM_MONITER);
            csEvent.SetSuppID((HySID)this.GetID());
            csEvent.SetResponseInfo((HySID)csElementID);
            csEvent.SetSubData(csPatternID);
            m_csDotNetVeiewer.PutEvent(csEvent);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>折れ線グラフ終了イベント送信要求</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>LineGraphScreenCloseEvent(csElementID)</para>
        /// </example>
        /// <param name="csElementID">エレメントID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void LineGraphScreenCloseEvent(HySIdentifier csElementID)
        {
            // 終了イベント生成
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_CLOSE_SCREEN);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            csEvent.SetFrom(HySSysEvent.OBJID_SIMULATOR);
            csEvent.SetFromSimKind(McDefine.SIMULATOR_KIND);
            csEvent.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
            csEvent.SetData(HySDefine.DISP_FORM_MONITER);
            csEvent.SetSuppID((HySID)this.GetID());
            csEvent.SetResponseInfo((HySID)csElementID);
            m_csDotNetVeiewer.PutEvent(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>計算結果モニタ画面にイベントを転送</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MoniterPutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public Boolean MoniterPutEvent(HySSysEvent csEvent)
        {
            bool bRtn = true;
            long lEventNo = ((HySEventObject)csEvent).GetEventNo();
            long lSubEventNo = ((HySEventObject)csEvent).GetSubEventNo();
            HySID csID = ((HySEventObject)csEvent).GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();
            bool bEventOn = false; // イベント送信無し設定

            if (lEventNo == HySEventObject.CMND_BROADCAST_SCREEN)
            {  // 状態遷移通知の場合
                if (lSubEventNo == McDefine.HYM_ACTIVE_PROJECT_NAME_SETUP_INFORMATION)
                {  // モデル名称設定報告の場合
                    if (m_csID.Equals(csID) == true)
                    {  // アクティブの場合
                        lSubEventNo = HySDispDefine.NOTICE_ACTIVE_EVENT;
                        bEventOn = true;
                    }
                }
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {  // 画面一般指示の場合
                if (lSubEventNo == McDefine.HYM_MODEL_SCREEN_CLOSE)
                {  // モデルクローズ報告の場合
                    if (m_csID.Equals(csID) == true)
                    {  // アクティブの場合
                        lSubEventNo = HySDispDefine.NOTICE_MODEL_CLOSE;
                        bEventOn = true;
                    }
                }               
            }
            else if (lEventNo == HySEventObject.NOTICE_START_SIMULATION)
            {  // シミュレーション計算開始報告の場合
                if (m_csID.Equals(csID) == true)
                {  // アクティブの場合
                    lSubEventNo = HySDispDefine.NOTICE_ACTIVE_EVENT;
                    bEventOn = true;
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_STOP_SIMULATION ||
                     lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION ||
                     lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND)
            {  // シミュレーション計算終了報告の場合
                if (m_csID.Equals(csID) == true)
                {  // アクティブの場合
                    lSubEventNo = lEventNo;
                    bEventOn = true;
                }
            }
            if (bEventOn == true)
            {  // イベント送信要の場合
                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                csEventObj.SetFromSimKind(McDefine.SIMULATOR_KIND);
                csEventObj.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                csEventObj.SetSuppID((HySID)this.GetID());
                csEventObj.SetSubEventNo(lSubEventNo);
                bRtn = m_csDotNetVeiewer.PutEvent(csEventObj);
            }
            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>評価画面表示イベント送信要求</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>PutEvaluationMenuEvent(csElementID,csDispKind)</para>
        /// </example>
        /// <param name="csElementID">エレメントID</param>
        /// <param name="csDispKind">画面識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PutEvaluationMenuEvent(HySIdentifier csElementID, HySKind csDispKind)
        {
            // 表示イベント生成
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISP_SCREEN);
            csEvent.SetFrom(HySSysEvent.OBJID_SIMULATOR);
            csEvent.SetFromSimKind(McDefine.SIMULATOR_KIND);
            csEvent.SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
            csEvent.SetData(csDispKind);
            csEvent.SetSubEventNo(HySDispDefine.NOTICE_NO_SEARCH_CONDITION_SCREEN_LATEST);
            HySString csKeyCondition = new HySString(this.GetID().ToString() + "," + this.GetProjectName().ToString() + "," + csElementID.ToString());
            csEvent.SetSubData(csKeyCondition);
            m_csDotNetVeiewer.PutEvent(csEvent);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル画面クローズ要求</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ModelFormUserClose( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ModelFormUserClose()
        {
            ((McDotNetViewerJob)m_csVJob).MenuCallBack(McDefine.HYMCO_FILE_CLOSE, false);
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル管理画面シミュレーション関連操作</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ModelFormSimulationOperate(lCallBackNo)</para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ModelFormSimulationOperate(long lCallBackNo)
        {
            ((McDotNetViewerJob)m_csVJob).MenuCallBack(lCallBackNo, false);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト取り込み開始要求イベント送信</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> PutEventRequestProjectIncorporate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PutEventRequestProjectIncorporate()
        {
            // プロジェクト取り込み開始要求イベント生成 
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON);
            csEvent.SetSubEventNo(McDefine.HYMCO_MODEL_LOAD_PROJECT);
            csEvent.SetToSimKind(m_csKindID);
            csEvent.SetSuppID(new HySID(McDefine.PROJECTSCREEN_ID));
            this.PutEvent(csEvent);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面要求イベント送信（ライブラリ管理表示タブ変更）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> PutEventRequestLibraryTabChange(iTabNo) </para>
        /// </example>
        /// <param name="iTabNo">表示要求タブNo</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void PutEventRequestLibraryTabChange(int iTabNo)
        {
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
            if (iTabNo == 0)
            {// 表示要求タブNoが０の場合
                csEventObject.SetSubEventNo(McDefine.HYM_MODEL_LIBRARY_TAB1_CHANGE);
            }
            else if (iTabNo == 1)
            {// 表示要求タブNoが１の場合
                csEventObject.SetSubEventNo(McDefine.HYM_MODEL_LIBRARY_TAB2_CHANGE);
            }
            else if (iTabNo == 2)
            {// 表示要求タブNoが２の場合
                csEventObject.SetSubEventNo(McDefine.HYM_MODEL_LIBRARY_TAB3_CHANGE);
            }
            else if (iTabNo == 3)
            {// 表示要求タブNoが３の場合
                csEventObject.SetSubEventNo(McDefine.HYM_MODEL_LIBRARY_TAB4_CHANGE);
            }
            else
            {// 表示要求タブNoが上記以外の場合
                return;
            }
            HySID csID = new HySID(McDefine.LIBRARYSCREEN_ID);
            csEventObject.SetSuppID(csID);
            csEventObject.SetToSimKind(m_csKindID);
            this.PutEvent(csEventObject);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面要求イベント送信（ツリー要求）</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> PutEventRequestTreeReq( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void PutEventRequestTreeReq()
        {
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
            csEventObject.SetSubEventNo(McDefine.HYM_MODEL_LIBRARY_TREE_REQUEST);
            HySID csID = new HySID(McDefine.LIBRARYSCREEN_ID);
            csEventObject.SetSuppID(csID);
            csEventObject.SetToSimKind(m_csKindID);
            this.PutEvent(csEventObject);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>シミュレーション開始要求中解除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> RequestSimulationStartRequest( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void RequestSimulationStartRequest()
        {
            McSimulationStatus csSimulationStatus = (McSimulationStatus)m_csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
            m_csModelCtlForm.SetMask(csSimulationStatus.GetCalcStatus(), true);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックデータインスタンス取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GetCheckData( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McStructCheckData</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McStructCheckData GetCheckData()
        {
            McStructCheckData csStructCheckData = (McStructCheckData)m_csDataContainer.GetData(McDefine.HYM_DATA_CHECK_INFO);
            return csStructCheckData;
        }

        /// <summary><para>method outline:</para>
        /// <para>外部データベースツール起動状態取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetExtDBToolStatus();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:起動中 false:停止中</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetExtDBToolStatus()
        {
            bool bRtn = false;
            HySObjectKind csWork = GetSimKind() as HySObjectKind;
            if (csWork != null)
            {
                HySString csKey = (HySString)GetSimKind().GetString() + new HySString(McDefine.PROJECTSCREEN_ID);
                if (m_csVJob != null)
                {
                    McDotNetProjectCtlScreen csProjectScreen = (McDotNetProjectCtlScreen)((HySDotNetViewerJob)m_csVJob).GetScreen(csKey);
                    if (csProjectScreen != null)
                    {
                        bRtn = csProjectScreen.GetExtDBToolStatus();
                    }
                }
            }
            return bRtn;
        }

        // Ver1.5 追加（プロジェクトプロパティ画面）
        /// <summary>
        /// <para>method outline:</para>
        /// <para>データコンテナインスタンス取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>  HySSimulationDataContainer m_csDataContainer = GetDataContainer( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySSimulationDataContainer</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySSimulationDataContainer GetDataContainer()
        {
            return m_csDataContainer;
        }
    }
}
