﻿// <summary>ソースコード：ＨＹＭＣＯモデルプロパティスクリーン基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;


namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルプロパティスクリーン基底クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/01/05][新規作成]</para>
    /// </remarks>
    abstract public class McDotNetModelPropertyScreenBase : HySDotNetScreen, McModelPropertyScreen
    {
        /// <summary>画面配置デスクトップ座標X</summary>
        static protected readonly int DESKTOP_LOCATION_X = 0;
        /// <summary>画面配置デスクトップ座標Y</summary>
        static protected readonly int DESKTOP_LOCATION_Y = 310;
        /// <summary>モデルプロパティ画面幅</summary>
        static protected readonly int FORM_WIDTH_PROPERTY = 360;
        /// <summary>モデルプロパティ画面高さ調整値</summary>
        static protected readonly int FORM_HEIGHT_PROPERTY_ADJUSTED_VALUE = 428;

        /// <summary>要素データＩＤ</summary>
        protected HySID m_csElementID = null;
        /// <summary>要素名称</summary>
        protected HySString m_csElementName = null;
        /// <summary>モデルプロパティ情報</summary>
        protected McPropertyInfoRoot m_csModelPropertyInfo = null;
        /// <summary>モデル初期情報</summary>
        protected McPropertyInfoRoot m_csModelIntialInfo = null;

        /// <summary>プロパティフォーム</summary>
        protected HySDotNetForm m_csPropertyForm;

        /// <summary>モデル管理画面</summary>
        protected McDotNetModelCtlScreen m_csModelCtlScreen;

        //メッセージ定義
        /// <summary>メッセージタイトル『モデル管理機能』</summary>
		static protected readonly string MSGBOX_TITLE = McMessage.GetString("MC_MSG_TITLE_MODEL_MANAGEMENT");
        /// <summary>メッセージ『設定内容が変更されています。\n保存しますか？』</summary>
		static protected readonly string MSG_DATA_SET = McMessage.GetString("MC_MSG_QUESTION_CONFILM_DATA_SETUP");

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            m_csModelPropertyInfo = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル初期情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelInitialInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデル初期情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetModelInitialInfo(McPropertyInfoRoot csInfo)
        {
            m_csModelIntialInfo = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素データＩＤを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElementDataID(csID)</para>
        /// </example>
        /// <param name="csID">要素データＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetElementDataID(HySID csID)
        {
            m_csElementID = csID;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素名称を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElementName(csElementName)</para>
        /// </example>
        /// <param name="csElementName">要素名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetElementName(HySString csElementName)
        {
            m_csElementName = csElementName;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル管理画面設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetModelCtlScreen( csScreen ) </para>
        /// </example>
        /// <param name="csScreen">モデル管理画面</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetModelCtlScreen(HySScreen csScreen)
        {
            m_csModelCtlScreen = (McDotNetModelCtlScreen)csScreen;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面消去報告</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ClosedForm( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ClosedForm()
        {
            m_csModelCtlScreen.DeleteScreen((HySString)m_csElementID.GetString());
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面リフレッシュ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> RefreshmentForm( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void RefreshmentForm()
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面消去前処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> BeforeCloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:画面クローズ可　false:画面クローズ不可</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool BeforeCloseScreen()
        {
            return false;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ情報設定イベント送信要求</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ReqPropertyInfoSetEvent( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void ReqPropertyInfoSetEvent()
        {
            m_csModelCtlScreen.ReqPropertyInfoSetEvent(m_csElementID);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ情報設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> PropertyInfoSet(bSetMode) </para>
        /// </example>
        /// <param name="bSetMode">変更モード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void PropertyInfoSet(bool bSetMode)
        {
            m_csModelCtlScreen.PropertyInfoSet(m_csElementID, bSetMode);
        }

        /// <summary><para>method outline</para>
        /// <para>プロパティ設定画面表示要素情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataRoot csPropertyDispElement = GetPropertyDispElement()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataRoot プロパティ設定画面表示要素情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataRoot GetPropertyDispElement()
        {
            return m_csModelCtlScreen.GetPropertyDispElement((HySString)m_csElementID.GetString());
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            //画面サイズにあわせて表示
            System.Drawing.Point point = new System.Drawing.Point();
            point.X = 0;
            point.Y = 0;
            System.Drawing.Rectangle rect;
            rect = System.Windows.Forms.Screen.GetBounds(point);

            // 登録されたプロジェクト名称を取得し、表示する。
            // "パラメータ設定"
            m_csPropertyForm.Text = Properties.McDotNetViewerResources.FORM_TITLE_PARAMETER + m_csModelCtlScreen.GetProjectName().ToString() + ":" + m_csElementID.ToString();
            m_csPropertyForm.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
            m_csPropertyForm.SetDesktopLocation(DESKTOP_LOCATION_X, DESKTOP_LOCATION_Y);
            m_csPropertyForm.Width = FORM_WIDTH_PROPERTY;
            // 画面サイズからモデルフォームの高さを調整する。
            m_csPropertyForm.Height = rect.Height - FORM_HEIGHT_PROPERTY_ADJUSTED_VALUE;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            this.SetViewerJob(m_csDotNetVeiewer.GetViewerJob(McDefine.SIMULATOR_KIND.GetString()));
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            m_csPropertyForm.TopMost = false;
            m_csPropertyForm.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            m_csPropertyForm.ShowDialog();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            m_csPropertyForm.Close();
            ClosedForm();
            m_csPropertyForm.Dispose();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
            m_csPropertyForm.Hide();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面初期配置表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>InitiateScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            //画面サイズにあわせて表示
            System.Drawing.Point point = new System.Drawing.Point();
            point.X = 0;
            point.Y = 0;
            System.Drawing.Rectangle rect;
            rect = System.Windows.Forms.Screen.GetBounds(point);

            m_csPropertyForm.SetDesktopLocation(DESKTOP_LOCATION_X, DESKTOP_LOCATION_Y);
            m_csPropertyForm.Width = FORM_WIDTH_PROPERTY;
            // 画面サイズからモデルフォームの高さを調整する。
            m_csPropertyForm.Height = rect.Height - FORM_HEIGHT_PROPERTY_ADJUSTED_VALUE;
            m_csPropertyForm.WindowState = System.Windows.Forms.FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NormalizeScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NormalizeScreen()
        {
            m_csPropertyForm.WindowState = System.Windows.Forms.FormWindowState.Normal;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>アクティブ報告</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> NoticeActive( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeActive()
        {
            base.NoticeActive();

            if (this.IsActive() != true)
            {// 自身がアクティブではない場合
                // 自スクリーンのアクティブ化
                this.SetScreenStatus(true);

                // 自スクリーンの初期配置表示
                this.NormalizeScreen();
            }
            else
            {// 自身がアクティブの場合
                if (m_csPropertyForm.WindowState == System.Windows.Forms.FormWindowState.Minimized)
                {// 最小化されている場合
                    this.NormalizeScreen();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public override Boolean PutEvent(HySSysEvent csEvent)
        {
            ((HySEventObject)csEvent).SetToSimKind(McDefine.SIMULATOR_KIND);
            return m_csDotNetVeiewer.PutEvent(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面をアクティブ化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ActivateForm()
        {
            m_csPropertyForm.Activate();
        }


        // ===============================
        // 共通便利ツール
        // ===============================
        /// <summary><para>method outline:</para>
        /// <para>CommonMPデータホームディレクトリ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csDataHomeDirectory = GetDataHomeDirectory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  CommonMPデータホームディレクトリ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetDataHomeDirectory()
        {
            return HySEnvInf.GetDataHomeDirectory();
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループ名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csGrpName = GetProjectGroupName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  プロジェクトグループ名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetProjectGroupName()
        {
            string sPrjName = "";
            McPropertyInfo csMdlPrtpy = m_csModelPropertyInfo as McPropertyInfo;
            if (csMdlPrtpy != null)
            {
                bool bRtn = HySCommonInfoHash.GetCorrespond(McDefine.PROJECT_GROUP_NAME, csMdlPrtpy.GetOwnerProjectID(), ref sPrjName);
                if (bRtn == false)
                {
                    if (m_csModelCtlScreen != null)
                    {
                        bRtn = HySCommonInfoHash.GetCorrespond(McDefine.PROJECT_GROUP_NAME, m_csModelCtlScreen.GetProjectID().ToString(), ref sPrjName);
                    }
                }
            }
            return new HySString(sPrjName);
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループディレクトリ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csDirectory = GetProjectGroupDirectory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  プロジェクトグループディレクトリ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetProjectGroupDirectory()
        {
            return (HySEnvInf.GetDataHomeDirectory() + new HySString("\\") + this.GetProjectGroupName());
        }

        /*  本メソッドは画面にとっては不要
        /// <summary><para>method outline:</para>
        /// <para>計算の識別子（計算ロット）を取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csCalLot = GetCalculationLotName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  計算の識別子（計算ロット）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>同じプロジェクトで計算を繰り返す場合、前回の計算と今回の計算を区別するための識別子を取得する</para>
        /// </remarks>
        public virtual HySString GetCalculationLotName()
        {
            string sLotName = "";
            McPropertyInfo csMdlPrtpy = m_csModelPropertyInfo as McPropertyInfo;
            if (csMdlPrtpy != null)
            {
                HySCommonInfoHash.GetCorrespond(McDefine.CALCULATION_LOT_NAME, csMdlPrtpy.GetOwnerProjectID(), ref sLotName);
            }
            return new HySString(sLotName);
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>データホームを基準とした相対パスを取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetRelativePathBasedOnDataHome(csAbsolutePath, refcsRelativePath)</para>
        /// </example>
        /// <param name="csAbsolutePath">絶対パス</param>
        /// <param name="csRelativePath">相対パス</param>
        /// <returns>相対化不能の場合には　false を返す</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>与えられた絶対パス値を　CommonMPデータホームを基準とした相対パスに変換して取得する</para>
        /// </remarks>
        public virtual bool GetRelativePathBasedOnDataHome(HySString csAbsolutePath, ref HySString csRelativePath)
        {
            string sRelativePath = "";
            bool bRtn = HySCommonInfoHash.DirectoryPathExchange(
                this.GetDataHomeDirectory().ToString(),
                csAbsolutePath.ToString(),
                ref sRelativePath);
            csRelativePath.SetChar(sRelativePath);
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループディレクトリを基準とした相対パスを取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetRelativePathBasedOnProjectGroup(csAbsolutePath, refcsRelativePath)</para>
        /// </example>
        /// <param name="csAbsolutePath">絶対パス</param>
        /// <param name="csRelativePath">相対パス</param>
        /// <returns>相対化不能の場合には　false を返す</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>与えられた絶対パス値を　プロジェクトグループディレクトリを基準とした相対パスに変換して取得する</para>
        /// </remarks>
        public virtual bool GetRelativePathBasedOnProjectGroup(HySString csAbsolutePath, ref HySString csRelativePath)
        {
            string sRelativePath = "";
            bool bRtn = HySCommonInfoHash.DirectoryPathExchange(
                this.GetDataHomeDirectory().ToString() + "\\" + this.GetProjectGroupName().ToString(),
                csAbsolutePath.ToString(),
                ref sRelativePath);
            csRelativePath.SetChar(sRelativePath);
            return bRtn;
        }


        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報を取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInfo = GetPropertyInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot  モデルプロパティ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public McPropertyInfoRoot GetPropertyInfo()
        { return m_csModelPropertyInfo; }

        /// <summary><para>method outline:</para>
        /// <para>モデル初期情報を取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInfo = GetInitialInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot  モデル初期情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        public McPropertyInfoRoot GetInitialInfo()
        { return m_csModelIntialInfo; }

    }
}
