﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Viewer;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    public  class McDotNetMutualTranInfoPropertyScreen : McDotNetTranInfoCellPropertyScreen
    {

        /// <summary>逆方向(下→上)パラメータ情報</summary>
        protected McCellArrayTranInfoPropertyInfo m_csUpstreamPrpty = null;
        /// <summary>順方向（上→下）パラメータ情報</summary>
        protected McCellArrayTranInfoPropertyInfo m_csDownstreamPrpty = null;

        //------------------------------------------------
        /// <summary>パラメータ情報</summary>
        private McMutualTranInfoProperty m_csPropertyInfo = null;



        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetTranInfoCellPropertyScreen csScreen = new McDotNetTranInfoCellPropertyScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetMutualTranInfoPropertyScreen()
        {
        }


        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            base.SetModelPropertyInfo( csInfo);

            m_csPropertyInfo = csInfo as McMutualTranInfoProperty;
            if (m_csPropertyInfo != null)
            {
                (m_csDownstreamPrpty, m_csUpstreamPrpty) = m_csPropertyInfo.GetTranInfoProperty();
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            if (m_csPropertyInfo == null)
            {
                m_csPropertyInfo = m_csModelPropertyInfo as McMutualTranInfoProperty;
            }

            m_csPropertyForm = new McDotNetMutualTranforPropertyForm();
            m_csPropertyForm.SetScreen(this);
            if (m_csPropertyInfo != null)
            {
                McPropertyInfoRoot csInfo = m_csModelPropertyInfo;
                ((McDotNetMutualTranforPropertyForm)m_csPropertyForm).SetModelPropertyInfo(csInfo);
            }

            ((McDotNetMutualTranforPropertyForm)m_csPropertyForm).SetElementName(m_csElementName);
            ((McDotNetMutualTranforPropertyForm)m_csPropertyForm).SetModelPropertyInfo(m_csCellTranInfoProperty);
            ((McDotNetMutualTranforPropertyForm)m_csPropertyForm).SetUpperElmPropertyInfo(m_csUpperElmPropertyInf);
            ((McDotNetMutualTranforPropertyForm)m_csPropertyForm).SetUpperElmSendTranDataPatternList(m_csUpperElmSendTranDataPatternList);
            ((McDotNetMutualTranforPropertyForm)m_csPropertyForm).SetLowerElmPropertyInfo(m_csLowerElmPropertyInf);
            ((McDotNetMutualTranforPropertyForm)m_csPropertyForm).SetLowerElmReceiveTranDataPatternList(m_csLowerElmReceiveTranDataPatternList);           
            ((McDotNetMutualTranforPropertyForm)m_csPropertyForm).EditParameter();

            // --------------
            System.Drawing.Point point = new System.Drawing.Point();
            point.X = 0;
            point.Y = 0;
            System.Drawing.Rectangle rect;
            rect = System.Windows.Forms.Screen.GetBounds(point);

            // 登録されたプロジェクト名称を取得し、表示する。
            // "パラメータ設定"
            m_csPropertyForm.Text = Properties.McDotNetViewerResources.FORM_TITLE_PARAMETER + m_csModelCtlScreen.GetProjectName().ToString() + ":" + m_csElementID.ToString();
            m_csPropertyForm.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
            m_csPropertyForm.SetDesktopLocation(DESKTOP_LOCATION_X, DESKTOP_LOCATION_Y);
            m_csPropertyForm.Width = FORM_WIDTH_PROPERTY;
            // 画面サイズからモデルフォームの高さを調整する。
            m_csPropertyForm.Height = rect.Height - FORM_HEIGHT_PROPERTY_ADJUSTED_VALUE;
            if (m_csPropertyForm.Height > 380) { m_csPropertyForm.Height = 380; }

            // --------------

            //base.Initialize();
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            m_csPropertyForm.TopMost = false;
            m_csPropertyForm.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            //m_csPropertyForm.ShowDialog();
            m_csPropertyForm.ShowDialog();
            if (m_bJunctureModelPropertyDispReq == true)
            {// 連接モデルプロパティ表示要求がある場合
                m_csModelCtlScreen.ShowModelPropertyScreen(m_csJunctureElementID);
            }
        }


        public virtual bool SetUpstreamProperty( )
        {
            McGraphicsElement csElm = (McGraphicsElement)((McDotNetModelPropertyScreenBase)this).GetPropertyDispElement();
           // (McGraphicsElement)((McDotNetModelPropertyScreenBase)m_csScreen).GetPropertyDispElement();

            McDotNetTranInfoCellPropertyScreen csScreen = new McDotNetTranInfoCellPropertyScreen();
            //csScreen.setG

            // スクリーン生成正常／画面表示実行
            csScreen.SetElementDataID(this.m_csElementID); //   m_csUpstreamPrpty.GetID() );
            csScreen.SetElementName(m_csElementName + " : 逆(上 ← 下)方向");
            csScreen.SetModelPropertyInfo(m_csUpstreamPrpty);
//            csScreen.SetModelInitialInfo(csElement.GetModelInfo().GetInitialInfo());

            csScreen.SetModelCtlScreen(this.m_csModelCtlScreen);
            csScreen.Initialize();
            csScreen.SetViewer(m_csDotNetVeiewer);
            csScreen.ShowScreen();

            m_csUpstreamPrpty = csScreen.GetPropertyInfo().Clone() as McCellArrayTranInfoPropertyInfo;
            m_csPropertyInfo.SetTranInfoProperty(m_csDownstreamPrpty, m_csUpstreamPrpty);
            return false;
        }

        public virtual bool SetDownstreamProperty()
        {
            McDotNetTranInfoCellPropertyScreen csScreen = new McDotNetTranInfoCellPropertyScreen();

            // スクリーン生成正常／画面表示実行
            csScreen.SetElementDataID(this.m_csElementID); //    m_csDownstreamPrpty.GetID() );
            csScreen.SetElementName(m_csElementName + " : 順(上 → 下)方向");
            csScreen.SetModelPropertyInfo(m_csDownstreamPrpty);
//            csScreen.SetModelInitialInfo(csElement.GetModelInfo().GetInitialInfo());

            csScreen.SetModelCtlScreen(this.m_csModelCtlScreen);
            csScreen.Initialize();
            csScreen.SetViewer(m_csDotNetVeiewer);
            csScreen.ShowScreen();

            m_csDownstreamPrpty = csScreen.GetPropertyInfo().Clone() as McCellArrayTranInfoPropertyInfo;
            m_csPropertyInfo.SetTranInfoProperty(m_csDownstreamPrpty, m_csUpstreamPrpty);
            return false;
        }


    }   // end of class
}
