﻿// <summary>ソースコード：Ｃｅｌｌ型伝送データプロパティスクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Viewer;

using CommonMP.HYMCO.CoreImpl.Data;


namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>Ｃｅｌｌ型伝送データプロパティスクリーンクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/01/05][新規作成]</para>
    /// </remarks>
    public class McDotNetTranInfoCellPropertyScreen : McDotNetModelPropertyScreenBase
    {
        /// <summary> セル型伝送データのプロパティ情報 </summary>
        protected McCellArrayTranInfoPropertyInfo m_csCellTranInfoProperty = null;
        /// <summary>上流要素モデルプロパティ情報 </summary>
        protected McCellModelPropertyInfo m_csUpperElmPropertyInf = null;
        /// <summary>上流要素の送信情報パターンリスト</summary>
        protected HySDataLinkedList m_csUpperElmSendTranDataPatternList = null;

        /// <summary>下流要素モデルプロパティ情報</summary>
        protected McCellModelPropertyInfo m_csLowerElmPropertyInf = null;
        /// <summary>下流要素の期待受信情報パターンリスト </summary>
        protected HySDataLinkedList m_csLowerElmReceiveTranDataPatternList = null;

        /// <summary> 連接モデルプロパティ表示要求 </summary>
        protected bool m_bJunctureModelPropertyDispReq = false;

        /// <summary> 連接要素ID </summary>
        protected HySIdentifier m_csJunctureElementID = null;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetTranInfoCellPropertyScreen csScreen = new McDotNetTranInfoCellPropertyScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetTranInfoCellPropertyScreen()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetModelPropertyInfo(McPropertyInfoRoot csInfo)
        {
            base.SetModelPropertyInfo(csInfo);
            m_csCellTranInfoProperty = csInfo as McCellArrayTranInfoPropertyInfo;
            if (m_csCellTranInfoProperty != null)
            {// プロパティ情報がある場合
                m_csUpperElmPropertyInf = m_csCellTranInfoProperty.GetUpperModelProperty() as McCellModelPropertyInfo;
                if (m_csUpperElmPropertyInf != null)
                {// 上流要素モデルプロパティ情報がある場合
                    m_csUpperElmSendTranDataPatternList = m_csUpperElmPropertyInf.GetSendPatternList();
                }
                m_csLowerElmPropertyInf = m_csCellTranInfoProperty.GetLowerModelProperty() as McCellModelPropertyInfo;
                if (m_csLowerElmPropertyInf != null)
                {// 下流要素モデルプロパティ情報がある場合
                    m_csLowerElmReceiveTranDataPatternList = m_csLowerElmPropertyInf.GetReceivePatternList();
                }
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面リフレッシュ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> RefreshmentForm( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void RefreshmentForm()
        {
            if (m_csCellTranInfoProperty != null)
            {// プロパティ情報がある場合
                m_csUpperElmPropertyInf = m_csCellTranInfoProperty.GetUpperModelProperty() as McCellModelPropertyInfo;
                m_csUpperElmSendTranDataPatternList = null;
                if (m_csUpperElmPropertyInf != null)
                {// 上流要素モデルプロパティ情報がある場合
                    m_csUpperElmSendTranDataPatternList = m_csUpperElmPropertyInf.GetSendPatternList();
                }
                m_csLowerElmPropertyInf = m_csCellTranInfoProperty.GetLowerModelProperty() as McCellModelPropertyInfo;
                m_csLowerElmReceiveTranDataPatternList = null;
                if (m_csLowerElmPropertyInf != null)
                {// 下流要素モデルプロパティ情報がある場合
                    m_csLowerElmReceiveTranDataPatternList = m_csLowerElmPropertyInf.GetReceivePatternList();
                }
            }

            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).SetElementName(m_csElementName);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).SetModelPropertyInfo(m_csCellTranInfoProperty);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).SetUpperElmPropertyInfo(m_csUpperElmPropertyInf);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).SetUpperElmSendTranDataPatternList(m_csUpperElmSendTranDataPatternList);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).SetLowerElmPropertyInfo(m_csLowerElmPropertyInf);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).SetLowerElmReceiveTranDataPatternList(m_csLowerElmReceiveTranDataPatternList);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).EditParameter();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面消去前処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> BeforeCloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:画面クローズ可　false:画面クローズ不可</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool BeforeCloseScreen()
        {
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            if (((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).ParaSet_Check() == true)
            {// 設定値に異常がある場合
                m_csPropertyForm.Activate();

                return false;
            }

            if (((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).ParaModify_Check(false, ref bChangeFlg1, ref bChangeFlg2) == true)
            {// 変更がある場合
                m_csPropertyForm.Activate();

                // 変更情報登録確認
                DialogResult result = MessageBox.Show(MSG_DATA_SET, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (result == DialogResult.Yes)
                {// 登録選択の場合
                    // 登録
                    ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

                    if (bChangeFlg2 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        PropertyInfoSet(true);
                    }
                    else if (bChangeFlg1 == true)
                    {// 変更がある場合
                        // プロパティ情報設定
                        PropertyInfoSet(false);
                    }
                }
            }

            return true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csPropertyForm = new McDotNetTranInfoCellPropertyForm();
            m_csPropertyForm.SetScreen(this);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).SetElementName(m_csElementName);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).SetModelPropertyInfo(m_csCellTranInfoProperty);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).SetUpperElmPropertyInfo(m_csUpperElmPropertyInf);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).SetUpperElmSendTranDataPatternList(m_csUpperElmSendTranDataPatternList);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).SetLowerElmPropertyInfo(m_csLowerElmPropertyInf);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).SetLowerElmReceiveTranDataPatternList(m_csLowerElmReceiveTranDataPatternList);
            ((McDotNetTranInfoCellPropertyForm)m_csPropertyForm).EditParameter();

            // --------------
            System.Drawing.Point point = new System.Drawing.Point();
            point.X = 0;
            point.Y = 0;
            System.Drawing.Rectangle rect;
            rect = System.Windows.Forms.Screen.GetBounds(point);

            // 登録されたプロジェクト名称を取得し、表示する。
            // "パラメータ設定"
            m_csPropertyForm.Text = Properties.McDotNetViewerResources.FORM_TITLE_PARAMETER + m_csModelCtlScreen.GetProjectName().ToString() + ":" + m_csElementID.ToString();
            m_csPropertyForm.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
            m_csPropertyForm.SetDesktopLocation(DESKTOP_LOCATION_X, DESKTOP_LOCATION_Y);
            m_csPropertyForm.Width = FORM_WIDTH_PROPERTY;
            // 画面サイズからモデルフォームの高さを調整する。
            m_csPropertyForm.Height = rect.Height - FORM_HEIGHT_PROPERTY_ADJUSTED_VALUE;
            if (m_csPropertyForm.Height > 380) { m_csPropertyForm.Height = 380; }

            // --------------

            //base.Initialize();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;

            return bRtn;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>連接モデルプロパティ表示要求</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> JunctureModelPropertyDispReq(csElement) </para>
        /// </example>
        /// <param name="csElement">プロパティ表示要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void JunctureModelPropertyDispReq(McGraphicsElement csElement)
        {
            m_csJunctureElementID = csElement.GetID();
            m_bJunctureModelPropertyDispReq = true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            m_csPropertyForm.TopMost = false;
            m_csPropertyForm.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            m_csPropertyForm.ShowDialog();

            if (m_bJunctureModelPropertyDispReq == true)
            {// 連接モデルプロパティ表示要求がある場合
                m_csModelCtlScreen.ShowModelPropertyScreen(m_csJunctureElementID);
            }
        }
    }
}
