﻿// <summary>ソースコード：ＨＹＭＣＯ伝送データプロパティスクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Viewer;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>ＨＹＭＣＯ伝送データプロパティスクリーンクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/01/05][新規作成]</para>
    /// </remarks>
    public class McDotNetTranInfoPropertyScreen : McDotNetModelPropertyScreenBase
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetTranInfoPropertyScreen csScreen = new McDotNetTranInfoPropertyScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetTranInfoPropertyScreen()
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面リフレッシュ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> RefreshmentForm( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void RefreshmentForm()
        {
            ((McDotNetTranInfoPropertyForm)m_csPropertyForm).SetElementName(m_csElementName);
            ((McDotNetTranInfoPropertyForm)m_csPropertyForm).EditParameter();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面消去前処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> BeforeCloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:画面クローズ可　false:画面クローズ不可</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool BeforeCloseScreen()
        {
            bool bChangeFlg1 = false;
            bool bChangeFlg2 = false;

            if (((McDotNetTranInfoPropertyForm)m_csPropertyForm).ParaSet_Check() == true)
            {// 設定値に異常がある場合
                m_csPropertyForm.Activate();

                return false;
            }

            if (((McDotNetTranInfoPropertyForm)m_csPropertyForm).ParaModify_Check(false, ref bChangeFlg1, ref bChangeFlg2) == true)
            {// 変更がある場合
                m_csPropertyForm.Activate();

                // 変更情報登録確認
                DialogResult result = MessageBox.Show(MSG_DATA_SET, MSGBOX_TITLE, MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (result == DialogResult.Yes)
                {// 登録選択の場合
                    // 登録
                    ((McDotNetTranInfoPropertyForm)m_csPropertyForm).ParaModify_Check(true, ref bChangeFlg1, ref bChangeFlg2);

                    if (bChangeFlg1 == true)
                    {// 変更がある場合
                        // プロパティ情報設定イベント送信要求
                        ReqPropertyInfoSetEvent();
                    }
                }
            }

            return true;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csPropertyForm = new McDotNetTranInfoPropertyForm();
            m_csPropertyForm.SetScreen(this);
            ((McDotNetTranInfoPropertyForm)m_csPropertyForm).SetElementName(m_csElementName);
            ((McDotNetTranInfoPropertyForm)m_csPropertyForm).SetModelPropertyInfo(m_csModelPropertyInfo);
            ((McDotNetTranInfoPropertyForm)m_csPropertyForm).SetModelInitialInfo(m_csModelIntialInfo);
            ((McDotNetTranInfoPropertyForm)m_csPropertyForm).EditParameter();

            base.Initialize();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;

            return bRtn;
        }
    }
}
