﻿// <summary>ソースコード：ＨＹＭＣＯプロジェクト管理画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.OptionImpl.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>プロジェクト管理画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McDotNetProjectCtlScreen : HySDotNetScreen
    {
        /// <summary>プロジェクト管理フォーム</summary>
        private McDotNetProjectCtlForm m_csProjectCtlForm;

        /// <summary>カレント個別プロジェクト検索結果応答イベント</summary>
        private long m_csPrjQueryResponceEvent = HySEventObject.CMND_NEW_SIMULATOR_CREATE;

        // 定数定義
        /// <summary>プロジェクト管理画面デフォルト幅</summary>
        static private readonly int DEFAULT_WIDTH = 360;

        /// <summary>プロジェクト管理画面デフォルト高さ</summary>
        static private readonly int DEFAULT_HEIGHT = 310;

        /// <summary>ログ出力用クラス名称</summary>
        static private readonly string LOG_CLASS_NAME = "McDotNetProjectCtlScreen";

        /// <summary>画面配置デスクトップ座標X</summary>
        static private int DESKTOP_LOCATION_X = 0;

        /// <summary>画面配置デスクトップ座標X調整値</summary>
        static private readonly int DESKTOP_LOCATION_X_ADJUSTED_VALUE = 8;

        /// <summary>画面配置デスクトップ座標Y調整値</summary>
        static private readonly int DESKTOP_LOCATION_Y_ADJUSTED_VALUE = 56;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetProjectCtlScreen csScreen = new McDotNetProjectCtlScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetProjectCtlScreen 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetProjectCtlScreen()
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csProjectCtlForm = new McDotNetProjectCtlForm(this);
            m_csProjectCtlForm.Text = Properties.McDotNetViewerResources.FORM_TITLE_PROJECT_CONTROL;    //"プロジェクト管理"
            m_csProjectCtlForm.Width = DEFAULT_WIDTH;
            m_csProjectCtlForm.Height = DEFAULT_HEIGHT;
            m_csProjectCtlForm.StartPosition = FormStartPosition.Manual;
            //m_csProjectCtlForm.SetDesktopLocation(0, 0);
            // 右端に表示
            Size desktopSize = System.Windows.Forms.SystemInformation.WorkingArea.Size;
            DESKTOP_LOCATION_X = desktopSize.Width - m_csProjectCtlForm.Size.Width;
            m_csProjectCtlForm.SetDesktopLocation(DESKTOP_LOCATION_X - DESKTOP_LOCATION_X_ADJUSTED_VALUE, DESKTOP_LOCATION_Y_ADJUSTED_VALUE);
            // 常に最前面表示
            m_csProjectCtlForm.BringToFront();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            this.SetViewerJob(m_csDotNetVeiewer.GetViewerJob(McDefine.SIMULATOR_KIND.GetString()));
            // 常に最前面表示
            m_csProjectCtlForm.Owner = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();
            //m_csProjectCtlForm.MdiParent = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            m_csProjectCtlForm.Show();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            m_csProjectCtlForm.Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面初期配置表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            m_csProjectCtlForm.Width = DEFAULT_WIDTH;
            m_csProjectCtlForm.Height = DEFAULT_HEIGHT;
            m_csProjectCtlForm.StartPosition = FormStartPosition.Manual;
            //m_csProjectCtlForm.SetDesktopLocation(0, 0);
            // 右端に表示
            m_csProjectCtlForm.SetDesktopLocation(DESKTOP_LOCATION_X - DESKTOP_LOCATION_X_ADJUSTED_VALUE, DESKTOP_LOCATION_Y_ADJUSTED_VALUE);
            m_csProjectCtlForm.WindowState = FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NormalizeScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NormalizeScreen()
        {
            m_csProjectCtlForm.WindowState = FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面をアクティブ化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ActivateForm()
        {
            m_csProjectCtlForm.Activate();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override bool EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            long lEventNo = ((HySEventObject)csEvent).GetEventNo();
            long lSubEventNo = ((HySEventObject)csEvent).GetSubEventNo();

            // 画面関連一般報告(個別)
            if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {
                // メニュー：新規作成
                if (lSubEventNo == McDefine.HYMCO_FILE_NEW)
                {
                    // プロジェクト新規作成画面の表示
                    m_csProjectCtlForm.ShowNewProjectForm();        
                    bRtn = true;
                }
// Ver1.1 追加 >>>
                // メニュー：新規作成(ファイル形式用)
                if (lSubEventNo == McDefine.HYMCO_PROJECT_NEW)
                {
                    // プロジェクト新規作成画面の表示
                    m_csProjectCtlForm.ShowNewProjectFileForm();
                    bRtn = true;
                }
// Ver1.1 追加 <<<
                // メニュー：プロジェクト取り込み
                else if (lSubEventNo == McDefine.HYMCO_MODEL_LOAD_PROJECT)
                {
                    // 個別プロジェクト検索結果応答イベントを「プロジェクト取り込み」に設定
                    SetQueryResponceEvent(McDefine.HYM_INCORPORATE_PROJECT);
                    // プロジェクト検索画面の表示
// Ver1.1 変更 >>>
                    //DBからの取込み用
                    //m_csProjectCtlForm.ShowProjectSearchForm();
                    //ファイルからの取込み用
                    m_csProjectCtlForm.OpenProject();
// Ver1.1 変更 <<<
                    bRtn = true;
                }
            }
            // 画面関連一般指示(全体)
            else if (lEventNo == HySEventObject.CMND_BROADCAST_SCREEN)
            {
                HySID csID = ((HySEventObject)csEvent).GetSuppID();
                HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();
                HySString csPrcID = (HySString)csID.GetString();
                HySString csPrcKind = (HySString)csSimKind.GetString();
                HySString csPrcKey = csPrcKind + csPrcID;
                // プロジェクト情報の追加指示
                if (lSubEventNo == McDefine.HYM_APPEND_PROJECTINF ||
                    lSubEventNo == McDefine.HYM_APPEND_EMPTY_PROJECTINF)
                {
                    bRtn = m_csProjectCtlForm.AppendProjectInf((HySEventObject)csEvent);
                }
                // モデル管理画面アクティブ変更通知
                else if (lSubEventNo == McDefine.HYM_ACTIVE_PROJECT_NAME_SETUP_INFORMATION)
                {
                    HySString csStatus = m_csProjectCtlForm.GetStatus();
                    // 計算中はアクティブ切り替えを無視する
                    //if (csStatus != McDotNetProjectCtlForm.SIMULATION_RUN)
                    //{
                        // 表示更新チェック
                        if (m_csProjectCtlForm.CheckUpdate(csPrcKey) == true)
                        {
                            // 計算パラメータの保存
                            m_csProjectCtlForm.SaveSimulationParameter();
                            // 表示更新
                            m_csProjectCtlForm.ShowUpdate(csPrcKey);
                        }
                    //}
                    bRtn = true;
                }
                // モデル管理画面クローズ通知
                else if (lSubEventNo == McDefine.HYM_CLOSED_PROJECT_NAME_SETUP_INFORMATION)
                {
                    if (m_csProjectCtlForm.DeleteProject(csPrcKey) == true)
                    {
                        ((HySDotNetViewerJob)m_csVJob).DeleteScreen(csPrcKey); // Screen識別管理テーブルからの削除処理
                        GC.Collect(); // 強制　ガベージコレクション
                        // 表示用プロジェクト名管理から削除
                        McViewerInfoManager.RemoveDispProjectName(csID);
                        bRtn = true;
                    }
                }
                // シミュレーション状態保持クラス変更通知
                else if (lSubEventNo == McDefine.HYM_SIMULATION_STATUS_MODIFY_INFORMATION)
                {
                    if(this.IsActiveProject(csID)) 
                    {   // アクティブプロジェクトの場合
                        // 計算コントロールタブステータス更新
                        m_csProjectCtlForm.UpdateSimulationTabStatus();
                    }
                    bRtn = true;
                }
            }
            // シミュレーション計算関連報告
            else if (lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION ||
                      lEventNo == HySEventObject.NOTICE_START_SIMULATION ||
                      lEventNo == HySEventObject.NOTICE_CANNOT_START_SIMULATION ||
                      lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION ||
                      lEventNo == HySEventObject.NOTICE_STOP_SIMULATION ||
                      lEventNo == HySEventObject.NOTICE_REPORT_SIMU_PROGRESS ||
                      lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION ||
                      lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND ||
                      lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION ||
                      lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION )
            {
                // フォームのコールバック処理をコール
                bRtn = m_csProjectCtlForm.CallBackSimulationNotice((HySEventObject)csEvent);
            }
            // DB関連一般報告(正常)  
            else if (lEventNo == HySEventObject.NOTICE_DB_OK)
            {
                // 検索結果(個別プロジェクト)
                if (lSubEventNo == HySLibraryMngDefine.DB_QUERY_DATA)
                {
                    // 個別プロジェクト検索結果応答イベントの送信
                    bRtn = QueryProjectResponceEvent(csEvent);
                }
                // 検索結果(プロジェクトリスト)
                else if (lSubEventNo == HySLibraryMngDefine.DB_QUERY_DATA_LIST)
                {
                    // 検索結果一覧表示画面の表示
                    m_csProjectCtlForm.ShowProjectSearchResultForm((HySStockDataList)(((HySEventObject)csEvent).GetData()));
                    bRtn = true;
                }
                else if(lSubEventNo == McDefine.HYM_DB_REGISTER ||
                        lSubEventNo == McDefine.HYMCO_PROJECT_SAVE ||
                        lSubEventNo == McDefine.HYMCO_PROJECT_SAVE_NEW)     // Ver1.1 変更
                {
                    // 登録後は保存済みとする。
                    McSimulationStatus csStatus = ((McDotNetModelCtlScreen)((McDotNetViewerJob)m_csVJob).GetActiveScreen()).GetSimulationStatusData();
                    csStatus.SetModelSaveStatus(McSimulationStatus.ModelSaveStatus.SAVED);
                    // フォームのコールバック処理をコール
                    bRtn = m_csProjectCtlForm.CallBackDBNotice((HySEventObject)csEvent);
                }
                // プロジェクト インポート
                else if(lSubEventNo == McDefine.HYM_PRJDATA_IMPORT)
                {
                    m_csProjectCtlForm.NoticeProjectImport((HySEventObject)csEvent);
                }
                else
                {
                    // フォームのコールバック処理をコール
                    bRtn =m_csProjectCtlForm.CallBackDBNotice((HySEventObject)csEvent);                   
                }
            }
            // DB関連一般報告(異常) 
            else if(lEventNo == HySEventObject.NOTICE_DB_NG)
            {
                // プロジェクト インポート
                if (lSubEventNo == McDefine.HYM_PRJDATA_IMPORT)
                {
                    m_csProjectCtlForm.NoticeProjectImport((HySEventObject)csEvent);
                }
                else
                {
                    // フォームのコールバック処理をコール
                    bRtn = m_csProjectCtlForm.CallBackDBError((HySEventObject)csEvent);
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_RUN_COMPLETE ||
                      lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_EXIT_COMPLETE)
            {
                // バックグラウンド操作化
                if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_RUN_COMPLETE)
                {
                    m_csProjectCtlForm.ChangeSimulationTabStatus(false);
                }
                else if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_EXIT_COMPLETE)
                {
                    if (((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).IsDBToolRun() == false)
                    {
                        m_csProjectCtlForm.ChangeSimulationTabStatus(true);
                    }
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_RUN_COMPLETE ||
                      lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_EXIT_COMPLETE)
            {
                // バックグラウンド操作化
                if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_RUN_COMPLETE)
                {
                    m_csProjectCtlForm.ChangeSimulationTabStatus(false);
                }
                else if (lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_EXIT_COMPLETE)
                {
                    if (((HySDotNetMainForm)((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm()).IsDBToolRun() == false)
                    {
                        m_csProjectCtlForm.ChangeSimulationTabStatus(true);
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>個別プロジェクト検索結果応答イベント送信</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = QueryProjectResponcePutEvent(csEvent); </para>
        /// </example>
        /// <param name="csEvent">イベントオブジェクト</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean QueryProjectResponceEvent(HySSysEvent csEvent)
        {
            string strErrMsg;
            Boolean bRtn = true;
            HySEventObject csEventObj;
            // 現在の応答イベントがプロジェクトオープン
            if (m_csPrjQueryResponceEvent == HySEventObject.CMND_NEW_SIMULATOR_CREATE)
            {
                csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_NEW_SIMULATOR_CREATE);
                csEventObj.SetSubEventNo(((HySEventObject)csEvent).GetSubEventNo());
               // ver1.5 エラートレース日本語対応
                strErrMsg = Properties.McDotNetViewerResources.STATEMENT_SIM_CREATE_ERR;
               // strErrMsg = "PutEvent CMND_NEW_SIMULATOR_CREATE is failed.";
            }
            // 現在の応答イベントがプロジェクト取り込み
            else
            {
                csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISPLY_COMMON);
                csEventObj.SetSubEventNo(McDefine.HYM_INCORPORATE_PROJECT);
                // アクティブプロジェクトのIDを設定
                csEventObj.SetSuppID(((McDotNetViewerJob)m_csVJob).GetActiveProject());
               // ver1.5 エラートレース日本語対応
                strErrMsg = Properties.McDotNetViewerResources.STATEMENT_CMND_DISP_INCORP_ERR;
               // strErrMsg = "PutEvent CMND_DISPLY_COMMON(HYM_INCORPORATE_PROJECT) is failed.";
            }

            // 検索結果イベントオブジェクトからデータを取り出す
            csEventObj.SetData(((HySStockData)((HySEventObject)csEvent).GetData()).GetData());

            // イベント送信
            if (false == this.PutEvent(csEventObj))
            {
                HySLog.LogOut(HySLog.ONLINE, LOG_CLASS_NAME, "QueryProjectResponceEvent", strErrMsg);
                bRtn = false;
            }
            // 応答イベントをデフォルト(プロジェクトオープン)に設定
            SetQueryResponceEvent(HySEventObject.CMND_NEW_SIMULATOR_CREATE);
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        override public Boolean PutEvent(HySSysEvent csEvent)
        {
            ((HySEventObject)csEvent).SetToSimKind(McDefine.SIMULATOR_KIND);
            return m_csDotNetVeiewer.PutEvent(csEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>MenuCallBack(lCallBackNumber)</para>
        /// </example>
        /// <param name="lCallBackNumber">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void MenuCallBack(long lCallBackNumber)
        {
            HySString csStatus = m_csProjectCtlForm.GetStatus();

            // 計算開始
            if (lCallBackNumber == McDefine.HYMCO_PROJECT_CALC_START)
            {
                // 未計算,中断,計算終了時のみ可能
                if (csStatus.Equal(McDotNetProjectCtlForm.SIMULATION_NOT_RUN) ||
                   csStatus.Equal(McDotNetProjectCtlForm.SIMULATION_SUSPEND) ||
                   csStatus.Equal(McDotNetProjectCtlForm.SIMULATION_FINISH))
                {
                    //m_csProjectCtlForm.SimulationRunOrder();
                    if (m_csProjectCtlForm.SimulationRunOrder() == false)
                    {
                        ((McDotNetModelCtlScreen)((McDotNetViewerJob)m_csVJob).GetActiveScreen()).RequestSimulationStartRequest();
                    }
                }
            }
            // 計算中断
            else if (lCallBackNumber == McDefine.HYMCO_PROJECT_CALC_PAUSE)
            {
                // 計算中のみ可能
                if (csStatus.Equal(McDotNetProjectCtlForm.SIMULATION_RUN))
                {
                    m_csProjectCtlForm.SimulationSuspendOrder();
                }
            }
            // 計算終了
            else if (lCallBackNumber == McDefine.HYMCO_PROJECT_CALC_STOP)
            {
                // 計算中,中断時のみ可能
                if (csStatus.Equal(McDotNetProjectCtlForm.SIMULATION_RUN) ||
                   csStatus.Equal(McDotNetProjectCtlForm.SIMULATION_SUSPEND))
                {
                    m_csProjectCtlForm.SimulationStopOrder();
                }
            }
            // 計算リセット
            else if (lCallBackNumber == McDefine.HYMCO_PROJECT_CALC_RESET)
            {
                // 計算終了,中断時のみ可能
                if (csStatus.Equal(McDotNetProjectCtlForm.SIMULATION_FINISH) ||
                   csStatus.Equal(McDotNetProjectCtlForm.SIMULATION_SUSPEND))
                {
                    m_csProjectCtlForm.SimulationResetOrder();
                }
            }
            // 検索
            else if (lCallBackNumber == McDefine.HYMCO_DB_SEARCH)
            {
                // 検索結果応答を「プロジェクトオープン」に設定
                SetQueryResponceEvent(HySEventObject.CMND_NEW_SIMULATOR_CREATE);

                m_csProjectCtlForm.ShowProjectSearchForm();
            }
            // 登録
            else if (lCallBackNumber == McDefine.HYMCO_DB_REGIST)
            {
                m_csProjectCtlForm.ShowProjectRegistForm();
            }
            // インポート
            else if (lCallBackNumber == McDefine.HYMCO_DB_IMPORT)
            {
                m_csProjectCtlForm.ShowProgressForm(McDefine.HYMCO_DB_IMPORT);
            }
// Ver1.1 追加 >>>
            // 開く
            else if (lCallBackNumber == McDefine.HYMCO_PROJECT_OPEN)
            {
                // 検索結果応答を「プロジェクトオープン」に設定
                SetQueryResponceEvent(HySEventObject.CMND_NEW_SIMULATOR_CREATE);

                m_csProjectCtlForm.OpenProject();
            }
            // 名前を付けて保存
            else if (lCallBackNumber == McDefine.HYMCO_PROJECT_SAVE_NEW)
            {
                m_csProjectCtlForm.ShowProjectSaveForm();
            }
// Ver1.1 追加　<<<
        }

        /// <summary><para>method outline:</para>
        /// <para>個別プロジェクト検索結果応答イベント設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetQueryResponceEvent(lEventNo); </para>
        /// </example>
        /// <param name="lEventNo">イベント番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetQueryResponceEvent(long lEventNo)
        {
            m_csPrjQueryResponceEvent = lEventNo;
        }

        /// <summary><para>method outline:</para>
        /// <para>アクティブプロジェクトであるかを判定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool isActiveProject = IsActiveProject( csID ) </para>
        /// </example>
        /// <param name="csID">プロジェクト識別子</param>
        /// <returns>true:=アクティブプロジェクト, false:=非アクティブプロジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool IsActiveProject(HySID csID)
        {
            HySID actID = ((McDotNetViewerJob)m_csVJob).GetActiveProject();
            return actID != null && csID.Equals(actID);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト取り込みシーケンス中であるかを判定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool isIncorporateProject = IsIncorporateProject( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:=プロジェクト取り込みシーケンス中, false:=非プロジェクト取り込み</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool IsIncorporateProject()
        {
            if (m_csPrjQueryResponceEvent == McDefine.HYM_INCORPORATE_PROJECT)
            {
                return true;
            }

            return false;
        }

        /// <summary><para>method outline:</para>
        /// <para>管理プロジェクト名称チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = IsManageProject(sDispProjectName);</para>
        /// </example>
        /// <param name="sDispProjectName">表示プロジェクト名称</param>
        /// <returns>=true:有り、=false:無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデル管理されたプロジェクト名かチェックする</para>
        /// </remarks>
        public bool IsManageProject(string sDispProjectName)
        {
            return m_csProjectCtlForm.IsManageProject(sDispProjectName);
        }

        /// <summary><para>method outline:</para>
        /// <para>外部データベースツール起動状態取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetExtDBToolStatus();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:起動中 false:停止中</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetExtDBToolStatus()
        {
            return m_csProjectCtlForm.GetExtDBToolStatus();
        }
    }
}
