// <summary>ソースコード：シミュレーター使用関連情報生成制御スクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.OptionImpl.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;    

using CommonMP.HYSSOP.Interface.HSViewer.HSScreens;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>シミュレーター使用情報生成制御スクリーンクラスＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/01][新規作成]</para>
    /// </remarks>
    public class McDotNetModelGenerateCtlScreen : HySDotNetScreen, HySSimDataGenerateCtlScreen
    {
        /// <summary>シミュレーター使用情報生成制御フォーム</summary>
        private McDotNetModelGenerateCtlForm m_csModelGenerateCtlForm;
        
        /// <summary>モデルデータジェネレーション用情報クラス</summary>
        protected McModelDataGenerationInfo m_csMDGInfo=new McModelDataGenerationInfo();

        /// <summary>情報格納用ファイル表示ラベル管理テーブル</summary>
        protected HySDataHashTable m_csParameterLabelTable = new HySDataHashTable();

        /// <summary>ビューアジョブ</summary>
        protected McDotNetViewerJob m_csJob = null;

        /// <summary>演算要素モデルネットワーク生成クラスの情報リスト</summary>
        protected HySDataLinkedList m_csMcModelNetworkGeneratorInfoList = null;

        /// <summary>モデルジェネレーター固有画面の情報リスト</summary>
        protected HySDataLinkedList m_csModelGeneratorScreenList = null;

        /// <summary>シミュレーター使用情報生成制御フォーム</summary>
        private string m_csModelModeKind = "";

        /// <summary>コンボボックスで選択されたモデルジェネレーター情報 </summary>
        protected McModelInfo m_csModelInfo=null;

        /// <summary>コンボボックスで選択されたモデルジェネレーターが必要とする情報リストリスト </summary>
        protected HySDataLinkedList m_csMdlGenDataList=null;


        // 定数定義
        /// <summary>シミュレーター使用ＧＩＳ関連情報生成制御画面デフォルト幅</summary>
        static private readonly int DEFAULT_WIDTH = 711;
        /// <summary>シミュレーター使用ＧＩＳ関連情報生成制御画面デフォルト高さ</summary>
        static private readonly int DEFAULT_HEIGHT = 668;

        /// <summary> <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetProjectCtlScreen csScreen = new McDotNetProjectCtlScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetProjectCtlScreen 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetModelGenerateCtlScreen()
        {
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csModelGenerateCtlForm = new McDotNetModelGenerateCtlForm(this);
            m_csModelGenerateCtlForm.Text = Properties.McDotNetViewerResources.FORM_TITLE_MODELGENERATE; //"モデルデータ生成制御";
            m_csModelGenerateCtlForm.Width = DEFAULT_WIDTH;
            m_csModelGenerateCtlForm.Height = DEFAULT_HEIGHT;
            m_csModelGenerateCtlForm.StartPosition = FormStartPosition.Manual;
            m_csModelGenerateCtlForm.SetDesktopLocation(450, 10);
            m_csModelGenerateCtlForm.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
            base.SetViewForm(m_csModelGenerateCtlForm);
            m_csMDGInfo.Clear();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            this.SetViewerJob(m_csDotNetVeiewer.GetViewerJob(McDefine.SIMULATOR_KIND.GetString()));
            m_csModelGenerateCtlForm.MdiParent = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();
            m_csJob = csViewer.GetViewerJob(McDefine.SIMULATOR_KIND.GetString()) as McDotNetViewerJob;
           
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            if (m_csModelGenerateCtlForm.Visible == false)
            {
                m_csModelGenerateCtlForm.Show();
            }
        }    
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            m_csModelGenerateCtlForm.Close();
        }
        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
            m_csModelGenerateCtlForm.Hide();
        }       
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面初期配置表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            m_csModelGenerateCtlForm.Width = DEFAULT_WIDTH;
            m_csModelGenerateCtlForm.Height = DEFAULT_HEIGHT;
            m_csModelGenerateCtlForm.WindowState = FormWindowState.Normal;
            m_csModelGenerateCtlForm.StartPosition = FormStartPosition.Manual;
            m_csModelGenerateCtlForm.SetDesktopLocation(450, 10);

            m_csMDGInfo.Clear();
        }

        /// <summary><para>method outline:</para>
        /// <para>画面ノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NormalizeScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NormalizeScreen()
        {
            m_csModelGenerateCtlForm.WindowState = FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面をアクティブ化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ActivateForm()
        {
            m_csModelGenerateCtlForm.Activate();
        }
            
        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override bool EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            HySEventObject csEvObj = csEvent as HySEventObject;
            if (csEvObj != null)
            {
                long lEvNo = csEvObj.GetEventNo();
                long lSubEvNo = csEvObj.GetSubEventNo();

                if (HySEventObject.CMND_SIMULATION_COMMON == lEvNo && HySSimulatorDefine.SIMULATION_DATA_CREATE == lSubEvNo)
                {   // シミュレーションジェネレーター応答ならば
                    McMdlDtGenAckInfo csSubDt = csEvObj.GetSubData() as McMdlDtGenAckInfo;

                    bool bOKNG = csSubDt.GetAckNack();
                    HySString csMsg = csSubDt.GetMessage();  // csMsg は　null の場合もある
                    long lAckNo = csSubDt.GetAckNo();
                    if (lAckNo == McMdlDtGenAckInfo.MODEL_GENERATION_ACK)
                    {
                        string mes = null;
                        string Projectname = m_csModelGenerateCtlForm.GetTextBoxName();

                        if (bOKNG == true)
                        {   // 正常終了
                            // メッセージボックスに　「正常終了」を出す
                            // 構造定義ファイル名は　「入力したプロジェクト名＋.xml」である事を補足として表示しても良い。
                            //mes = "正常終了\n「" + Projectname  + "」" + "\n" + csMsg.ToString();
                            mes = String.Format(McMessage.GetString("MC_MSG_COMPLET_MG_END"), Projectname) + "\n" + csMsg.ToString();
                        }
                        else
                        {   // 異常終了
                            // メッセージボックスに　「異常終了」を出す
                            // 補足メッセージ：何処でエラーになったか等のメッセージ情報は　csMsg　に入っている
                            //mes = "異常終了\n「" + Projectname + "」" + "\n" + csMsg.ToString();
                            mes = String.Format(McMessage.GetString("MC_MSG_ERROR_MG_END"), Projectname) + "\n" + csMsg.ToString();
                        }
                        // 正常終了・異常終了等のメッセージを出す
                        //MessageBox.Show(mes, "メッセージ", MessageBoxButtons.OK, MessageBoxIcon.Information);
                        MessageBox.Show(mes, McMessage.GetString("MC_MSG_TITLE_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Information);

                        // ToDo
                        // 画面の中断ボタンを非活性とし、開始ボタンを活性とする
                        m_csModelGenerateCtlForm.ButtonStatusSet();
                        // カーソルを標準にする。
                        m_csModelGenerateCtlForm.Cursor = Cursors.Default;
                    }
                    else if (lAckNo == McMdlDtGenAckInfo.MODEL_GENERATION_PROGRESS)
                    {
                        // 作成進行状況を報告
                        // 制御画面下の状況（ステータス表示等）に状況を表示する
                        // カーソルを砂時計にする
                        m_csModelGenerateCtlForm.Cursor = Cursors.WaitCursor;
                    }
                    //    new McMdlDtGenAckInfo(true, new HySString(""), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                    //((HySEventObject)csEvent).SetSubData(csSubDt);
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        override public Boolean PutEvent(HySSysEvent csEvent)
        {
            ((HySEventObject)csEvent).SetToSimKind(McDefine.SIMULATOR_KIND);
            return m_csDotNetVeiewer.PutEvent(csEvent);
        }
        
        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
            if (m_csModelGenerateCtlForm.Visible == false)
            {
                McMdlDtGenScreenReqInfo csReqInf = ((HySEventObject)csEvent).GetSubData() as McMdlDtGenScreenReqInfo;
                m_csMcModelNetworkGeneratorInfoList = csReqInf.GetModelGeneratorList();
                m_csModelGeneratorScreenList = csReqInf.GetModelGeneratorScreenList();

                m_csModelGenerateCtlForm.SetModelNetworkGeneratorList(m_csMcModelNetworkGeneratorInfoList);
                m_csModelGenerateCtlForm.SetModelGeneratorScreenList(m_csModelGeneratorScreenList);
                m_csModelGenerateCtlForm.SetModelSettingScreenList();
                m_csModelGenerateCtlForm.SetModelNetworkGeneratorInfoList();
                m_csModelGenerateCtlForm.SetStateDispMDGSetScreen();
                m_csModelGenerateCtlForm.ClearGridView();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラスの情報リストを返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList bRtn = GetModelNetworkGeneratorList( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素モデルネットワーク生成クラスの情報リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelNetworkGeneratorList()
        {
            return m_csMcModelNetworkGeneratorInfoList;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルジェネレーター固有画面の情報リストを返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList bRtn = GetModelGeneratorScreenList( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデルジェネレーター固有画面の情報リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelGeneratorScreenList()
        {
            return m_csModelGeneratorScreenList;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルジェネレーター固有画面の情報リストを表示する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = DispMdlDataGenScreen(csScreenInfo)</para>
        /// </example>
        /// <param name="csScreenInfo">モデルジェネレーター固有画面を表す情報</param>
        /// <returns>bool =true:正常　=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool DispMdlDataGenScreen(McModelInfo csScreenInfo)
        {
            bool bRtn = false;
            if (csScreenInfo != null)
            {
                HySKind csSimulatorKind = McDefine.SIMULATOR_KIND;
                HySIdentifier csLibID = csScreenInfo.GetLibraryID();
                HySKind csScreenKind = csScreenInfo.GetModelKind();

                m_csModelModeKind = csScreenInfo.GetModelKind().ToString();

                McDotNetViewerJob csMcVJob = this.m_csJob as McDotNetViewerJob;

                McDotNetModelDataGeneratorScreenBase csScreen = csMcVJob.CreateModelDataGeneratorScreen(csSimulatorKind, csLibID, csScreenKind) as McDotNetModelDataGeneratorScreenBase;
                if (csScreen != null)
                {  // スクリーンが有効の場合
                    try
                    {
                        csScreen.SetListStringBase(m_csModelGenerateCtlForm.GetListString());
                        csScreen.Initialize();

                        // モデルジェネレーターフォーム取得
                        //m_csMGSDataSelectForm = csScreen.GetGenerationForm();

                        csScreen.SetCtlScreen(this);

                        csMcVJob.SetScreen(csScreen);
                        //csScreen.SetDispEventData(csEvent);

                        csScreen.ShowScreen();
                        bRtn = true;
                    }
                    catch (Exception ex)
                    {
                        // ログ出力
                       // ver1.5 エラートレース日本語対応
                        HySLog.LogOut(HySLog.ONLINE, "McModelDataGeneratorScreen::DispMdlDataGenScreen",
                            Properties.McDotNetViewerResources.STATEMENT_EXCEPTION_CATCH + Properties.McDotNetViewerResources.STATEMENT_IN_CLASS
                            + "(" + csScreen.ToString() + ") :: " + ex.Message); //ex.StackTrace);
                       // HySLog.LogOut(HySLog.ONLINE, "McModelDataGeneratorScreen::DispMdlDataGenScreen", " Exception Catch" + " in Class(" + csScreen.ToString() + ") :: " + ex.Message); //ex.StackTrace);
                        MessageBox.Show("McModelDataGeneratorScreen Exception Catch  in Class(" + csScreen.ToString() + ") :: " + ex.Message);
                    }
                }

            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル一覧情報リスト画面を表示する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = DispMdlDataGenScreen(csScreenInfo)</para>
        /// </example>
        /// <param name="csScreenInfo">ファイル一覧情報リスト画面を表す情報</param>
        /// <returns>bool =true:正常　=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool DispMdlDataGenSelectScreen(McModelInfo csScreenInfo)
        {
            bool bRtn = false;
            if (csScreenInfo != null)
            {
                HySKind csSimulatorKind = McDefine.SIMULATOR_KIND;
                HySIdentifier csLibID = csScreenInfo.GetLibraryID();
                HySKind csScreenKind = csScreenInfo.GetModelKind();

                m_csModelModeKind = csScreenInfo.GetModelKind().ToString();

                McDotNetViewerJob csMcVJob = this.m_csJob as McDotNetViewerJob;

                McModelGeneratorDataSelectScreenBase csScreen = csMcVJob.CreateModelDataGeneratorSelectScreen(csSimulatorKind, csLibID, csScreenKind) as McModelGeneratorDataSelectScreenBase ;
                if (csScreen == null)
                {   // 特別提供がなければ標準画面を表示する
                    csLibID = McModelLibraryDefine.SYSTEM_MODEL_FACTORY;
                    csScreenKind = McModelLibraryDefine.MODEL_GENERATOR_SELECT_COMMON_SCREEN;
                    csScreen = csMcVJob.CreateModelDataGeneratorSelectScreen(csSimulatorKind, csLibID, csScreenKind) as McModelGeneratorDataSelectScreenBase;
                }
                if (csScreen != null)
                {  // スクリーンが有効の場合
                    csScreen.SetNeedDataList(m_csMdlGenDataList); // モデルジェネレーターが必要とする情報リストリスト

                    csScreen.Initialize();

                    csScreen.SetCtlScreen(this);

                    csScreen.SetDispData(); // 画面にデータ表示

                    csMcVJob.SetScreen(csScreen);

                    csScreen.ShowScreen();
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>個別情報設定通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeModelDataSet( csScreen ) </para>
        /// </example>
        /// <param name="csScreen">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>個別情報設画面にて「ＯＫ」ボタン押下時に発行</para>
        /// </remarks>
        public virtual void NoticeModelDataSet(McDotNetModelDataGeneratorScreenBase csScreen)
        {
            m_csModelGenerateCtlForm.UpdataFileList();
        }
        /// <summary><para>method outline:</para>
        /// <para>個別情報設定通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeFileDataSet( csScreen ) </para>
        /// </example>
        /// <param name="csScreen">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>個別情報設画面にて「ＯＫ」ボタン押下時に発行</para>
        /// </remarks>
        public virtual void NoticeFileDataSet(McModelGeneratorDataSelectScreenBase csScreen)
        {
            // ファイル一覧更新
            m_csModelGenerateCtlForm.UpdataFileList();
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル生成用情報を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelDataGenerationInfo csDt = GetMdlGenerationInfo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelDataGenerationInfo モデル生成用情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelDataGenerationInfo GetMdlGenerationInfo()
        {
            return m_csMDGInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>情報格納用ファイル表示ラベル情報を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataHashTable csDt = GetMdlDataDispLabel()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataHashTable 情報格納用ファイル表示ラベル情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataHashTable GetMdlDataDispLabel()
        {
            return m_csParameterLabelTable;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル種別を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string GetModelModeKind</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual string GetModelModeKind()
        {
            return m_csModelModeKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面で選択されたモデルジェネレーター情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelGenerationInfo(csModelInfo)</para>
        /// </example>
        /// <param name="csModelInfo">画面で選択されたモデルジェネレーター情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetModelGenerationInfo(McModelInfo csModelInfo)
        {
            m_csModelInfo = csModelInfo;
            if (m_csModelInfo != null)
            {
                HySID csLibraryID=m_csModelInfo.GetLibraryID();
                HySObjectKind csModelKind=m_csModelInfo.GetModelKind();

                m_csMdlGenDataList = ((McDotNetViewerJob)this.m_csVJob).GetModelGeneratorNeedDataList(csLibraryID, csModelKind);
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルデータジェネレーション用情報初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MakeInitialModelGenerationDataSetList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void MakeInitialModelGenerationDataSetList()
        {
            if( m_csMdlGenDataList != null )
            {
                m_csMDGInfo.Clear();
                m_csParameterLabelTable.ClearAllObject();
                McMdlGenNeedData csNdDt=null;
                long lNum = m_csMdlGenDataList.GetCount();
                m_csMdlGenDataList.SetCursorFirst();
                for( long lLp=0;lLp<lNum;lLp++)
                {
                    csNdDt = m_csMdlGenDataList.GetCursorData() as McMdlGenNeedData;
                    if( csNdDt != null )
                    {
                        m_csParameterLabelTable.AddObject((HySString)csNdDt.GetModelKind().GetString(), csNdDt.GetModelName());
                        //m_csMDGInfo.AddInfo(csNdDt.GetType(), new HySString(""));
                    }
                    m_csMdlGenDataList.MoveCursorNext();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル一覧情報リスト画面にデータ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>void SetDispData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDispData()
        {
        }
        
        /// <summary><para>method outline:</para>
        /// <para>モデルデータジェネレーション開始</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ModelConstructionStart()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual bool ModelConstructionStart()
        {
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_SIMULATION_COMMON);
            csEvent.SetSubEventNo(HySSimulatorDefine.SIMULATION_DATA_CREATE);

            // モデル生成情報設定
            csEvent.SetData(m_csMDGInfo);

            string Projectname = m_csModelGenerateCtlForm.GetTextBoxName();
            if( Projectname.Equals("")==true){
                //MessageBox.Show("生成構造定義ファイル名が未設定です。", "エラーメッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                MessageBox.Show(McMessage.GetString("MC_MSG_ERROR_MG_UNESTABLISHED_FILE"), McMessage.GetString("MC_MSG_TITLE_ERROR_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }

            int i = m_csModelGenerateCtlForm.SelectComboBoxIndex();
            if (i < 0)
            {
                //MessageBox.Show("モデル構造定義生成ツールが選択されていません。", "エラーメッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                MessageBox.Show(McMessage.GetString("MC_MSG_ERROR_MG_SELECT_DATATOOL"), McMessage.GetString("MC_MSG_TITLE_ERROR_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }

            //DialogResult result = MessageBox.Show("モデル構造定義の作成を開始します。\nよろしいですか？", "メッセージ", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
            DialogResult result = MessageBox.Show(McMessage.GetString("MC_MSG_INFO_MG_CLEATESIMULATIONINFO_START"), McMessage.GetString("MC_MSG_TITLE_MESSAGE"), MessageBoxButtons.YesNo, MessageBoxIcon.Question);
            if (result == DialogResult.No)
            {
                return false;
            }

            McModelInfo csModelInfo = m_csMcModelNetworkGeneratorInfoList.GetData(i) as McModelInfo;
            if (csModelInfo != null)
            {
                m_csMDGInfo.SetLibraryID(csModelInfo.GetLibraryID());
                m_csMDGInfo.SetGeneratorKind(csModelInfo.GetModelKind());
            }
            m_csMDGInfo.SetProjectname(Projectname);

            this.PutEvent(csEvent);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>実行中のモデルデータジェネレーションを止める</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>BreakModelConstruction(csMdlGenInfo)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual bool BreakModelConstruction()
        {
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_SIMULATION_COMMON);
            csEvent.SetSubEventNo(HySSimulatorDefine.SIMULATION_DATA_CREATE_BREAK);

            // モデル生成情報設定
            csEvent.SetData(m_csMDGInfo);

            this.PutEvent(csEvent);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳ情報作成開始開始</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GISDataGenerationStart()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual bool GISDataGenerationStart()
        {
            // GIS起動
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISP_SCREEN);
            csEvent.SetSubEventNo(HySGISDefine.GIS_COTS_WAKEUP);
            csEvent.SetData(HySDefine.DISP_FORM_GIS_BASEMAP);   // 背景地図表示
            this.PutEvent(csEvent);
            // 背景地図と対で横断面データ編集画面用GISスクリーン生成を行う
            csEvent = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISP_SCREEN);
            csEvent.SetSubEventNo(HySGISDefine.GIS_COTS_WAKEUP);
            csEvent.SetData(HySDefine.DISP_FORM_RIVER_CROSSSECTION);
            this.PutEvent(csEvent);

            ////★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            //// DIOVista使用時には、ボタンは一つなので　HySGISDataKindDefine.GIS_GENERAL_DATA　の宣言を使用してください
            //// DioVista 側は、画面を開くのみ
            //// DioVista の画面の中に　作成したい情報が入っている
            ////★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

            return true;
        }
        //　以下追加
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳ情報作成開始開始</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GISDataGenerationStart()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual bool MdlGenDataDataSelectScreenStart()
        {
            bool bRtn = true;
            HySKind csSimulatorKind = McDefine.SIMULATOR_KIND;
            HySIdentifier csLibID = null; // <-- モデル構造定義生成ツール同じライブラリＩＤ csScreenInfo.GetLibraryID();
            HySKind csScreenKind = null; // セレクト画面用の　画面種別をどこかで定義する（共通）

            McDotNetViewerJob csMcVJob = this.m_csJob as McDotNetViewerJob;
            McModelGeneratorDataSelectScreen csScreen =
                csMcVJob.CreateModelDataGeneratorSelectScreen(csSimulatorKind, csLibID, csScreenKind)
                            as McModelGeneratorDataSelectScreen;
            
            if (csScreen != null)
            {  // スクリーンが有効の場合
                //csLibIDを　McMdlGenCommonScreenFactoryと同じＩＤとして再度挑戦
            
            }
            if (csScreen != null)
            {
                //csScreenを表示させる
            }
            else
            {
                bRtn = false;
            }
            return bRtn;
        }
        //★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

    }
}
