﻿// <summary>ソースコード：ラッパーモデル情報編集制御スクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSData;
//using CommonMP.HYSSOP.CoreImpl.HSTools;
//using CommonMP.HYSSOP.CoreImpl.HSSimulator;
//using CommonMP.HYSSOP.CoreImpl.HSGIS;
//using CommonMP.HYSSOP.CoreImpl;
//using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.OptionImpl.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
//using CommonMP.HYMCO.Interface.Data;
//using CommonMP.HYMCO.CoreImpl.Data;
//using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;

using CommonMP.HYSSOP.Interface.HSViewer.HSScreens;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ラッパーモデル情報編集制御スクリーンクラスＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/01][新規作成]</para>
    /// </remarks>
    public class McDotNetWrapperModelInfoEditCtlScreen : HySDotNetScreen
    {
        /// <summary>ラッパーモデル情報編集制御フォーム</summary>
        private McDotNetWrapperModelInfoEditCtlForm m_csWrapperModelInfoEditCtlForm;

        // 定数定義
        /// <summary>ラッパーモデル情報編集制御画面デフォルト幅</summary>
        static private readonly int DEFAULT_WIDTH = 520;
        /// <summary>ラッパーモデル情報編集制御画面デフォルト高さ</summary>
        static private readonly int DEFAULT_HEIGHT = 800;

        /// <summary> <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetWrapperModelInfoEditCtlScreen csScreen = new McDotNetWrapperModelInfoEditCtlScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetWrapperModelInfoEditCtlScreen 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetWrapperModelInfoEditCtlScreen()
        {
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csWrapperModelInfoEditCtlForm = new McDotNetWrapperModelInfoEditCtlForm(this);
            m_csWrapperModelInfoEditCtlForm.Text = "ラッパーモデル情報編集";
            m_csWrapperModelInfoEditCtlForm.Width = DEFAULT_WIDTH;
            m_csWrapperModelInfoEditCtlForm.Height = DEFAULT_HEIGHT;
            m_csWrapperModelInfoEditCtlForm.StartPosition = FormStartPosition.Manual;
            m_csWrapperModelInfoEditCtlForm.SetDesktopLocation(450, 10);
            m_csWrapperModelInfoEditCtlForm.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
            base.SetViewForm(m_csWrapperModelInfoEditCtlForm);
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            this.SetViewerJob(m_csDotNetVeiewer.GetViewerJob(McDefine.SIMULATOR_KIND.GetString()));
            m_csWrapperModelInfoEditCtlForm.MdiParent = ((HySDotNetViewer)m_csDotNetVeiewer).GetMainForm();
            m_csVJob = csViewer.GetViewerJob(McDefine.SIMULATOR_KIND.GetString()) as McDotNetViewerJob;
           
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            if (m_csWrapperModelInfoEditCtlForm.Visible == false)
            {
                m_csWrapperModelInfoEditCtlForm.Show();
            }
        }    
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            m_csWrapperModelInfoEditCtlForm.Close();
        }
        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
            m_csWrapperModelInfoEditCtlForm.Hide();
        }       
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面初期配置表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            m_csWrapperModelInfoEditCtlForm.Width = DEFAULT_WIDTH;
            m_csWrapperModelInfoEditCtlForm.Height = DEFAULT_HEIGHT;
            m_csWrapperModelInfoEditCtlForm.WindowState = FormWindowState.Normal;
            m_csWrapperModelInfoEditCtlForm.StartPosition = FormStartPosition.Manual;
            m_csWrapperModelInfoEditCtlForm.SetDesktopLocation(450, 10);

        }

        /// <summary><para>method outline:</para>
        /// <para>画面ノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NormalizeScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NormalizeScreen()
        {
            m_csWrapperModelInfoEditCtlForm.WindowState = FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面をアクティブ化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ActivateForm()
        {
            m_csWrapperModelInfoEditCtlForm.Activate();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override bool EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            HySEventObject csEvObj = csEvent as HySEventObject;
            if (csEvObj != null)
            {
                long lEvNo = csEvObj.GetEventNo();
                long lSubEvNo = csEvObj.GetSubEventNo();

            }
            return bRtn;
        }
    }
}
