// <summary>ソースコード：ＨＹＭＣＯモデルジェネレータ使用データ選択設定画面標準スクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.OptionImpl.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;

using CommonMP.HYSSOP.Interface.HSViewer.HSScreens;


namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルジェネレータ使用データ選択設定画面標準スクリーンクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    public class McMdlGenDataCmnSelectScreen : McModelGeneratorDataSelectScreenBase
    {
        /// <summary>モデル用データファイル設定画面 </summary>
        private McMdlGenDataCmnSelectForm m_csCmnSelectForm;

        /// <summary>コンボボックスで選択されたモデルジェネレーターが必要とする情報リスト </summary>
        private HySDataLinkedList m_csMdlGenDataListScreen = null;


        /// <summary><para>method outline:</para>
        /// <para>モデルジェネレータ使用データ選択設定画面フォーム生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McModelGeneratorDataSelectScreenFormBase csMdlGenDatarSlctForm = CreateModelGeneratorDataSelectForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelGeneratorDataSelectScreenFormBase モデルジェネレータ使用データ選択設定画面フォーム</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McModelGeneratorDataSelectScreenFormBase CreateModelGeneratorDataSelectForm()
        {
            m_csCmnSelectForm = new McMdlGenDataCmnSelectForm();

            m_csCmnSelectForm.Text = Properties.McDotNetViewerResources.FORM_TITLE_MG_DATAFILE_SETTING; //"モデル用データファイル設定";

            // コンボボックスで選択されたモデルジェネレーターが必要とする情報リスト設定
            m_csMdlGenDataListScreen = GetNeedDataList();
            m_csCmnSelectForm.SetNeedDataList(m_csMdlGenDataListScreen);

            // データグリッドビューヘッダー部設定
            m_csCmnSelectForm.SetHeaderDataGridView();

            // データグリッドビューデータ部設定
            //m_csCmnSelectForm.SetDataGridView();

            return m_csCmnSelectForm;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            base.Initialize();
        }
        /// <summary> <para>method outline:</para>
        /// <para>表示位置取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GetDispLocation( ref iX, ref iY ) </para>
        /// </example>
        /// <param name="iX">表示位置：Ｘ ピクセル</param>
        /// <param name="iY">表示位置：Ｙピクセル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void GetDispLocation(ref int iX, ref int iY)
        {
            iX = 310;
            iY = 30;
        }

        /// <summary> <para>method outline:</para>
        /// <para>リストボックス選択位置取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetDataGridView(string clickString) </para>
        /// </example>
        /// <param name="clickString">文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDataGridView(string clickString)
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル一覧情報リスト画面にデータ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>void SetDispData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetDispData()
        {
            // データグリッドビューデータ部設定
            m_csCmnSelectForm.SetDataGridView();
        }


    }
}
