﻿// <summary>ソースコード：ＨＹＭＣＯモデルジェネレータ使用データ選択設定画面スクリーン親クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.OptionImpl.HSViewer;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;

using CommonMP.HYSSOP.Interface.HSViewer.HSScreens;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{

    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルジェネレータ使用データ選択設定画面スクリーン親クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    public abstract class McModelGeneratorDataSelectScreenBase : HySDotNetScreen, McModelGeneratorDataSelectScreen
    {
        /// <summary>リストボックス選択文字列 </summary>
        public string m_csMdlGenBaseClickString = null;

        /// <summary>シミュレーター使用ＧＩＳ関連情報生成制御スクリーンクラス</summary>
        protected McDotNetModelGenerateCtlScreen m_csMDGCtlScreen = null;

        /// <summary> モデルジェネレータ使用データ選択設定画面フォーム</summary>
        protected McModelGeneratorDataSelectScreenFormBase m_csMGSDataSelectForm = null;
        /// <summary>モデルデータジェネレーション用情報クラス</summary>
        protected McModelDataGenerationInfo m_csMDGInfo = null;
        /// <summary>コンボボックスで選択されたモデルジェネレーターが必要とする情報リスト </summary>
        protected HySDataLinkedList m_csMdlGenDataList = null;

        /// <summary> デフォルト表示位置：Ｘ </summary>
        static protected readonly int s_lDefaultLocationX = 400;
        /// <summary> デフォルト表示位置：Ｙ </summary>
        static protected readonly int s_lDefaultLocationY = 10;

        /// <summary> <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelDataGeneratorScreenBase csScreen = new McDotNetModelDataGeneratorScreenBase()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetModelDataGeneratorScreenBase 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelGeneratorDataSelectScreenBase()
        {
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Initialize()
        {
            m_csID = new HySID("MDG-McModelGeneratorDataSelectScreenFormBase-Screen");

            m_csMGSDataSelectForm = this.CreateModelGeneratorDataSelectForm();
            m_csMGSDataSelectForm.StartPosition = FormStartPosition.Manual;
            int iX = McModelGeneratorDataSelectScreenBase.s_lDefaultLocationX; int iY = McModelGeneratorDataSelectScreenBase.s_lDefaultLocationY;
            this.GetDispLocation(ref iX, ref iY);
            m_csMGSDataSelectForm.SetDesktopLocation(iX, iY);

            m_csMGSDataSelectForm.SetMdlDataSelectScreen(this);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>リストボックス選択文字列設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetListStringBase(string slistString) </para>
        /// </example>
        /// <param name="slistString">文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetListStringBase(string slistString)
        {
            m_csMdlGenBaseClickString = slistString;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Terminate()
        {
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>ビューア設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetViewer( csViewer ) </para>
        /// </example>
        /// <param name="csViewer">ビューア</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetViewer(HySViewer csViewer)
        {
            m_csDotNetVeiewer = csViewer;
            this.SetViewerJob(m_csDotNetVeiewer.GetViewerJob(McDefine.SIMULATOR_KIND.GetString()));

        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> ShowScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShowScreen()
        {
            //m_csMGSDataSelectForm.Show();
            m_csMGSDataSelectForm.ShowDialog();
        }    
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面消去</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CloseScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CloseScreen()
        {
            m_csMGSDataSelectForm.Close();
        }
        /// <summary><para>method outline:</para>
        /// <para>画面消去</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HideScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void HideScreen()
        {
            m_csMGSDataSelectForm.Hide();
        }       
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロジェクト画面初期配置表示</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> InitiateScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void InitiateScreen()
        {
            m_csMGSDataSelectForm.WindowState = FormWindowState.Normal;
            m_csMGSDataSelectForm.StartPosition = FormStartPosition.Manual;
            int iX = McModelGeneratorDataSelectScreenBase.s_lDefaultLocationX; int iY = McModelGeneratorDataSelectScreenBase.s_lDefaultLocationY;
            this.GetDispLocation(ref iX, ref iY);
            m_csMGSDataSelectForm.SetDesktopLocation(iX, iY);

        }

        /// <summary><para>method outline:</para>
        /// <para>画面ノーマライズ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NormalizeScreen()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NormalizeScreen()
        {
            m_csMGSDataSelectForm.WindowState = FormWindowState.Normal;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面をアクティブ化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ActivateForm( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ActivateForm()
        {
            m_csMGSDataSelectForm.Activate();
        }
            
        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override bool EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        override public Boolean PutEvent(HySSysEvent csEvent)
        {
            ((HySEventObject)csEvent).SetToSimKind(McDefine.SIMULATOR_KIND);
            return m_csDotNetVeiewer.PutEvent(csEvent);
        }
          
        /// <summary><para>method outline:</para>
        /// <para>表示に特別に必要なイベント情報の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDispEventData( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>表示に特別に必要なイベント情報があった場合のみ発行</para>
        /// </remarks>
        public override void SetDispEventData(HySSysEvent csEvent)
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルジェネレータ使用データ選択設定画面フォーム生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McModelGeneratorDataSelectScreenFormBase csMdlGenDatarSlctForm = CreateModelGeneratorDataSelectForm()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelGeneratorDataSelectScreenFormBase モデルジェネレータ使用データ選択設定画面フォーム</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract McModelGeneratorDataSelectScreenFormBase CreateModelGeneratorDataSelectForm();

        /// <summary><para>method outline:</para>
        /// <para>モデルジェネレーター制御画面クラスインスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCtlScreen(csCtlScreen)</para>
        /// </example>
        /// <param name="csCtlScreen">モデルジェネレーター制御画面クラスインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCtlScreen(McDotNetModelGenerateCtlScreen csCtlScreen)
        {
            m_csMDGCtlScreen = csCtlScreen;

            if (m_csMGSDataSelectForm != null)
            {
                m_csMGSDataSelectForm.SetCtlScreen(csCtlScreen);
                m_csMDGInfo = csCtlScreen.GetMdlGenerationInfo();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル生成に必要なデータのリストの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNeedDataList(HySDataLinkedList csNeedDataList) </para>
        /// </example>
        /// <param name="csNeedDataList">モデル生成に必要なデータのリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetNeedDataList(HySDataLinkedList csNeedDataList)
        {
            m_csMdlGenDataList = csNeedDataList;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル生成に必要なデータのリストの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetNeedDataList(HySDataLinkedList csNeedDataList) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList モデル生成に必要なデータのリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetNeedDataList()
        {
            return m_csMdlGenDataList;
        }

        /// <summary><para>method outline:</para>
        /// <para>個別情報設定通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeFileDataSet(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>個別情報設画面にて「ＯＫ」ボタン押下時に発行</para>
        /// </remarks>
        public virtual void NoticeFileDataSet()
        {
            m_csMDGCtlScreen.NoticeFileDataSet(this);
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル生成用情報クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelDataGenerationInfo csDt = GetMdlGenerationInfo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelDataGenerationInfo モデル生成用情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelDataGenerationInfo GetMdlGenerationInfo()
        {
            return m_csMDGCtlScreen.GetMdlGenerationInfo();
        }
        /// <summary> <para>method outline:</para>
        /// <para>画面表示位置取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GetDispLocation( ref iX, ref iY ) </para>
        /// </example>
        /// <param name="iX">表示位置：Ｘ ピクセル</param>
        /// <param name="iY">表示位置：Ｙピクセル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetDispLocation(ref int iX, ref int iY)
        {
            iX = McModelGeneratorDataSelectScreenBase.s_lDefaultLocationX;
            iY = McModelGeneratorDataSelectScreenBase.s_lDefaultLocationY;
        }
        /// <summary><para>method outline:</para>
        /// <para>ファイル一覧情報リスト画面にデータ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>void SetDispData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDispData()
        {
        }

    }
}
