﻿// <summary>ソースコード：ＨＹＭＣＯプロパティスクリーンファクトリ集合体クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.CoreImpl.Controller;


using CommonMP.HYMCO._SYSTEM_;
namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯスクリーンファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_SCREEN_FACTORY_CREATOR_IMPLE : PROPERTY_SCREEN_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_SCREEN_FACTORY_CREATOR csFactCrt = new HYMCO_SCREEN_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_SCREEN_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルプロパティスクリーンファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyScreenFactoryBase CreateFactory()
        {
            return new CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer.McDotNetSystemModelPropertyScreenFactory();
        }
    }
}



namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCO用 プロパティスクリーンファクトリ集合体クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McDotNetSystemModelPropertyScreenFactory : McPropertyScreenFactoryBase //McPropertyScreenFactorySet
    {
        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(csFactoryMng) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Init(HySFactoryMng csFactoryMng)
        {
            // ファクトリ管理クラス取得
            m_csFactoryMng = (HySFactoryManager)csFactoryMng;
            // ファクトリ管理クラスに自分を設定
            //m_csFactoryMng.SetPropertyScreenFactorySet(this);
        }
        ///// <summary><para>method outline:</para>
        ///// <para>ファクトリ識別子を生成</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> HySID csFactID = CreateFactoryID( ) </para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>ファクトリ識別子</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public override HySID CreateFactoryID()
        //{
        //    return (HySID)McDefine.FACTORY_ID_SCREEN;
        //}


        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            return (HySID)McModelLibraryDefine.SYSTEM_MODEL_FACTORY;
        }



        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ画面クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelPropertyScreen csScreen = CreatePropertyScreen( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelPropertyScreen モデルプロパティ画面クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McModelPropertyScreen CreatePropertyScreen(HySKind csModelKind)
        {
            McModelPropertyScreen csScreen = null;

            // ★★制御系モデル
            if (csModelKind.Equals(McModelLibraryDefine.HYM_MODEL_FIG_UNITY) == true)
            {
                // 全体系（FugureUnity)プロパティ生成
                csScreen = new McDotNetFigUnityPropertyScreen();
            }
            else if (csModelKind.Equals(McModelLibraryDefine.HYM_MODEL_SUBSYSTEM) == true)
            {
                // 部分系プロパティ生成
                csScreen = new McDotNetGroupPropertyScreen();
            }
            else if (csModelKind.Equals(McModelLibraryDefine.HYM_MODEL_CONVERGENCE_ITERATION) == true)
            {
                // 収束演算系グループプロパティ生成
                csScreen = new McDotNetGroupPropertyScreen();
            }
            else if (csModelKind.Equals(McModelLibraryDefine.HYM_MODEL_HYDRAULIC_CONVERGENCE_CTL_H24) == true)
            {   // 水理収束演算系演算制御モデルH24版
                csScreen = new McDotNetGroupPropertyScreen();
                //csScreen = new McDotNetFigUnityPropertyScreen();
            }
            // ★★デフォルト実装モデル
            else if (csModelKind.Equals(McModelLibraryDefine.HYM_MODEL_IDLE) == true)
            {
                // Idle モデルプロパティ生成
                csScreen = new McDotNetModelPropertyScreen();
            }
            else if (csModelKind.Equals(McModelLibraryDefine.HYM_MODEL_DATA_MERGE) == true)
            {
                // データマージモデルプロパティ生成
                csScreen = new McDotNetDataMergeModelPropertyScreen();
            }
            // ★★伝送データ
            // ★セル型伝送データ（定常）
            else if (csModelKind.Equals(McTranInfoDefine.D1_CELL) == true)
            {
                // 伝送データプロパティ生成
                csScreen = new McDotNetTranInfoCellPropertyScreen();
            }
            else if (csModelKind.Equals(McTranInfoDefine.D2_CELL) == true)
            {
                // 伝送データプロパティ生成
                csScreen = new McDotNetTranInfoCellPropertyScreen();
            }
            else if (csModelKind.Equals(McTranInfoDefine.D3_CELL) == true)
            {
                // 伝送データプロパティ生成
                csScreen = new McDotNetTranInfoCellPropertyScreen();
            }
            // ★セル型伝送データ（時系列）
            else if (csModelKind.Equals(McTranInfoDefine.SINGLE_CELL_SERIAL) == true)
            {
                // 伝送データプロパティ生成
                csScreen = new McDotNetTranInfoCellPropertyScreen();
            }
            else if (csModelKind.Equals(McTranInfoDefine.D1_CELL_SERIAL) == true)
            {
                // 伝送データプロパティ生成
                csScreen = new McDotNetTranInfoCellPropertyScreen();
            }
            else if (csModelKind.Equals(McTranInfoDefine.D2_CELL_SERIAL) == true)
            {
                // 伝送データプロパティ生成
                csScreen = new McDotNetTranInfoCellPropertyScreen();
            }
            else if (csModelKind.Equals(McTranInfoDefine.D3_CELL_SERIAL) == true)
            {
                // 伝送データプロパティ生成
                csScreen = new McDotNetTranInfoCellPropertyScreen();
            }
            // ★ＧＩＳ伝送データ（定常）
            else if (csModelKind.Equals(McTranInfoDefine.D2_GIS_MESH) == true)
            {
                // 伝送データプロパティ生成
                csScreen = new McDotNetTranInfoGeoPropertyScreen();
            }
            else if (csModelKind.Equals(McTranInfoDefine.D3_GIS_MESH) == true)
            {
                // 伝送データプロパティ生成
                csScreen = new McDotNetTranInfoGeoPropertyScreen();
            }
            // ＧＩＳ伝送データ（時系列）
            else if (csModelKind.Equals(McTranInfoDefine.D2_GIS_MESH_SERIAL) == true)
            {
                // 伝送データプロパティ生成
                csScreen = new McDotNetTranInfoGeoPropertyScreen();
            }
            else if (csModelKind.Equals(McTranInfoDefine.D3_GIS_MESH_SERIAL) == true)
            {
                // 伝送データプロパティ生成
                csScreen = new McDotNetTranInfoGeoPropertyScreen();
            }
            else if (csModelKind.Equals(McTranInfoDefine.MUTUAL_SINGLE_TRAN_SERIAL) == true
                || csModelKind.Equals(McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL) == true
                || csModelKind.Equals(McTranInfoDefine.MUTUAL_D2_TRAN_SERIAL) == true
                || csModelKind.Equals(McTranInfoDefine.MUTUAL_D3_TRAN_SERIAL) == true)
            {
                // 相互＿伝送データプロパティ生成
                csScreen = new McDotNetMutualTranInfoPropertyScreen();
            }

            // ----------------------------------------------------
            //** ↓　　★★★　プロトタイプ版リリース　★★★　　↓ **
            // ----------------------------------------------------
            /*
        else if (csModelKind.Equals(McTranInfoDefine.TRNINF_LINE_GRAPH) == true)
        {
            // 伝送データプロパティ生成
            //csScreen = new McDotNetModelPropertyScreen();
            csScreen = new McDotNetTranInfoPropertyScreen();
        }
            */
            else if (csModelKind.Equals(McTranInfoDefine.TRNINF_MULTI_SERIAL_PROTOTYPE) == true)
            {
                // 伝送データプロパティ生成
                //csScreen = new McDotNetModelPropertyScreen();
                csScreen = new McDotNetTranInfoPropertyScreen();
            }
            else if (csModelKind.Equals(McTranInfoDefine.TRNINF_1DIM_SERIAL_PROTOTYPE) == true)
            {
                // 伝送データプロパティ生成
                //csScreen = new McDotNetModelPropertyScreen();
                csScreen = new McDotNetTranInfoPropertyScreen();
            }
            else if (csModelKind.Equals(McTranInfoDefine.TRNINF_2DIM_SERIAL_PROTOTYPE) == true)
            {
                // 伝送データプロパティ生成
                //csScreen = new McDotNetModelPropertyScreen();
                csScreen = new McDotNetTranInfoPropertyScreen();
            }
            // ----------------------------------------------------
            //** ↑　　★★★　プロトタイプ版リリース　★★★　　↑ **
            // ----------------------------------------------------

            return csScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル固有のモデルジェネレータ用必要情報選択画面スクリーンクラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelGeneratorDataSelectScreen csMdlGen = CreateModelDataGeneratorSelectScreen(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelGeneratorDataSelectScreen モデル固有のモデルジェネレータ用必要情報選択画面スクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデルジェネレータが必要とする情報を選択する画面
        /// CommonMPシステムが提供する汎用画面では、機能不足の場合本メソッドをオーバーライドして固有の画面を作成する</para>
        /// </remarks>
        public override McModelGeneratorDataSelectScreen CreateModelDataGeneratorSelectScreen(HySKind csModelKind)
        {
            McModelGeneratorDataSelectScreen csRtnObj = new McMdlGenDataCmnSelectScreen();
            return csRtnObj;
        }
    }
}
