﻿// <summary>ソースコード：ビューアジョブクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;
using System.IO;

using CommonMP.HYMCO.Interface;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYSSOP.CoreImpl.HSTools.HSExecutor;


using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.LibraryCtl;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>ビューア内制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/10/01][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/05][修正]
    /// </para>
    /// </remarks>
    public class McDotNetViewerJob : HySDotNetViewerJob
    {
        /// <summary>業務動作中フラグ</summary>
        protected bool m_bWorkFlg = false;

        /// <summary>tempフォルダ（相対パス）</summary>
        protected static readonly string TEMP_FOLDER = @"\temp";

        /// <summary>プロジェクトインポート時ダイアログ　フィルタ</summary>
        protected static readonly string IMPORT_DIALOG_FILTER = Properties.McDotNetViewerResources.FILE_DLG_FILTER_PRJDB; //"エクスポートファイル(*.prjdb)|*.prjdb"

        /// <summary>プロジェクトインポート時ダイアログ　タイトル</summary>
        protected static readonly string IMPORT_DIALOG_TITLE = Properties.McDotNetViewerResources.FILE_DLG_TITLE_IMPORT;  //"プロジェクトのインポート"

        /// <summary>
        /// メッセージボックスタイトル
        /// 『プロジェクト管理機能』
        /// </summary>
        protected static readonly string MC_MSG_TITLE_PROJECT_MANAGEMENT = McMessage.GetString("MC_MSG_TITLE_PROJECT_MANAGEMENT");

        /// <summary>
        /// メッセージ
        ///『 同一IDのプロジェクトが既に開かれています。
        /// 　プロジェクト名称：　　　　　　　　　　　　』
        /// </summary>
        protected static readonly string MC_MSG_WARNING_OPEN_PROJECT = McMessage.GetString("MC_MSG_WARNING_OPEN_PROJECT");

        /// <summary>
        /// メッセージ
        /// 『プロジェクトの変更を保存しますか？
        /// 　プロジェクト名：　　　　　　　　　』
        /// </summary>
        protected static readonly string MC_MSG_QUESTION_CONFILM_SAVE = McMessage.GetString("MC_MSG_QUESTION_CONFILM_SAVE");

        /// <summary>
        /// メッセージ
        /// 『プロジェクトの保存が完了しました。』
        /// </summary>
        protected static readonly string MC_MSG_INFO_SAVE_PROJECT = McMessage.GetString("MC_MSG_INFO_SAVE_PROJECT");

        /// <summary>
        /// メッセージ
        /// 『プロジェクトの保存が失敗しました。』
        /// </summary>
        protected static readonly string MC_MSG_ERR_SAVE_PROJECT = McMessage.GetString("MC_MSG_ERR_SAVE_PROJECT");

        /// <summary>
        /// メッセージ
        /// 『プロジェクトの読み込みに失敗しました。』
        /// </summary>
        protected static readonly string MC_MSG_ERR_READ_PROJECT = McMessage.GetString("MC_MSG_ERR_READ_PROJECT");

        /// <summary>
        /// メッセージボックスタイトル
        /// 『ライブラリ登録支援機能』
        /// </summary>
        protected static readonly string MC_MSG_TITLE_LIBRARY_REGISUT_SUPPORT = McMessage.GetString("MC_MSG_TITLE_LIBRARY_REGISUT_SUPPORT");

        /// <summary>
        /// 『前回のインストール処理が完了していません。
        /// 前回のインストールを完了する場合は、CommonMPを再起動して下さい。』
        /// </summary>
        static protected readonly string MSG_ERR_NOT_COMPLETE_INSTALL = McMessage.GetString("MC_MSG_WARNING_NOT_COMPLETE_INSTALL");

        /// <summary>GIS起動パス設定　フィルタ</summary>
        protected static readonly string GISPATH_DIALOG_FILTER = Properties.McDotNetViewerResources.FILE_DLG_FILTER_EXEFILE; //"実行ファイル(*.exe)|*.exe"
        /// <summary>GIS起動パス設定ダイアログ　タイトル</summary>
        protected static readonly string GISPATH_DIALOG_TITLE = Properties.McDotNetViewerResources.FILE_DLG_TITLE_GISPATH;
        /// <summary>GIS起動パス設定ダイアログ　タイトル</summary>
        protected static readonly string GISPATH_MSG_TITLE = McMessage.GetString("MC_MSG_TITLE_GISPATH");
        /// <summary>GIS起動パス設定　メッセージ「完了・再起動」</summary>
        protected static readonly string MC_MSG_INFO_COMPLETE_GISPATH = McMessage.GetString("MC_MSG_INFO_COMPLETE_GISPATH");
        /// <summary>GIS起動パス設定　メッセージ「設定異常」</summary>
        protected static readonly string MC_MSG_ERR_SET_GISPATH = McMessage.GetString("MC_MSG_ERR_SET_GISPATH");

        ///// <summary>メッセージ「同一プロジェクト名」 </summary>
        //static private readonly string MSG_ERROR_PERIOD_DATE = "既に同一名称のプロジェクト名が存在します。";
        /// <summary>メッセージ「同一ファイル名」 </summary>
        static protected readonly string MSG_ERROR_PROJECT_EXIST = McMessage.GetString("MC_MSG_WARNING_PROJECT_EXIST");
        /////// <summary>メッセージ「同一ファイル名」 </summary>
        ////static private readonly string MSG_ERROR_PERIOD_DATE = "既に同一名称のファイルが存在します。上書きしてよろしいですか？";
        //static private readonly string MSG_MSG_INFO_FILE_EXIST = McMessage.GetString("MC_MSG_INFO_FILE_EXIST");

        /// <summary>「接続要素のレコード数自動調整」</summary>
        protected static readonly string MC_MSG_TITLE_OPTIMIZE_TRANINFO = McMessage.GetString("MC_MSG_TITLE_OPTIMIZE_TRANINFO");
        /// <summary>「接続要素のレコード数の調整を行いますか？(調整後のアンドゥは出来ません。)」</summary>
        protected static readonly string MC_MSG_QUESTION_OPTIMIZE_TRANINFO = McMessage.GetString("MC_MSG_QUESTION_OPTIMIZE_TRANINFO");
        /// <summary>「各接続線の最大レコード数が変更されました。各接続線におけるレコード数を確認してください。」</summary>
        protected static readonly string MC_MSG_TITLE_OPTIMIZE_TRANINFO_OK = McMessage.GetString("MC_MSG_TITLE_OPTIMIZE_TRANINFO_OK");
        /// <summary>「レコード数の調整ができませんでした。モデルチェック結果を確認してください。」</summary>
        protected static readonly string MC_MSG_TITLE_OPTIMIZE_TRANINFO_NG = McMessage.GetString("MC_MSG_TITLE_OPTIMIZE_TRANINFO_NG");
        /// <summary>「起動切り替え」</summary>
        protected static readonly string MC_MSG_TITLE_SYSTEM_CHANGE = McMessage.GetString("MC_MSG_TITLE_SYSTEM_CHANGE");
        /// <summary>「起動切り替えのためCommonMPを再起動します。よろしいですか?」</summary>
        protected static readonly string MC_MSG_QUESTION_SYSTEM_CHANGE = McMessage.GetString("MC_MSG_QUESTION_SYSTEM_CHANGE");

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDotNetViewerJob csViewerJob = new McDotNetViewerJob( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McDotNetViewerJob 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetViewerJob()
        {
            m_csScreenTbl = new Hashtable();    // スクリーン管理用ハッシュテーブル
            m_lScreenNum = 0;                   // 搭載スクリーン数
            m_csScreenKeyList = new ArrayList();// スクリーン管理用キーリスト

            // 終了時に必ず動作させるプログラムを設定しておく
            HySExcecutor csExecutor = new HySExcecutor();

            // 終了時起動プログラムを設定する
            // HymcoLibDelete.exe を起動する
            string sAfterExeName = "CommonMPMain";// CommonMP本体が終了するのを待つ
            string sExeName = "HymcoLibDelete.exe";
            string sParam = "";// 起動パラメーターは無し
            HySExecSuite csSuiteData = new HySExecSuite(true, sAfterExeName, sExeName, sParam);
            csSuiteData.SetDelayTime(300); // 起動前に300m秒の待ちを加える
            csExecutor.AddExecSuite(csSuiteData);

            // 終了時起動プログラムを設定する
            // HSToolDelete.exe を起動する
            sAfterExeName = "HymcoLibDelete";// CommonMP本体が終了するのを待つ
            sExeName = "HSToolDelete.exe";
            sParam = "";// 起動パラメーターは無し
            csSuiteData = new HySExecSuite(true, sAfterExeName, sExeName, sParam);
            csSuiteData.SetDelayTime(300); // 起動前に300m秒の待ちを加える
            csExecutor.AddExecSuite(csSuiteData);

            // XMLファイル書き出し
            csExecutor.WriteXML(new HySString("..\\temp\\exit.xml"));
        }

        /// <summary><para>method outline</para>
        /// <para>画面クローズ時のScreen削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteScreen( csString )</para>
        /// </example>
        /// <param name="csString">スクリーン識別情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面のクローズ化に伴うスクリーンインスタンス削除処理</para>
        /// </remarks>
        override public void DeleteScreen(HySString csString)
        {
            base.DeleteScreen(csString);
            if (m_lScreenNum <= 2)
            {
                ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.SYSTEMSTART);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>メニューコールバック処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = MenuCallBack( lCallBackNo,bCheckOnOff ) </para>
        /// </example>
        /// <param name="lCallBackNo">メニューコールバック番号</param>
        /// <param name="bCheckOnOff">チェックオンオフフラグ</param>
        /// <returns>＝０：正常、≠０：異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override long MenuCallBack(long lCallBackNo, Boolean bCheckOnOff)
        {
            long lRtn = 0;
            HySString csKind = null;
            HySString csGroup = null;
            HySString csKey = null;
            HySID csID = null;
            HySScreen csScreen = null;

            if (lCallBackNo == McDefine.HYMCO_FILE_NEW || lCallBackNo == McDefine.HYMCO_PROJECT_NEW)    // Ver1.1 追加
            {   // 新規作成(N)

                csKind = new HySString("");
                csGroup = new HySString("");
                csKey = new HySString(McDefine.PROJECTSCREEN_ID);
                //csID = new HySID(csKind, csGroup, csKey);
                csID = new HySID(csKind + csGroup + csKey);
                if (!PutEvent(HySEventObject.CMND_DISPLY_COMMON, lCallBackNo, csID))
                {
                    lRtn = -1;
                }
            }
            else if (lCallBackNo == McDefine.HYMCO_PROJECT_CALC_BUILD ||
                     lCallBackNo == McDefine.HYMCO_PROJECT_CALC_START ||
                     lCallBackNo == McDefine.HYMCO_PROJECT_CALC_STOP ||
                     lCallBackNo == McDefine.HYMCO_PROJECT_CALC_PAUSE ||
                     lCallBackNo == McDefine.HYMCO_DB_SEARCH ||
                     lCallBackNo == McDefine.HYMCO_DB_REGIST ||
                     lCallBackNo == McDefine.HYMCO_PROJECT_CALC_RESET||
                     lCallBackNo == McDefine.HYMCO_PROJECT_OPEN ||      // Ver1.1 追加
                     lCallBackNo == McDefine.HYMCO_PROJECT_SAVE_NEW)    // Ver1.1 追加
            {   // ビルド・計算開始・再開、計算中断、計算終了、計算リセット

                //プロジェクトスクリーン取得
                csScreen = GetScreen(McDefine.PROJECTSCREEN_ID);
                if (csScreen != null)
                {
                    ((HySDotNetScreen)csScreen).MenuCallBack(lCallBackNo);
                }
            }
            else if (lCallBackNo == McDefine.HYMCO_FILE_CLOSE)
            {   // 閉じる(C)
                lRtn = FileClose();
            }
            else if (lCallBackNo == McDefine.HYMCO_FILE_OPEN)
            {   // 開く
                lRtn = FileOpen();
            }
            else if (lCallBackNo == McDefine.HYMCO_FILE_SAVE)
            {   // 上書き保存
                lRtn = FileSave();
            }
            else if (lCallBackNo == McDefine.HYMCO_FILE_SAVE_NEW)
            {   // 名前を付けて保存
                lRtn = FileSaveAs();
            }
            //else if (lCallBackNo == McDefine.HYMCO_EDIT_UNDO ||
            //         lCallBackNo == McDefine.HYMCO_EDIT_REDO ||
            //         lCallBackNo == McDefine.HYMCO_EDIT_CUT ||
            //         lCallBackNo == McDefine.HYMCO_EDIT_COPY ||
            //         lCallBackNo == McDefine.HYMCO_EDIT_PASTE ||
            //         lCallBackNo == McDefine.HYMCO_EDIT_DELETE ||
            else if (lCallBackNo == McDefine.HYMCO_EDIT_SELECTALL ||
                    lCallBackNo == McDefine.HYMCO_EDIT_MOVE_TOP ||
                    lCallBackNo == McDefine.HYMCO_EDIT_MOVE_BOTTOM ||
                    lCallBackNo == McDefine.HYMCO_EDIT_PART_GROUP ||
                    lCallBackNo == McDefine.HYMCO_EDIT_CONVEGENT_CALC_GROUP ||
                    lCallBackNo == McDefine.HYMCO_EDIT_DISBAND ||
                    lCallBackNo == McDefine.HYMCO_MODEL_LOAD_PROJECT ||
                    lCallBackNo == McDefine.HYMCO_MODEL_PART_DISPLAY ||
                    lCallBackNo == McDefine.HYMCO_MODEL_PART_CLOSE ||
                    lCallBackNo == McDefine.HYMCO_MODEL_CALCRESULT_VIEWERDISP ||
                    lCallBackNo == McDefine.HYMCO_MODEL_CALCRESULT_FILEDISP ||
                    lCallBackNo == McDefine.HYMCO_MODEL_STRUCTINFO_READ ||
                    //lCallBackNo == McDefine.HYMCO_MODEL_STRUCTINFO_WRITE ||
                    lCallBackNo == McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_PART ||
                    lCallBackNo == McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL ||
                    lCallBackNo == McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_SEPARATE ||
                    lCallBackNo == McDefine.HYMCO_MODEL_GUIDMAP ||
                    lCallBackNo == McDefine.HYMCO_MODEL_CUSTUMIZE ||
                    lCallBackNo == McDefine.HYMCO_MODEL_CHECK ||
                    lCallBackNo == McDefine.HYMCO_PROJECT_PARA_SET)
            {   // モデル管理関連メニューコールバック
                csScreen = this.GetActiveScreen();
                if (csScreen != null)
                {
                    ((HySDotNetScreen)csScreen).MenuCallBack(lCallBackNo);
                }
            }
            else if (lCallBackNo == McDefine.HYMCO_EDIT_UNDO ||
                lCallBackNo == McDefine.HYMCO_EDIT_REDO ||
                lCallBackNo == McDefine.HYMCO_EDIT_CUT ||
                lCallBackNo == McDefine.HYMCO_EDIT_COPY ||
                lCallBackNo == McDefine.HYMCO_EDIT_PASTE ||
                lCallBackNo == McDefine.HYMCO_EDIT_DELETE)
            {
                 csScreen = this.GetFocusOnScreen();
                if (csScreen != null)
                {
                    ((HySDotNetScreen)csScreen).MenuCallBack(lCallBackNo);
                }
           }
            else if (lCallBackNo == McDefine.HYMCO_MODEL_DISP_ID_ON)
            {   // モデル：ＩＤを表示（ON/OFF)
                if (bCheckOnOff == false)
                {
                    lCallBackNo = McDefine.HYMCO_MODEL_DISP_ID_OFF;
                }
                this.AllScreenMenuCall(lCallBackNo);
            }
            else if (lCallBackNo == McDefine.HYMCO_MODEL_DISP_NAME_ON)
            {   // モデル：名前を表示（ON/OFF)
                if (bCheckOnOff == false)
                {
                    lCallBackNo = McDefine.HYMCO_MODEL_DISP_NAME_OFF;
                }
                this.AllScreenMenuCall(lCallBackNo);
            }
            else if (lCallBackNo == McDefine.HYMCO_LIBRARY_SET ||
                     lCallBackNo == McDefine.HYMCO_LIBRARY_RELEASE)
            {   // ライブラリ設定／解除
                HySString csPrcKind = (HySString)m_csSimKindID.GetString();
                HySString csPrcID = new HySString(McDefine.LIBRARYSCREEN_ID);
                HySString csPrcKey = csPrcKind + csPrcID;
                csScreen = this.GetScreen(csPrcKey);
                if (csScreen != null)
                {
                    ((HySDotNetScreen)csScreen).MenuCallBack(lCallBackNo);
                }
            }
            else if (lCallBackNo == McDefine.HYMCO_TOOL_MODEL_GENERATOER )
            {      // HYMCO 系 モデルジェネレーター
                // 業務に通知（モデルジェネレーター画面表示要求）
                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISP_SCREEN);
                csEventObj.SetToSimKind(McDefine.SIMULATOR_KIND);
                //HySSimulationDataContainer csContainer = null;// (HySSimulationDataContainer)csHySEvent.GetData();
                //csEventObj.SetData(csContainer);
                csEventObj.SetData(HySDefine.SIMULATION_DATA_GENERATOR);
                //csEventObj.SetData(McDefine.HYM_MDL_DATA_GENERATOR_CTL_SCREEN);
                //csEventObj.SetSubData(HySDefine.SIMULATION_DATA_GENERATOR);
                //csEventObj.SetSuppID(new HySID(HySDefine.SIMULATION_DATA_GENERATOR_SCREEN_ID));
                csEventObj.SetSuppID(new HySID(McDefine.HYM_MDL_DATA_GENERATOR_CTL_SCREEN_ID));
                m_csViewer.PutEvent(csEventObj);
            }
            //else if (lCallBackNo == McDefine.HYMCO_TOOL_GIS)
            //{   // GIS表示
            //}
            else if (lCallBackNo == McDefine.HYMCO_TOOL_WRAPPER_MODEL_EDIT)
            {      // HYMCO 系 ラッパーモデル情報編集
                // 業務に通知（ラッパーモデル情報編集画面表示要求）
                HySEventObject csEventObj = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, HySEventObject.CMND_DISP_SCREEN);
                csEventObj.SetToSimKind(McDefine.SIMULATOR_KIND);
                csEventObj.SetData(HySDefine.WRAPPER_MODELINFO_EDIT);
                csEventObj.SetSuppID(new HySID(McDefine.HYM_WRAPPER_MODELINFO_EDIT_CTL_SCREEN_ID));
                m_csViewer.PutEvent(csEventObj);
            }
            // プロジェクト－インポート
            else if ( lCallBackNo == McDefine.HYMCO_DB_IMPORT )
            {
                lRtn = ImportProject();
            }
            // プロジェクト－エクスポート
            else if ( lCallBackNo == McDefine.HYMCO_DB_EXPORT )
            {
                //プロジェクトスクリーン取得
                csScreen = GetScreen(McDefine.PROJECTSCREEN_ID);
                if (csScreen != null)
                {
                    // 検索画面を開く
                    ((HySDotNetScreen)csScreen).MenuCallBack(McDefine.HYMCO_DB_SEARCH);
                }
            }
            // ライブラリ管理-ライブラリ入力
            else if (lCallBackNo == McDefine.HYMCO_HELP_CTL_LIB_IMPORT)
            {
                ImportLibrary();
            }
            // ライブラリ管理-ライブラリ出力
            else if (lCallBackNo == McDefine.HYMCO_HELP_CTL_LIB_EXPORT)
            {
                ExportLibrary();
            }
            else if (lCallBackNo == McDefine.HYMCO_HELP_CTL_LIB_DELETE)
            {
                // ライブラリ削除
                this.DeleteLibrary();
            }
// Ver1.1 追加 >>>
            // 上書き保存
            else if (lCallBackNo == McDefine.HYMCO_PROJECT_SAVE)
            {
                this.SaveProjectFile();
            }
            // プロジェクト－ポータブルデータ作成
            else if (lCallBackNo == McDefine.HYMCO_PROJECT_EXPORT)
            {
                this.MakePortableData();
            }
            // プロジェクト－ポータブルデータ取込
            else if (lCallBackNo == McDefine.HYMCO_PROJECT_IMPORT)
            {
                this.TakePortableData();
            }
            // データフォルダー格納先設定
            else if (lCallBackNo == McDefine.HYMCO_SETTING_DATAFOLDER)
            {
                this.SettingDataFolder();
            }
            // データフォルダー格納先設定
            else if (lCallBackNo == McDefine.HYMCO_SETTING_GISPATH)
            {
                this.SettingGISPath();
            }
// Ver1.1 追加 <<<
// Ver1.1 追加 >>>
            // データフォルダー格納先設定
            else if (lCallBackNo == McDefine.HYMCO_MODEL_OPTIMIZE_TRANINFR)
            {
                this.OptimizeTranInfo();
            }
// Ver1.1 追加 <<<
            else if (lCallBackNo == HySDotNetViewerDefine.SYSTEM_CHANGE)
            {   // システム切り替え

                DialogResult result = MessageBox.Show(MC_MSG_QUESTION_SYSTEM_CHANGE, MC_MSG_TITLE_SYSTEM_CHANGE, MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
                if (result == DialogResult.Yes)
                {
                    HySExcecutor csExecutor = new HySExcecutor();

                    // 終了時起動プログラムを設定する
                    // No.1　HymcoLibDelete.exe を起動する
                    string sAfterExeName = "CommonMPMain";// CommonMP本体が終了するのを待つ
                    string sExeName = "HymcoLibDelete.exe";
                    string sParam = "";// 起動パラメーターは無し
                    HySExecSuite csSuiteData = new HySExecSuite(true, sAfterExeName, sExeName, sParam);
                    csSuiteData.SetDelayTime(300); // 起動前に300m秒の待ちを加える
                    csExecutor.AddExecSuite(csSuiteData);

                    // No.2 HSToolDelete.exeを起動する
                    sAfterExeName = "HymcoLibDelete";
                    //sExeName = "cmd.exe";  // <-- バッチファイルを起動する場合
                    //sParam = "/c \"UserSysCommonMPStart.bat\"";  // <-- バッチファイルを起動する場合
                    sExeName = "HSToolDelete.exe";
                    csSuiteData = new HySExecSuite(true, sAfterExeName, sExeName, sParam);
                    csSuiteData.SetDelayTime(300); // 起動前に300m秒の待ちを加える
                    csExecutor.AddExecSuite(csSuiteData);

                    // No.3 CommonMPMain.exeを起動する
                    sAfterExeName = "HSToolDelete";
                    //sExeName = "cmd.exe";  // <-- バッチファイルを起動する場合
                    //sParam = "/c \"UserSysCommonMPStart.bat\"";  // <-- バッチファイルを起動する場合
                    sExeName = "CommonMPMain.exe";

                    HySString csChangeFile = HySEnvInf.GetEnvInf("SYSTEM_CHANGE_CONFIG_FILENAME");
                    sParam = "-c " + csChangeFile.ToString();
                    csSuiteData = new HySExecSuite(true, sAfterExeName, sExeName, sParam);
                    csExecutor.AddExecSuite(csSuiteData);

                    // XMLファイル書き出し
                    csExecutor.WriteXML(new HySString("..\\temp\\exit.xml"));

                    // システムの終了処理へ移行
                    lRtn = ((HySDotNetViewer)m_csViewer).MenuCallBack(HySDotNetViewerDefine.SYSTEM_EXIT, new HySString("CommonSysBusiProcedure"), false);

                    if (lRtn == 10)
                    {
                        HySString csExitFile = new HySString("..\\temp\\exit.xml");
                        HySFile csExit = new HySFile(csExitFile);
                        csExit.Delete();

                        csExecutor = new HySExcecutor();

                        // 終了時起動プログラムを設定する
                        // No.1　HymcoLibDelete.exe を起動する
                        sAfterExeName = "CommonMPMain";// CommonMP本体が終了するのを待つ
                        sExeName = "HymcoLibDelete.exe";
                        sParam = "";// 起動パラメーターは無し
                        csSuiteData = new HySExecSuite(true, sAfterExeName, sExeName, sParam);
                        csSuiteData.SetDelayTime(300); // 起動前に300m秒の待ちを加える
                        csExecutor.AddExecSuite(csSuiteData);

                        // No.2 HSToolDelete.exeを起動する
                        sAfterExeName = "HymcoLibDelete";
                        //sExeName = "cmd.exe";  // <-- バッチファイルを起動する場合
                        //sParam = "/c \"UserSysCommonMPStart.bat\"";  // <-- バッチファイルを起動する場合
                        sExeName = "HSToolDelete.exe";
                        csSuiteData = new HySExecSuite(true, sAfterExeName, sExeName, sParam);
                        csSuiteData.SetDelayTime(300); // 起動前に300m秒の待ちを加える
                        csExecutor.AddExecSuite(csSuiteData);

                        // XMLファイル書き出し
                        csExecutor.WriteXML(new HySString("..\\temp\\exit.xml"));
                        lRtn = 0;
                    }
                }
            }
            // Ver1.5 追加（プロジェクトプロパティ画面）
            else if (lCallBackNo == McDefine.HYMCO_PROJECT_DISP_PROPERTY)
            {    //プロジェクト管理：プロジェクトプロパティ表示        long HYMCO_PROJECT_DISP_PROPERTY = 30610;
                this.DispProjectProperty(); // ﾌﾟﾛｼﾞｪｸﾄ ﾌﾟﾛﾊﾟﾃｨ画面表示
            }
            else
            {
                lRtn = -1;
            }
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>フォーカスオンスクリーン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = GetFocusOnScreen( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>アクティブスクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySScreen GetFocusOnScreen()
        {
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            HySScreen csScreenWork = null;
            HySScreen csScreenResult = null;

            csScreenResult = base.GetFocusOnScreen();
            if (csScreenResult == null)
            {
                for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
                {
                    csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                    csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()] as McDotNetModelCtlScreen;
                    if (csScreen != null)
                    {
                        csScreenWork = ((McDotNetModelCtlScreen)csScreen).GetFocusOnScreen();
                        {
                            if (csScreenWork != null)
                            {
                                csScreenResult = csScreenWork;
                                break;
                            }
                        }
                    }
                }
            }
            return csScreenResult;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            m_bWorkFlg = true;
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            m_bWorkFlg = false;
            HySString csPrcKey = null;
            HySScreen csScreen = null;
            // 全スクリーンの終了処理を実行
            for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
            {
                csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                if (csScreen != null)
                {
                    csScreen.Terminate();
                    csScreen = null;
                }
            }
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            if (m_bWorkFlg)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>アクティブなプロジェクトを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csActiveProjectID = GetActiveProject( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>アクティブなプロジェクトの識別子。アクティブなプロジェクトが無い場合はnullを返す。</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetActiveProject()
        {
           // HySScreen csScreen = ((HySDotNetViewer)m_csViewer).GetActiveScreen();
            HySScreen csScreen = this.GetActiveScreen();
            if (IComparable.Equals(csScreen, null))
            {
                return null;
            }
            return (HySID)csScreen.GetID();
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            String csMethod = "McDotNetViewerJob.EventCallback";

            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            long lSubEventNo = csHySEvent.GetSubEventNo();
            HySID csID = ((HySEventObject)csEvent).GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)((HySEventObject)csEvent).GetToSimKind();

            if (lEventNo == HySEventObject.NOTICE_END_SIMULATOR_SAVE)
            {
                if (lSubEventNo == McDefine.HYMCO_FILE_SAVE || lSubEventNo == McDefine.HYMCO_FILE_SAVE_NEW)
                {
                    // 演算中断保存処理で正常完了報告
                    // メニューマスク解除・カーソルをデフォルトに戻す。
                    ((HySDotNetMainForm)((HySDotNetViewer)(m_csViewer)).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.END_PROCESS);
                    ((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.Default;
                    // 完了報告メッセージを表示する
                    ShowMessage(lSubEventNo, true);

                    // 「上書き保存」、「名前を付けて保存」の場合は、付属データ2が設定されている場合
                    // がある(「閉じる」処理から呼ばれた場合)ので、付属データ2に設定されたイベントの処理を行う
                    if (csHySEvent.GetSubData() != null)
                    {
                        if (!m_csViewer.PutEvent((HySEventObject)csHySEvent.GetSubData()))
                        {
                           // ver1.5 エラートレース日本語対応
                            HySLog.LogOut(HySLog.ONLINE, csMethod,
                                Properties.McDotNetViewerResources.STATEMENT_SEND_FAILURE );
                           // HySLog.LogOut(HySLog.ONLINE, csMethod, "イベント送信失敗");
                            return false;
                        }
                    }
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_END_SIMULATOR_SAVE_NG)
            {
                // 演算中断保存処理で異常報告
                // メニューマスク解除・カーソルをデフォルトに戻す。
                ((HySDotNetMainForm)((HySDotNetViewer)(m_csViewer)).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.END_PROCESS);
                ((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.Default;
                // 異常報告メッセージを表示する
                ShowMessage(lSubEventNo, false);
            }
            else if (lEventNo == HySEventObject.NOTICE_SIMULATION_NG)
            {
                // 上書き保存失敗時
                if (lSubEventNo == McDefine.HYMCO_FILE_SAVE)
                {
                    // エラーメッセージ取得
                    HySString csMsgStr = (HySString)csHySEvent.GetData();

                    // 上書き保存用ファイルパス無し時
                    if (csMsgStr == McDefine.ERR_SAVE_NO_FILE_PATH)
                    {
                        // 名前を付けて保存実行
                        if (FileSaveAs((HySEventObject)csHySEvent.GetSubData()) != 0)
                        {
                            return false;
                        }
                    }
                    else
                    {
                        // サブイベントごとに異常報告メッセージを表示する
                        ShowMessage(lSubEventNo, false);
                    }
                }
                else
                {
                    // サブイベントごとに異常報告メッセージを表示する
                    ShowMessage(lSubEventNo, false);
                }
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_MESSAGE)
            {
                if (lSubEventNo == McDefine.HYM_PROJECT_OPEN_NG)
                {
                    // 演算中断復元処理で開く対象のシミュレータがすでに存在する場合                    
                    //HySString csMessage = new HySString("同一ＩＤのプロジェクトが既に開かれています。\n") + new HySString("プロジェクト名称：");
                    //HySSimulationDataContainer csContainer = (HySSimulationDataContainer)csHySEvent.GetData();
                    //McProjectInfData csProjectInfo = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
                    //csMessage = csMessage + csProjectInfo.GetProjectName();
                    //MessageBox.Show(csMessage.ToString(), "水・物質循環解析ソフトウェア共通基盤　CommonMP", MessageBoxButtons.OK, MessageBoxIcon.Warning);

                    HySString msgboxMsg = new HySString(MC_MSG_WARNING_OPEN_PROJECT);
                    HySString msgboxTitle = new HySString(MC_MSG_TITLE_PROJECT_MANAGEMENT);
                    HySSimulationDataContainer csContainer = (HySSimulationDataContainer)csHySEvent.GetData();
                    McProjectInfData csProjectInfo = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
                    StringBuilder strBuilder = new StringBuilder(msgboxMsg.ToString());                                                
                    strBuilder.Append(csProjectInfo.GetProjectName().ToString());
                    msgboxMsg.Replace(msgboxMsg.ToString(), strBuilder.ToString());
                    MessageBox.Show(msgboxMsg.ToString(), msgboxTitle.ToString(), MessageBoxButtons.OK, MessageBoxIcon.Warning);

                    // メニューマスク解除・カーソルをデフォルトに戻す。
                    ((HySDotNetMainForm)((HySDotNetViewer)(m_csViewer)).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.END_PROCESS);
                    ((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.Default;
                }
                else if (lSubEventNo == McDefine.HYM_SIMU_CREATE_NG)
                {
                    // シミュレータの作成に失敗した場合
                    // メッセージの表示等
                }
                else if (lSubEventNo == McDefine.HYMCO_FILE_OPEN)
                {
                    // 演算中断復元処理でシミュレータ復元異常報告
                    // メニューマスク解除・カーソルをデフォルトに戻す。
                    ((HySDotNetMainForm)((HySDotNetViewer)(m_csViewer)).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.END_PROCESS);
                    ((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.Default;
                    // 異常報告メッセージを表示する
                    ShowMessage(lSubEventNo, false);
                }
            }
            else if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {  // 個別画面の生成及び表示を行う。
                bRtn = CmndShowScreen(csEvent);
                HySObjectKind csScreenKind = ((HySEventObject)csEvent).GetData() as HySObjectKind;
                if (csScreenKind != null)
                {
                    //if (csScreenKind.Equals(McDefine.HYM_LIBRARYCTL_SCREEN) == true)
                    //{
                    //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskMode(false, HySDotNetViewerDefine.MENU_FILE_REG, HySDotNetViewerDefine.MENU_FILE_REG_INDEX);
                    //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_SAVE_NEW, HySDotNetViewerDefine.MENU_CAL_SAVE_NEW_INDEX);
                    //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskMode(false, HySDotNetViewerDefine.MENU_CAL_SAVE_UPDATE, HySDotNetViewerDefine.MENU_CAL_SAVE_UPDATE_INDEX);
                    //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskMode(false, HySDotNetViewerDefine.MENU_STRUCT_FILE, HySDotNetViewerDefine.MENU_STRUCT_FILE_INDEX);
                    //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskMode(false, HySDotNetViewerDefine.MENU_STRUCT_READ, HySDotNetViewerDefine.MENU_STRUCT_READ_INDEX);
                    //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskMode(false, HySDotNetViewerDefine.MENU_STRUCT_WRITE_SIMPLE, HySDotNetViewerDefine.MENU_STRUCT_WRITE_SIMPLE_INDEX);
                    //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskMode(false, HySDotNetViewerDefine.MENU_STRUCT_WRITE_ALL, HySDotNetViewerDefine.MENU_STRUCT_WRITE_ALL_INDEX);
                    //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskMode(false, HySDotNetViewerDefine.MENU_STRUCT_WRITE_DEVIDE, HySDotNetViewerDefine.MENU_STRUCT_WRITE_DEVIDE_INDEX);
                    //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskMode(false, HySDotNetViewerDefine.MENU_EDIT, HySDotNetViewerDefine.MENU_EDIT_INDEX);
                    //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskMode(false, HySDotNetViewerDefine.MENU_PROJECT, HySDotNetViewerDefine.MENU_PROJECT_INDEX);
                    //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskMode(false, HySDotNetViewerDefine.MENU_LIBRARY, HySDotNetViewerDefine.MENU_LIBRARY_INDEX);
                    //    ((HySDotNetMainForm)((HySDotNetViewer)m_csViewer).GetMainForm()).SetMaskMode(false, HySDotNetViewerDefine.MENU_MODEL, HySDotNetViewerDefine.MENU_MODEL_INDEX);
                    //}
                }
            }
            else if (lEventNo == HySEventObject.ARBITRARY_EVENT ||
                     lEventNo == HySEventObject.CMND_DISPLY_COMMON
                     )
            {
                if (lSubEventNo == McDefine.HYM_MODEL_SCREEN_CLOSE)
                {
                    // モデル管理画面を閉じる指示
                    HySScreen csScreen = GetScreen(csHySEvent.GetSuppID());
                    if (csScreen != null)
                    {
                        csScreen.CloseScreen();
                        bRtn = true;
                    }
                }
                else if (lSubEventNo == McDefine.HYMCO_FILE_CLOSE)
                {
                    //ファイル閉じる指示
                    if (FileClose() != 0)
                    {
                        return false;
                    }
                }
                if (lSubEventNo == McDefine.HYM_NOTICE_DATACONTAINER_SET)
                {
                    for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
                    {
                        HySString csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                        HySScreen csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                        if (csScreen != null)
                        {
                            csScreen.EventCallback(csEvent);            // 該当スクリーンのコールバック処理
                            bRtn = true;
                        }
                    }
                }
                else
                {
                    // 該当スクリーンを決定する
                    HySString csPrcID = (HySString)csID.GetString();
                    HySString csPrcKind = (HySString)csSimKind.GetString();
                    HySString csPrcKey = csPrcKind + csPrcID;
                    HySScreen csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                    if (csScreen != null)
                    {
                        csScreen.EventCallback(csEvent);            // 該当スクリーンのコールバック処理
                        bRtn = true;
                    }
                }
            }
            // シミュレーション報告イベント
            // DB関連報告イベント
            // 画面表示・消去報告イベント
            else if (lEventNo == HySEventObject.CMND_BROADCAST_SCREEN ||
                    lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION ||
                    lEventNo == HySEventObject.NOTICE_START_SIMULATION ||
                    lEventNo == HySEventObject.NOTICE_CANNOT_START_SIMULATION ||
                    lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION ||
                    lEventNo == HySEventObject.NOTICE_STOP_SIMULATION ||
                    lEventNo == HySEventObject.NOTICE_REPORT_SIMU_PROGRESS ||
                    lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION ||
                    lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND ||
                    lEventNo == HySEventObject.NOTICE_RENEW_SIMULATION ||
                    lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION ||
                    lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION ||
                    lEventNo == HySEventObject.NOTICE_DB_OK ||
                    lEventNo == HySEventObject.NOTICE_DB_NG ||
                    lEventNo == HySEventObject.NOTICE_DISPLY_OK ||
                    lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_RUN_COMPLETE ||
                    lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RSD_EXIT_COMPLETE||
                    lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_RUN_COMPLETE ||
                    lEventNo == HySEventObject.NOTICE_EXTDBTOOL_RW_EXIT_COMPLETE)
            {
                // プロジェクトインポート報告イベント
                if (lSubEventNo == McDefine.HYM_PRJDATA_IMPORT)
                {
                    ((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.Default;

                    //プロジェクトスクリーン取得
                    HySScreen csScreen = GetScreen(McDefine.PROJECTSCREEN_ID);
                    if (csScreen != null)
                    {
                        ((HySDotNetScreen)csScreen).EventCallback(csEvent);
                    }
                }
                else
                {
                    bRtn = false;
                    // 全スクリーンに対して送信
                    for (long lLp = 1; lLp <= m_lScreenNum; lLp++)
                    {
                        HySString csPrcKey = (HySString)m_csScreenKeyList[(int)(lLp - 1)];
                        HySScreen csScreen = (HySScreen)m_csScreenTbl[csPrcKey.ToString()];
                        if (csScreen != null)
                        {
                            csScreen.EventCallback(csEvent);            // 該当スクリーンのコールバック処理
                            bRtn = true;
                        }
                    }
                }
            }
            else if (lEventNo == HySEventObject.CMND_GIS_COMMON)
            {   // ＧＩＳ関連指示
                HySScreen csScreen = null;
                if (lSubEventNo == HySGISDefine.GET_GIS_INFO)
                {   // ＧＩＳ情報作成
                } 
                else if (lSubEventNo == HySGISDefine.GET_GIS_INFO_OK)
                {   // ＧＩＳ情報作成ＯＫ
                    csScreen = GetScreen(McDefine.HYM_MDL_DATA_GENERATOR_CTL_SCREEN_ID);
                    if (csScreen != null)
                    {
                        csScreen.EventCallback(csEvent);
                    }
                }
                else if (lSubEventNo == HySGISDefine.GET_GIS_INFO_NG)
                {   // ＧＩＳ情報作成ＮＧ
                    csScreen = GetScreen(McDefine.HYM_MDL_DATA_GENERATOR_CTL_SCREEN_ID);
                    if (csScreen != null)
                    {
                        csScreen.EventCallback(csEvent);
                    }
                }
            }
            else if (lEventNo == HySEventObject.CMND_SIMULATION_COMMON)
            {   // 共通シミュレーションコマンド
                if (lSubEventNo == HySSimulatorDefine.SIMULATION_DATA_CREATE)
                {
                    HySScreen csScreen = GetScreen(McDefine.HYM_MDL_DATA_GENERATOR_CTL_SCREEN_ID);
                    if (csScreen != null)
                    {
                        csScreen.EventCallback(csEvent);
                    }
                }
                else if (lSubEventNo == McDefine.ACK_OPTIMIZE_RECORD_NUMBER || lSubEventNo == McDefine.NAK_OPTIMIZE_RECORD_NUMBER)
                {   // 最適化処理完了通知を受け取った場合の処理
                    this.NoticeOptimizeTranInfo((HySEventObject)csEvent);
                }
                else
                {
                }
            }
// start of Ver1.1 追加
            else if (lEventNo == HySEventObject.CMND_NEW_SIMULATOR_CREATE)
            {// 新規プロジェクト
                if (lSubEventNo == McDefine.HYMCO_PROJECT_NEW)
                {
                    McProjectInfData csNewPrjData = csHySEvent.GetSubData() as McProjectInfData;
                    // 此処で、データフォルダー等を作成する
                    this.MakeProjectGroupFolder(csNewPrjData);
                }
            }
            //else if (lEventNo == HySEventObject.CMND_DB_REGISTER)
            //{
            //    McProjectInfData csNewPrjData = csHySEvent.GetSubData() as McProjectInfData;
            //    this.MakeProjectGroupFolder(csNewPrjData); // プロジェクトフォルダ作成

            //    HySSimulationDataContainer csContainer = null; // = csPrjFile.DataRead() as HySSimulationDataContainer;
            //    // 何とかして、データコンテナを取得する
            //    csContainer.SetData(McDefine.HYM_DATA_PROJECT_INFO, csNewPrjData);
            //    SaveProject(csNewPrjData, csContainer);
            //}
            else if (lEventNo == HySEventObject.CMND_PROJECT_SAVE)
            {// 名前を付けて保存、上書き保存
                HySSimulationDataContainer csContainer = csHySEvent.GetData() as HySSimulationDataContainer;
                McProjectInfData csNewPrjData = csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO) as McProjectInfData;

                //プロジェクトスクリーン取得
                HySScreen csScreen = GetScreen(McDefine.PROJECTSCREEN_ID);
                if (csScreen != null)
                {
                    // メニューマスク＆マウスカーソル変更（時計マーク）
                    ((HySDotNetMainForm)((HySDotNetViewer)(m_csViewer)).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.IN_PROCESS);
                    ((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.WaitCursor;
                    System.Threading.Thread.Sleep(300);

                    ((HySEventObject)csEvent).SetEventNo(SaveProject(csNewPrjData, csContainer));
                    ((HySDotNetScreen)csScreen).EventCallback(csEvent);

                    // メニューマスク＆マウスカーソル変更（時計マーク）
                    ((HySDotNetMainForm)((HySDotNetViewer)(m_csViewer)).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.END_PROCESS);
                    ((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.Default;

                }
            }
            else if (lEventNo == HySEventObject.CMND_PROJECT_SAVE_ACT)
            {
                if (lSubEventNo == McDefine.HYMCO_PROJECT_SAVE)
                {
                    // 上書き保存
                    this.SaveProjectFile();
                }
                else if (lSubEventNo == McDefine.HYMCO_PROJECT_SAVE_NEW)
                {   // 名前を付けて保存
                    //プロジェクトスクリーン取得
                    HySScreen csScreen = GetScreen(McDefine.PROJECTSCREEN_ID);
                    if (csScreen != null)
                    {
                        ((HySDotNetScreen)csScreen).MenuCallBack(McDefine.HYMCO_PROJECT_SAVE_NEW);
                    }
                }
            }
// end of Ver1.1 追加
            else
            {
               // ver1.5 エラートレース日本語対応
                string DispStatement = Properties.McDotNetViewerResources.STATEMENT_UNSUPPORT_EVEN + lEventNo.ToString()
                    + Properties.McDotNetViewerResources.STATEMENT_SUB_EVENT + lSubEventNo.ToString();
                HySLog.LogOut(HySLog.ONLINE, csMethod, DispStatement );
               // HySLog.LogOut(HySLog.ONLINE, csMethod, "処理対象外イベント: イベント番号: " + lEventNo.ToString() +
               //     " サブイベント番号: " + lSubEventNo.ToString());
            }

            this.ChangeMenuStatus(csEvent);

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルオープンメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = FileOpen() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected long FileOpen()
        {
            OpenFileDialog csOpenFileDlg = new OpenFileDialog();
            csOpenFileDlg.InitialDirectory = HySEnvInf.GetHomeDirectory().ToString() + TEMP_FOLDER;
            csOpenFileDlg.Filter = Properties.McDotNetViewerResources.FILE_DLG_FILTER_PRJCT;    //"プロジェクトファイル(*.prjct)|*.prjct"
            csOpenFileDlg.Title = Properties.McDotNetViewerResources.FILE_DLG_TITLE_OPEN_FILE;  //"開くファイルを選択してください"
            csOpenFileDlg.RestoreDirectory = true;
            if (csOpenFileDlg.ShowDialog() == DialogResult.OK)
            {
                HySString csFileName = new HySString(csOpenFileDlg.FileName);

                // 重複チェック↓↓↓↓↓
                HySFile csPrjFile = new HySFile(csOpenFileDlg.FileName);
                csPrjFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                try
                {
                    HySFileOutData csFileOutData = (HySFileOutData)csPrjFile.DataRead();
                    csPrjFile.Close();

                    if (csFileOutData != null)
                    {
                        HySSimulationDataContainer csContainer = (HySSimulationDataContainer)csFileOutData.GetContainer();
                        if (csContainer != null)
                        {
                            McProjectInfData csProjectInf = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
                            if (csProjectInf != null)
                            {
                                HySString csPrjGrName = csProjectInf.GetProjectGroupName();
                                HySString csPrjName = csProjectInf.GetProjectName();
                                
                                // モデル管理画面で既に使用されているプロジェクト名のチェック
                                HySScreen csScreen = GetScreen(McDefine.PROJECTSCREEN_ID);
                                if (csScreen != null)
                                {
                                    if (((McDotNetProjectCtlScreen)csScreen).IsManageProject(csPrjGrName.ToString() + "_" + csPrjName.ToString()) == true)
                                    {
                                        MessageBox.Show(MSG_ERROR_PROJECT_EXIST, MC_MSG_TITLE_PROJECT_MANAGEMENT, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                                        return 0;
                                    }
                                }

                                //// 上書き保存チェック
                                //HySString csProjectFile = HySEnvInf.GetDataHomeDirectory() + "\\" + csPrjGrName + "\\" + csPrjName + ".cmprj";
                                //HySFile csFile = new HySFile(csProjectFile);
                                //if (csFile.Exist() == true)
                                //{// 既に同一ファイル有り。
                                //    if (MessageBox.Show(MSG_MSG_INFO_FILE_EXIST, MC_MSG_TITLE_PROJECT_MANAGEMENT, MessageBoxButtons.OKCancel) == DialogResult.Cancel)
                                //    {// 保存キャンセル
                                //        return 0;
                                //    }
                                //}
                            }
                        }
                    }
                }
                catch
                {
                }
                // 重複チェック↑↑↑↑↑

                // メニューマスク＆マウスカーソル変更（時計マーク）
                ((HySDotNetMainForm)((HySDotNetViewer)(m_csViewer)).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.IN_PROCESS);
                ((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.WaitCursor;

                if (!PutEvent(HySEventObject.CMND_SIMULATOR_RESTORE, McDefine.HYMCO_FILE_OPEN, null, csFileName))
                {
                    return -1;
                }
            }
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>名前を付けて保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = FileSaveAs() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected long FileSaveAs()
        {
            return FileSaveAs(null);
        }

        /// <summary><para>method outline:</para>
        /// <para>名前を付けて保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = FileSaveAs(csNextEvent) </para>
        /// </example>
        /// <param name="csNextEvent">付属イベント。業務へ送るイベントに設定され、イベント処理が終わると本イベントが処理される。</param>
        /// <returns>0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected long FileSaveAs(HySEventObject csNextEvent)
        {
            HySID csActiveID = GetActiveProject();
            if (csActiveID == null)
            {
                // 保存対象プロジェクトがない場合は何もしない
                return 0;
            }

            McDotNetModelCtlScreen csScreen = (McDotNetModelCtlScreen)this.GetActiveScreen();
            SaveFileDialog csSaveFileDlg = new SaveFileDialog();
            //csSaveFileDlg.FileName = "新しいプロジェクト名称.prjct";
            csSaveFileDlg.FileName = csScreen.GetProjectName().ToString();
            csSaveFileDlg.InitialDirectory = HySEnvInf.GetHomeDirectory().ToString() + TEMP_FOLDER;
            // プロジェクトグループディレクトリ
            //string csDataDirectory = HySEnvInf.GetHomeDirectory().ToString() + new HySString("\\..\\CommonMPData").ToString() + @"\" + csScreen.GetProjectGroupName().ToString();
            //csSaveFileDlg.InitialDirectory = csDataDirectory;
            csSaveFileDlg.Filter = Properties.McDotNetViewerResources.FILE_DLG_FILTER_PRJCT;    //"プロジェクトファイル(*.prjct)|*.prjct"
            csSaveFileDlg.Title = Properties.McDotNetViewerResources.FILE_DLG_TITLE_SAVE_FILE;  //"保存先のファイルを入力してください"
            csSaveFileDlg.RestoreDirectory = true;
            try
            {
                if (csSaveFileDlg.ShowDialog() == DialogResult.OK)
                {
                    HySString csFileName = new HySString(csSaveFileDlg.FileName);
                    // ダイアログにてプロジェクトファイル拡張子以外で入力された場合には、".prjct"を付加して保存処理を行う
                    if (csSaveFileDlg.FileName.Substring(csSaveFileDlg.FileName.Length - 6, 6) != Properties.McDotNetViewerResources.FILE_DLG_EXTENSION_PRJCT)
                    {
                        csFileName += Properties.McDotNetViewerResources.FILE_DLG_EXTENSION_PRJCT;
                    }

                    // メニューマスク＆マウスカーソル変更（時計マーク）
                    ((HySDotNetMainForm)((HySDotNetViewer)(m_csViewer)).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.IN_PROCESS);
                    ((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.WaitCursor;

                    if (!PutEvent(HySEventObject.CMND_SIMULATOR_SAVE, McDefine.HYMCO_FILE_SAVE_NEW, csActiveID, csFileName, csNextEvent))
                    {
                        return -1;
                    }
                }
                else
                {
                    // メニューマスク＆マウスカーソル変更（時計マーク）
                    ((HySDotNetMainForm)((HySDotNetViewer)(m_csViewer)).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.END_PROCESS);
                    ((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.Default;
                    // 付属イベントがある場合は、付属イベントを送る。
                    if (csNextEvent != null)
                    {
                        if (!m_csViewer.PutEvent(csNextEvent))
                        {
                            return -1;
                        }
                    }
                }
            }
            catch (InvalidOperationException csExp)
            {
                //MessageBox.Show(csExp.Message.ToString(),"エラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
				MessageBox.Show(csExp.Message.ToString(), MC_MSG_TITLE_PROJECT_MANAGEMENT, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return -1;
            }
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>上書き保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = FileSave() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected long FileSave()
        {
            return FileSave(null);
        }

        /// <summary><para>method outline:</para>
        /// <para>上書き保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = FileSave(csNextEvent) </para>
        /// </example>
        /// <param name="csNextEvent">付属イベント。業務へ送るイベントに設定され、イベント処理が終わると本イベントが処理される。</param>
        /// <returns>0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected long FileSave(HySEventObject csNextEvent)
        {
            HySID csActiveID = GetActiveProject();
            if (csActiveID == null)
            {
                // 保存対象のプロジェクトが存在しない場合は、何もしない
                return 0;
            }
            // メニューマスク＆マウスカーソル変更（時計マーク）
            ((HySDotNetMainForm)((HySDotNetViewer)(m_csViewer)).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.IN_PROCESS);
            ((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.WaitCursor;
            if (!PutEvent(HySEventObject.CMND_SIMULATOR_SAVE, McDefine.HYMCO_FILE_SAVE, csActiveID, null, csNextEvent))
            {
                return -1;
            }

            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>閉じる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = FileClose() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0:=正常,-1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected long FileClose()
        {
            HySID csActiveID = GetActiveProject();
            if (csActiveID == null)
            {
                // 閉じる対象プロジェクトが存在しない場合は、何もしない
                return 0;
            }

            McDotNetModelCtlScreen csScreen = (McDotNetModelCtlScreen)this.GetActiveScreen();
            McSimulationStatus csStatus = csScreen.GetSimulationStatusData();

            if (csStatus.GetModelSaveStatus() == McSimulationStatus.ModelSaveStatus.UNSAVED)
            {
                //Ｖ1.0対応→
                //DialogResult result = MessageBox.Show("プロジェクト：[" + csScreen.GetProjectName().ToString() + "]の変更を保存しますか?", "水・物質循環解析ソフトウェア共通基盤　CommonMP", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button3);
                
                HySString msgboxMsg = new HySString(MC_MSG_QUESTION_CONFILM_SAVE);
                HySString msgboxTitle = new HySString(MC_MSG_TITLE_PROJECT_MANAGEMENT);
                StringBuilder strBuilder = new StringBuilder(msgboxMsg.ToString());
                strBuilder.Append(csScreen.GetProjectName().ToString());
                msgboxMsg.Replace(msgboxMsg.ToString(), strBuilder.ToString());
                DialogResult result = MessageBox.Show(msgboxMsg.ToString(), msgboxTitle.ToString(),
                    MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button3);
                
                if (result == DialogResult.Yes)
                {
                    // 名前を付けて保存処理を行い、その後画面を閉じる必要がある。
                    HySEventObject csNextEvent = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON);
                    csNextEvent.SetSubEventNo(McDefine.HYMCO_FILE_CLOSE);
                    csNextEvent.SetToSimKind(m_csSimKindID);
                    csNextEvent.SetSuppID(GetActiveProject());
                    return FileSave(csNextEvent);
                }
                else if (result == DialogResult.Cancel)
                {
                    // キャンセルの場合は何もしない
                    return 0;
                }
                //Ｖ1.0対応←
            }

            // プロジェクトを閉じる
            if (PutEvent(HySEventObject.CMND_DISPLY_COMMON, McDefine.HYMCO_FILE_CLOSE, GetActiveProject()))
            {
                return -1;
            }

            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント送信メソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PutEvent(lNo, lSubNo, csData)</para>
        /// </example>
        /// <param name="lNo">イベント番号</param>
        /// <param name="lSubNo">サブイベント番号</param>
        /// <param name="csID">付属識別子</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>イベントの送り先は業務。</para>
        /// </remarks>
        protected Boolean PutEvent(long lNo, long lSubNo, HySID csID)
        {
            return PutEvent(lNo, lSubNo, csID, null);
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント送信メソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PutEvent(lNo, lSubNo, csID, csData)</para>
        /// </example>
        /// <param name="lNo">イベント番号</param>
        /// <param name="lSubNo">サブイベント番号</param>
        /// <param name="csID">付属識別子</param>
        /// <param name="csData">付属データ1</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>イベントの送り先は業務。</para>
        /// </remarks>
        protected Boolean PutEvent(long lNo, long lSubNo, HySID csID, HySDataRoot csData)
        {
            return PutEvent(lNo, lSubNo, csID, csData, null);
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント送信メソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PutEvent(lNo, lSubNo, csID, csData, csSubData)</para>
        /// </example>
        /// <param name="lNo">イベント番号</param>
        /// <param name="lSubNo">サブイベント番号</param>
        /// <param name="csID">付属識別子</param>
        /// <param name="csData">付属データ1</param>
        /// <param name="csSubData">付属データ2</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>イベントの送り先は業務。</para>
        /// </remarks>
        protected Boolean PutEvent(long lNo, long lSubNo, HySID csID, HySDataRoot csData, HySDataRoot csSubData)
        {
            String csMethod = "McDotNetViewerJob.PutEvent";
            HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_BUSIPROCEDURE, lNo, lSubNo);
            csEventObject.SetToSimKind(m_csSimKindID);
            csEventObject.SetSuppID(csID);
            csEventObject.SetData(csData);
            csEventObject.SetSubData(csSubData);
            if (!m_csViewer.PutEvent(csEventObject))
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, csMethod, Properties.McDotNetViewerResources.STATEMENT_SEND_FAILURE );
               // HySLog.LogOut(HySLog.ONLINE, csMethod, "イベント送信失敗");
                return false;
            }
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetScreen(csPrjID)</para>
        /// </example>
        /// <param name="csPrjID">プロジェクトID</param>
        /// <returns>スクリーン。対応するものが無い場合はnullが返る。</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySScreen GetScreen(HySID csPrjID)
        {
            HySString csPrcKind = (HySString)m_csSimKindID.GetString();
            HySString csPrcID = (HySString)csPrjID.GetString();
            HySString csPrcKey = csPrcKind + csPrcID;
            return this.GetScreen(csPrcKey);
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetScreen(csID)</para>
        /// </example>
        /// <param name="csID">画面識別子</param>
        /// <returns>スクリーン。対応するものが無い場合はnullが返る。</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySScreen GetScreen(String csID)
        {
            HySString csPrcKind = (HySString)m_csSimKindID.GetString();
            HySString csPrcKey = csPrcKind + new HySString(csID);
            return this.GetScreen(csPrcKey);
        }

        /// <summary><para>method outline:</para>
        /// <para>メッセージ表示メソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ShowMessage(lSubEventNo, bCheck) </para>
        /// </example>
        /// <param name="lSubEventNo">サブイベント</param>
        /// <param name="bCheck">成功失敗フラグ</param>
        /// <returns>0:=正常,-1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected long ShowMessage(long lSubEventNo, Boolean bCheck)
        {
            long lRtn = 0;

            HySString msgboxMsg = null;
            HySString msgboxTitle = new HySString(MC_MSG_TITLE_PROJECT_MANAGEMENT);

            if (lSubEventNo == McDefine.HYMCO_FILE_SAVE ||
                lSubEventNo == McDefine.HYMCO_FILE_SAVE_NEW)
            {
                if (bCheck == true)
                {
                    //MessageBox.Show("保存が完了しました。", "水・物質循環解析ソフトウェア共通基盤　CommonMP",
                    //MessageBoxButtons.OK,
                    //MessageBoxIcon.Information);

                    msgboxMsg = new HySString(MC_MSG_INFO_SAVE_PROJECT);
                    MessageBox.Show(msgboxMsg.ToString(), msgboxTitle.ToString(),MessageBoxButtons.OK,MessageBoxIcon.Information);
                }
                else
                {
                    //MessageBox.Show("保存に失敗しました。", "水・物質循環解析ソフトウェア共通基盤　CommonMP",                
                    //MessageBox.Show(msgboxMsg.ToString(), msgboxTitle.ToString(),
                    //MessageBoxButtons.OK,
                    //MessageBoxIcon.Error);
                    msgboxMsg = new HySString(MC_MSG_ERR_SAVE_PROJECT);
                    MessageBox.Show(msgboxMsg.ToString(), msgboxTitle.ToString(),MessageBoxButtons.OK,MessageBoxIcon.Error);
                }
            }
            else if (lSubEventNo == McDefine.HYMCO_FILE_OPEN)
            {
                if (bCheck == false)
                {
                    //MessageBox.Show("シミュレーション復元に失敗しました。", "水・物質循環解析ソフトウェア共通基盤　CommonMP", 
                    //MessageBoxButtons.OK,
                    //MessageBoxIcon.Error);

                    msgboxMsg = new HySString(MC_MSG_ERR_READ_PROJECT);
                    MessageBox.Show(msgboxMsg.ToString(), msgboxTitle.ToString(), MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトインポート</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ImportProject() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>0:=正常,-1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected long ImportProject()
        {
            // ファイルオープンダイアログ設定
            OpenFileDialog csOpenFileDlg = new OpenFileDialog();
            csOpenFileDlg.InitialDirectory = HySEnvInf.GetHomeDirectory().ToString() + TEMP_FOLDER;
            csOpenFileDlg.Filter = IMPORT_DIALOG_FILTER;
            csOpenFileDlg.Title = IMPORT_DIALOG_TITLE;
            csOpenFileDlg.RestoreDirectory = true;
            
            // ダイアログ表示
            if (csOpenFileDlg.ShowDialog() == DialogResult.OK)
            {
                // ファイルパス取得
                HySString csFileName = new HySString(csOpenFileDlg.FileName);

                // イベント送信
                if (!PutEvent(HySEventObject.CMND_DB_COMMON, McDefine.HYM_PRJDATA_IMPORT, null, csFileName))
                {
                    return -1;
                }

                //プロジェクトスクリーン取得
                HySScreen csScreen = GetScreen(McDefine.PROJECTSCREEN_ID);
                if (csScreen != null)
                {
                    // 処理中画面表示
                    ((HySDotNetScreen)csScreen).MenuCallBack(McDefine.HYMCO_DB_IMPORT);
                }
            }

            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ画面クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelPropertyScreen csScreen 
        ///            = CreatePropertyScreen( csSimulatorKind, csElmID, csLibID, csModelKind) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csElmID">モデル要素識別子</param>
        /// <param name="csLibID">ライブラリ識別子</param>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>プロパティ画面クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McModelPropertyScreen CreatePropertyScreen(HySKind csSimulatorKind, HySIdentifier csElmID, HySIdentifier csLibID, HySKind csModelKind)
        {
            McModelPropertyScreen csRtn = null;
            HySScreenFactorySet csHySFctrSet = m_csScreenFactory as HySScreenFactorySet;

            McPropertyScreenFactorySet csMcPrptyFctrSet = csHySFctrSet.GetFactory(McDefine.FACTORY_ID_PROPERTY_SCREEN_SET) as McPropertyScreenFactorySet;
            /*
            long lFctryNum = csHySFctrSet.GetFactoryNum();
            for (long lLp = 0; lLp < lFctryNum; lLp++)
            {
                csMcPrptyFctrSet = csHySFctrSet.GetFactory(lLp) as McPropertyScreenFactorySet;
                if (csMcPrptyFctrSet != null)
                {
                    break;
                }
            }
            */
            if (csMcPrptyFctrSet != null)
            {
                csRtn = csMcPrptyFctrSet.CreatePropertyScreen(csSimulatorKind, csElmID, csLibID, csModelKind);
            }
            //HySScreenFactorySet を取得して　
            //HySScreenFactorySet.CreatePropertyScreen()をコールする
            //return this.m_csScreenFactory;
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>個別モデル用設定スクリーンクラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelDataGeneratorScreen csMdlNetworkGen 
        ///            = CreateModelDataGeneratorScreen( csSimulatorKind, csLibID, csModelKind) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csLibID">ライブラリ識別子</param>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelDataGeneratorScreen 個別モデル用設定スクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelDataGeneratorScreen CreateModelDataGeneratorScreen(HySKind csSimulatorKind, HySIdentifier csLibID, HySKind csModelKind)
        {
            McModelDataGeneratorScreen csRtnScreen = null;

            // ２重に起動しない仕組みが必要
            //csScreen = this.GetScreen(csSimKind, csID);
            //if (csScreen == null)
            //{
            //}
            HySScreenFactorySet csHySFctrSet = m_csScreenFactory as HySScreenFactorySet;

            McPropertyScreenFactorySet csMcPrptyFctrSet = csHySFctrSet.GetFactory(McDefine.FACTORY_ID_PROPERTY_SCREEN_SET) as McPropertyScreenFactorySet;
            if (csMcPrptyFctrSet != null)
            {
                csRtnScreen = csMcPrptyFctrSet.CreateModelDataGeneratorScreen(csSimulatorKind, csLibID, csModelKind);
            }

            return csRtnScreen;
        }

        /// <summary><para>method outline:</para>
        /// <para>個別モデル用設定スクリーンクラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelDataGeneratorScreen csMdlNetworkGen 
        ///            = CreateModelDataGeneratorSelectScreen( csSimulatorKind, csLibID, csModelKind) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csLibID">ライブラリ識別子</param>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelDataGeneratorScreen 個別モデル用設定スクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelGeneratorDataSelectScreen CreateModelDataGeneratorSelectScreen(HySKind csSimulatorKind, HySIdentifier csLibID, HySKind csModelKind)
        {
            McModelGeneratorDataSelectScreen csRtnScreen = null;

            // ２重に起動しない仕組みが必要
            //csScreen = this.GetScreen(csSimKind, csID);
            //if (csScreen == null)
            //{
            //}
            HySScreenFactorySet csHySFctrSet = m_csScreenFactory as HySScreenFactorySet;

            McPropertyScreenFactorySet csMcPrptyFctrSet = csHySFctrSet.GetFactory(McDefine.FACTORY_ID_PROPERTY_SCREEN_SET) as McPropertyScreenFactorySet;
            if (csMcPrptyFctrSet != null)
            {
                csRtnScreen = csMcPrptyFctrSet.CreateModelDataGeneratorSelectScreen(csSimulatorKind, csLibID, csModelKind);
            }

            return csRtnScreen;
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>個別モデル用設定スクリーンクラスの表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CmndShowModelDataGeneratorScreen( csSimulatorKind, csLibID, csModelKind) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csLibID">ライブラリ識別子</param>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>bool bRtn   true:正常  false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean CmndShowModelDataGeneratorScreen(HySKind csSimulatorKind, HySIdentifier csLibID, HySKind csModelKind)
        {
            bool bRtn = false;
            McModelDataGeneratorScreen csScreen = this.CreateModelDataGeneratorScreen(csSimulatorKind, csLibID, csModelKind);
            if (csScreen != null)
            {  // スクリーンが有効の場合
                csScreen.Initialize();
                this.SetScreen(csScreen);
                //csScreen.SetDispEventData(csEvent);
                csScreen.ShowScreen();
            }

            return bRtn;
        }
        */
        /// <summary><para>method outline:</para>
        /// <para>スクリーン生成ファクトリ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetScreen(csPrjID)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySScreenFactory スクリーンファクトリ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySScreenFactory GetScreenFactory()
        { 
            return this.m_csScreenFactory;
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルジェネレータが必要とするデータのリスト情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelGeneratorNeedDataList(csLibraryID, csModelKind )</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルジェネレータが必要とするデータのリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデルジェネレータが必要とするデータ(McMdlGenNeedData)をリスト形式で返却する</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelGeneratorNeedDataList(HySID csLibraryID, HySObjectKind csModelKind)
        {
            return McModelFactorySet.g_McModelFactorySet.GetModelGeneratorNeedDataList(csLibraryID, csModelKind);
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ImportLibrary() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void ImportLibrary()
        {
            // ライブラリ管理スクリーンよりインストール情報を取得する
            HySString csPrcKind = (HySString)m_csSimKindID.GetString();
            HySString csPrcID = new HySString(McDefine.LIBRARYSCREEN_ID);
            HySString csPrcKey = csPrcKind + csPrcID;
            HySScreen csScreen = this.GetScreen(csPrcKey);
            McLibraryInstallInfoData csInstallInfoData = null;
            if (csScreen != null)
            {
                csInstallInfoData = ((McDotNetLibraryCtlScreen)csScreen).GetLibraryInstallInfoData();
            }

            try
            {
                //★★★★★★★★★★★★★★★★★★★★
                // Ver1.4で追加(ライブラリ入力機能の改良)
                //★★★★★★★★★★★★★★★★★★★★
                // 入力情報ファイルの存在チェックは不要。

                //// 実行環境フォルダパス取得
                //HySString homeDir = HySEnvInf.GetHomeDirectory();
                //string fileFullPath = homeDir.ToString() + @"\temp\LibraryImportInfo";

                //// 入力情報ファイルが存在する場合は
                //// 再起動を促すメッセージを表示
                //if (System.IO.File.Exists(fileFullPath) == true)
                //{
                //    HySLog.LogOut(HySLog.ONLINE, "McDotNetViewerJob", "ImportLibrary",
                //        "ライブラリ入力情報ファイルが既に存在します。:" + fileFullPath.ToString());
                //    MessageBox.Show(
                //        MSG_ERR_NOT_COMPLETE_INSTALL,
                //        MC_MSG_TITLE_LIBRARY_REGISUT_SUPPORT,
                //        MessageBoxButtons.OK,
                //        MessageBoxIcon.Warning
                //        );
                //    return;
                //}

                // ライブラリ入力画面表示
                McDotNetLibraryImportForm libraryForm = new McDotNetLibraryImportForm();
                // インストール情報を入力画面に設定
                libraryForm.SetLibraryInstallInfoData(csInstallInfoData);
                libraryForm.ShowDialog();
            }
            catch(Exception e)
            {   // エラー内容をログ出力
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(
                    HySLog.ONLINE,
                    "McDotNetViewerJob",
                    "ImportLibrary",
                    Properties.McDotNetViewerResources.STATEMENT_LIBINFO_INPUT_ERR + Environment.NewLine + e.ToString()
                    );
               // HySLog.LogOut(
               //     HySLog.ONLINE,
               //     "McDotNetViewerJob",
               //     "ImportLibrary",
               //     "ライブラリ入力で例外発生" + Environment.NewLine + e.ToString()
               //     );
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ExportLibrary() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void ExportLibrary()
        {
            try
            {
                // ライブラリ出力画面表示
                McDotNetLibraryExportForm libraryForm = new McDotNetLibraryExportForm();
                libraryForm.ShowDialog();
            }
            catch (Exception e)
            {   // エラー内容をログ出力
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(
                    HySLog.ONLINE,
                    "McDotNetViewerJob",
                    "ImportLibrary",
                    Properties.McDotNetViewerResources.STATEMENT_LIBINFO_OUTPUT_ERR + Environment.NewLine + e.ToString()
                    );
               // HySLog.LogOut(
               //     HySLog.ONLINE,
               //     "McDotNetViewerJob",
               //     "ImportLibrary",
               //     "ライブラリ出力で例外発生" + Environment.NewLine + e.ToString()
               //     );
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteLibrary() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void DeleteLibrary()
        {
            // ライブラリ管理スクリーンよりライブラリ削除処理をコールする
            HySString csPrcKind = (HySString)m_csSimKindID.GetString();
            HySString csPrcID = new HySString(McDefine.LIBRARYSCREEN_ID);
            HySString csPrcKey = csPrcKind + csPrcID;
            HySScreen csScreen = this.GetScreen(csPrcKey);
            if (csScreen != null)
            {
                ((McDotNetLibraryCtlScreen)csScreen).DeleteLibrary();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Zキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeUndoEvent( ) </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeUndoEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticeUndoEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Yキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRedoEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeRedoEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticeRedoEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Xキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCutEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCutEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticeCutEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Cキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeCopyEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeCopyEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticeCopyEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Vキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticePasteEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticePasteEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticePasteEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Delキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeDeleteEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeDeleteEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticeDeleteEvent();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>Ctrl+Aキーイベント通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeAllSelectEvent( ) </para>
        /// </example>
        /// <param name="lCallBackNo">コールバック番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void NoticeAllSelectEvent(long lCallBackNo)
        {
            HySScreen csScreeen = null;
            csScreeen = this.GetFocusOnScreen();
            if (csScreeen != null)
            {
                if (csScreeen as McDotNetModelCtlScreen != null)
                {   // モデル管理画面の場合は既存の処理に流す
                    this.MenuCallBack(lCallBackNo, false);
                }
                else
                {
                    // フォーカスオンのスクリーンがある場合のみ、通知する
                    csScreeen.NoticeAllSelectEvent();
                }
            }
        }

// Ver1.1 追加 >>>
              
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループフォルダーの作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MakeProjectGroupFolder(csPrjctInf) </para>
        /// </example>
        /// <param name="csPrjctInf">プロジェクト情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void MakeProjectGroupFolder(McProjectInfData csPrjctInf)
        {
            HySString  csDataHomeDir = HySEnvInf.GetDataHomeDirectory() + new HySString("\\");
            HySString csPrjGrName = csPrjctInf.GetProjectGroupName() + new HySString("\\");

            HySString csReadData = new HySString("InputData\\");
            HySString csParameterData = new HySString("ParameterData\\");
            HySString csOutputData = new HySString("OutputData\\");
            HySString csRefInfo = new HySString("RefInfo\\");
            HySString csSCF = new HySString("SCF\\");
            HySString csSupp = new HySString("Supp\\");
            HySString mkDirFile = new HySString("ReadMe.txt");

            HySFile csPrjGrFlder = new HySFile(csDataHomeDir + csPrjGrName + csReadData+mkDirFile);
            if (csPrjGrFlder.Exist() == false)
            {// ファイル無し、作成
                csPrjGrFlder.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
                csPrjGrFlder.WriteText("入力データ等格納場所");
                csPrjGrFlder.Close();
            }
            csPrjGrFlder = new HySFile(csDataHomeDir + csPrjGrName + csParameterData + mkDirFile);
            if (csPrjGrFlder.Exist() == false)
            {// ファイル無し、作成
                csPrjGrFlder.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
                csPrjGrFlder.WriteText("パラメーターデータ等格納場所");
                csPrjGrFlder.Close();
            }
            csPrjGrFlder = new HySFile(csDataHomeDir + csPrjGrName + csOutputData + mkDirFile);
            if (csPrjGrFlder.Exist() == false)
            {// ファイル無し、作成
                csPrjGrFlder.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
                csPrjGrFlder.WriteText("計算結果等格納場所");
                csPrjGrFlder.Close();
            }
            csPrjGrFlder = new HySFile(csDataHomeDir + csPrjGrName + csRefInfo + mkDirFile);
            if (csPrjGrFlder.Exist() == false)
            {// ファイル無し、作成
                csPrjGrFlder.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
                csPrjGrFlder.WriteText("本プロジェクトグループに関する解説等格納場所");
                csPrjGrFlder.Close();
            }
            csPrjGrFlder = new HySFile(csDataHomeDir + csPrjGrName + csSCF + mkDirFile);
            if (csPrjGrFlder.Exist() == false)
            {// ファイル無し、作成
                csPrjGrFlder.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
                csPrjGrFlder.WriteText("構造定義ファイル等格納場所");
                csPrjGrFlder.Close();
            }
            csPrjGrFlder = new HySFile(csDataHomeDir + csPrjGrName + csSupp + mkDirFile);
            if (csPrjGrFlder.Exist() == false)
            {// ファイル無し、作成
                csPrjGrFlder.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
                csPrjGrFlder.WriteText("その他の補足情報格納場所");
                csPrjGrFlder.Close();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトファイル上書き保存</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = SaveProjectFile() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected long SaveProjectFile()
        {
            HySID csActiveID = GetActiveProject();
            if (csActiveID == null)
            {
                // 保存対象のプロジェクトが存在しない場合は、何もしない
                return 0;
            }
            // メニューマスク＆マウスカーソル変更（時計マーク）
            //((HySDotNetMainForm)((HySDotNetViewer)(m_csViewer)).GetMainForm()).SetMaskPatern(HySDotNetViewerDefine.EventKind.IN_PROCESS);
            //((HySDotNetViewer)(m_csViewer)).GetMainForm().Cursor = Cursors.WaitCursor;

            if (!PutEvent(HySEventObject.CMND_PROJECT_SAVE_ACT, McDefine.HYMCO_PROJECT_SAVE, csActiveID, null, null))
            {
                return -1;
            }

            return 0;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>プロジェクト情報ファイル作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> lRtn = SaveProject(csPrjctInf,csContainer) </para>
        /// </example>
        /// <param name="csPrjctInf">プロジェクト情報</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <returns>0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected long SaveProject(McProjectInfData csPrjctInf, HySSimulationDataContainer csContainer)
        {
            long lRtn = HySEventObject.NOTICE_DB_OK;

            string sPrjFileName = HySEnvInf.GetDataHomeDirectory().ToString() + "\\"
                               + csPrjctInf.GetProjectGroupName().ToString() + "\\"
                               + csPrjctInf.GetProjectName().ToString() + ".cmprj";
            HySFile csPrjFile = new HySFile(sPrjFileName);
            if (csPrjFile.Open(HySFile.OPEN_MODE.CREATE, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) == 0)
            {
                try
                {
                    if (csPrjFile.DataWrite(csContainer) == false)
                    {
                        // エラー
                        lRtn = HySEventObject.NOTICE_DB_NG;
                    }
                }
                catch
                {
                    // エラー
                    lRtn = HySEventObject.NOTICE_DB_NG;
                }
                csPrjFile.Close();
            }
            else
            {
                // エラー
                lRtn = HySEventObject.NOTICE_DB_NG;
            }

            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>ポータブルデータ作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MakePortableData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void MakePortableData()
        {
            try
            {
                // ポータブルデータ作成画面表示
                McDotNetPortableDataMakeForm csPortableDataForm = new McDotNetPortableDataMakeForm();
                csPortableDataForm.ShowDialog();
            }
            catch (Exception e)
            {   // エラー内容をログ出力
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(
                    HySLog.ONLINE,
                    "McDotNetViewerJob",
                    "ImportLibrary",
                    Properties.McDotNetViewerResources.STATEMENT_PORTABL_DATA_NG + Environment.NewLine + e.ToString()
                    );
               // HySLog.LogOut(
               //     HySLog.ONLINE,
               //     "McDotNetViewerJob",
               //     "ImportLibrary",
               //     "ポータブルデータ作成で例外発生" + Environment.NewLine + e.ToString()
               //     );
            }
        }

        /// <summary><para>method outline:</para> STATEMENT_PORTABL_DATA_NG
        /// <para>ポータブルデータ取込</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> TakePortableData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void TakePortableData()
        {
            try
            {
                // ポータブルデータ取込処理
                //McPortableDataImport csPortableDataImport = new McPortableDataImport();
                McPortableDataImport csPortableDataImport = new McPortableDataImport(m_csViewer);
                csPortableDataImport.ImportData();

            }
            catch (Exception e)
            {   // エラー内容をログ出力
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(
                    HySLog.ONLINE,
                    "McDotNetViewerJob",
                    "TakePortableData",
                    Properties.McDotNetViewerResources.STATEMENT_PORTABL_IMPORT_ERR  + Environment.NewLine + e.ToString()
                    );
               // HySLog.LogOut(
               //     HySLog.ONLINE,
               //     "McDotNetViewerJob",
               //     "TakePortableData",
               //     "ポータブルデータ取込で例外発生" + Environment.NewLine + e.ToString()
               //     );
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>データフォルダー格納先設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SettingDataFolder() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void SettingDataFolder()
        {
            try
            {
                // ポータブルデータ取込画面表示
                McDotNetDataFolderSetForm csDataFolderSetForm = new McDotNetDataFolderSetForm();
                csDataFolderSetForm.ShowDialog();
            }
            catch (Exception e)
            {   // エラー内容をログ出力
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(
                    HySLog.ONLINE,
                    "McDotNetViewerJob",
                    "SettingDataFolder",
                    Properties.McDotNetViewerResources.STATEMENT_DATAF_SAVESET_ERR + Environment.NewLine + e.ToString()
                    );
               // HySLog.LogOut(
               //     HySLog.ONLINE,
               //     "McDotNetViewerJob",
               //     "SettingDataFolder",
               //     "データフォルダー格納先設定で例外発生" + Environment.NewLine + e.ToString()
               //     );
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>GIS起動パス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SettingGISPath() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void SettingGISPath()
        {
            OpenFileDialog csOpenFileDlg = new OpenFileDialog();
            csOpenFileDlg.InitialDirectory = HySEnvInf.GetHomeDirectory().ToString();
            csOpenFileDlg.Filter = GISPATH_DIALOG_FILTER;
            csOpenFileDlg.Title = GISPATH_DIALOG_TITLE;
            csOpenFileDlg.RestoreDirectory = true;
            if (csOpenFileDlg.ShowDialog() == DialogResult.OK)
            {
                HySString csFileName = new HySString(csOpenFileDlg.FileName);

                HySString csDataHomeIniFileName = HySEnvInf.GetHomeDirectory() + "\\conf\\DioVista.ini";

                HySIniFile csIniFile = new HySIniFile(csDataHomeIniFileName);

                // ファイル属性を取得
                FileAttributes csFas = File.GetAttributes(csDataHomeIniFileName.ToString());

                // 読み取り専用かどうか確認
                if ((csFas & FileAttributes.ReadOnly) == FileAttributes.ReadOnly)
                {
                    // ファイル属性から読み取り専用を削除
                    csFas = csFas & ~FileAttributes.ReadOnly;
                    // ファイル属性を設定
                    File.SetAttributes(csDataHomeIniFileName.ToString(), csFas);
                }

                bool bFlg = false;

                if (csIniFile.SetValue(new HySString("DIOVISTA_PATH"), csFileName, true) == 0)
                {// ファイルパス更新成功
                    bFlg = true;
                    // ローカルホストの設定確認
                    if ((object)csIniFile.GetValue(new HySString("DIOVISTA_HOST")) == null)
                    {// 設定無しの場合、デフォルト値をセット
                        if (csIniFile.SetValue(new HySString("DIOVISTA_HOST"), new HySString("127.0.0.1"), true) != 0)
                        {
                            bFlg = false;
                        }
                    }
                    // 接続ポートの設定確認
                    if ((object)csIniFile.GetValue(new HySString("DIOVISTA_PORT")) == null)
                    {// 設定無しの場合、デフォルト値をセット
                        if (csIniFile.SetValue(new HySString("DIOVISTA_PORT"), new HySString("12345"), true) != 0)
                        {
                            bFlg = false;
                        }
                    }
                }

                if(bFlg == true)
                {// 更新成功
                    MessageBox.Show(MC_MSG_INFO_COMPLETE_GISPATH, GISPATH_MSG_TITLE);
                }
                else
                {// 更新異常
                    MessageBox.Show(MC_MSG_ERR_SET_GISPATH, GISPATH_MSG_TITLE);
                }
            }

        }
// Ver1.1 追加 <<<

// start of Ver1.2 追加

        /// <summary><para>method outline:</para>
        /// <para>メニューから「伝送データ内のレコード数を最適化」が選択された時の処理を行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> OptimizeTranInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void OptimizeTranInfo()
        {
            // ダイアローグ表示：最適化するか？（アンドゥは出来ません）を問い合わせる
            if (
            MessageBox.Show(MC_MSG_QUESTION_OPTIMIZE_TRANINFO, MC_MSG_TITLE_OPTIMIZE_TRANINFO, MessageBoxButtons.YesNo, MessageBoxIcon.Question)
             == DialogResult.Yes)
            {
                // アクティブなモデル編集のIDを取得
                HySID csMdlID = this.GetActiveProject();

                // シミュレーターに対して　最適化を指示する
                HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_SIMULATION_COMMON, csMdlID); 
                csEventObject.SetSubEventNo(McDefine.REQ_OPTIMIZE_RECORD_NUMBER);
                csEventObject.SetToSimKind(m_csSimKindID);
                //csEventObject.SetSuppID(csID);
                //csEventObject.SetData(csData);
                //csEventObject.SetSubData(csSubData);
                m_csViewer.PutEvent(csEventObject);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>伝送データ内のレコード数最適化する処理の応答を受け取った時の処理を行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> OptimizeTranInfo() </para>
        /// </example>
        /// <param name="csEvent">応答イベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void NoticeOptimizeTranInfo( HySEventObject csEvent)
        {
            HySID csID = csEvent.GetSuppID();
            long lSubEventNo = csEvent.GetSubEventNo();
            if (lSubEventNo == McDefine.ACK_OPTIMIZE_RECORD_NUMBER)
            {   // 最適化が正常に行われた場合の処理

                // ここで　先ず、モデル管理画面のモデルチェック画面を更新したい。
                HySScreen csScreen = GetScreen(McDefine.SIMULATOR_KIND, csID);
                if (csScreen != null)
                {
                    // モデル構築済、モデル変更有とし、未保存状態に設定
                    McSimulationStatus csSimulationStatus = ((McDotNetModelCtlScreen)csScreen).GetSimulationStatusData();
                    csSimulationStatus.SetModelConStatus(McSimulationStatus.ModelConstructionStatus.CONSTRUCTED);
                    csSimulationStatus.SetModelModStatus(McSimulationStatus.ModelModificationStatus.MODIFIED_CONSTRUCTION_NOT_REQUIRED);
                    csEvent.SetEventNo(HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION);
                    csScreen.EventCallback(csEvent);
                }

                // メッセージ表示
                DialogResult csRtn = MessageBox.Show(MC_MSG_TITLE_OPTIMIZE_TRANINFO_OK, MC_MSG_TITLE_OPTIMIZE_TRANINFO, MessageBoxButtons.OK, MessageBoxIcon.Information);

            }
            else
            {   // 最適化時に異常を検出した場合の処理
                // ここで　先ず、モデル管理画面のモデルチェック画面を更新したい。
                HySScreen csScreen = GetScreen(McDefine.SIMULATOR_KIND, csID);
                if (csScreen != null)
                {
                    csEvent.SetEventNo(HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION);
                    csScreen.EventCallback(csEvent);
                }

                // メッセージ表示
                DialogResult csRtn = MessageBox.Show(MC_MSG_TITLE_OPTIMIZE_TRANINFO_NG, MC_MSG_TITLE_OPTIMIZE_TRANINFO, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }
// end of Ver1.2 追加

        // Ver1.5 追加（プロジェクトプロパティ画面）
        /// <summary><para>method outline:</para>
        /// <para>メニューから「プロジェクトプロパティ」が選択された時の処理を行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DispProjectProperty() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void DispProjectProperty()
        {
            // アクティブなプロジェクト情報を取得する
            List<McProjectModelInfo>  csModelInfoList;
            McDotNetModelCtlScreen          csActiveScreen = null;
            HySSimulationDataContainer      csDataContainer = null;
            McStructInfo                    csStructInfo = null;
            McProjectInfData csPrjctInfo = null;

            // アクティブなスクリーンを取得する
            csActiveScreen = this.GetActiveScreen() as McDotNetModelCtlScreen;

            if (csActiveScreen != null)
            {
                // データコンテナインスタンス取得
                csDataContainer = csActiveScreen.GetDataContainer();
                // プロジェクト構造体取得
                csStructInfo = csDataContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO) as McStructInfo;

                csPrjctInfo = csDataContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO) as McProjectInfData;
            }

            // プロジェクト内モデル一覧作成
            csModelInfoList = McMdlLibInfoMng.CreateProjectModelList(csStructInfo);

            McDotNetProjectPropertyDispForm csOpenFileDlg = new McDotNetProjectPropertyDispForm(csPrjctInfo, csModelInfoList);

            csOpenFileDlg.ShowDialog();
        }
    }  // end of class
}  // end of namespace
