﻿// <summary>ソースコード：ＨＹＭＣＯスクリーンファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>ＨＹＭＣＯスクリーンファクトリクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McDotNetScreenFactory : HySFactoryMono, HySScreenFactory //HySDotNetScreenFactory
    {
        /// <summary> 業務種別識別子  </summary>
        protected HySKind m_csSimKind = McDefine.SIMULATOR_KIND;

        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetScreenFactory csFactory = new McDotNetScreenFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetScreenFactory()
        {
            SetFactoryID(McDefine.FACTORY_ID_SCREEN);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetSimKind(HySKind csSimKindID)
        {
            //m_csSimKind = csSimKindID;
            // Do Nothing
        }
        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>業務種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return m_csSimKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">業務種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKind.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimulatorKind,csID,csScreenKind ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <param name="csScreenKind">画面種別</param>
        /// <returns>スクリーンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySScreen CreateScreen(HySKind csSimulatorKind, HySIdentifier csID, HySKind csScreenKind)
        {
            HySScreen csScreen = null;
            if (csSimulatorKind.Equals(McDefine.SIMULATOR_KIND) == true)
            {
                if (McDefine.HYM_PROJECTCTL_SCREEN.Equals(csScreenKind)==true )
                {
                    csScreen = (McDotNetProjectCtlScreen)new McDotNetProjectCtlScreen();
                }
                else if (McDefine.HYM_LIBRARYCTL_SCREEN.Equals(csScreenKind)==true)
                {
                    csScreen = (McDotNetLibraryCtlScreen)new McDotNetLibraryCtlScreen();
                }
                else if (McDefine.HYM_MODELCTL_SCREEN.Equals(csScreenKind) == true)
                {
                    csScreen = (McDotNetModelCtlScreen)new McDotNetModelCtlScreen();
                }
                //else if (McDefine.HYM_MDL_DATA_GENERATOR_CTL_SCREEN.Equals(csScreenKind) == true)
                else if (HySDefine.SIMULATION_DATA_GENERATOR.Equals(csScreenKind) == true)
                {   // モデルデータジェネレーター制御設定画面
                    csScreen = (McDotNetModelGenerateCtlScreen)new McDotNetModelGenerateCtlScreen();
                }
                else if (HySDefine.WRAPPER_MODELINFO_EDIT.Equals(csScreenKind) == true)
                {   // ラッパーモデル情報編集画面
                    csScreen = (McDotNetWrapperModelInfoEditCtlScreen)new McDotNetWrapperModelInfoEditCtlScreen();
                }
                else
                {
                }
            }
            return csScreen;
        }
    }
}
