﻿// <summary>ソースコード：画面情報管理クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

using CommonMP.HYMCO.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer
{
    /// <summary><para>class outline:</para>
    /// <para>画面情報管理クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/02/06][新規作成]</para>
    /// </remarks>
    static public class McViewerInfoManager 
    {
        /// <summary><para>class outline:</para>
        /// <para>表示プロジェクト名クラス</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2009/02/06][新規作成]</para>
        /// </remarks>
        public class McDispProjectName
        {
            HySString m_csPrjName;
            long m_lNo;

            /// <summary><para>method outline:</para>
            /// <para>コンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>McDispProjectName csDispName = new McDispProjectName(csPrjName, lNo)</para>
            /// </example>
            /// <param name="csPrjName">プロジェクト名</param>
            /// <param name="lNo">表示管理番号</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McDispProjectName(HySString csPrjName, long lNo)
            {
                m_csPrjName = csPrjName;
                m_lNo = lNo;
            }

            /// <summary><para>method outline:</para>
            /// <para>プロジェクト名取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>HySString csPrjName = GetPrjName()</para>
            /// </example>
            /// <returns>プロジェクト名</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public HySString GetPrjName()
            {
                return m_csPrjName;
            }

            /// <summary><para>method outline:</para>
            /// <para>表示管理番号取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>long lNo = GetNo()</para>
            /// </example>
            /// <returns>表示管理番号</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public long GetNo()
            {
                return m_lNo;
            }

            /// <summary><para>method outline:</para>
            /// <para>表示プロジェクト名取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>HySString csPrjName = GetDispName()</para>
            /// </example>
            /// <returns>表示プロジェクト名</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public HySString GetDispName()
            {
                // 管理番号0の場合は表示名称にNoをつけない
                if (m_lNo == 0)
                {
                    return m_csPrjName;
                }
                else
                {
                    // プロジェクト名と表示管理番号から表示用プロジェクト名を作成
                    string strDispName = m_csPrjName.ToString() + "<" + m_lNo.ToString() + ">";
                    return new HySString(strDispName);
                }
            }
        }

        /// <summary>表示プロジェクト名クラス管理ハッシュテーブル</summary>
        static private  Hashtable m_csDispPrjNameTbl = new Hashtable();
        /// <summary>プロジェクト名チェック用</summary>
        static private Regex m_csRege = new Regex(@"(?<subPrj>.*)<(?<num>\d*)>");

        /// <summary><para>method outline:</para>
        /// <para>表示プロジェクト名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csDispPrjName = GetDispProjectName(csPrjID,csPrjName)</para>
        /// </example>
        /// <param name="csPrjID">プロジェクトID</param>
        /// <param name="csPrjName">プロジェクト名</param>
        /// <returns>表示プロジェクト名文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public HySString GetDispProjectName(HySID csPrjID, HySString csPrjName )
        {
            // ハッシュテーブルより指定IDで表示名称クラスを取得
            McDispProjectName csDispPrjName = (McDispProjectName)m_csDispPrjNameTbl[csPrjID.GetString().ToString()];
            // 登録されていない場合は新規作成
            if (csDispPrjName == null)
            {
                long lNo = -1;
                // ハッシュテーブル内を検索
                foreach (string strID in m_csDispPrjNameTbl.Keys)
                {
                    csDispPrjName = (McDispProjectName)m_csDispPrjNameTbl[strID];
                    // 同一プロジェクト名の中でもっとも番号が大きいものを検索する
                    if (csDispPrjName.GetPrjName().Equal(csPrjName) && (lNo < csDispPrjName.GetNo()))
                    {
                        lNo = csDispPrjName.GetNo();
                    }
                    // 表示プロジェクト名と引数プロジェクト名が重複した場合
                    else if ((csDispPrjName.GetNo() != 0 ) && (csDispPrjName.GetDispName().Equal(csPrjName)))
                    {
                        // 括弧部分を取り除いたもので再度実行
                        HySString csSubPrjName = csDispPrjName.GetPrjName().Clone();
                        return GetDispProjectName(csPrjID, csSubPrjName);
                    }
                }
                Match csMatch = m_csRege.Match(csPrjName.ToString());
                if (csMatch.Success)
                {
                    csPrjName = new HySString(csMatch.Groups["subPrj"].Value);
                    Int64.TryParse(csMatch.Groups["num"].Value, out lNo);
                    lNo--;
                }
                // 番号を最大値＋1したものをハッシュテーブルに追加する
                m_csDispPrjNameTbl.Add(csPrjID.GetString().ToString(), new McDispProjectName(csPrjName, lNo+1));
                // クラスを設定
                csDispPrjName = (McDispProjectName)m_csDispPrjNameTbl[csPrjID.GetString().ToString()];
            }

            return csDispPrjName.GetDispName();
        }


        /// <summary><para>method outline:</para>
        /// <para>表示プロジェクト名削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McViewerInfoManager.RemoveDispProjectName(csPrjID)</para>
        /// </example>
        /// <param name="csPrjID">プロジェクトID</param>
        /// <returns>無し</returns>  
        /// <exception cref="">無し</exception>      
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public void RemoveDispProjectName(HySID csPrjID)
        {
            // ハッシュテーブル内から指定IDをキーとするアイテムを削除。
            m_csDispPrjNameTbl.Remove(csPrjID.GetString().ToString());
        }

    }
}
