﻿// <summary>ソースコード：ＨＹＭＣＯモデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;



using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;
namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.CoreOptions.McViewer.MdlGenScreenCommonLIB.McMdlGenCommonFactory();
        }
    }
}

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.CoreOptions.McViewer.MdlGenScreenCommonLIB
{
    /// <summary><para>class outline:</para>
    /// <para>モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McMdlGenCommonFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            // ToDo 本ファクトリクラスにユニークな識別子を生成して返してください
            return McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            // Do Nothing
            return null;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            // Do Nothing
            return null;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            // Do Nothing
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            // Do Nothing
            return null;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            // Do Nothing
            return null;
        }

        // ★★★
        // ================= モデルデータ半自動作成ツール用メソッド ============================
        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラス情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelNetworkGeneratorList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素モデルネットワーク生成クラス情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>演算要素モデルネットワーク生成クラス情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetModelNetworkGeneratorList()
        {
            // Do Nothing
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelNetworkGenerator csMdlNetworkGen = CreateModelNetworkGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelNetworkGenerator 演算要素モデルネットワーク生成クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McModelNetworkGenerator CreateModelNetworkGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            // Do Nothing
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデル用パラメータ情報半自動生成クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelParameterGenerator csParaGen = CreateModelParameterGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelParameterGenerator 演算モデル用パラメータ等情報生成</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McModelParameterGenerator CreateModelParameterGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            // Do Nothing
            return null;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルジェネレータが必要とするデータのリスト情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelGeneratorNeedDataList(csLibraryID, csModelKind )</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルジェネレータが必要とするデータのリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデルジェネレータが必要とするデータ(McMdlGenNeedData)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetModelGeneratorNeedDataList(HySID csLibraryID, HySObjectKind csModelKind)
        {
            HySDataLinkedList csRtnList = new HySDataLinkedList();

            //HySString cDataName = null;
            //HySObjectKind csDataKind = null;

            // GIS関連
            //McMdlGenNeedData csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, HySGISDataKindDefine.KIND_GIS_GENERAL_DATA, HySGISDataKindDefine.NAME_GIS_GENERAL_DATA);
            //csRtnList.AddLast(csNeedData);
            McMdlGenNeedData csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, HySGISDataKindDefine.KIND_GIS_DRAINAGE_DIRECTION_MATRIX, HySGISDataKindDefine.NAME_GIS_DRAINAGE_DIRECTION_MATRIX);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, HySGISDataKindDefine.KIND_GIS_SEA_LEVEL, HySGISDataKindDefine.NAME_GIS_SEA_LEVLE);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, HySGISDataKindDefine.KIND_GIS_RIVER_CROSS_SECTION, HySGISDataKindDefine.NAME_GIS_RIVER_CROSS_SECTION);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, HySGISDataKindDefine.KIND_GIS_LONGITUDINAL_SECTION, HySGISDataKindDefine.NAME_GIS_RIVER_LONGITUDINAL_SECTION);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, HySGISDataKindDefine.KIND_GIS_RIVER_DISTANCE_MARK, HySGISDataKindDefine.NAME_GIS_RIVER_DISTANCE_MARK);
            csRtnList.AddLast(csNeedData);
            //McMdlGenNeedData csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, HySGISDataKindDefine.KIND_GIS_MDL_DRAWING_FIGURE, HySGISDataKindDefine.NAME_GIS_MDL_DRAWING_FIGURE);
            //csRtnList.AddLast(csNeedData);

            // 手入力関連
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_1, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_1);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_2, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_2);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_3, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_3);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_4, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_4);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_5, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_5);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_6, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_6);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_7, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_7);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_8, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_8);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_9, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_9);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_10, McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_10);
            csRtnList.AddLast(csNeedData);

            return csRtnList;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルジェネレータが必要とする必須のデータを提供するか？</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = IsEssentialModelGenerationData( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:必須、=false:モデルによっては不要</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデルジェネレータが必要とするデータが必須か否かを返す（共通の画面上に表示する／しないを決める）</para>
        /// </remarks>
        public override bool IsEssentialModelGenerationData()
        { return true; }
        // ★★★
    }
}
