﻿// <summary>ソースコード：モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

namespace CommonMP.HYMCO.CoreOptions.McViewer.MdlGenScreenCommonLIB
{
    /// <summary><para>class outline:</para>
    /// <para>モデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McMdlGenCommonScreenDefine
    {
        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID MODEL_FACTORY_LIB_ID = McDotNetCommonDef.COMMON_MODEL_GEN_MANULAL_SCREEN_FACTORY_LIB_ID;


        //********************************
        //===== モデルジェネレーター関連クラス定義 ========
        //********************************

        //// <summary>河道利用計画モデル関連　情報設定画面名称</summary>
        //public static readonly HySString MODEL_GENERATOR_SCREEN_NAME_1 = new HySString("流量配分データ設定画面");
        /// <summary>河道利用計画モデル関連　情報設定画面種別</summary>
        public static readonly HySObjectKind MODEL_GENERATOR_DATA_KIND_1 = new HySObjectKind("MdlGenData1");
        /// <summary>河道利用計画モデル関連　情報名称</summary>
        //public static readonly HySString MODEL_GENERATOR_DATA_NAME_1 = new HySString("流量配分データ");
        public static readonly HySString MODEL_GENERATOR_DATA_NAME_1 = new HySString(Properties.McMdlGenCommonScreenResource.MODEL_GENERATOR_DATA_NAME_FLOWRATE);

        //// <summary>河道利用計画モデル関連　情報設定画面名称</summary>
        //public static readonly HySString MODEL_GENERATOR_SCREEN_NAME_2 = new HySString("河床材料データ設定画面");
        /// <summary>河道利用計画モデル関連　情報設定画面種別</summary>
        public static readonly HySObjectKind MODEL_GENERATOR_DATA_KIND_2 = new HySObjectKind("MdlGenData2");
        /// <summary>河道利用計画モデル関連　情報名称</summary>
        //public static readonly HySString MODEL_GENERATOR_DATA_NAME_2 = new HySString("河床材料データ");
        public static readonly HySString MODEL_GENERATOR_DATA_NAME_2 = new HySString(Properties.McMdlGenCommonScreenResource.MODEL_GENERATOR_DATA_NAME_RIVERBED);

        //// <summary>河道利用計画モデル関連　情報設定画面名称</summary>
        //public static readonly HySString MODEL_GENERATOR_SCREEN_NAME_3 = new HySString("植生データ設定画面");
        /// <summary>河道利用計画モデル関連　情報設定画面種別</summary>
        public static readonly HySObjectKind MODEL_GENERATOR_DATA_KIND_3 = new HySObjectKind("MdlGenData3");
        /// <summary>河道利用計画モデル関連　情報名称</summary>
        //public static readonly HySString MODEL_GENERATOR_DATA_NAME_3 = new HySString("植生データ");
        public static readonly HySString MODEL_GENERATOR_DATA_NAME_3 = new HySString(Properties.McMdlGenCommonScreenResource.MODEL_GENERATOR_DATA_NAME_VEGETATION);

        //// <summary>河道利用計画モデル関連　情報設定画面名称</summary>
        //public static readonly HySString MODEL_GENERATOR_SCREEN_NAME_4 = new HySString("河川構造物データ（堰）設定画面");
        /// <summary>河道利用計画モデル関連　情報設定画面種別</summary>
        public static readonly HySObjectKind MODEL_GENERATOR_DATA_KIND_4 = new HySObjectKind("MdlGenData4");
        /// <summary>河道利用計画モデル関連　情報名称</summary>
        //public static readonly HySString MODEL_GENERATOR_DATA_NAME_4 = new HySString("河川構造物データ（堰）");
        public static readonly HySString MODEL_GENERATOR_DATA_NAME_4 = new HySString(Properties.McMdlGenCommonScreenResource.MODEL_GENERATOR_DATA_NAME_WEIR);

        //// <summary>河道利用計画モデル関連　情報設定画面名称</summary>
        //public static readonly HySString MODEL_GENERATOR_SCREEN_NAME_5 = new HySString("河川構造物データ（橋脚）設定画面");
        /// <summary>河道利用計画モデル関連　情報設定画面種別</summary>
        public static readonly HySObjectKind MODEL_GENERATOR_DATA_KIND_5 = new HySObjectKind("MdlGenData5");
        /// <summary>河道利用計画モデル関連　情報名称</summary>
        //public static readonly HySString MODEL_GENERATOR_DATA_NAME_5 = new HySString("河川構造物データ（橋脚）");
        public static readonly HySString MODEL_GENERATOR_DATA_NAME_5 = new HySString(Properties.McMdlGenCommonScreenResource.MODEL_GENERATOR_DATA_NAME_PIER);

        //// <summary>河道利用計画モデル関連　情報設定画面名称</summary>
        //public static readonly HySString MODEL_GENERATOR_SCREEN_NAME_6 = new HySString("河川構造物データ（落差工）設定画面");
        /// <summary>河道利用計画モデル関連　情報設定画面種別</summary>
        public static readonly HySObjectKind MODEL_GENERATOR_DATA_KIND_6 = new HySObjectKind("MdlGenData6");
        /// <summary>河道利用計画モデル関連　情報名称</summary>
        //public static readonly HySString MODEL_GENERATOR_DATA_NAME_6 = new HySString("河川構造物データ（落差工）");
        public static readonly HySString MODEL_GENERATOR_DATA_NAME_6 = new HySString(Properties.McMdlGenCommonScreenResource.MODEL_GENERATOR_DATA_NAME_WATERFALL);

        //// <summary>河道利用計画モデル関連　情報設定画面名称</summary>
        //public static readonly HySString MODEL_GENERATOR_SCREEN_NAME_7 = new HySString("河川構造物データ（潜水橋）設定画面");
        /// <summary>河道利用計画モデル関連　情報設定画面種別</summary>
        public static readonly HySObjectKind MODEL_GENERATOR_DATA_KIND_7 = new HySObjectKind("MdlGenData7");
        /// <summary>河道利用計画モデル関連　情報名称</summary>
        //public static readonly HySString MODEL_GENERATOR_DATA_NAME_7 = new HySString("河川構造物データ（潜水橋）");
        public static readonly HySString MODEL_GENERATOR_DATA_NAME_7 = new HySString(Properties.McMdlGenCommonScreenResource.MODEL_GENERATOR_DATA_NAME_BRIDGE);

        //// <summary>河道利用計画モデル関連　情報設定画面名称</summary>
        //public static readonly HySString MODEL_GENERATOR_SCREEN_NAME_8 = new HySString("河川構造物データ（不明）設定画面");
        /// <summary>河道利用計画モデル関連　情報設定画面種別</summary>
        public static readonly HySObjectKind MODEL_GENERATOR_DATA_KIND_8 = new HySObjectKind("MdlGenData8");
        /// <summary>河道利用計画モデル関連　情報名称</summary>
        //public static readonly HySString MODEL_GENERATOR_DATA_NAME_8 = new HySString("河川構造物データ（不明）");
        public static readonly HySString MODEL_GENERATOR_DATA_NAME_8 = new HySString(Properties.McMdlGenCommonScreenResource.MODEL_GENERATOR_DATA_NAME_UNKNOWN);

        //// <summary>河道利用計画モデル関連　情報設定画面名称</summary>
        //public static readonly HySString MODEL_GENERATOR_SCREEN_NAME_9 = new HySString("その他／痕跡水位データ設定画面");
        /// <summary>河道利用計画モデル関連　情報設定画面種別</summary>
        public static readonly HySObjectKind MODEL_GENERATOR_DATA_KIND_9 = new HySObjectKind("MdlGenData9");
        /// <summary>河道利用計画モデル関連　情報名称</summary>
        //public static readonly HySString MODEL_GENERATOR_DATA_NAME_9 = new HySString("その他／痕跡水位データ");
        public static readonly HySString MODEL_GENERATOR_DATA_NAME_9 = new HySString(Properties.McMdlGenCommonScreenResource.MODEL_GENERATOR_DATA_NAME_OTHERS);

        //// <summary>河道利用計画モデル関連　情報設定画面名称</summary>
        //public static readonly HySString MODEL_GENERATOR_SCREEN_NAME_10 = new HySString("支川合流条件データ設定画面");
        /// <summary>河道利用計画モデル関連　情報設定画面種別</summary>
        public static readonly HySObjectKind MODEL_GENERATOR_DATA_KIND_10 = new HySObjectKind("MdlGenData10");
        /// <summary>河道利用計画モデル関連　情報名称</summary>
        //public static readonly HySString MODEL_GENERATOR_DATA_NAME_10 = new HySString("支川合流条件データ");
        public static readonly HySString MODEL_GENERATOR_DATA_NAME_10 = new HySString(Properties.McMdlGenCommonScreenResource.MODEL_GENERATOR_DATA_NAME_JOIN);

        //********************************
        //===== モデルジェネレーター　側の共通定義 ========
        //********************************
        /// <summary>情報：Ａセット　キーワード</summary>
        public static readonly HySString MODEL_SETTING_FILE = new HySString("MdlSetting");

    }
}
