﻿// <summary>ソースコード：モデル用プロパティスクリーンファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYMCO._SYSTEM_;
namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯスクリーンファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_SCREEN_FACTORY_CREATOR_IMPLE : PROPERTY_SCREEN_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_SCREEN_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_SCREEN_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_SCREEN_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルプロパティスクリーンファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyScreenFactoryBase CreateFactory()
        {
            return new CommonMP.HYMCO.CoreOptions.McViewer.MdlGenScreenCommonLIB.McMdlGenCommonScreenFactory();
        }
    }
}


namespace CommonMP.HYMCO.CoreOptions.McViewer.MdlGenScreenCommonLIB
{  
    /// <summary><para>class outline:</para>
    /// <para>モデル用プロパティスクリーンファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/25][新規作成]</para>
    /// </remarks>
    public class McMdlGenCommonScreenFactory : McPropertyScreenFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(csFactoryMng) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Init(HySFactoryMng csFactoryMng)
        {
            // ファクトリ管理クラス取得
            m_csFactoryMng = (HySFactoryManager)csFactoryMng;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            return McMdlGenCommonScreenDefine.MODEL_FACTORY_LIB_ID;
        }

 
        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ画面クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelPropertyScreen csScreen = CreatePropertyScreen( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelPropertyScreen モデルプロパティ画面クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McModelPropertyScreen CreatePropertyScreen(HySKind csModelKind)
        {
            // Do Nothing
            return null;
        }

        //
        // ================= モデルデータ半自動作成ツール用メソッド ============================
        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算要素モデルジェネレーター固有画面情報リスト提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelGeneratorScreenList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素モデルジェネレーター固有画面情報リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>演算要素モデルジェネレーター固有画面情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetModelGeneratorScreenList()
        {
            HySDataLinkedList csRtnList = new HySDataLinkedList();

            McModelInfo csModelInfo = null;

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_1,
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_1);

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McMdlGenCommonScreenResource.MODEL_SUMMARY_MG_SAMPLE); // "モデル生成の為の情報を設定する画面クラス"
            csModelInfo.SetCreatorInf(Properties.McMdlGenCommonScreenResource.MODEL_CREATOR_MG_SAMPLE); // "CommonMP 標準"

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_2,
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_2);

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McMdlGenCommonScreenResource.MODEL_SUMMARY_MG_SAMPLE); // "モデル生成の為の情報を設定する画面クラス"
            csModelInfo.SetCreatorInf(Properties.McMdlGenCommonScreenResource.MODEL_CREATOR_MG_SAMPLE); // "CommonMP 標準"

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_3,
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_3);

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McMdlGenCommonScreenResource.MODEL_SUMMARY_MG_SAMPLE); // "モデル生成の為の情報を設定する画面クラス"
            csModelInfo.SetCreatorInf(Properties.McMdlGenCommonScreenResource.MODEL_CREATOR_MG_SAMPLE); // "CommonMP 標準"

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_4,
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_4);

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McMdlGenCommonScreenResource.MODEL_SUMMARY_MG_SAMPLE); // "モデル生成の為の情報を設定する画面クラス"
            csModelInfo.SetCreatorInf(Properties.McMdlGenCommonScreenResource.MODEL_CREATOR_MG_SAMPLE); // "CommonMP 標準"

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_5,
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_5);

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McMdlGenCommonScreenResource.MODEL_SUMMARY_MG_SAMPLE); // "モデル生成の為の情報を設定する画面クラス"
            csModelInfo.SetCreatorInf(Properties.McMdlGenCommonScreenResource.MODEL_CREATOR_MG_SAMPLE); // "CommonMP 標準"

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_6,
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_6);

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McMdlGenCommonScreenResource.MODEL_SUMMARY_MG_SAMPLE); // "モデル生成の為の情報を設定する画面クラス"
            csModelInfo.SetCreatorInf(Properties.McMdlGenCommonScreenResource.MODEL_CREATOR_MG_SAMPLE); // "CommonMP 標準"

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_7,
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_7);

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McMdlGenCommonScreenResource.MODEL_SUMMARY_MG_SAMPLE); // "モデル生成の為の情報を設定する画面クラス"
            csModelInfo.SetCreatorInf(Properties.McMdlGenCommonScreenResource.MODEL_CREATOR_MG_SAMPLE); // "CommonMP 標準"

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_8,
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_8);

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McMdlGenCommonScreenResource.MODEL_SUMMARY_MG_SAMPLE); // "モデル生成の為の情報を設定する画面クラス"
            csModelInfo.SetCreatorInf(Properties.McMdlGenCommonScreenResource.MODEL_CREATOR_MG_SAMPLE); // "CommonMP 標準"

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_9,
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_9);

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McMdlGenCommonScreenResource.MODEL_SUMMARY_MG_SAMPLE); // "モデル生成の為の情報を設定する画面クラス"
            csModelInfo.SetCreatorInf(Properties.McMdlGenCommonScreenResource.MODEL_CREATOR_MG_SAMPLE); // "CommonMP 標準"

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_10,
                McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_NAME_10);

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McMdlGenCommonScreenResource.MODEL_SUMMARY_MG_SAMPLE); // "モデル生成の為の情報を設定する画面クラス"
            csModelInfo.SetCreatorInf(Properties.McMdlGenCommonScreenResource.MODEL_CREATOR_MG_SAMPLE); // "CommonMP 標準"

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            return csRtnList;
        }
        /// <summary><para>method outline:</para>
        /// <para>個別モデル用設定スクリーンクラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelDataGeneratorScreen csMdlGen = CreateModelDataGeneratorScreen(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelDataGeneratorScreen 個別モデル用設定スクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McModelDataGeneratorScreen CreateModelDataGeneratorScreen(HySKind csModelKind)
        {
            McModelDataGeneratorScreen csScreen = null;

            if (McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_1.Equals(csModelKind) == true)
            {
                csScreen = new McMdlGenInfSettingScreen((HySObjectKind)csModelKind);
            }
            else if (McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_2.Equals(csModelKind) == true)
            {
                csScreen = new McMdlGenInfSettingScreen((HySObjectKind)csModelKind);
            }
            else if (McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_3.Equals(csModelKind) == true)
            {
                csScreen = new McMdlGenInfSettingScreen((HySObjectKind)csModelKind);
            }
            else if (McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_4.Equals(csModelKind) == true)
            {
                csScreen = new McMdlGenInfSettingScreen((HySObjectKind)csModelKind);
            }
            else if (McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_5.Equals(csModelKind) == true)
            {
                csScreen = new McMdlGenInfSettingScreen((HySObjectKind)csModelKind);
            }
            else if (McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_6.Equals(csModelKind) == true)
            {
                csScreen = new McMdlGenInfSettingScreen((HySObjectKind)csModelKind);
            }
            else if (McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_7.Equals(csModelKind) == true)
            {
                csScreen = new McMdlGenInfSettingScreen((HySObjectKind)csModelKind);
            }
            else if (McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_8.Equals(csModelKind) == true)
            {
                csScreen = new McMdlGenInfSettingScreen((HySObjectKind)csModelKind);
            }
            else if (McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_9.Equals(csModelKind) == true)
            {
                csScreen = new McMdlGenInfSettingScreen((HySObjectKind)csModelKind);
            }
            else if (McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_10.Equals(csModelKind) == true)
            {
                csScreen = new McMdlGenInfSettingScreen((HySObjectKind)csModelKind);
            }
            else
            {
                // Do Nothing
            }

            return csScreen;
        }

    }
}
