﻿// <summary>ソースコード：モデル生成情報設定フォームクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;

namespace CommonMP.HYMCO.CoreOptions.McViewer.MdlGenScreenCommonLIB
{
    /// <summary><para>class outline:</para>
    /// <para>モデル生成情報設定フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public partial class McMdlGenInfSectionForm : McDotNetModelDataGeneratorFormBase
    {
        /// <summary>ファイルパス</summary>
        //private static HySString DATA_PATH = new HySString("\\conf\\");
        private static HySString DATA_PATH = new HySString("\\conf\\") + HySEnvInf.GetCultureDirectory().ToString();
        /// <summary>ファイルパス</summary>
        private static HySString XML_PATH = new HySString("McMdlGenInfSettingFile.xml");

        /// <summary>エンコーディング</summary>
        static Encoding sjisEnc = Encoding.GetEncoding("Shift_JIS");

        /// <summary>データ名</summary>
        private string m_csDataName = null;

        /// <summary>ユニークデータ名</summary>
        private string m_csUniqueName = null;

        /// <summary>可変長データ格納</summary>
        private List<List<string>> m_csSectList = new List<List<string>>();

        /// <summary>可変長データ設定数格納</summary>
        private int m_csSectListCnt = 0;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McMdlGenInfSettingForm()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        public McMdlGenInfSectionForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>挿入</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Insertbutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Insertbutton_Click(object sender, EventArgs e)
        {
            int iIndex = dataGridView2.Rows.Count;
            int iSelect_flg = 0;

            foreach (DataGridViewRow row in dataGridView2.SelectedRows)
            {
                // 先頭選択行取得
                if (iIndex > row.Index)
                {
                    iIndex = row.Index;
                }
                iSelect_flg = 1;
            }

            if (iSelect_flg == 0)
            {
                //MessageBox.Show("行が選択されていません。", "メッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                MessageBox.Show(McMessage.GetString("MC_MSG_INFO_MG_SELECT_ROW"), McMessage.GetString("MC_MSG_TITLE_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                // １行挿入
                dataGridView2.Rows.Insert(iIndex, 1);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Deletebutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Deletebutton_Click(object sender, EventArgs e)
        {
            int iSelect_flg = 0;

            //DataGridView1で選択されているすべての行を削除する
            foreach (DataGridViewRow row in dataGridView2.SelectedRows)
            {
                if (!row.IsNewRow)
                {
                    // １行削除
                    dataGridView2.Rows.Remove(row);
                }
                iSelect_flg = 1;
            }

            if (iSelect_flg == 0)
            {
                //MessageBox.Show("行が選択されていません。", "メッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                MessageBox.Show(McMessage.GetString("MC_MSG_INFO_MG_SELECT_ROW"), McMessage.GetString("MC_MSG_TITLE_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Updatebutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Updatebutton_Click(object sender, EventArgs e)
        {
            // 入力エラー有無チェック
            for (int iRow = 0; iRow < dataGridView2.Rows.Count - 1; iRow++)
            {
                for (int iCell = 0; iCell < dataGridView2.Rows[iRow].Cells.Count; iCell++)
                {
                    if (dataGridView2[iCell, iRow].ErrorText != string.Empty)
                    {
                        //MessageBox.Show("入力項目に誤りがあります。", "エラーメッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        MessageBox.Show(McMessage.GetString("MC_MSG_ERROR_MG_INPUT_DATA"), McMessage.GetString("MC_MSG_TITLE_ERROR_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                        return;
                    }
                }
            }

            // 可変長データ設定数格納
            m_csSectListCnt = dataGridView2.Rows.Count - 1;

            // 同じユニーク名称のリスト削除
            //int iList_cnt = this.m_csSectList.Count;
            for (int iCnt = 0; iCnt < this.m_csSectList.Count; iCnt++)
            {
                int iDtcnt = this.m_csSectList[iCnt].Count;
                for (int iCntCnt = 0; iCntCnt < iDtcnt; iCntCnt++)
                {
                    // １項目目はユニーク名称
                    if (iCntCnt == 0)
                    {
                        // ユニーク名称判定
                        if (this.m_csSectList[iCnt][iCntCnt] == m_csUniqueName)
                        {
                            this.m_csSectList.RemoveAt(iCnt--);
                            break;
                        }
                    }
                }
            }

            int iNew_cnt = this.m_csSectList.Count;

            // 画面の設定情報をリストに設定
            for (int iRow = 0; iRow < dataGridView2.Rows.Count - 1; iRow++)
            {
                // 可変長データ領域定義
                m_csSectList.Add(new List<string>());

                // ユニーク名称設定
                m_csSectList[iRow + iNew_cnt].Add(m_csUniqueName);

                for (int iCell = 0; iCell < dataGridView2.Rows[iRow].Cells.Count; iCell++)
                {
                    if (dataGridView2.Columns[iCell] is DataGridViewComboBoxColumn)
                    {  // DataGridViewComboBoxの場合
                    }
                    else if (dataGridView2.Columns[iCell] is DataGridViewButtonColumn)
                    {  // DataGridViewButtonColumnの場合
                    }
                    else if (dataGridView2.Columns[iCell] is DataGridViewTextBoxColumn)
                    {  // DataGridViewTextBoxColumnの場合
                        string sDataName = m_csDataName;
                        string sItemName = this.Text;
                        string sSubItemName = dataGridView2.Columns[iCell].Name.ToString();

                        string sKind = GetXmlTextSubItemKind(sDataName, sItemName, sSubItemName);

                        if (sKind == "F")
                        {   // 浮動小数点ありの場合
                            if (dataGridView2.Rows[iRow].Cells[iCell].Value != null
                                && dataGridView2.Rows[iRow].Cells[iCell].Value.ToString() != "")
                            {
                                string csNum = GetXmlTextSubItemNum(sDataName, sItemName, sSubItemName);

                                // 桁数取得
                                int iIndex = csNum.IndexOf(".");
                                string csCut_Num;
                                if (iIndex != -1)
                                {
                                    // 小数点以下取得
                                    csCut_Num = csNum.Remove(0, iIndex + 1);
                                }
                                else
                                {
                                    // 小数点以下なし
                                    csCut_Num = "0";
                                }
                                int iLnum = int.Parse(csCut_Num);

                                // ToStringのFormat(0.000)を作る
                                string csNumStr = "0.";
                                for (int iCutCnt = 0; iCutCnt < iLnum; iCutCnt++)
                                {
                                    csNumStr = csNumStr + "0";
                                }

                                string sInput = dataGridView2.Rows[iRow].Cells[iCell].Value.ToString();
                                double dwInput = double.Parse(sInput);
                                //string sChgInput = dwInput.ToString("0.000");
                                string sChgInput = dwInput.ToString(csNumStr);
                                m_csSectList[iRow + iNew_cnt].Add(sChgInput);
                            }
                            else
                            {
                                m_csSectList[iRow + iNew_cnt].Add("");
                            }
                        }
                        else
                        {   // 浮動小数点以外の場合
                            if (dataGridView2.Rows[iRow].Cells[iCell].Value != null
                                && dataGridView2.Rows[iRow].Cells[iCell].Value.ToString() != "")
                            {
                                m_csSectList[iRow + iNew_cnt].Add(dataGridView2.Rows[iRow].Cells[iCell].Value.ToString());
                            }
                            else
                            {
                                m_csSectList[iRow + iNew_cnt].Add("");
                            }
                        }
                    }
                }
            }
            this.Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>取消</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OKbutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OKbutton_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じるイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McMdlGenInfSectionForm_FormClosing( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McMdlGenInfSectionForm_FormClosing(object sender, FormClosingEventArgs e)
        {

        }

        /// <summary> <para>method outline:</para>
        /// <para>データグリッドビューデータ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SubFormSetData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SubFormSetData()
        {
            dataGridView2.Rows.Clear();

            int iRowCnt = -1;

            int iList_cnt = this.m_csSectList.Count;
            for (int iCnt = 0; iCnt < iList_cnt; iCnt++)
            {
                int iDtcnt = this.m_csSectList[iCnt].Count;
                //for (int iCntCnt = 0; iCntCnt < iDtcnt; iCntCnt++)
                for (int iCntCnt = 0; iCntCnt < dataGridView2.ColumnCount+1; iCntCnt++)
                {
                    // １項目はユニーク名称
                    if (iCntCnt == 0)
                    {
                        // ユニーク名称判定
                        if (this.m_csSectList[iCnt][iCntCnt] == m_csUniqueName)
                        {
                            dataGridView2.Rows.Add();       // 行追加
                            iRowCnt++;
                            continue;
                        }
                        else
                        {
                            break;
                        }
                    }
                    // データグリッドビューにセット
                    dataGridView2.Rows[iRowCnt].Cells[iCntCnt - 1].Value = this.m_csSectList[iCnt][iCntCnt];
                }
                
            }

            // カレントセル初期化
            dataGridView2.CurrentCell = dataGridView2[0, 0];

            // 可変長データ設定数格納
            m_csSectListCnt = dataGridView2.Rows.Count - 1;

        }

        /// <summary> <para>method outline:</para>
        /// <para>データグリッドビューヘッダー部設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GetXmlComboItemName(string sDataName, string sItemName) </para>
        /// </example>
        /// <param name="sDataName">文字列</param>
        /// <param name="sItemName">文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SubFormSetHeaderDataGridView(string sDataName, string sItemName)
        {
            // リストビュークリア
            dataGridView2.Rows.Clear();

            // 画面タイトル設定
            this.Text = sItemName;

            // データ名設定
            m_csDataName = sDataName;

            HySXmlReader csXmlReader = null;
            HySString csFullPath = HySEnvInf.GetHomeDirectory() + DATA_PATH + XML_PATH;
            HySFile csFile = new HySFile(csFullPath);
            if (csFile.Exist() == true)
            {
                // 定義データの読み込み＆解析
                csXmlReader = new HySXmlReader(csFullPath);
            }
            HySXmlNode csRootNode = csXmlReader.GetRootNode();

            if (csRootNode == null)
            {
                // ＸＭＬファイル読込エラーの場合
                return ;
            }

            HySXmlNodeList csNodeList;
            HySXmlNodeList csChildNodeList;
            HySXmlNodeList csChildChildNodeList;
            HySXmlNode csNode;
            HySXmlNode csChildNode;
            HySXmlNode csChildChildNode;
            long lNodeListCount;
            long lChildNodeListCount;
            long lChildChildNodeListCount;
            long lLoop;
            long lChildLoop;
            long lChildChildLoop;
            csNodeList = csRootNode.GetChildNodeList();
            lNodeListCount = csNodeList.GetCount();
            for (lLoop = 0; lLoop < lNodeListCount; lLoop++)
            {
                csNode = csNodeList.GetNode(lLoop);

                if (csNode.GetAttribute("Name") == sDataName)
                {
                    csChildNodeList = csNode.GetChildNodeList();
                    lChildNodeListCount = csChildNodeList.GetCount();
                    for (lChildLoop = 0; lChildLoop < lChildNodeListCount; lChildLoop++)
                    {
                        csChildNode = csChildNodeList.GetNode(lChildLoop);

                        if (csChildNode.GetAttribute("Name") == sItemName)
                        {
                            string csItemtype = csChildNode.GetAttribute("Type");

                            switch (csItemtype)
                            {
                                //case "TEXT_TYPE":
                                //    break;
                                //case "COMBO_TYPE":
                                //    break;
                                case "BUTTON_TYPE":
                                    csChildChildNodeList = csChildNode.GetChildNodeList();
                                    lChildChildNodeListCount = csChildChildNodeList.GetCount();

                                    for (lChildChildLoop = 0; lChildChildLoop < lChildChildNodeListCount; lChildChildLoop++)
                                    {
                                        csChildChildNode = csChildChildNodeList.GetNode(lChildChildLoop);
                                        string csItemname = csChildChildNode.GetAttribute("Name");
                                        dataGridView2.Columns.Add(csItemname, csItemname);
                                    }
                                    break;
                                default:
                                    break;

                            }
                        }
                    }
                }
            }
        }

        /// <summary> <para>method outline:</para>
        /// <para>定義ファイルの文字種別を返す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GetXmlTextSubItemKind(string sDataName, string sItemName, string SubItemName) </para>
        /// </example>
        /// <param name="sDataName">文字列</param>
        /// <param name="sItemName">文字列</param>
        /// <param name="SubItemName">文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetXmlTextSubItemKind(string sDataName, string sItemName, string SubItemName)
        {
            HySXmlReader csXmlReader = null;
            HySString csFullPath = HySEnvInf.GetHomeDirectory() + DATA_PATH + XML_PATH;
            HySFile csFile = new HySFile(csFullPath);
            if (csFile.Exist() == true)
            {
                // 定義データの読み込み＆解析
                csXmlReader = new HySXmlReader(csFullPath);
            }
            HySXmlNode csRootNode = csXmlReader.GetRootNode();

            if (csRootNode == null)
            {
                // ＸＭＬファイル読込エラーの場合
                return "";
            }

            HySXmlNodeList csNodeList;
            HySXmlNodeList csChildNodeList;
            HySXmlNodeList csChildChildNodeList;
            HySXmlNode csNode;
            HySXmlNode csChildNode;
            HySXmlNode csChildChildNode;
            long lNodeListCount;
            long lChildNodeListCount;
            long lChildChildNodeListCount;
            long lLoop;
            long lChildLoop;
            long lChildChildLoop;
            csNodeList = csRootNode.GetChildNodeList();
            lNodeListCount = csNodeList.GetCount();
            for (lLoop = 0; lLoop < lNodeListCount; lLoop++)
            {
                csNode = csNodeList.GetNode(lLoop);

                if (csNode.GetAttribute("Name") == sDataName)
                {
                    csChildNodeList = csNode.GetChildNodeList();
                    lChildNodeListCount = csChildNodeList.GetCount();
                    for (lChildLoop = 0; lChildLoop < lChildNodeListCount; lChildLoop++)
                    {
                        csChildNode = csChildNodeList.GetNode(lChildLoop);

                        if (csChildNode.GetAttribute("Name") == sItemName)
                        {
                            string csItemtype = csChildNode.GetAttribute("Type");

                            switch (csItemtype)
                            {
                                //case "TEXT_TYPE":
                                //    break;
                                //case "COMBO_TYPE":
                                //    break;
                                case "BUTTON_TYPE":
                                    csChildChildNodeList = csChildNode.GetChildNodeList();
                                    lChildChildNodeListCount = csChildChildNodeList.GetCount();

                                    for (lChildChildLoop = 0; lChildChildLoop < lChildChildNodeListCount; lChildChildLoop++)
                                    {
                                        csChildChildNode = csChildChildNodeList.GetNode(lChildChildLoop);
                                        if (csChildChildNode.GetAttribute("Name") == SubItemName)
                                        {
                                            return csChildChildNode.GetAttribute("Kind");
                                        }
                                    }
                                    break;
                                default:
                                    break;

                            }
                        }
                    }
                }
            }
            return "";
        }

        /// <summary> <para>method outline:</para>
        /// <para>定義ファイルの入力桁数を返す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GetXmlTextSubItemNum(string sDataName, string sItemName, string SubItemName) </para>
        /// </example>
        /// <param name="sDataName">文字列</param>
        /// <param name="sItemName">文字列</param>
        /// <param name="SubItemName">文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetXmlTextSubItemNum(string sDataName, string sItemName, string SubItemName)
        {
            HySXmlReader csXmlReader = null;
            HySString csFullPath = HySEnvInf.GetHomeDirectory() + DATA_PATH + XML_PATH;
            HySFile csFile = new HySFile(csFullPath);
            if (csFile.Exist() == true)
            {
                // 定義データの読み込み＆解析
                csXmlReader = new HySXmlReader(csFullPath);
            }
            HySXmlNode csRootNode = csXmlReader.GetRootNode();

            if (csRootNode == null)
            {
                // ＸＭＬファイル読込エラーの場合
                return "";
            }

            HySXmlNodeList csNodeList;
            HySXmlNodeList csChildNodeList;
            HySXmlNodeList csChildChildNodeList;
            HySXmlNode csNode;
            HySXmlNode csChildNode;
            HySXmlNode csChildChildNode;
            long lNodeListCount;
            long lChildNodeListCount;
            long lChildChildNodeListCount;
            long lLoop;
            long lChildLoop;
            long lChildChildLoop;
            csNodeList = csRootNode.GetChildNodeList();
            lNodeListCount = csNodeList.GetCount();
            for (lLoop = 0; lLoop < lNodeListCount; lLoop++)
            {
                csNode = csNodeList.GetNode(lLoop);

                if (csNode.GetAttribute("Name") == sDataName)
                {
                    csChildNodeList = csNode.GetChildNodeList();
                    lChildNodeListCount = csChildNodeList.GetCount();
                    for (lChildLoop = 0; lChildLoop < lChildNodeListCount; lChildLoop++)
                    {
                        csChildNode = csChildNodeList.GetNode(lChildLoop);

                        if (csChildNode.GetAttribute("Name") == sItemName)
                        {
                            string csItemtype = csChildNode.GetAttribute("Type");

                            switch (csItemtype)
                            {
                                //case "TEXT_TYPE":
                                //    break;
                                //case "COMBO_TYPE":
                                //    break;
                                case "BUTTON_TYPE":
                                    csChildChildNodeList = csChildNode.GetChildNodeList();
                                    lChildChildNodeListCount = csChildChildNodeList.GetCount();

                                    for (lChildChildLoop = 0; lChildChildLoop < lChildChildNodeListCount; lChildChildLoop++)
                                    {
                                        csChildChildNode = csChildChildNodeList.GetNode(lChildChildLoop);
                                        if (csChildChildNode.GetAttribute("Name") == SubItemName)
                                        {
                                            return csChildChildNode.GetAttribute("Num");
                                        }
                                    }
                                    break;
                                default:
                                    break;

                            }
                        }
                    }
                }
            }
            return "";
        }

        /// <summary><para>method outline:</para>
        /// <para>可変長データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSectionList()</para>
        /// </example>
        /// <param name="SectList">可変長データリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSectionList(List<List<string>> SectList)
        {
            m_csSectList = SectList;
        }

        /// <summary><para>method outline:</para>
        /// <para>ユニークデータ名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetSectionList(string UniqueName)</para>
        /// </example>
        /// <param name="UniqueName">ユニークデータ名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GetSectionList(string UniqueName)
        {
            m_csUniqueName = UniqueName;
        }

        /// <summary><para>method outline:</para>
        /// <para>可変長設定データ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetSectionListCnt()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>可変長設定データ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int GetSectionListCnt()
        {
            return m_csSectListCnt;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>最終セル編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>dataGridView2_CellEndEdit( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void dataGridView2_CellEndEdit(object sender, DataGridViewCellEventArgs e)
        {
            
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>dataGridView2_CellValidating( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void dataGridView2_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {
            if (dataGridView2.Columns[e.ColumnIndex] is DataGridViewTextBoxColumn)
            {
                string sDataName = m_csDataName;
                string sItemName = this.Text;
                string sSubItemName = dataGridView2.Columns[e.ColumnIndex].Name.ToString();
                string sKind = GetXmlTextSubItemKind(sDataName, sItemName, sSubItemName);
                string sNum = GetXmlTextSubItemNum(sDataName, sItemName, sSubItemName);

                // 桁数
                int iIndex = sNum.IndexOf(".");
                string sCut_Num;
                if (iIndex != -1)
                {
                    // 小数点以下削除
                    sCut_Num = sNum.Remove(iIndex);
                }
                else
                {
                    // 小数点なし
                    sCut_Num = sNum;
                }
                int lnum = int.Parse(sCut_Num);


                // 全角チェック
                if (sKind == "A")
                {
                    if (isZenkaku((string)e.FormattedValue) == false)
                    {
                        dataGridView2[e.ColumnIndex, e.RowIndex].ErrorText = McMessage.GetString("MC_MSG_WARNING_MG_IMPUT_FULL_SIZE"); //"全角で入力してください。";
                        return;
                    }
                }
                // 数値チェック
                else if (sKind == "F")
                {
                    if (IsNumeric(e.FormattedValue) == false && e.FormattedValue.Equals("") == false)
                    {
                        dataGridView2[e.ColumnIndex, e.RowIndex].ErrorText = McMessage.GetString("MC_MSG_WARNING_MG_IMPUT_NUMBER"); //"数値を入力してください。";
                        return;
                    }
                }

                // 桁数チェック
                if (((string)e.FormattedValue).Length > lnum)
                {
                    dataGridView2[e.ColumnIndex, e.RowIndex].ErrorText = McMessage.GetString("MC_MSG_WARNING_MG_CHECK_LINAGE"); //"桁数を確認してください。";
                    return;
                }

                // エラークリア
                dataGridView2[e.ColumnIndex, e.RowIndex].ErrorText = string.Empty;

            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HelpJump_button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODELGEN_0003,null);
        }

        #region　IsNumeric メソッド (+1)
        /// <summary>
        /// <para>method outline:</para>
        /// <para>数字チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = IsNumeric( stTarget )</para>
        /// </example>
        /// <param name="stTarget">対象文字</param>
        /// <returns>true:数字、false:数字以外</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private static bool IsNumeric(string stTarget)
        {
            double dNullable;

            return double.TryParse(
                stTarget,
                System.Globalization.NumberStyles.Any,
                null,
                out dNullable
            );
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>数字チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = IsNumeric( oTarget )</para>
        /// </example>
        /// <param name="oTarget">対象オブジェクト</param>
        /// <returns>true:数字、false:数字以外</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private static bool IsNumeric(object oTarget)
        {
            return IsNumeric(oTarget.ToString());
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>全角チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = isZenkaku( str )</para>
        /// </example>
        /// <param name="str">対象文字</param>
        /// <returns>true:全角、false:全角以外</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private static bool isZenkaku(string str)
        {
            int num = sjisEnc.GetByteCount(str);
            return num == str.Length * 2;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>半角チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = isHankaku( str )</para>
        /// </example>
        /// <param name="str">対象文字</param>
        /// <returns>true:半角、false:半角以外</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private static bool isHankaku(string str)
        {
            int num = sjisEnc.GetByteCount(str);
            return num == str.Length;
        }

        #endregion

    }
}