﻿// <summary>ソースコード：モデル生成情報設定フォームクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;
using CommonMP.HYMCO.CoreImpl.Tool.Msg;


namespace CommonMP.HYMCO.CoreOptions.McViewer.MdlGenScreenCommonLIB
{

    /// <summary><para>class outline:</para>
    /// <para>モデル生成情報設定フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public partial class McMdlGenInfSettingForm : McDotNetModelDataGeneratorFormBase //Form
    {
        /// <summary>リストボックス選択文字列 </summary>
        private string m_csMdlGenSettingString = null;

        /// <summary>可変データ入力画面 </summary>
        private McMdlGenInfSectionForm m_csInfSectionForm;

        /// <summary>ファイルパス</summary>
        //private static HySString DATA_PATH = new HySString("\\conf\\");
        private static HySString DATA_PATH = new HySString("\\conf\\") + HySEnvInf.GetCultureDirectory().ToString();
        /// <summary>定義ファイルパス</summary>
        private static HySString DEF_PATH = new HySString("\\temp\\ModelGenerator");
        /// <summary>定義ファイルパス</summary>
        private static HySString XML_PATH = new HySString("McMdlGenInfSettingFile.xml");

        /// <summary>エンコーディング</summary>
        static Encoding sjisEnc = Encoding.GetEncoding("Shift_JIS");

        /// <summary>可変長データ格納</summary>
        private List<List<string>> m_csSectList = new List<List<string>>();

        /// <summary>ユニークデータ名</summary>
        private string m_csUniqueName = null;

        /// <summary>設定するべきデータ種別</summary>
        protected HySObjectKind m_csInputDataKind = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McMdlGenInfSettingForm()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McMdlGenInfSettingForm()
        {
            InitializeComponent();

        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McMdlGenInfSettingForm csScreen = new McMdlGenInfSettingForm()</para>
        /// </example>
        /// <param name="csInputDataKind">入力データ種別</param>
        /// <returns>McMdlGenInfSettingForm 生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McMdlGenInfSettingForm(HySObjectKind csInputDataKind)
        {
            InitializeComponent();

            // データ種別セット
            m_csInputDataKind = csInputDataKind;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じる</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OKbutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OKbutton_Click(object sender, EventArgs e)
        {
            // 可変長データリストクリア
            m_csSectList.Clear();
            this.Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>挿入</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Insertbutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Insertbutton_Click(object sender, EventArgs e)
        {
            int iIndex = dataGridView1.Rows.Count;
            int iSelect_flg = 0;

            foreach (DataGridViewRow row in dataGridView1.SelectedRows)
            {
                // 先頭選択行取得
                if (iIndex > row.Index)
                {
                    iIndex = row.Index;
                }
                iSelect_flg = 1;
            }
             
            if (iSelect_flg == 0)
            {
                //MessageBox.Show("行が選択されていません。", "メッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                MessageBox.Show(McMessage.GetString("MC_MSG_INFO_MG_SELECT_ROW"), McMessage.GetString("MC_MSG_TITLE_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                // １行挿入
                dataGridView1.Rows.Insert(iIndex, 1);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>削除</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Deletebutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Deletebutton_Click(object sender, EventArgs e)
        {
            int iSelect_flg = 0;

            //DataGridView1で選択されているすべての行を削除する
            foreach (DataGridViewRow row in dataGridView1.SelectedRows)
            {
                if (!row.IsNewRow)
                {
                    // １行削除
                    dataGridView1.Rows.Remove(row);
                }
                iSelect_flg = 1;
            }

            if (iSelect_flg == 0)
            {
                //MessageBox.Show("行が選択されていません。", "メッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                MessageBox.Show(McMessage.GetString("MC_MSG_INFO_MG_SELECT_ROW"), McMessage.GetString("MC_MSG_TITLE_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>読込み</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Readbutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Readbutton_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            HySString csFullPath = HySEnvInf.GetHomeDirectory() + DEF_PATH;
            openFileDialog1.InitialDirectory = csFullPath.ToString();
            openFileDialog1.Filter = Properties.McMdlGenCommonScreenResource.FILE_DLG_FILTER_CSVXML + "|" + Properties.McMdlGenCommonScreenResource.FILE_DLG_FILTER_ALLFILES; //"CSV XMLファイル(*.csv *.xml)|*.csv;*.xml|すべてのファイル(*.*)|*.*";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                string csFileName = openFileDialog1.FileName;    // 入力ファイルフルパス名

                HySFile csFile = new HySFile((new HySString(csFileName)));
                if (csFile.Exist() == true)
                {  // 既存ファイルが有れば

                    HySString sOut = new HySString();
                    string[] sInWk;
                    int lCnt = 0;

                    // DataGridViewButtonColumn数取得
                    int iButtonCnt = 0;
                    for (int iColumnLoop = 0; iColumnLoop < dataGridView1.ColumnCount; iColumnLoop++)
                    {
                        if (dataGridView1.Columns[iColumnLoop] is DataGridViewButtonColumn)
                        {
                            iButtonCnt++;
                        }
                    }

                    if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                    {   // 既存CSVファイルを正常に開ければ
                        while (csFile.ReadText(ref sOut) != 0)
                        {   // １行取得
                            sInWk = sOut.ToString().Split(',');
                            if (iButtonCnt == 0)
                            {
                                if (dataGridView1.ColumnCount != sInWk.LongLength)
                                {
                                    // 読込みファイル項目数オーバー
                                    //MessageBox.Show("読込みファイルの項目数が異常です。", "エラーメッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                                    MessageBox.Show(McMessage.GetString("MC_MSG_ERROR_MG_READ_ITEM"), McMessage.GetString("MC_MSG_TITLE_ERROR_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                                    csFile.Close();
                                    openFileDialog1.Dispose();
                                    return;
                                }
                            }
                            else
                            {
                                if (dataGridView1.ColumnCount < sInWk.LongLength + iButtonCnt)
                                {
                                    // 読込みファイル項目数オーバー
                                    //MessageBox.Show("読込みファイルの項目数が異常です。", "エラーメッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                                    MessageBox.Show(McMessage.GetString("MC_MSG_ERROR_MG_READ_ITEM"), McMessage.GetString("MC_MSG_TITLE_ERROR_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                                    csFile.Close();
                                    openFileDialog1.Dispose();
                                    return;
                                }
                            }
                        }
                    }
                    else
                    {
                        //MessageBox.Show("ファイルの読込みに失敗しました。", "エラーメッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        MessageBox.Show(McMessage.GetString("MC_MSG_ERROR_MG_READ_FILE"), McMessage.GetString("MC_MSG_TITLE_ERROR_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                        openFileDialog1.Dispose();
                        return;
                    }
                    csFile.Close();

                    if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                    {   // 既存CSVファイルを正常に開ければ
                        lCnt = 0;
                        dataGridView1.Rows.Clear();

                        // ユニークキーの名称取得
                        string csXmlUniqueName = GetXmlUniqueName( this.label1.Text.ToString() );
                        string csUniqueName = "";

                        // 可変長データリストクリア
                        m_csSectList.Clear();

                        int iSect_cnt = 0;
                        int iLoop_cnt = 0;
                        int iData_cnt2 = 0;

                        while (csFile.ReadText(ref sOut) != 0)
                        {   // １行取得
                            sInWk = sOut.ToString().Split(',');

                            if (iSect_cnt == 0)
                            {
                                dataGridView1.Rows.Add();       // 行追加

                                int iData_cnt = 0;
                                for (int iIcnt = 0; iIcnt < sInWk.LongLength; iIcnt++)
                                {
                                    if (dataGridView1.Columns[iIcnt] is DataGridViewComboBoxColumn)
                                    {  // DataGridViewComboBoxの場合
                                        if (sInWk[iData_cnt] != null && sInWk[iData_cnt] != "")
                                        {
                                            string csDataName = this.label1.Text;
                                            string csItemName = dataGridView1.Columns[iIcnt].Name.ToString();
                                            string csID = sInWk[iData_cnt];
                                            string csName = GetXmlComboItemName(csDataName, csItemName, csID);

                                            dataGridView1.Rows[lCnt].Cells[iIcnt].Value = csName;
                                        }
                                        iData_cnt++;
                                    }
                                    else if (dataGridView1.Columns[iIcnt] is DataGridViewButtonColumn)
                                    {  // DataGridViewButtonColumnの場合

                                    }
                                    else if (dataGridView1.Columns[iIcnt] is DataGridViewTextBoxColumn)
                                    {  // DataGridViewTextBoxColumnの場合
                                        if (sInWk[iData_cnt] != null && sInWk[iData_cnt] != "")
                                        {
                                            dataGridView1.Rows[lCnt].Cells[iIcnt].Value = sInWk[iData_cnt];

                                            if (dataGridView1.Columns[iIcnt].Name.ToString() == csXmlUniqueName)
                                            {
                                                csUniqueName = sInWk[iData_cnt];
                                            }

                                            if (dataGridView1.Columns[iIcnt].ReadOnly == true)
                                            {
                                                // 可変長データ数取得
                                                iSect_cnt = int.Parse(sInWk[iData_cnt]);

                                                iLoop_cnt = 0;
                                            }
                                        }
                                        iData_cnt++;
                                    }
                                }
                                lCnt++;
                            }
                            else
                            {
                                // 可変長データ領域定義
                                m_csSectList.Add(new List<string>());

                                // ユニーク名称設定
                                m_csSectList[iData_cnt2].Add(csUniqueName);

                                // 可変長データを取り込む
                                for (int iJcnt = 0; iJcnt < sInWk.GetLength(0); iJcnt++)
                                {

                                    m_csSectList[iData_cnt2].Add(sInWk[iJcnt]);
                                }
                                iData_cnt2++;
                                iLoop_cnt ++;
                                if( iSect_cnt == iLoop_cnt )
                                {
                                    iSect_cnt = 0;
                                    csUniqueName = "";
                                }
                            }
                        }
                        csFile.Close();

                        // カレントセル初期化
                        dataGridView1.CurrentCell = dataGridView1[0, 0];
                    }
                }
            }
            openFileDialog1.Dispose();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>書出し</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Writebutton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Writebutton_Click(object sender, EventArgs e)
        {
            // 入力エラー有無チェック
            for (int iRow = 0; iRow < dataGridView1.Rows.Count - 1; iRow++)
            {
                for (int iCell = 0; iCell < dataGridView1.Rows[iRow].Cells.Count; iCell++)
                {
                    if (dataGridView1[iCell, iRow].ErrorText != string.Empty)
                    {
                        //MessageBox.Show("入力項目に誤りがあります。", "エラーメッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        MessageBox.Show(McMessage.GetString("MC_MSG_ERROR_MG_INPUT_DATA"), McMessage.GetString("MC_MSG_TITLE_ERROR_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                        return;
                    }
                }
            }

            SaveFileDialog saveFileDialog1 = new SaveFileDialog();
            HySString csFullPath = HySEnvInf.GetHomeDirectory() + DEF_PATH;
            saveFileDialog1.InitialDirectory = csFullPath.ToString();
            saveFileDialog1.Filter = Properties.McMdlGenCommonScreenResource.FILE_DLG_FILTER_CSVXML + "|" + Properties.McMdlGenCommonScreenResource.FILE_DLG_FILTER_ALLFILES; //"CSV XMLファイル(*.csv *.xml)|*.csv;*.xml|すべてのファイル(*.*)|*.*";
            saveFileDialog1.FilterIndex = 1;
            saveFileDialog1.RestoreDirectory = true;

            string csFilePath = this.label1.Text + ".csv";
            saveFileDialog1.FileName = csFilePath;

            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                string csFileName = saveFileDialog1.FileName;    // 入力ファイルフルパス名
                HySFile csFile = new HySFile((new HySString(csFileName)));
                csFile.Open(HySFile.OPEN_MODE.CREATE, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                
                // ユニークキーの名称取得
                string csXmlUniqueName = GetXmlUniqueName(this.label1.Text.ToString());
                string csUniqueName = "";

                string csDataName = this.label1.Text;
                string csItemName = "";
                int iSect_cnt = 0;

                for (int iRow = 0; iRow < dataGridView1.Rows.Count-1; iRow++)
                {
                    string csWriteString = "";
                    for (int iCell = 0; iCell < dataGridView1.Rows[iRow].Cells.Count; iCell++)
                    {
                        if (dataGridView1.Columns[iCell] is DataGridViewComboBoxColumn)
                        {  // DataGridViewComboBoxの場合
                            csItemName = dataGridView1.Columns[iCell].Name.ToString();
                            string csName = "";
                            if (dataGridView1.Rows[iRow].Cells[iCell].Value != null
                                && dataGridView1.Rows[iRow].Cells[iCell].Value.ToString() != "")
                            {
                                csName = dataGridView1.Rows[iRow].Cells[iCell].Value.ToString();
                            }

                            string iId = GetXmlComboItemID(csDataName, csItemName, csName);
                            csWriteString += iId;

                            if (iCell < dataGridView1.Rows[iRow].Cells.Count - 1)
                            {
                                csWriteString += ",";
                            }
                        }
                        else if (dataGridView1.Columns[iCell] is DataGridViewButtonColumn)
                        {  // DataGridViewButtonColumnの場合
                            if (iCell == dataGridView1.Rows[iRow].Cells.Count - 1)
                            {
                                // 最後の","削除
                                string csSearch_string = csWriteString;
                                int iIndex = csSearch_string.LastIndexOf(",");
                                csWriteString = csSearch_string.Remove(iIndex);
                            }
                        }
                        else if (dataGridView1.Columns[iCell] is DataGridViewTextBoxColumn)
                        {  // DataGridViewTextBoxColumnの場合
                            csItemName = dataGridView1.Columns[iCell].Name.ToString();
                            string csKind = GetXmlTextItemKind(csDataName, csItemName);

                            if (csKind == "F")
                            {
                                if (dataGridView1.Rows[iRow].Cells[iCell].Value != null
                                    && dataGridView1.Rows[iRow].Cells[iCell].Value.ToString() != "")
                                {
                                    string csNum = GetXmlTextItemNum(csDataName, csItemName);
                                    // 桁数
                                    int iIndex = csNum.IndexOf(".");
                                    string csCut_Num;
                                    if (iIndex != -1)
                                    {
                                        // 小数点以下取得
                                        csCut_Num = csNum.Remove(0,iIndex+1);
                                    }
                                    else
                                    {
                                        // 小数点なし
                                        csCut_Num = "0";
                                    }
                                    int iLnum = int.Parse(csCut_Num);

                                    // ToStringのFormat(0.000)を作る
                                    string csNumStr = "0.";
                                    for (int iCutCnt = 0; iCutCnt < iLnum; iCutCnt++)
                                    {
                                        csNumStr = csNumStr + "0";
                                    }

                                    string csStr_input = dataGridView1.Rows[iRow].Cells[iCell].Value.ToString();
                                    double dwInput = double.Parse(csStr_input);
                                    string csChg_input = dwInput.ToString(csNumStr);
                                    csWriteString += csChg_input;
                                }
                            }
                            else
                            {
                                if (dataGridView1.Rows[iRow].Cells[iCell].Value != null
                                    && dataGridView1.Rows[iRow].Cells[iCell].Value.ToString() != "")
                                {
                                    csWriteString += dataGridView1.Rows[iRow].Cells[iCell].Value;
                                }
                            }

                            if (iCell < dataGridView1.Rows[iRow].Cells.Count - 1)
                            {
                                csWriteString += ",";
                            }

                            // ユニークキー項目のユニーク名称取得
                            if (dataGridView1.Columns[iCell].Name.ToString() == csXmlUniqueName)
                            {
                                if (dataGridView1.Rows[iRow].Cells[iCell].Value != null
                                    && dataGridView1.Rows[iRow].Cells[iCell].Value.ToString() != "")
                                {
                                    csUniqueName = dataGridView1.Rows[iRow].Cells[iCell].Value.ToString();
                                }
                                else
                                {
                                    csUniqueName = "";
                                }
                            }

                            // 可変長データ数取得
                            if (dataGridView1.Columns[iCell].ReadOnly == true)
                            {
                                if (dataGridView1.Rows[iRow].Cells[iCell].Value != null
                                    && dataGridView1.Rows[iRow].Cells[iCell].Value.ToString() != "")
                                {
                                    iSect_cnt = int.Parse(dataGridView1.Rows[iRow].Cells[iCell].Value.ToString());
                                }
                            }
                        }
                    }
                    // 空白行の場合は書込みしない
                    string a = csWriteString.Replace(",", "");
                    if( a.Equals(string.Empty))
                    {
                        continue;
                    }
                    csFile.WriteText(csWriteString);

                    if (iSect_cnt > 0)
                    {
                        int iList_cnt = this.m_csSectList.Count;
                        for (int iIcnt = 0; iIcnt < iList_cnt; iIcnt++)
                        {
                            csWriteString = "";
                            int iDt_cnt = this.m_csSectList[iIcnt].Count;
                            for (int iJcnt = 0; iJcnt < iDt_cnt; iJcnt++)
                            {
                                // １項目はユニーク名称
                                if (iJcnt == 0)
                                {
                                    // ユニーク名称判定
                                    if (this.m_csSectList[iIcnt][iJcnt] == csUniqueName)
                                    {
                                        continue;
                                    }
                                    else
                                    {
                                        break;
                                    }
                                }
                                csWriteString += this.m_csSectList[iIcnt][iJcnt];

                                if (iJcnt < iDt_cnt - 1)
                                {
                                    csWriteString += ",";
                                }
                            }
                            if (csWriteString != "")
                            {
                                csFile.WriteText(csWriteString);
                            }
                        }
                        iSect_cnt = 0;
                    }
                }
                csFile.Close();

                // パラメーター設定
                McModelDataGenerationInfo csMDGInfo = this.GetMdlGenerationInfo();
                csMDGInfo.SetInfo(m_csInputDataKind, new HySString(csFileName));

                // 制御画面側に　設定完了を通知する
                this.NoticeModelDataSet();
            }
            saveFileDialog1.Dispose();
        }

        /// <summary> <para>method outline:</para>
        /// <para>リストボックス選択文字列取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GetClickString(string sclickString) </para>
        /// </example>
        /// <param name="sclickString">文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void GetClickString(string sclickString)
        {
            m_csMdlGenSettingString = sclickString;
        }

        /// <summary> <para>method outline:</para>
        /// <para>データグリッドビューヘッダー部設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetHeaderDataGridView() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetHeaderDataGridView()
        {
            // リストボックスクリア
            //this.listBox1.Items.Clear();

            DataGridViewComboBoxColumn column;
            DataGridViewButtonColumn columnB;


            HySXmlReader csXmlReader = null;
            HySString csFullPath = HySEnvInf.GetHomeDirectory() + DATA_PATH + XML_PATH;
            HySFile csFile = new HySFile(csFullPath);
            if (csFile.Exist() == true)
            {
                // 定義データの読み込み＆解析
                csXmlReader = new HySXmlReader(csFullPath);
            }
            HySXmlNode csRootNode = csXmlReader.GetRootNode();

            if (csRootNode == null)
            {
                // ＸＭＬファイル読込エラーの場合
                return ;
            }

            HySXmlNodeList csNodeList;
            HySXmlNodeList csChildNodeList;
            HySXmlNodeList csChildChildNodeList;
            HySXmlNode csNode;
            HySXmlNode csChildNode;
            HySXmlNode csChildChildNode;
            long lNodeListCount;
            long lChildNodeListCount;
            long lChildChildNodeListCount;
            long lLoop;
            long lChildLoop;
            long lChildChildLoop;
            csNodeList = csRootNode.GetChildNodeList();
            lNodeListCount = csNodeList.GetCount();
            for (lLoop = 0; lLoop < lNodeListCount; lLoop++)
            {
                csNode = csNodeList.GetNode(lLoop);

                if (csNode.GetAttribute("Name") == m_csMdlGenSettingString)
                {
                    this.label1.Text = m_csMdlGenSettingString;

                    csChildNodeList = csNode.GetChildNodeList();
                    lChildNodeListCount = csChildNodeList.GetCount();
                    for (lChildLoop = 0; lChildLoop < lChildNodeListCount; lChildLoop++)
                    {
                        csChildNode = csChildNodeList.GetNode(lChildLoop);
                        string csItemname = csChildNode.GetAttribute("Name");
                        string csItemtype = csChildNode.GetAttribute("Type");
                        string csItemkind = csChildNode.GetAttribute("Kind");
                        string csItemnum = csChildNode.GetAttribute("Num");
                        string csItemreadonly = csChildNode.GetAttribute("ReadOnly");

                        switch (csItemtype)
                        {
                            case "TEXT_TYPE":
                                dataGridView1.Columns.Add(csItemname, csItemname);

                                int cnt = dataGridView1.ColumnCount;
                                // 読み取り専用設定
                                if (csItemreadonly == "1")
                                {
                                    dataGridView1.Columns[cnt-1].ReadOnly = true;
                                }
                                break;
                            case "COMBO_TYPE":
                                //DataGridViewComboBoxColumnを作成
                                column = new DataGridViewComboBoxColumn();
                                //ComboBoxのリストに表示する項目を指定する
                                csChildChildNodeList = csChildNode.GetChildNodeList();
                                lChildChildNodeListCount = csChildChildNodeList.GetCount();

                                for (lChildChildLoop = 0; lChildChildLoop < lChildChildNodeListCount; lChildChildLoop++)
                                {
                                    csChildChildNode = csChildChildNodeList.GetNode(lChildChildLoop);
                                    string csComboname = csChildChildNode.GetAttribute("Name");
                                    column.Items.Add(csComboname);
                                }
                                //"River"列にバインドされているデータを表示する
                                column.DataPropertyName = "River";
                                dataGridView1.Columns.Add(column);
                                column.Name = csItemname;
                                
                                break;
                            case "BUTTON_TYPE":
                                //DataGridViewButtonColumnの作成
                                columnB = new DataGridViewButtonColumn();
                                //列の名前を設定
                                columnB.Name = csItemname;
                                //全てのボタンに"設定"と表示する
                                columnB.UseColumnTextForButtonValue = true;
                                columnB.Text = Properties.McMdlGenCommonScreenResource.CALCULATION_CONDITION_INPUT_SETTING_BUTTON;//"設定";
                                //DataGridViewに追加する
                                dataGridView1.Columns.Add(columnB);

                                break;
                            default:
                                break;

                        }
                    }
                }
            }
        }

        /// <summary> <para>method outline:</para>
        /// <para>定義ファイルのコンボボックス情報を返す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GetXmlComboItemName(string csDataName, string csItemName, string csID) </para>
        /// </example>
        /// <param name="csDataName">文字列</param>
        /// <param name="csItemName">文字列</param>
        /// <param name="csID">文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetXmlComboItemName(string csDataName, string csItemName, string csID)
        {
            HySXmlReader csXmlReader = null;
            HySString csFullPath = HySEnvInf.GetHomeDirectory() + DATA_PATH + XML_PATH;
            HySFile csFile = new HySFile(csFullPath);
            if (csFile.Exist() == true)
            {
                // 定義データの読み込み＆解析
                csXmlReader = new HySXmlReader(csFullPath);
            }
            HySXmlNode csRootNode = csXmlReader.GetRootNode();

            if (csRootNode == null)
            {
                // ＸＭＬファイル読込エラーの場合
                return "";
            }

            HySXmlNodeList csNodeList;
            HySXmlNodeList csChildNodeList;
            HySXmlNodeList csChildChildNodeList;
            HySXmlNode csNode;
            HySXmlNode csChildNode;
            HySXmlNode csChildChildNode;
            long lNodeListCount;
            long lChildNodeListCount;
            long lChildChildNodeListCount;
            long lLoop;
            long lChildLoop;
            long lChildChildLoop;
            csNodeList = csRootNode.GetChildNodeList();
            lNodeListCount = csNodeList.GetCount();
            for (lLoop = 0; lLoop < lNodeListCount; lLoop++)
            {
                csNode = csNodeList.GetNode(lLoop);

                if (csNode.GetAttribute("Name") == csDataName)
                {
                    csChildNodeList = csNode.GetChildNodeList();
                    lChildNodeListCount = csChildNodeList.GetCount();
                    for (lChildLoop = 0; lChildLoop < lChildNodeListCount; lChildLoop++)
                    {
                        csChildNode = csChildNodeList.GetNode(lChildLoop);

                        if (csChildNode.GetAttribute("Name") == csItemName)
                        {
                            string csItemtype = csChildNode.GetAttribute("Type");

                            switch (csItemtype)
                            {
                                //case "TEXT_TYPE":
                                //    break;
                                case "COMBO_TYPE":
                                    csChildChildNodeList = csChildNode.GetChildNodeList();
                                    lChildChildNodeListCount = csChildChildNodeList.GetCount();

                                    for (lChildChildLoop = 0; lChildChildLoop < lChildChildNodeListCount; lChildChildLoop++)
                                    {
                                        csChildChildNode = csChildChildNodeList.GetNode(lChildChildLoop);
                                        string csComboname = csChildChildNode.GetAttribute("Name");
                                        string csComboid = csChildChildNode.GetAttribute("Id");
                                        if (csComboid == csID)
                                        {
                                            return csChildChildNode.GetAttribute("Name");
                                        }

                                    }
                                    break;
                                //case "BUTTON_TYPE":
                                //    break;
                                default:
                                    break;

                            }
                        }
                    }
                }
            }
            return "";
        }
        /// <summary> <para>method outline:</para>
        /// <para>定義ファイルのコンボボックス情報を返す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GetXmlComboItemID(string csDataName, string csItemName, string csName) </para>
        /// </example>
        /// <param name="csDataName">文字列</param>
        /// <param name="csItemName">文字列</param>
        /// <param name="csName">文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetXmlComboItemID(string csDataName, string csItemName, string csName)
        {
            HySXmlReader csXmlReader = null;
            HySString csFullPath = HySEnvInf.GetHomeDirectory() + DATA_PATH + XML_PATH;
            HySFile csFile = new HySFile(csFullPath);
            if (csFile.Exist() == true)
            {
                // 定義データの読み込み＆解析
                csXmlReader = new HySXmlReader(csFullPath);
            }
            HySXmlNode csRootNode = csXmlReader.GetRootNode();

            if (csRootNode == null)
            {
                // ＸＭＬファイル読込エラーの場合
                return "";
            }

            HySXmlNodeList csNodeList;
            HySXmlNodeList csChildNodeList;
            HySXmlNodeList csChildChildNodeList;
            HySXmlNode csNode;
            HySXmlNode csChildNode;
            HySXmlNode csChildChildNode;
            long lNodeListCount;
            long lChildNodeListCount;
            long lChildChildNodeListCount;
            long lLoop;
            long lChildLoop;
            long lChildChildLoop;
            csNodeList = csRootNode.GetChildNodeList();
            lNodeListCount = csNodeList.GetCount();
            for (lLoop = 0; lLoop < lNodeListCount; lLoop++)
            {
                csNode = csNodeList.GetNode(lLoop);

                if (csNode.GetAttribute("Name") == csDataName)
                {
                    csChildNodeList = csNode.GetChildNodeList();
                    lChildNodeListCount = csChildNodeList.GetCount();
                    for (lChildLoop = 0; lChildLoop < lChildNodeListCount; lChildLoop++)
                    {
                        csChildNode = csChildNodeList.GetNode(lChildLoop);

                        if (csChildNode.GetAttribute("Name") == csItemName)
                        {
                            string csItemtype = csChildNode.GetAttribute("Type");

                            switch (csItemtype)
                            {
                                //case "TEXT_TYPE":
                                //    break;
                                case "COMBO_TYPE":
                                    csChildChildNodeList = csChildNode.GetChildNodeList();
                                    lChildChildNodeListCount = csChildChildNodeList.GetCount();

                                    for (lChildChildLoop = 0; lChildChildLoop < lChildChildNodeListCount; lChildChildLoop++)
                                    {
                                        csChildChildNode = csChildChildNodeList.GetNode(lChildChildLoop);
                                        string csComboname = csChildChildNode.GetAttribute("Name");
                                        string csComboid = csChildChildNode.GetAttribute("Id");
                                        if (csComboname == csName)
                                        {
                                            return csChildChildNode.GetAttribute("Id");
                                        }

                                    }
                                    break;
                                //case "BUTTON_TYPE":
                                //    break;
                                default:
                                    break;

                            }
                        }
                    }
                }
            }
            return "";
        }
        /// <summary> <para>method outline:</para>
        /// <para>定義ファイルのテキストボックス情報を返す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GetXmlTextItemKind(string csDataName, string csItemName) </para>
        /// </example>
        /// <param name="csDataName">文字列</param>
        /// <param name="csItemName">文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetXmlTextItemKind(string csDataName, string csItemName)
        {
            HySXmlReader csXmlReader = null;
            HySString csFullPath = HySEnvInf.GetHomeDirectory() + DATA_PATH + XML_PATH;
            HySFile csFile = new HySFile(csFullPath);
            if (csFile.Exist() == true)
            {
                // 定義データの読み込み＆解析
                csXmlReader = new HySXmlReader(csFullPath);
            }
            HySXmlNode csRootNode = csXmlReader.GetRootNode();

            if (csRootNode == null)
            {
                // ＸＭＬファイル読込エラーの場合
                return "";
            }

            HySXmlNodeList csNodeList;
            HySXmlNodeList csChildNodeList;
            HySXmlNode csNode;
            HySXmlNode csChildNode;
            long lNodeListCount;
            long lChildNodeListCount;
            long lLoop;
            long lChildLoop;
            csNodeList = csRootNode.GetChildNodeList();
            lNodeListCount = csNodeList.GetCount();
            for (lLoop = 0; lLoop < lNodeListCount; lLoop++)
            {
                csNode = csNodeList.GetNode(lLoop);

                if (csNode.GetAttribute("Name") == csDataName)
                {
                    csChildNodeList = csNode.GetChildNodeList();
                    lChildNodeListCount = csChildNodeList.GetCount();
                    for (lChildLoop = 0; lChildLoop < lChildNodeListCount; lChildLoop++)
                    {
                        csChildNode = csChildNodeList.GetNode(lChildLoop);

                        if (csChildNode.GetAttribute("Name") == csItemName)
                        {
                            return csChildNode.GetAttribute("Kind");
                        }
                    }
                }
            }
            return "";
        }

        /// <summary> <para>method outline:</para>
        /// <para>定義ファイルのテキストボックス情報を返す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GetXmlTextItemNum(string csDataName, string csItemName) </para>
        /// </example>
        /// <param name="csDataName">文字列</param>
        /// <param name="csItemName">文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetXmlTextItemNum(string csDataName, string csItemName)
        {
            HySXmlReader csXmlReader = null;
            HySString csFullPath = HySEnvInf.GetHomeDirectory() + DATA_PATH + XML_PATH;
            HySFile csFile = new HySFile(csFullPath);
            if (csFile.Exist() == true)
            {
                // 定義データの読み込み＆解析
                csXmlReader = new HySXmlReader(csFullPath);
            }
            HySXmlNode csRootNode = csXmlReader.GetRootNode();

            if (csRootNode == null)
            {
                // ＸＭＬファイル読込エラーの場合
                return "";
            }

            HySXmlNodeList csNodeList;
            HySXmlNodeList csChildNodeList;
            HySXmlNode csNode;
            HySXmlNode csChildNode;
            long lNodeListCount;
            long lChildNodeListCount;
            long lLoop;
            long lChildLoop;
            csNodeList = csRootNode.GetChildNodeList();
            lNodeListCount = csNodeList.GetCount();
            for (lLoop = 0; lLoop < lNodeListCount; lLoop++)
            {
                csNode = csNodeList.GetNode(lLoop);

                if (csNode.GetAttribute("Name") == csDataName)
                {
                    csChildNodeList = csNode.GetChildNodeList();
                    lChildNodeListCount = csChildNodeList.GetCount();
                    for (lChildLoop = 0; lChildLoop < lChildNodeListCount; lChildLoop++)
                    {
                        csChildNode = csChildNodeList.GetNode(lChildLoop);

                        if (csChildNode.GetAttribute("Name") == csItemName)
                        {
                            return csChildNode.GetAttribute("Num");
                        }
                    }
                }
            }
            return "";
        }

        /// <summary> <para>method outline:</para>
        /// <para>定義ファイルのユニークキー名称を返す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GetXmlUniqueName(string csDataName) </para>
        /// </example>
        /// <param name="csDataName">文字列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetXmlUniqueName(string csDataName)
        {
            HySXmlReader csXmlReader = null;
            HySString csFullPath = HySEnvInf.GetHomeDirectory() + DATA_PATH + XML_PATH;
            HySFile csFile = new HySFile(csFullPath);
            if (csFile.Exist() == true)
            {
                // 定義データの読み込み＆解析
                csXmlReader = new HySXmlReader(csFullPath);
            }
            HySXmlNode csRootNode = csXmlReader.GetRootNode();

            if (csRootNode == null)
            {
                // ＸＭＬファイル読込エラーの場合
                return "";
            }

            HySXmlNodeList csNodeList;
            HySXmlNodeList csChildNodeList;
            HySXmlNode csNode;
            HySXmlNode csChildNode;
            long lNodeListCount;
            long lChildNodeListCount;
            long lLoop;
            long lChildLoop;
            csNodeList = csRootNode.GetChildNodeList();
            lNodeListCount = csNodeList.GetCount();
            for (lLoop = 0; lLoop < lNodeListCount; lLoop++)
            {
                csNode = csNodeList.GetNode(lLoop);

                if (csNode.GetAttribute("Name") == csDataName)
                {
                    csChildNodeList = csNode.GetChildNodeList();
                    lChildNodeListCount = csChildNodeList.GetCount();
                    for (lChildLoop = 0; lChildLoop < lChildNodeListCount; lChildLoop++)
                    {
                        csChildNode = csChildNodeList.GetNode(lChildLoop);

                        if (csChildNode.GetAttribute("UniqueKey") == "1")
                        {
                            return csChildNode.GetAttribute("Name");
                        }
                    }
                }
            }
            return "";
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>dataGridView1_CellValidating( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void dataGridView1_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {
            if (dataGridView1.Columns[e.ColumnIndex] is DataGridViewTextBoxColumn)
            {
                string csDataName = this.label1.Text;
                string csItemName = dataGridView1.Columns[e.ColumnIndex].Name.ToString();
                string csKind = GetXmlTextItemKind(csDataName, csItemName);
                string csNum = GetXmlTextItemNum(csDataName, csItemName);

                // 桁数
                int iIndex = csNum.IndexOf(".");
                string csCut_Num;
                if (iIndex != -1)
                {
                    // 小数点以下削除
                    csCut_Num = csNum.Remove(iIndex);
                }
                else
                {
                    // 小数点なし
                    csCut_Num = csNum;
                }
                int iLnum = int.Parse(csCut_Num);

                // 全角チェック
                if (csKind == "A")
                {
                    if (isZenkaku((string)e.FormattedValue) == false)
                    {
                        dataGridView1[e.ColumnIndex, e.RowIndex].ErrorText = McMessage.GetString("MC_MSG_WARNING_MG_IMPUT_FULL_SIZE"); //"全角で入力してください。";
                        return;
                    }
                }
                // 数値チェック
                else if (csKind == "F")
                {
                    if (IsNumeric(e.FormattedValue) == false && e.FormattedValue.Equals("") == false)
                    {
                        dataGridView1[e.ColumnIndex, e.RowIndex].ErrorText = McMessage.GetString("MC_MSG_WARNING_MG_IMPUT_NUMBER"); //"数値を入力してください。";
                        return;
                    }
                }

                // 桁数チェック
                if (((string)e.FormattedValue).Length > iLnum)
                {
                    dataGridView1[e.ColumnIndex, e.RowIndex].ErrorText = McMessage.GetString("MC_MSG_WARNING_MG_CHECK_LINAGE"); //"桁数を確認してください。";
                    return;
                }
                
                // エラークリア
                dataGridView1[e.ColumnIndex, e.RowIndex].ErrorText = string.Empty;

            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セル選択</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>dataGridView1_CellContentClick( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void dataGridView1_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            DataGridView dgv = (DataGridView)sender;
            //"Button"列ならば、ボタンがクリックされた
            if (dgv.Columns[e.ColumnIndex] is DataGridViewButtonColumn)
            {
                // ユニークキーの名称取得
                string csXmlUniqueName = GetXmlUniqueName(this.label1.Text.ToString());
                string csUniqueName = "";
                for (int iIcnt = 0; iIcnt < dataGridView1.ColumnCount; iIcnt++)
                {
                    if (dgv.Columns[iIcnt].Name == csXmlUniqueName)
                    {
                        if (dataGridView1.Rows[e.RowIndex].Cells[iIcnt].Value != null
                            && dataGridView1.Rows[e.RowIndex].Cells[iIcnt].Value.ToString() != "")
                        {
                            csUniqueName = dataGridView1.Rows[e.RowIndex].Cells[iIcnt].Value.ToString();
                        }
                        break;
                    }
                }
                if (csUniqueName == "")
                {
                    //string csMsg = csXmlUniqueName + McMessage.GetString("MC_MSG_ERROR_MG_INPUT_EARLIER"); //"を先に入力してください。";
                    string csMsg = string.Format(McMessage.GetString("MC_MSG_ERROR_MG_INPUT_EARLIER"), csXmlUniqueName);
                    //MessageBox.Show(csMsg, "エラーメッセージ", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    MessageBox.Show(csMsg, McMessage.GetString("MC_MSG_TITLE_ERROR_MESSAGE"), MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }

                // 可変データ入力画面作成
                m_csInfSectionForm = new McMdlGenInfSectionForm();

                // データグリッドビューヘッダー部設定
                m_csInfSectionForm.SubFormSetHeaderDataGridView(this.label1.Text.ToString(), dgv.Columns[e.ColumnIndex].Name.ToString());

                // ユニークデータ名称設定
                m_csInfSectionForm.GetSectionList(csUniqueName);

                // データ表示
                m_csInfSectionForm.SetSectionList(m_csSectList);
                m_csInfSectionForm.SubFormSetData();

                // 表示位置設定
                m_csInfSectionForm.StartPosition = FormStartPosition.CenterParent;

                // 画面表示
                if (m_csInfSectionForm.ShowDialog() == DialogResult.OK)
                {
                    // 可変長データ数更新
                    for (int iIcnt = 0; iIcnt < dataGridView1.ColumnCount; iIcnt++)
                    {
                        //if (dgv.Columns[iIcnt].Name == csXmlUniqueName)
                        if (dgv.Columns[iIcnt].ReadOnly == true)
                        {
                            dataGridView1.Rows[e.RowIndex].Cells[iIcnt].Value = m_csInfSectionForm.GetSectionListCnt().ToString();
                            break;
                        }
                    }
                }
            }
        }

        #region　IsNumeric メソッド (+1)
        /// <summary>
        /// <para>method outline:</para>
        /// <para>数字チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = IsNumeric( stTarget )</para>
        /// </example>
        /// <param name="stTarget">対象文字</param>
        /// <returns>true:数字、false:数字以外</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private static bool IsNumeric(string stTarget)
        {
            double dNullable;

            return double.TryParse(
                stTarget,
                System.Globalization.NumberStyles.Any,
                null,
                out dNullable
            );
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>数字チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = IsNumeric( oTarget )</para>
        /// </example>
        /// <param name="oTarget">対象オブジェクト</param>
        /// <returns>true:数字、false:数字以外</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private static bool IsNumeric(object oTarget)
        {
            return IsNumeric(oTarget.ToString());
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>全角チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = isZenkaku( str )</para>
        /// </example>
        /// <param name="str">対象文字</param>
        /// <returns>true:全角、false:全角以外</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private static bool isZenkaku(string str)
        {
            int num = sjisEnc.GetByteCount(str);
            return num == str.Length * 2;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>半角チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = isHankaku( str )</para>
        /// </example>
        /// <param name="str">対象文字</param>
        /// <returns>true:半角、false:半角以外</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private static bool isHankaku(string str)
        {
            int num = sjisEnc.GetByteCount(str);
            return num == str.Length;
        }

        #endregion


        /// <summary>
        /// <para>method outline:</para>
        /// <para>閉じるイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McMdlGenInfSettingForm_FormClosing( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McMdlGenInfSettingForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            //this.NoticeModelDataSet();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>セル編集開始</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>dataGridView1_CellBeginEdit( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void dataGridView1_CellBeginEdit(object sender, DataGridViewCellCancelEventArgs e)
        {
            DataGridView dgv = (DataGridView)sender;
            // テキストボックス列か
            if (dgv.Columns[e.ColumnIndex] is DataGridViewTextBoxColumn)
            {
                // ユニークキーの名称取得
                string csXmlUniqueName = GetXmlUniqueName(this.label1.Text.ToString());

                if (dgv.Columns[e.ColumnIndex].Name.ToString() == csXmlUniqueName)
                {
                    if (dgv.Rows[e.RowIndex].Cells[e.ColumnIndex].Value != null
                        && dgv.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString() != "")
                    {
                        // 編集列がユニークキー列の場合、文字列格納
                        m_csUniqueName = dgv.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString();
                    }
                    else
                    {
                        m_csUniqueName = "";
                    }
                }
            }

        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>セル編集最終</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>dataGridView1_CellEndEdit( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void dataGridView1_CellEndEdit(object sender, DataGridViewCellEventArgs e)
        {
            // 編集列がユニークキー列の場合、編集開始時と比較し変更があった場合可変長リストのユニークキー列を更新する
            
            DataGridView dgv = (DataGridView)sender;
            // テキストボックス列か
            if (dgv.Columns[e.ColumnIndex] is DataGridViewTextBoxColumn)
            {
                // ユニークキーの名称取得
                string csXmlUniqueName = GetXmlUniqueName(this.label1.Text.ToString());

                if (dgv.Columns[e.ColumnIndex].Name.ToString() == csXmlUniqueName)
                {
                    if (dgv.Rows[e.RowIndex].Cells[e.ColumnIndex].Value != null
                        && dgv.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString() != "")
                    {
                        // 
                        if (dgv.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString() != m_csUniqueName)
                        {
                            // 可変長リストのユニーク文字列更新
                            for (int iCnt = 0; iCnt < this.m_csSectList.Count; iCnt++)
                            {
                                int iDtcnt = this.m_csSectList[iCnt].Count;
                                for (int iCntCnt = 0; iCntCnt < iDtcnt; iCntCnt++)
                                {
                                    // １項目目はユニーク名称
                                    if (iCntCnt == 0)
                                    {
                                        // ユニーク名称判定
                                        if (this.m_csSectList[iCnt][iCntCnt] == m_csUniqueName)
                                        {
                                            this.m_csSectList[iCnt][iCntCnt] = dgv.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString();
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    else
                    {
                        // ユニーク名称削除した場合は元に戻す
                        dgv.Rows[e.RowIndex].Cells[e.ColumnIndex].Value = m_csUniqueName;
                    }
                }
            }
        }

        /// <summary><para>method outline</para>
        /// <para>ヘルプリンクイベント</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HelpJump_button_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void HelpJump_button_Click(object sender, EventArgs e)
        {
            // ヘルプ画面の表示
            HySShowHelpNavigator.ShowHelpNavigator(HySShowHelpNavigator.NAV_MSG_MODELGEN_0002,null);
        }

    }
}
