﻿// <summary>ソースコード：モデル用プロパティスクリーンファクトリクラス型紙</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYMCO._SYSTEM_;
namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯスクリーンファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_SCREEN_FACTORY_CREATOR_IMPLE : PROPERTY_SCREEN_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_SCREEN_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_SCREEN_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_SCREEN_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルプロパティスクリーンファクトリインスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyScreenFactoryBase CreateFactory()
        {
            // ToDo 自作のモデルファクトリ（ネームスペース付き）を new して下さい。
            return new CommonMP.HYMCO.OptionImpl.MyModelLIB.MyModelPropertyScreenFactory();
        }
    }
}


// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.MyModelLIB
{  
    /// <summary><para>class outline:</para>
    /// <para>モデル用プロパティスクリーンファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/25][新規作成]</para>
    /// </remarks>
    public class MyModelPropertyScreenFactory : McPropertyScreenFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(csFactoryMng) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Init(HySFactoryMng csFactoryMng)
        {
            // ファクトリ管理インスタンス取得
            m_csFactoryMng = (HySFactoryManager)csFactoryMng;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            // To Do モデル作成側ファクトリクラスと同じ値にして下さい　←★重要
            return MyModelDefine.MODEL_FACTORY_LIB_ID;
        }

 
        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ画面インスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelPropertyScreen csScreen = CreatePropertyScreen( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelPropertyScreen モデルプロパティ画面インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McModelPropertyScreen CreatePropertyScreen(HySKind csModelKind)
        {
            McModelPropertyScreen csScreen = null;

            /* * コーディングイメージです
            if (csModelKind.Equals(MyModelDefine.MY_SPECIAL_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば

                // モデルプロパティ生成
                csScreen = new McMyModelPropertyScreen();
            }
            // ToDo　引数で与えられた　モデル識別子に従って、演算モデルを返して下さい。（知らない識別子の場合には null を返す）
            //else if( csModelKind.Equals(    
            * */
            return csScreen;
        }

        //
    }
}
