﻿// <summary>ソースコード：ＨＹＭＣＯ接続端子クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.Interface.Controller
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCO端子基底インターフェース</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface McPort : McRoot
    {

        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetTranInfo(csInfo) </para>
        /// </example>
        /// <param name="csInfo">要素間伝送情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetTranInfo(McTranInfo csInfo);

        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csInf = GetTranInfo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>要素間伝送情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfo GetTranInfo();

        /// <summary><para>method outline:</para>
        /// <para>端子を保持している要素の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>端子を保持している要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McElement GetElement();


        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetID(HySIdentifier csID);
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySIdentifier GetID();
        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Equal( csID ) </para>
        /// </example>
        /// <param name="csID">比較する種別識別子</param>
        /// <returns>  true :＝ , false:≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool Equal(HySIdentifier csID);
    }
}
