﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>データ出力基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/04/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>計算状態を復元するためのデータクラス</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    [Serializable]
    public class McCmnElementOutData : HySDataRoot, HySVersionManagement
    {
        /// <summary>演算インスタンス識別ＩＤ</summary>
        protected HySID m_csID;

        /// <summary>ユニーク識別子を作る為の一貫番号</summary>
        protected static ulong m_lElmNo;

        /// <summary> Calculate()メソッドコールフラグ DataFusion()メソッドコール前 </summary>
        protected long m_lCalculate_Call_Before_DataFution_Call;

        /// <summary>時刻データ管理テーブル</summary>
        protected HySDataHashTable m_csTimeDataTable = new HySDataHashTable();

        /// <summary>伝送データリスト管理テーブル</summary>
        protected Hashtable m_csTranInfoDataTable = new Hashtable();

        /// <summary> 演算データ </summary>
        protected McCalInfo m_csCalInfo;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCmnElementOutData csDt = new McCmnElementOutData()  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McCmnElementOutData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCmnElementOutData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算インスタンス識別ＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetID( csID )</para>
        /// </example>
        /// <param name="csID">演算インスタンス識別ＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetID(HySID csID)
        {
            m_csID = csID;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ユニーク識別子を作る為の一貫番号設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetElmNo(ulNum)</para>
        /// </example>
        /// <param name="ulNum">一貫番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetElmNo(ulong ulNum)
        {
            m_lElmNo = ulNum;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>Calculate()メソッドコールフラグ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetCalculateCallNum(lNum)</para>
        /// </example>
        /// <param name="lNum">Calculate()メソッドコールフラグ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetCalculateCallNum(long lNum)
        {
            m_lCalculate_Call_Before_DataFution_Call = lNum;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算インスタンス識別ＩＤ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySID csID = GetID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算インスタンス識別ＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySID GetID()
        {
            return m_csID;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ユニーク識別子を作る為の一貫番号取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ulong ulNumber = GetElmNo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>一貫番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public ulong GetElmNo()
        {
            return m_lElmNo;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>Calculate()メソッドコールフラグ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lCalCallNum = GetCalculateCallNum()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Calculate()メソッドコールフラグ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public long GetCalculateCallNum()
        {
            return m_lCalculate_Call_Before_DataFution_Call;
        }

        /// <summary><para>method outline:</para>
        /// <para>時刻データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTimeData(csKey, csDt) </para>
        /// </example>
        /// <param name="cskey">キー</param>
        /// <param name="csDt">データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetTimeData(HySStringRoot cskey, HySDataRoot csDt)
        {
            m_csTimeDataTable.AddObject((HySString)cskey, csDt);
        }

        /// <summary><para>method outline:</para>
        /// <para>時刻データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HysDataRoot csDataRoot = GetTimeData(csKey) </para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>HySDataRoot  データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySDataRoot GetTimeData(HySStringRoot csKey)
        {
            return m_csTimeDataTable.GetObject((HySString)csKey);
        }

        /// <summary><para>method outline:</para>
        /// <para>伝送データリスト設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTranInfoData(csKey, csDt) </para>
        /// </example>
        /// <param name="cskey">キー</param>
        /// <param name="csDt">伝送データリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetTranInfoData(HySStringRoot cskey, HySDataLinkedList csDt)
        {
            m_csTranInfoDataTable[cskey.ToString()] = csDt;
        }

        /// <summary><para>method outline:</para>
        /// <para>伝送データリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csDataRoot = GetTranInfoData(csKey) </para>
        /// </example>
        /// <param name="csKey">キー</param>
        /// <returns>HySDataLinkedList  伝送データリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySDataLinkedList GetTranInfoData(HySStringRoot csKey)
        {
            return (HySDataLinkedList)m_csTranInfoDataTable[csKey.ToString()];
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetData( csData )</para>
        /// </example>
        /// <param name="csData">演算データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetData(HySDataRoot csData)
        {
            if (csData is McCalInfo == true)
            {
                m_csCalInfo = (McCalInfo)(csData);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算データ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McCalInfo csData = GetData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public McCalInfo GetData()
        {
            return m_csCalInfo;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }

    }
}
