// <summary>ソースコード：セル型伝送データ接続プロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>セル型伝送データプロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    public interface McCellModelPropertyIF : McPropertyInfoRoot, McModelPropertyIF
    {
        // モデルへの入力接続情報関連
        /// <summary><para>method outline:</para>
        /// <para>入力接続の情報リスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csCnctList = GetInputConnectionInfoList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList  受信接続情報リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する
        /// リスト内は　McModelInfoが入っており、プロパティは、.GetPropertyInfo();で取り出す必要があるが、モデル未設定等によりnull の場合もある
        /// </para>
        /// </remarks>
        HySDataLinkedList GetInputConnectionInfoList();
        /// <summary><para>method outline:</para>
        /// <para>入力接続の情報リスト設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInputConnectionInfoList( csList ) </para>
        /// </example>
        /// <param name="csList">入力接続の情報リストし</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する
        /// リスト内は　McModelInfoが入っており、プロパティは、.GetPropertyInfo();で取り出す必要があるが、モデル未設定等によりnull の場合もある
        /// </para>
        /// </remarks>
        void SetInputConnectionInfoList( HySDataLinkedList csList);

        // モデルへの出力接続情報関連
        /// <summary><para>method outline:</para>
        /// <para>出力接続の情報リスト</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csCnctList = GetOutputConnectionInfoList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList  送信接続情報リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する
        /// リスト内は　McModelInfoが入っており、プロパティは、.GetPropertyInfo();で取り出す必要があるが、モデル未設定等によりnull の場合もある
        /// </para>
        /// </remarks>
        HySDataLinkedList GetOutputConnectionInfoList();
        /// <summary><para>method outline:</para>
        /// <para>出力接続の情報リスト設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetOutputConnectionInfoList(csList) </para>
        /// </example>
        /// <param name="csList">送信接続情報リスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する
        /// リスト内は　McModelInfoが入っており、プロパティは、.GetPropertyInfo();で取り出す必要があるが、モデル未設定等によりnull の場合もある
        /// </para>
        /// </remarks>
        void SetOutputConnectionInfoList( HySDataLinkedList csList);

        // 入力データ配列と実際の接続との対応をつける情報
        /// <summary><para>method outline:</para>
        /// <para>受信接続数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetInputConnectionNumber() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  受信接続数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する</para>
        /// </remarks>
        long GetInputConnectionNumber();
        /// <summary><para>method outline:</para>
        /// <para>受信情報配列に対応する受信ＩＤ（ユーザー設定）を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInputConnectionIndex(lIdxNo,csConnectionID) </para>
        /// </example>
        /// <param name="lIdxNo">配列位置</param>
        /// <param name="csConnectionID">受信情報識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続が完了した後に再度設定する必要がある</para>
        /// </remarks>
        void SetInputConnectionIndex(long lIdxNo, HySID csConnectionID);

        // 出力データ配列と実際の接続の対応をつける情報
        /// <summary><para>method outline:</para>
        /// <para>送信接続数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetOutputConnectionNumber() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  送信接続数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する</para>
        /// </remarks>
        long GetOutputConnectionNumber();
        /// <summary><para>method outline:</para>
        /// <para>送信情報配列に対応する受信ＩＤ（ユーザー設定）を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInputConnectionIndex(lIdxNo,csSendCellDataID) </para>
        /// </example>
        /// <param name="lIdxNo">配列位置</param>
        /// <param name="csSendCellDataID">送信情報識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続が完了した後に再度設定する必要がある</para>
        /// </remarks>
        void SetOutputConnectionIndex(long lIdxNo, HySID csSendCellDataID);

        /// <summary><para>method outline:</para>
        /// <para>端子毎に送信するセル型情報を管理するクラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSendCellData(lIdxNo,csSendCellData) </para>
        /// </example>
        /// <param name="csSendCellDataID">配列位置</param>
        /// <param name="csSendCellData">送信情報識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の場合には、再度設定する必要がある</para>
        /// </remarks>
        void SetSendCellData(HySID csSendCellDataID, McSendCellDataIF csSendCellData);

        /*
        /// <summary><para>method outline:</para>
        /// <para>送信接続数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetOutputConnectionNumber() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  送信接続数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する</para>
        /// </remarks>
        //long HasMcSendCellData();
        */

        /// <summary><para>method outline:</para>
        /// <para>送信するセル型情報を管理するクラスを作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSendCellDataIF[] m_OutputCellData = CreateSendCellData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSendCellDataIF[]  送信するセル型情報を管理するクラスの配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>McBasicCalculateModelBase派生モデルで使用する</para>
        /// </remarks>
        McSendCellDataIF[] CreateSendCellData();
        
        /*
        /// <summary><para>method outline:</para>
        /// <para>デフォルトで　送信端子にあわせたセル型情報を管理するクラスを作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MakeRecommendCellData(lTranInfoNumber, csOutputData) </para>
        /// </example>
        /// <param name="lTranInfoNumber">送信伝送データ数</param>
        /// <param name="csOutputData">送信伝送データ配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ｵﾍﾟﾚｰﾀが何も設定しない場合等に用いる</para>
        /// </remarks>
        void MakeRecommendCellData( ); //long lTranInfoNumber, McTranInfo[] csOutputData);
        */
        /// <summary><para>method outline:</para>
        /// <para>全送信するセル型情報は設定されているか？</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = IsAllSendCellDataSet() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool  全送信するセル型情報は設定されている場合＝true が返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>return 値が false の場合には　プロパティが設定されていない可能性がある</para>
        /// </remarks>
        bool IsAllSendCellDataSet();

        /// <summary><para>method outline:</para>
        /// <para>モデルの送受信パターン情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McTranInfoPatternPropertyIF csPtn = CreateTranInforPattern(csID,csTranInfoKind,sName) </para>
        /// </example>
        /// <param name="csID">パターンＩＤ</param>
        /// <param name="csTranInfoKind">伝送データ種別</param>
        /// <param name="sName">パターン名称</param>
        /// <returns>McTranInfoPatternPropertyIF モデルの送受信パターン情報</returns>
        /// <exception cref="">無し </exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfoPatternPropertyIF CreateTranInforPattern(HySID csID, HySObjectKind csTranInfoKind, String sName);

        // モデルが期待する受信情報パターン  
        /// <summary><para>method outline:</para>
        /// <para>モデルが期待する受信情報パターン設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddReceivePattern(csID,csPtn) </para>
        /// </example>
        /// <param name="csPtn">パターン情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void AddReceivePattern(McTranInfoPatternPropertyIF csPtn);
        /// <summary><para>method outline:</para>
        /// <para>モデルが期待する受信情報パターンの数</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetReceivePatternNumber() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  受信情報パターン数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetReceivePatternNumber();
        /// <summary><para>method outline:</para>
        /// <para>モデルが期待する受信情報パターン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csPtnList = GetReceivePatternList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList  受信情報パターン(リンクリスト形式）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDataLinkedList GetReceivePatternList();
        /// <summary><para>method outline:</para>
        /// <para>モデルが期待する受信情報パターン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfoPatternPropertyIF csPtn = GetReceivePattern(csID) </para>
        /// </example>
        /// <param name="csID">パターンＩＤ</param>
        /// <returns>McTranInfoPatternPropertyIF  受信情報パターン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfoPatternPropertyIF GetReceivePattern(HySID csID);


        // モデルが送信する情報パターン
        /// <summary><para>method outline:</para>
        /// <para>モデルが出力する送信情報パターン設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddSendPattern(csID,csPtn) </para>
        /// </example>
        /// <param name="csPtn">パターン情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void AddSendPattern(McTranInfoPatternPropertyIF csPtn);
        /// <summary><para>method outline:</para>
        /// <para>モデルが出力する送信情報パターンの数</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetSendPatternNumber() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  送信情報パターン数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetSendPatternNumber();
        /// <summary><para>method outline:</para>
        /// <para>モデルが出力する送信情報パターン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csPtnList = GetSendPatternList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList  送信情報パターン(リンクリスト形式）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDataLinkedList GetSendPatternList();
        /// <summary><para>method outline:</para>
        /// <para>モデルが出力する送信情報パターン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfoPatternPropertyIF csPtn = GetSendPattern(csID) </para>
        /// </example>
        /// <param name="csID">パターンＩＤ</param>
        /// <returns>McTranInfoPatternPropertyIF  送信情報パターン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfoPatternPropertyIF GetSendPattern(HySID csID);


        /*
        /// <summary><para>method outline:</para>
        /// <para>期待する入力データのセル内データ種別を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetExpectedInputDataKind(csID, csInputData,csDataKindInCell) </para>
        /// </example>
        /// <param name="csDataID">入力データへの識別子</param>
        /// <param name="csInputData">入力データのタイプ</param>
        /// <param name="csDataKindInCell">期待するセル内データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetExpectedInputDataKind(HySID csDataID, McTranInfo csInputData,  HySDataCharacteristicInCell csDataKindInCell);

        /// <summary><para>method outline:</para>
        /// <para>入力データのセル内データ種別を取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetExpectedInputDataKind(csID, csInputData) </para>
        /// </example>
        /// <param name="csDataID">入力データへの識別子</param>
        /// <param name="csInputData">入力データのタイプ</param>
        /// <returns>HySDataCharacteristicInCell 入力データのセル内のデータ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDataCharacteristicInCell GetExpectedInputDataKind(HySID csDataID, McTranInfo csInputData);

        /// <summary><para>method outline:</para>
        /// <para>出力データのセル内データ種別を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetOutputDataKind(csID, csOutputData,csDataKindInCell) </para>
        /// </example>
        /// <param name="csDataID">出力データへの識別子</param>
        /// <param name="csOutputData">出力データのタイプ</param>
        /// <param name="csDataKindInCell">期待するセル内データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetOutputDataKind(HySID csDataID, McTranInfo csOutputData, HySDataCharacteristicInCell csDataKindInCell);

        /// <summary><para>method outline:</para>
        /// <para>出力データのセル内データ種別を取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetOutputDataKind(csID, csInputData) </para>
        /// </example>
        /// <param name="csDataID">出力データへの識別子</param>
        /// <param name="csOutputData">出力データのタイプ</param>
        /// <returns>HySDataCharacteristicInCell 出力データのセル内のデータ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDataCharacteristicInCell GetOutputDataKind(HySID csDataID, McTranInfo csOutputData);
        */
    
    }
}
