// <summary>ソースコード：セル型伝送データ接続プロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>セル型伝送データプロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    public interface McCellTranPropertyIF : McConnectionPropertyIF
    {
        /// <summary><para>method outline:</para>
        /// <para>内挿方式設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInterpolateType(eInterpolateType) </para>
        /// </example>
        /// <param name="eInterpolateType">内挿方式</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetInterpolateType(HySDefine.InterpolateType eInterpolateType);
        /// <summary><para>method outline:</para>
        /// <para>内挿方式取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDefine.InterpolateType eInterpolateType = GetInterpolateType() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDefine.InterpolateType  内挿方式</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDefine.InterpolateType GetInterpolateType();

        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataGetter(csCellGetter); </para>
        /// </example>
        /// <param name="csCellGetter">セル内データ取得クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetCellDataGetter(HySCellDataGetter csCellGetter);
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellDataGetter csCellGetter = GetCellDataGetter(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellDataGetter セル内データ取得クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySCellDataGetter GetCellDataGetter();

        /// <summary><para>method outline:</para>
        /// <para>受信側セル型伝送パターンの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetReceiveTranInfoPattern(csTranInfoPattern); </para>
        /// </example>
        /// <param name="csTranInfoPattern">セル型伝送パターン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetReceiveTranInfoPattern(McTranInfoPatternPropertyIF csTranInfoPattern);
        /// <summary><para>method outline:</para>
        /// <para>受信側セル型伝送パターンの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfoPatternPropertyIF csTranInfoPattern=GetReceiveTranInfoPattern(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranInfoPatternPropertyIF セル型伝送パターン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfoPatternPropertyIF GetReceiveTranInfoPattern();
        /// <summary><para>method outline:</para>
        /// <para>送信側セル型伝送パターンの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSendTranInfoPattern(csTranInfoPattern); </para>
        /// </example>
        /// <param name="csTranInfoPattern">セル型伝送パターン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetSendTranInfoPattern(McTranInfoPatternPropertyIF csTranInfoPattern);
        /// <summary><para>method outline:</para>
        /// <para>送信側セル型伝送パターンの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfoPatternPropertyIF csTranInfoPattern=GetSendTranInfoPattern(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranInfoPatternPropertyIF セル型伝送パターン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfoPatternPropertyIF GetSendTranInfoPattern();
    }
}
