// <summary>ソースコード：接続プロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>接続プロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    public interface McConnectionPropertyIF : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>上流要素のモデル情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetUpperElementModelInfor(csMcModelInfo)</para>
        /// </example>
        /// <param name="csMcModelInfo">モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetUpperElementModelInfor(HySDataRoot csMcModelInfo);
        /// <summary><para>method outline:</para>
        /// <para>下流要素のモデル情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLowerElementModelInfor(csMcModelInfo)</para>
        /// </example>
        /// <param name="csMcModelInfo">モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetLowerElementModelInfor(HySDataRoot csMcModelInfo);

        /// <summary><para>method outline:</para>
        /// <para>上流要素のモデルプロパティ情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetFromElementModelInfor(csMcModelInfo)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelPropertyIF　モデルプロパティ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McModelPropertyIF GetUpperModelProperty( );
        /// <summary><para>method outline:</para>
        /// <para>下流要素のモデルプロパティ情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetToElementModelInfor(csMcModelInfo)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelPropertyIF　モデルプロパティ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McModelPropertyIF GetLowerModelProperty( );

        /// <summary><para>method outline:</para>
        /// <para>上流要素のモデル情報情報パターンＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetUpperConnectionPatternID(csCnnctPtnID)</para>
        /// </example>
        /// <param name="csCnnctPtnID">接続パターンＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetUpperConnectionPatternID(HySID csCnnctPtnID);
        /// <summary><para>method outline:</para>
        /// <para>下流要素のモデル情報情報パターンＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLowerConnectionPatternID(csCnnctPtnID)</para>
        /// </example>
        /// <param name="csCnnctPtnID">接続パターンＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetLowerConnectionPatternID(HySID csCnnctPtnID);
        /// <summary><para>method outline:</para>
        /// <para>上流要素のモデル情報情報パターンＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySID csCnnctPtnID = GetUpperConnectionPatternID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 接続パターンＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySID GetUpperConnectionPatternID();
        /// <summary><para>method outline:</para>
        /// <para>下流要素のモデル情報情報パターンＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySID csCnnctPtnID = GetLowerConnectionPatternID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 接続パターンＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySID GetLowerConnectionPatternID();
    }
}
