// <summary>ソースコード：モデルプロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>モデルプロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    //[Serializable]
    public interface McModelPropertyIF : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>演算実行刻み時間（δT)設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetStepTime(dDltT) </para>
        /// </example>
        /// <param name="dDltT">演算実行刻み時間（δT) (sec)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetStepTime(double dDltT);
        /// <summary><para>method outline:</para>
        /// <para>演算実行刻み時間（δT)取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dDltT = GetStepTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double  演算実行刻み時間（δT) (sec)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        double GetStepTime();

    }
}
