﻿// <summary>ソースコード：モデルプロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>プロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>プロパティ画面に表示すべき情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/23][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    [Serializable]
    public abstract class McPropertyInfoBase : McPropertyInfoRoot, HySVersionManagement
    {
        ///// <summary> 構造定義ファイル（XML)出力フラグ：true=出力、false=出力せず </summary>
        //protected static bool g_lXmlOutFlg = false;
        /// <summary> 
        /// 構造定義ファイル（XML)出力フラグ：
        ///  McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_PART 接続情報のみ
        ///  McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL 　全ての情報を１ファイルにて出力
        ///  McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_SEPARATE　ファイルを分割して全ての情報
        /// </summary>
        protected static long g_lXmlOutFlg = McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL;


        /// <summary>ライブラリ識別子（必須）</summary>
        protected HySID m_csLibraryID = null;
        /// <summary>モデルの名称（必須）</summary>
        protected HySString m_csModelName = null;
        /// <summary>モデルの種別（必須）</summary>
        protected HySObjectKind m_csModelKind = null;
        /// <summary>インスタンス識別ＩＤ</summary>
        protected HySID m_csID = null;

        /// <summary>セルと識別子の対応管理データ </summary>
        protected McCellIDMngIF m_csCellIDMngData = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private McPropertyInfoBase()
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInfoRoot = new McPropertyInfoRoot() </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>McPropertyInfoRoot 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McPropertyInfoBase(HySID csLibraryID, HySObjectKind csModelKind)
        {
            m_csLibraryID = csLibraryID;
            m_csModelKind = csModelKind;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryID(csID) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFactoryID(HySID csID)
        {
            m_csLibraryID = csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetFactoryID() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID  識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetFactoryID()
        {
            return m_csLibraryID;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル名称を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelName(csName) </para>
        /// </example>
        /// <param name="csName">モデルの名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetModelName(HySString csName)
        {
            m_csModelName = csName;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルの名称を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = GetModelName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  モデルの名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetModelName()
        {
            return m_csModelName;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルのユニーク種別を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelKind(csKind) </para>
        /// </example>
        /// <param name="csKind">モデルの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetModelKind(HySKind csKind)
        {
            m_csModelKind = (HySObjectKind)csKind;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルの種別を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySKind csKind = GetModelKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind  モデルの種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySKind GetModelKind()
        {
            return m_csModelKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>個別インスタンス識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID(csID) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetID(HySID csID)
        {
            m_csID = csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>個別インスタンス識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID  識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetID()
        {
            return m_csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Equal(csID) </para>
        /// </example>
        /// <param name="csID">比較する種別識別子</param>
        /// <returns>bool　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool Equal(HySID csID)
        {
            return m_csID.Equals(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>セルと識別子の対応管理データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellIDMngData(csID) </para>
        /// </example>
        /// <param name="csCellIDMngData">セルと識別子の対応管理データ</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellIDMngData(McCellIDMngIF csCellIDMngData)
        {
            m_csCellIDMngData = csCellIDMngData;
        }
        /// <summary><para>method outline:</para>
        /// <para>セルと識別子の対応管理データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCellIDMngIF csDt = GetCellIDMngData </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McCellIDMngIF  セルと識別子の対応管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McCellIDMngIF GetCellIDMngData()
        {
            return m_csCellIDMngData;
        }
        /// <summary><para>method outline:</para>
        /// <para>セルと識別子の対応管理データの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCellIDMngIF csDt = CreateCellIDMngData(csKind) </para>
        /// </example>
        /// <param name="csKind">識別子</param>
        /// <returns>McCellIDMngIF  セルと識別子の対応管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract McCellIDMngIF CreateCellIDMngData(HySKind csKind);
        /// <summary><para>method outline:</para>
        /// <para>XML書き出しをXMLノードを</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlCreateNode(csXmlWriter) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual HySXmlNode XmlCreateNode(ref HySXmlWriter csXmlWriter)
        {
            return  HySXmlNode.CreateElement(McDefine.xml_PROPERTY, csXmlWriter);
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csFile) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            //HySXmlNode csRtn = HySXmlNode.CreateElement(McDefine.xml_PROPERTY, csXmlWriter);
            HySXmlNode csRtn = this.XmlCreateNode(ref csXmlWriter);
            /*
            if (g_bXmlOutFlg == true)
            {   // XML出力ONならば
                if( m_csCellIDMngData != null )
                {
                    HySXmlNode csLclNode = m_csCellIDMngData.XmlOUT(ref csXmlWriter);
                    csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う
                }
            }
            */
            HySXmlNode csLclNode = null;
            McCellIDMngIF csMngDt = this.GetCellIDMngData();
            if (csMngDt != null)
            {
                //if (g_lXmlOutFlg == true)
                if (g_lXmlOutFlg == McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_PART)
                {   // XML出力OFFならば
                    // Do Nothing
                }
                else if (g_lXmlOutFlg == McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL)
                {   // XML出力ON & 一括ファイル出力ならば
                    csLclNode = csMngDt.XmlOUT(ref csXmlWriter);
                    csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う
                }
                else if (g_lXmlOutFlg == McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_SEPARATE)
                {   // XML出力ON & 分割ファイル出力ならば
                    HySString csFileName = csMngDt.GetXmlFileName();
                    HySString csPath = csMngDt.GetXmlFileBasePath();
                    if ((object)csFileName != null)
                    {
                        HySString csMainFile = csXmlWriter.GetFileName();
                        string sMainFileName = ""; string sMainFileNameWithoutSfx = ""; string sMainPath = "";
                        this.GetFileNameString(csMainFile, ref sMainFileName, ref sMainFileNameWithoutSfx, ref  sMainPath);


                        csLclNode = HySXmlNode.CreateElement(McDefine.xml_CELL_ID_MNG_FILE, csXmlWriter);

                        //csLclNode.SetAttribute(McDefine.xml_NAME, csFileName.ToString());
                        string sFileName = ""; string sFileNameWithoutSfx = ""; string sPath = "";
                        this.GetFileNameString(csFileName, ref sFileName, ref sFileNameWithoutSfx, ref  sPath);

                        //csLclNode.SetAttribute(McDefine.xml_NAME, sFileName);
                        //csLclNode.SetAttribute(McDefine.xml_MODELKIND, csMngDt.GetClassName().ToString());
                        //csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う
                        if (((object)csPath) == null)
                        {
                            csPath = new HySString("");
                        }
                        if (csPath.ToString() != "")
                        {
                                // Do Nothing
                        }
                        else
                        {
                            csMngDt.SetXmlFileBasePath(this.GetProjectGroupDirectory() + new HySString("\\"));
                            csMngDt.SetXmlFileName(new HySString("ParameterData\\" + sFileName));
                        }

                        //csMngDt.XmlFileWrite(); // 別ﾌｧｲﾙとして　内容を出力する
                        //csMngDt.SetXmlFileName(new HySString(sMainPath+"\\"+sFileName));
                        csMngDt.XmlFileWrite(); // 別ﾌｧｲﾙとして　内容を出力する


                        //csLclNode.SetAttribute(McDefine.xml_NAME, sFileName);
                        csLclNode.SetAttribute(McDefine.xml_MODELKIND, csMngDt.GetClassName().ToString());
                        csLclNode.SetAttribute(McDefine.xml_NAME, csMngDt.GetXmlFileName().ToString());

                        csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う
                    }
                    else
                    {
                        csMngDt.SetXmlFileBasePath(this.GetProjectGroupDirectory() + new HySString("\\"));
                        csLclNode = csMngDt.XmlOUT(ref csXmlWriter);
                        csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う
                    }
                }
                else
                {
                    // Do Nothing
                }
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>XMLからモデル情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csPrptyXml) </para>
        /// </example>
        /// <param name="csPrptyXml">入力XML</param>
        /// <returns>bool　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool XmlIN(HySXmlNode csPrptyXml)
        {
            bool bRtn = true;
            /*
            if (m_csCellIDMngData != null)
            {
                m_csCellIDMngData.XmlIN(csXml);
            }
            */
            HySXmlNode csXml = null;
            HySXmlNodeList csXmlVariableList = null;
            csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(McDefine.xml_CELL_ID_MNG_FILE);
            {
                csXml = csXmlVariableList.GetNode(0);
                if (csXml != null)
                {
                    string sKeyAttr = csXml.GetAttribute(McDefine.xml_NAME);
                    HySString csFileName = new HySString(sKeyAttr);
                    McCellIDMngIF csMngDt = this.GetCellIDMngData();
                    if (csMngDt != null)
                    {
                        HySString csBasePath = this.GetProjectGroupDirectory() + new HySString("\\");   //相対化パスを設定する
                        csMngDt.SetXmlFileBasePath(csBasePath);

                        csMngDt.SetXmlFileName(csFileName);
                        csMngDt.XmlFileRead();
                    }
                    else
                    {
                                       
                        HySObjectKind csKnd = new HySObjectKind("");
                        string sKind = csXml.GetAttribute(McDefine.xml_MODELKIND);
                        if (sKind != "") { csKnd = new HySObjectKind(sKind); }

                        csMngDt = this.CreateCellIDMngData(csKnd);
                        this.SetCellIDMngData(csMngDt);
                        // 生成する必要がある。
                        if (csMngDt != null)
                        {
                            HySString csBasePath = this.GetProjectGroupDirectory() + new HySString("\\");   //相対化パスを設定する
                            csMngDt.SetXmlFileBasePath(csBasePath);

                            csMngDt.SetXmlFileName(csFileName);
                            csMngDt.XmlFileRead();
                        }
                    }
                }
                //else
                //{
                //}
            }
            csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(McDefine.xml_TRAN_CELL_MANAGE_TABLE);
            {
                csXml = csXmlVariableList.GetNode(0);
                if (csXml != null)
                {
                    McCellIDMngIF csMngDt = this.GetCellIDMngData();
                    if (csMngDt != null)
                    {
                        csMngDt.XmlIN(csXml);
                    }
                    else
                    {
                        HySObjectKind csKnd = new HySObjectKind("");
                        string sKind = csXml.GetAttribute(McDefine.xml_MODELKIND);
                        if (sKind != "") { csKnd = new HySObjectKind(sKind); }

                        csMngDt = this.CreateCellIDMngData(csKnd);
                        this.SetCellIDMngData(csMngDt);
                        // 生成する必要がある。
                        if (csMngDt != null)
                        {
                            HySString csBasePath = this.GetProjectGroupDirectory() + new HySString("\\");   //相対化パスを設定する
                            csMngDt.SetXmlFileBasePath(csBasePath);

                            string sFileNameWithPath = csXml.GetAttribute(McDefine.xml_CELL_ID_MNG_FILE);
                            if (sFileNameWithPath != "")
                            {
                                csMngDt.SetXmlFileName(new HySString(sFileNameWithPath));
                                bRtn = csMngDt.XmlFileRead();
                            }
                            else
                            {
                                csMngDt.XmlIN(csXml);
                            }
                        }
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInfoRoot = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract McPropertyInfoRoot Clone();

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyInf(csOrgObjRoot) </para>
        /// </example>
        /// <param name="csOrgObjRoot">コピー元情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual void CopyInf(McPropertyInfoRoot csOrgObjRoot)
        {
            McPropertyInfoBase csOrgObj = csOrgObjRoot as McPropertyInfoBase;
            if (csOrgObj.m_csLibraryID != null)
            {   // オリジナルデータ有り
                this.m_csLibraryID = csOrgObj.m_csLibraryID.Clone();
            }
            if ((object)csOrgObj.m_csModelName != null)
            {   // オリジナルデータ有り
                this.m_csModelName = csOrgObj.m_csModelName.Clone();
            }
            if (csOrgObj.m_csModelKind != null)
            {   // オリジナルデータ有り
                this.m_csModelKind = csOrgObj.m_csModelKind.Clone();
            }
            if (csOrgObj.m_csID != null)
            {   // オリジナルデータ有り
                this.m_csID = csOrgObj.m_csID.Clone();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>XML（構造定義ファイル）への出力有無設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetXmlOutFlg(bSW) </para>
        /// </example>
        /// <param name="lSW">
        ///  McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_PART      接続情報のみ出力
        ///  McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL 　    全ての情報を１ファイルにて出力
        ///  McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_SEPARATE　ファイルを分割して全ての情報を出力
        /// </param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void SetXmlOutFlg(long lSW)
        {
            g_lXmlOutFlg = lSW;
        }
        /// <summary><para>method outline:</para>
        /// <para>XML（構造定義ファイル）への出力有無設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetXmlOutFlg() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long
        ///  McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_PART      接続情報のみ出力
        ///  McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_ALL 　    全ての情報を１ファイルにて出力
        ///  McDefine.HYMCO_MODEL_STRUCTINFO_WRITE_SEPARATE　ファイルを分割して全ての情報を出力
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static long GetXmlOutFlg( )
        {
            return g_lXmlOutFlg;
        }

        /// <summary><para>method outline:</para>
        /// <para>構造定義ファイル本体部出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = GetFileNameString(sSCFNameWithPath, ref sFileName, ref sFileNameWithoutSfx, ref sPath)</para>
        /// </example>
        /// <param name="sSCFNameWithPath">パス付きファイル名称</param>
        /// <param name="sFileName">パス無しファイル名</param>
        /// <param name="sFileNameWithoutSfx">X添え字無しファイル名</param>
        /// <param name="sPath">ファイルへのパス</param>
        /// <returns>bool =true:正常、=false:異常 </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected bool GetFileNameString(HySString sSCFNameWithPath, ref string sFileName, ref string sFileNameWithoutSfx, ref string sPath)
        {
            string sFileNamePath = sSCFNameWithPath.ToString();
            int lLstPathIdx = -1; int lTmpLstPathIdx = -1;
            for (long lStr = 0; lStr < sSCFNameWithPath.GetLength(); lStr++)
            {
                lTmpLstPathIdx = sFileNamePath.IndexOf("\\", lLstPathIdx + 1);
                if (lTmpLstPathIdx >= 0)
                { lLstPathIdx = lTmpLstPathIdx; }
                else
                { break; }
            }
            sFileName = sFileNamePath.Substring(lLstPathIdx + 1);
            sFileNameWithoutSfx = sFileName.Substring(0, sFileName.Length - 4);
            if( lLstPathIdx > -1 )
            {
                sPath = sFileNamePath.Substring(0, lLstPathIdx);
            }
            return true;
        }


        /// <summary><para>method outline:</para>
        /// <para>CommonMPデータホームディレクトリ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csDataHomeDirectory = GetDataHomeDirectory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  CommonMPデータホームディレクトリ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetDataHomeDirectory()
        {
            return HySEnvInf.GetDataHomeDirectory();
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループ名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csGrpName = GetProjectGroupName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  プロジェクトグループ名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetProjectGroupName()
        {
            return new HySString("");
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループディレクトリ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csDirectory = GetProjectGroupDirectory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  プロジェクトグループディレクトリ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetProjectGroupDirectory()
        {
            return new HySString("");
        }
        /// <summary><para>method outline:</para>
        /// <para>計算の識別子（計算ロット）を取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csCalLot = GetCalculationLotName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  計算の識別子（計算ロット）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>同じプロジェクトで計算を繰り返す場合、前回の計算と今回の計算を区別するための識別子を取得する</para>
        /// </remarks>
        public virtual HySString GetCalculationLotName()
        {
            return new HySString("");
        }
        /// <summary><para>method outline:</para>
        /// <para>データホームを基準とした相対パスを取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetRelativePathBasedOnDataHome(csAbsolutePath, refcsRelativePath)</para>
        /// </example>
        /// <param name="csAbsolutePath">絶対パス</param>
        /// <param name="csRelativePath">相対パス</param>
        /// <returns>相対化不能の場合には　false を返す</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>与えられた絶対パス値を　CommonMPデータホームを基準とした相対パスに変換して取得する</para>
        /// </remarks>
        public virtual bool GetRelativePathBasedOnDataHome(HySString csAbsolutePath, ref HySString csRelativePath)
        {
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループディレクトリを基準とした相対パスを取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetRelativePathBasedOnProjectGroup(csAbsolutePath, refcsRelativePath)</para>
        /// </example>
        /// <param name="csAbsolutePath">絶対パス</param>
        /// <param name="csRelativePath">相対パス</param>
        /// <returns>相対化不能の場合には　false を返す</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>与えられた絶対パス値を　プロジェクトグループディレクトリを基準とした相対パスに変換して取得する</para>
        /// </remarks>
        public virtual bool GetRelativePathBasedOnProjectGroup(HySString csAbsolutePath, ref HySString csRelativePath)
        {
            return true;
        }
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
