﻿// <summary>ソースコード：モデルプロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>プロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>プロパティ画面に表示すべき情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/23][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    //[Serializable]
    public interface McPropertyInfoRoot : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryID(csID) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetFactoryID(HySID csID);
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetFactoryID() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID  識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySID GetFactoryID();

        /// <summary><para>method outline:</para>
        /// <para>モデル名称を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelName(csName) </para>
        /// </example>
        /// <param name="csName">モデルの名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetModelName(HySString csName);
        /// <summary><para>method outline:</para>
        /// <para>モデルの名称を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = GetModelName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  モデルの名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySString GetModelName();

        /// <summary><para>method outline:</para>
        /// <para>モデルのユニーク種別を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelKind(csKind) </para>
        /// </example>
        /// <param name="csKind">モデルの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetModelKind(HySKind csKind);
        /// <summary><para>method outline:</para>
        /// <para>モデルの種別を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySKind csKind = GetModelKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySKind  モデルの種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySKind GetModelKind();

        /// <summary><para>method outline:</para>
        /// <para>個別インスタンス識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID(csID) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetID(HySID csID);
        /// <summary><para>method outline:</para>
        /// <para>個別インスタンス識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID  識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySID GetID();
        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Equal(csID) </para>
        /// </example>
        /// <param name="csID">比較する種別識別子</param>
        /// <returns>bool　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool Equal(HySID csID);

        /// <summary><para>method outline:</para>
        /// <para>セルと識別子の対応管理データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellIDMngData(csID) </para>
        /// </example>
        /// <param name="csCellIDMngData">セルと識別子の対応管理データ</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetCellIDMngData(McCellIDMngIF csCellIDMngData);
        /// <summary><para>method outline:</para>
        /// <para>セルと識別子の対応管理データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCellIDMngIF csDt = GetCellIDMngData </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McCellIDMngIF  セルと識別子の対応管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McCellIDMngIF GetCellIDMngData();
        /// <summary><para>method outline:</para>
        /// <para>セルと識別子の対応管理データの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCellIDMngIF csDt = CreateCellIDMngData(csKind) </para>
        /// </example>
        /// <param name="csKind">識別子</param>
        /// <returns>McCellIDMngIF  セルと識別子の対応管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McCellIDMngIF CreateCellIDMngData(HySKind csKind);

        /// <summary><para>method outline:</para>
        /// <para>モデル情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csFile) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter);
        /// <summary><para>method outline:</para>
        /// <para>XMLからモデル情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csFile) </para>
        /// </example>
        /// <param name="csXml">入力XML</param>
        /// <returns>bool　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool XmlIN(HySXmlNode csXml);

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInfoRoot = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McPropertyInfoRoot Clone();

    }
}
