// <summary>ソースコード：モデルプデータジェネレーター作成条件等のクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>モデルデータ作成制御画面表示条件等のクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    //[Serializable]
    public interface McMdlDtGenScreenReqInfoIF : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>使用できるモデルジェネレーターのリストを設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelGeneratorList(csMdlGenList) </para>
        /// </example>
        /// <param name="csMdlGenList">モデルジェネレーターのリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面上で選択可能なモデルジェネレーターのリストを設定する</para>
        /// </remarks>
        void SetModelGeneratorList(HySDataLinkedList csMdlGenList);
        /// <summary><para>method outline:</para>
        /// <para>使用できるモデルジェネレーターのリストを取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csMdlGenList = GetModelGeneratorList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList 使用できるモデルジェネレーターのリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面上で選択可能なモデルジェネレーターのリストを取得する</para>
        /// </remarks>
        HySDataLinkedList GetModelGeneratorList();

        /// <summary><para>method outline:</para>
        /// <para>使用できるモデルジェネレーター固有画面のリストを設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelGeneratorScreenList(csMdlGenScreenList) </para>
        /// </example>
        /// <param name="csMdlGenScreenList">モデルジェネレーター固有画面のリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面上で選択可能なモデルジェネレーター固有画面のリストを設定する</para>
        /// </remarks>
        void SetModelGeneratorScreenList(HySDataLinkedList csMdlGenScreenList);
        /// <summary><para>method outline:</para>
        /// <para>使用できるモデルジェネレーター固有画面のリストを取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csMdlGenScreenList = GetModelGeneratorScreenList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList 使用できるモデルジェネレーター固有画面のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面上で選択可能なモデルジェネレーター固有画面のリストを取得する</para>
        /// </remarks>
        HySDataLinkedList GetModelGeneratorScreenList();
        /// <summary><para>method outline:</para>
        /// <para>内部情報クリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clear() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void Clear();
        //
    }
}
