﻿// <summary>ソースコード：モデルプデータジェネレーターが必要とする情報の保持クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.Interface.Data
{
       
    /// <summary>
    /// <para>class outline:</para>
    /// <para>モデルジェネレーターが必要とする情報を格納するクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>モデルの情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/17][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McMdlGenNeedData : HySDataRoot, HySVersionManagement
    {
        /// <summary>含まれるファクトリＩＤ </summary>
        protected HySID m_csLibraryID;   // 含まれるファクトリＩＤ
        /// <summary> データ種別</summary>
        protected HySObjectKind m_csModelKind;  // データ種別
        /// <summary> 表示する時の名称</summary>
        protected HySString m_csModelName;   // 表示する時の名称
               
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected McMdlGenNeedData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        //必須情報はコンストラクタ内に入れる
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelInfo csMdlInf = new McModelInfo(csLibraryID,  csModelKind, csModelName, csCalInfoKind) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別</param>
        /// <param name="csModelName">モデル名称</param>
        /// <returns>エレメントクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プロトタイプと互換性を取る為　使用を奨励しない</para>
        /// </remarks>
        public McMdlGenNeedData(HySID csLibraryID, HySObjectKind csModelKind, HySString csModelName)
        {
            m_csLibraryID = csLibraryID;
            m_csModelKind = csModelKind;
            m_csModelName = csModelName;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリＩＤ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID m_csLibraryID = GetLibraryID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string ファクトリＩＤ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているファクトリＩＤ情報を返す</para>
        /// </remarks>
        public HySID GetLibraryID()
        {
            return m_csLibraryID;
        }
        /// <summary><para>method outline:</para>
        /// <para>データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind m_csModelKind = GetModelKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string データ種別情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているデータ種別情報を返す</para>
        /// </remarks>
        public HySObjectKind GetModelKind()
        {
            return m_csModelKind;
        }
        /// <summary><para>method outline:</para>
        /// <para>表示する時の名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString m_csModelName = GetModelName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 表示する時の名称情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されている表示する時の名称情報を返す</para>
        /// </remarks>
        public HySString GetModelName()
        {
            return m_csModelName;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
