// <summary>ソースコード：モデルデータジェネレーター作成条件等格納インターフェース</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>モデルデータジェネレーター作成条件等格納のインターフェース</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    //[Serializable]
    public interface McModelDataGenerationInfoIF : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>プロジェクト名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetProjectname(csName) </para>
        /// </example>
        /// <param name="csName">プロジェクト名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本設定が　構造定義ファイル名を決定する</para>
        /// </remarks>
        void SetProjectName(HySString csName);
        /// <summary><para>method outline:</para>
        /// <para>プロジェクト名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetProjectname(sName) </para>
        /// </example>
        /// <param name="sName">プロジェクト名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本設定が　構造定義ファイル名を決定する</para>
        /// </remarks>
        void SetProjectname(string sName);
        /// <summary><para>method outline:</para>
        /// <para>プロジェクト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetProjectName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString プロジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>戻り値に従って構造定義ファイル名を決定する</para>
        /// </remarks>
        HySString GetProjectName();

        /// <summary><para>method outline:</para>
        /// <para>モデル接続生成ライブラリ識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLibraryID(csLibraryID) </para>
        /// </example>
        /// <param name="csLibraryID">モデル接続生成ライブラリ識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetLibraryID(HySID csLibraryID);
        /// <summary><para>method outline:</para>
        /// <para>モデル接続生成ライブラリ識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csLibraryID = LibraryID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID モデル接続生成ライブラリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySID GetLibraryID();

        /// <summary><para>method outline:</para>
        /// <para>モデル接続生成クラス種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetGeneratorKind(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル接続生成クラス種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetGeneratorKind(HySObjectKind csModelKind);
        /// <summary><para>method outline:</para>
        /// <para>モデル接続生成クラス種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csModelKind = GetGeneratorKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind モデル接続生成クラス種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySObjectKind GetGeneratorKind();
    }
}
