﻿// <summary>ソースコード：ＨＹＭＣＯ要素間構造エラー情報格納クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCO要素間構造エラー情報格納クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    [Serializable]
    public abstract class McStructErrorInfo : HySDataRoot  // , HySVersionManagement <-- メンバー変数なしのため不要
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>エラー情報追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddSimuErrorData(csID, csModelKind, sMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="csModelKind">要素種別</param>
        /// <param name="sMessage">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public void AddSimuErrorData(HySIdentifier csID, HySKind csModelKind, string sMessage);
               
        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックエラーデータ追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddCheckData(csID, csModelKind, eMessageLevel, csMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="csModelKind">要素種別</param>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public void AddCheckErrorData(HySIdentifier csID, HySKind csModelKind,  string csMessage);
        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェックワーニングデータ追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddCheckData(csID, csModelKind, eMessageLevel, csMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="csModelKind">要素種別</param>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public void AddCheckWarningData(HySIdentifier csID, HySKind csModelKind, string csMessage);
        /// <summary>
        /// <para>method outline:</para>
        /// <para>チェック一般情報データ追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddCheckInformationData(csID, csModelKind, eMessageLevel, csMessage)</para>
        /// </example>
        /// <param name="csID">要素ID</param>
        /// <param name="csModelKind">要素種別</param>
        /// <param name="csMessage">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public void AddCheckInformationData(HySIdentifier csID, HySKind csModelKind, string csMessage);
        ///// <summary><para>method outline:</para>
        ///// <para>復元後の整合性確保処理</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> PostDeserialize( ) </para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        ///// バージョンによって変数等追加が発生した場合にオーバーライドして実装する。
        ///// </para>
        ///// </remarks>
        //public abstract void PostDeserialize();
    }
}
