﻿// <summary>ソースコード：>時系列データのレコードとなるデータのＩ／Ｆ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>双方向通信データのＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>
    /// 上流から下流、下流から上流へ流れるデータは全て同じ型である事
    /// 本クラスの派生クラスは全て[Serializable]であること
    /// </para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    ///[Serializable]
    public interface McMutualTranInfo : McTranInfo
    {
        /// <summary><para>method outline:</para>
        /// <para>上流から下流への伝送データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTranInfo(csDownstreamTranInfo,csUpstreamTranInfo) </para>
        /// </example>
        /// <param name="csUpstreamTranInfo">下流→上流伝送データ</param>
        /// <param name="csDownstreamTranInfo">上流→下流伝送データ</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetTranInfo(McTranInfo csDownstreamTranInfo, McTranInfo csUpstreamTranInfo);

        /// <summary><para>method outline:</para>
        /// <para>引数で与えたＩＤの要素が送信するデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> (csDownstreamTranInfo , csUpstreamTranInfo) = GetTranInfo() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns> (csDownstreamTranInfo , csUpstreamTranInfo)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        (McTranInfo,McTranInfo) GetTranInfo();
        //

    }
}
