﻿// <summary>ソースコード：ＨＹＭＣＯ要素間伝送データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

using CommonMP.HYMCO.Interface.Controller;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCO要素間伝送データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    //[Serializable]
    public interface McTranInfo : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>接続線共通情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranCommonCellDataIF csCnnctInf = GetCommonInf( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McTranCommonCellDataIF 接続線共通情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の共通情報を取得する</para>
        /// </remarks>
        McTranCommonCellDataIF GetCommonInf();

        /// <summary><para>method outline:</para>
        /// <para>接続線ＩＤ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetConnectionID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 接続線ＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線のＩＤを取得する</para>
        /// </remarks>
        HySID GetConnectionID();
        /// <summary><para>method outline:</para>
        /// <para>接続線名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetConnectionName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 接続線名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の名称を取得する</para>
        /// </remarks>
        HySString GetConnectionName();

        /// <summary><para>method outline:</para>
        /// <para>上流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csElmID = GetUpperElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        HySID GetUpperElementID();
        /// <summary><para>method outline:</para>
        /// <para>下流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csElmID = GetUpperElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        HySID GetLowerElementID();

        /// <summary><para>method outline:</para>
        /// <para>上流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetUpperElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 上流要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        McElement GetUpperElement();
        /// <summary><para>method outline:</para>
        /// <para>下流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetLowerElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 下流要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        McElement GetLowerElement();

        /// <summary><para>method outline:</para>
        /// <para>同一種別比較比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Equal( csTranInfo ) </para>
        /// </example>
        /// <param name="csTranInfo">比較する伝送データ</param>
        /// <returns>bool true:同一種別 , false:異種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>入力情報が null の場合には　false で返す</para>
        /// </remarks>
        bool SameKind(McTranInfo csTranInfo);

        /// <summary><para>method outline:</para>
        /// <para>最新の時刻を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime dTime = GetLastTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>最新時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySTime GetLastTime();

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfo Clone(); 

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool CopyInfo(McTranInfo csOrgInfo);

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報から、最後に追加された情報を　自分の情報に追加する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = LastDataCopy(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>中継端子処理、別マシンへの伝送情報転送処理等に必要</para>
        /// </remarks>
        bool LastDataCopy(McTranInfo csOrgInfo);

        /// <summary><para>method outline:</para>
        /// <para>中継端子の導通設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataTrans(csOrgTran)</para>
        /// </example>
        /// <param name="csOrgTran">上流側の情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void MakeRelayPortDataTransContinuity(McTranInfo csOrgTran);

        /// <summary><para>method outline:</para>
        /// <para>モデル生成時にプロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetProperty(McPropertyInfoRoot csPropertyInfo);
        /// <summary><para>method outline:</para>
        /// <para>演算実行中断中のプロパティ等情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetOnlineProperty(csPropertyInfo)</para>
        /// </example>
        /// <param name="csPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>演算中断中にプロパティ、初期値等を変更して動作させ場合等に使用する</para>
        /// </remarks>
        void SetOnlineProperty(McPropertyInfoRoot csPropertyInfo);

        /// <summary><para>method outline:</para>
        /// <para>内部蓄積データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Initialize() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void ResetData();

        /// <summary><para>method outline:</para>
        /// <para>伝送データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csKind = GetTranInfoKind( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind 伝送データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySObjectKind GetTranInfoKind();

    }
}
