// <summary>ソースコード：セル型 要素間伝送データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>セル型 要素間伝送データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    public interface McTranInfoIFCellType : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>セルメッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDimension(ref lDim1, ref lDim2, ref lDim3) </para>
        /// </example>
        /// <param name="lDim1">第１分割数</param>
        /// <param name="lDim2">第２分割数</param>
        /// <param name="lDim3">第３分割数</param>
        /// <returns>long 次元数　1次元＝１、２次元＝２、３次元＝３が　返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetDimension(ref long lDim1, ref long lDim2, ref long lDim3);

        /// <summary><para>method outline:</para>
        /// <para>セル内データ配列数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDataDimentionInCell() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long セル内データ配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetDataDimentionInCell();

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataCharacteristic(csCellChara) </para>
        /// </example>
        /// <param name="csCellChara">１セル内の各データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetCellDataCharacteristic(HySDataCharacteristicInCell csCellChara);

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        ///    HySDataCharacteristicInCell csKind = GetCellDataCharacteristic();
        ///    csKind.SetTranDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataCharacteristicInCell １セル内の各データの種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDataCharacteristicInCell GetCellDataCharacteristic();

        /// <summary><para>method outline:</para>
        /// <para>最終セルデータ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellArray csCellArry = GetLastCellArrayData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellArray セル配列データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySCellArray GetLastCellArrayData();

        /// <summary><para>method outline:</para>
        /// <para>セル識別子とセルの配列管理データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellIDMngData(csCellIDMngData); </para>
        /// </example>
        /// <param name="csCellIDMngData">セル識別子とセルの配列管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetCellIDMngData(HySCellIDManageData csCellIDMngData);

        /// <summary><para>method outline:</para>
        /// <para>セル識別子とセルの配列管理データ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellIDManageData csCellIDMng = GetCellIDManager(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellIDManageData セル識別子とセルの配列管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySCellIDManageData GetCellIDMngData();

        /*
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataGetter(csCellGetter); </para>
        /// </example>
        /// <param name="csCellGetter">セル内データ取得クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetCellDataGetter(HySCellDataGetter csCellGetter);
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellDataGetter csCellGetter = GetCellDataGetter(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellDataGetter セル内データ取得クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySCellDataGetter GetCellDataGetter();
        */

        /// <summary><para>method outline:</para>
        /// <para>受信したセル型情報取得クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McReceiveCellDataIF csRevDt = GetReceiveCellData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McReceiveCellDataIF 受信したセル型情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本クラスを通じて受信情報本体をを取得する</para>
        /// </remarks>
        McReceiveCellDataIF GetReceiveCellData();
        /// <summary><para>method outline:</para>
        /// <para>送信するセル型情報設定クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSendCellDataIF csSndDt = GetSendCellData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSendCellDataIF 送信するセル型情報設定クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本クラスを通じて受信情報を設定する</para>
        /// </remarks>
        McSendCellDataIF GetSendCellData();
    }
}
