// <summary>ソースコード：時系列 要素間伝送データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>時系列 要素間伝送データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    public interface McTranInfoIFTimeSeriesType : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>内挿方式設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInterpolateType(eInterpolateType) </para>
        /// </example>
        /// <param name="eInterpolateType">内挿方式</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetInterpolateType(HySDefine.InterpolateType eInterpolateType);
        /// <summary><para>method outline:</para>
        /// <para>内挿方式取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDefine.InterpolateType eInterpolateType = GetInterpolateType() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDefine.InterpolateType  内挿方式</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDefine.InterpolateType GetInterpolateType();

        /// <summary><para>method outline:</para>
        /// <para>最後のデータの時間比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = Before(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用時刻</param>
        /// <returns>
        /// bool  最後に追加した時刻が 引数：csTime の時刻より前の場合は true、そうでない場合（同一時刻含む）は false
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool Before(HySTime csTime);
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも後か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = After(csTime) </para>
        /// </example>
        /// <param name="csTime">
        /// 比較用日付管理クラスオブジェクト(HySTime)
        /// </param>
        /// <returns>bool  =HySTime の現在時刻が 引数：Date の時刻よりあとの場合は true、そうでない場合は false </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool After(HySTime csTime);
        /// <summary><para>method outline:</para>
        /// <para>最後のデータの時間比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = EqualTime(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用時刻</param>
        /// <returns>
        /// bool  最後に追加した時刻が 引数：csTime と同じならばは true、そうでない場合は false
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool EqualTime(HySTime csTime);
        /// <summary><para>method outline:</para>
        /// <para>最新のデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeRecordIF csDt = GetLastData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> 最新データ </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySTimeRecordIF GetLastData();

        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeRecordIF csNewRecord = CreateNewRecord( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>GetNewRecord 新レコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列として保持すべき情報を新規に生成する</para>
        /// </remarks>
        HySTimeRecordIF CreateNewRecord();
           
        /// <summary><para>method outline:</para>
        /// <para>情報を追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddData(csAddRecord) </para>
        /// </example>
        /// <param name="csAddRecord">追加データ</param>
        /// <returns> 無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>引数で与えた時刻と同一又は未来のレコードがあればそれらを削除して最後に追加する</para>
        /// </remarks>
        void AddData(HySTimeRecordIF csAddRecord);
    }
}
