﻿// <summary>ソースコード：セル識別子とセルの配列管理データ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using  CommonMP.HYMCO.Interface;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>セル識別子とセルの配列管理データ</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/23][新規作成]</para>
    /// </remarks>
    public interface McCellIDMngIF : McRoot , HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>セルと識別子の対応管理情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csFile) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter);
        /// <summary><para>method outline:</para>
        /// <para>XMLからセルと識別子の対応管理情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csFile) </para>
        /// </example>
        /// <param name="csXml">入力XML</param>
        /// <returns>bool　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool XmlIN(HySXmlNode csXml);

        /// <summary><para>method outline:</para>
        /// <para>読み書き用XMLファイル名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetXmlFileName(csFileNameWithPath) </para>
        /// </example>
        /// <param name="csFileNameWithPath">XMLファイル名（パス付き）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetXmlFileName(HySString csFileNameWithPath);
        /// <summary><para>method outline:</para>
        /// <para>読み書き用XMLファイル名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>  HySString csFileName = GetXmlFileName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>XMLファイル名（パス付き）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySString GetXmlFileName( );
        /// <summary><para>method outline:</para>
        /// <para>読み書き用XMLファイル用基準パス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetXmlFileBasePath(csBasePath) </para>
        /// </example>
        /// <param name="csBasePath">基準パス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetXmlFileBasePath(HySString csBasePath);
        /// <summary><para>method outline:</para>
        /// <para>読み書き用XMLファイル用基準パス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csBasePath = GetXmlFileBasePath() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>XMLファイル用基準パス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySString GetXmlFileBasePath( );
        /// <summary><para>method outline:</para>
        /// <para>指定したファイルにセルと識別子の対応管理情報を書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = XmlFileWrite();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool XmlFileWrite();
        /// <summary><para>method outline:</para>
        /// <para>指定したファイルからセルと識別子の対応管理情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = XmlFileRead();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool XmlFileRead();
        /// <summary><para>method outline:</para>
        /// <para>クラス名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetXmlFileName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>クラスファイル名（ネームスペース無し）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySString GetClassName();
              
        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCellIDMngIF csNewObj = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McCellIDMngIF 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McCellIDMngIF Clone();
    }
}
