// <summary>ソースコード：受信したセル型情報を管理するクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>受信したセル型情報を取得するクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>接続線毎に管理する</para>
    /// </remarks>
    public interface McReceiveCellDataIF : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetID(HySID csID);
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySID GetID();

        //==========================================
        //  セルから情報を取り出す処理を行う場合
        //==========================================
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double Data(csCell, lDataIdx); </para>
        /// </example>
        /// <param name="csCell">対象セル</param>
        /// <param name="lDataIdx">データインデックス</param>
        /// <returns> double データ値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// シミュレーション演算中に使用する
        /// 速度アップの為内部でのデータ整合性チェック等は行っていない。
        /// 使用者側の責任において使用すること。
        /// </para>
        /// </remarks>
        double Data(HySCellData csCell, long lDataIdx);

        //==========================================
        //  時系列情報の場合の処理用メソッド
        //==========================================
        /// <summary><para>method outline:</para>
        /// <para>内挿時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCurrentTime(csTime) </para>
        /// </example>
        /// <param name="csTime">内挿すべき時刻</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>設定した時刻に内挿する</para>
        /// </remarks>
        void SetCurrentTime(HySTime csTime);
        /// <summary><para>method outline:</para>
        /// <para>最終時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLastTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>保持しているデータの最終の時刻に設定する</para>
        /// </remarks>
        void SetLastTime( ); 
        
        //==========================================
        //  個別セルについて内挿処理を行う場合
        //==========================================

        /// <summary><para>method outline:</para>
        /// <para>セル配列の次元</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetCellDimention() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> long セル配列の次元（１、２，３次元）　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetCellDimention();

        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetInterpolatedCell(lIdx1) </para>
        /// </example>
        /// <param name="lCellIdx1">第１配列のセル位置</param>
        /// <returns> HySCellData 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// 時系列以外の時には　内挿処理は行わない
        /// </para>
        /// </remarks>
        HySCellData GetInterpolatedCell(long lCellIdx1);
        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetInterpolatedCell(lIdx1,lIdx2) </para>
        /// </example>
        /// <param name="lCellIdx1">第１配列のセル位置</param>
        /// <param name="lCellIdx2">第２配列のセル位置</param>
        /// <returns> HySCellData 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// 時系列以外の時には　内挿処理は行わない
        /// </para>
        /// </remarks>
        HySCellData GetInterpolatedCell(long lCellIdx1, long lCellIdx2);
        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetInterpolatedCell(lIdx1,lIdx2,lIdx3) </para>
        /// </example>
        /// <param name="lCellIdx1">第１配列のセル位置</param>
        /// <param name="lCellIdx2">第２配列のセル位置</param>
        /// <param name="lCellIdx3">第３配列のセル位置</param>
        /// <returns> HySCellData 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// 時系列以外の時には　内挿処理は行わない
        /// </para>
        /// </remarks>
        HySCellData GetInterpolatedCell(long lCellIdx1, long lCellIdx2, long lCellIdx3);

        /// <summary><para>method outline:</para>
        /// <para>ＩＤで指定したセルの内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellData csCell = GetInterpolatedCell(lCellID) </para>
        /// </example>
        /// <param name="lCellID">セルＩＤ</param>
        /// <returns> HySCellData 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内部で検索処理が走る為処理速度が遅くなる
        /// 速度重視の際は使用を奨励しない
        /// 時系列以外の時には　内挿処理は行わない
        /// </para>
        /// </remarks>
        HySCellData GetInterpolatedCell(HySID lCellID);

        //==========================================
        //  セルの配列全体について内挿処理を行う場合
        //==========================================

        /// <summary><para>method outline:</para>
        /// <para>一括内挿結果取得（１次元セル）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetInterpolatedCellD1() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData[] 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// 時系列以外の時には　内挿処理は行わない
        /// </para>
        /// </remarks>
        HySCellData[] GetInterpolatedCellD1();
        /// <summary><para>method outline:</para>
        /// <para>一括内挿結果取得（２次元セル）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetInterpolatedCellD2() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData[,] 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD2CellArrayData,HySGeoDim2MeshSerialDataの時に使用
        /// 時系列以外の時には　内挿処理は行わない
        /// </para>
        /// </remarks>
        HySCellData[,] GetInterpolatedCellD2();
        /// <summary><para>method outline:</para>
        /// <para>一括内挿結果取得（３次元セル）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetInterpolatedCellD3() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData[,,] 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD3CellArrayData,HySGeoDim3MeshSerialDataの時に使用
        /// 時系列以外の時には　内挿処理は行わない
        /// </para>
        /// </remarks>
        HySCellData[, ,] GetInterpolatedCellD3();
        //★★★★★★★★★★★★★★★★
        // Ver1.4で追加(一時ファイル作成)
        //★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>一時ファイル取得（2次元）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetFileOutCellD2(csTime) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <returns> HySCellData[,] 一時ファイル出力した2次元セル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySCellData[,] GetFileOutCellD2(HySTime csTime);

        //==========================================
        //  各種部品設定
        //==========================================

        /// <summary><para>method outline:</para>
        /// <para>伝送データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTranInfo(csTranInfo) </para>
        /// </example>
        /// <param name="csTranInfo">伝送データ</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetTranInfo(McTranInfo csTranInfo);
        /// <summary><para>method outline:</para>
        /// <para>伝送データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csTranInfo = GetTranInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>csTranInfo 伝送データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfo GetTranInfo();
        /// <summary><para>method outline:</para>
        /// <para>内挿方式設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInterpolateType(eInterpolateType) </para>
        /// </example>
        /// <param name="eInterpolateType">内挿方式</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetInterpolateType(HySDefine.InterpolateType eInterpolateType);
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得ツール設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataGetter(csCellDataGetter) </para>
        /// </example>
        /// <param name="csCellDataGetter">セル内データ取得ツール</param>
        /// <returns> 無し　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetCellDataGetter(HySCellDataGetter csCellDataGetter);
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellDataGetter csCellGetter = GetCellDataGetter(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellDataGetter セル内データ取得クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySCellDataGetter GetCellDataGetter();

        /// <summary><para>method outline:</para>
        /// <para>最終設定時刻取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = GetTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>保持している情報の最新時刻を取得する</para>
        /// </remarks>
        HySTime GetLastTime();

        /*
        /// <summary><para>method outline:</para>
        /// <para>内挿方式設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInterpolateType(eInterpolateType) </para>
        /// </example>
        /// <param name="eInterpolateType">内挿方式</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetInterpolateType(HySDefine.InterpolateType eInterpolateType);
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataGetter(csCellGetter); </para>
        /// </example>
        /// <param name="csCellGetter">セル内データ取得クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetCellDataGetter(HySCellDataGetter csCellGetter);
        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellDataGetter csCellGetter = GetCellDataGetter(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellDataGetter セル内データ取得クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySCellDataGetter GetCellDataGetter();
        */

        //==========================================
        //  各種情報取得
        //==========================================
        /// <summary><para>method outline:</para>
        /// <para>セルメッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDimension(ref lDim1, ref lDim2, ref lDim3) </para>
        /// </example>
        /// <param name="lDim1">第１分割数</param>
        /// <param name="lDim2">第２分割数</param>
        /// <param name="lDim3">第３分割数</param>
        /// <param name="lDataDimInCell">セル内変数の数</param>
        /// <returns>long 次元数　1次元＝１、２次元＝２、３次元＝３が　返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetDimension(ref long lDim1, ref long lDim2, ref long lDim3, ref long lDataDimInCell);

        /// <summary><para>method outline:</para>
        /// <para>伝送データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csKind = GetTranInfoKind( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind 伝送データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySObjectKind GetTranInfoKind();

        /// <summary><para>method outline:</para>
        /// <para>セル識別子とセルの配列管理データ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellIDManageData csCellIDMng = GetCellIDManager(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellIDManageData セル識別子とセルの配列管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySCellIDManageData GetCellIDData();
        /// <summary><para>method outline:</para>
        /// <para>受信伝送情報パターンプロパティ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetReceiveTranInfoPattern(csPattern) </para>
        /// </example>
        /// <param name="csPattern">受信伝送情報パターンプロパティ</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetReceiveTranInfoPattern(McTranInfoPatternPropertyIF csPattern);
        /// <summary><para>method outline:</para>
        /// <para>受信伝送情報パターンプロパティ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfoPatternPropertyIF csPattern = GetReceiveTranInfoPattern( ) </para>
        /// </example>
        /// <param name=""></param> 
        /// <returns>McTranInfoPatternPropertyIF 受信伝送情報パターンプロパティ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfoPatternPropertyIF GetReceiveTranInfoPattern();
        /// <summary><para>method outline:</para>
        /// <para>受信パターン識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetReceivePatternID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>受信パターン識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySID GetReceivePatternID();

        /// <summary><para>method outline:</para>
        /// <para>接続線名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetConnectionName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 接続線名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の名称を取得する</para>
        /// </remarks>
        HySString GetConnectionName();
        /// <summary><para>method outline:</para>
        /// <para>上流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csElmID = GetUpperElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        HySID GetUpperElementID();
        /// <summary><para>method outline:</para>
        /// <para>上位要素の送信パターン識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetUpperElmSendPatternID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 上位要素の送信パターン識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySID GetUpperElmSendPatternID();

        //==========================================
        //  ＧＩＳ関連：各種情報取得
        //==========================================
        // 将来拡張用
        ///// <summary><para>method outline:</para>
        ///// <para>距離配列の取得</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>double[] dDistance = GetCellDistance()</para> 
        ///// <para>例：1番目のセル始点から、1番目のセル終点までの距離情報設定　dDistance[0] = x;</para>
        ///// <para>例：1番目のセル始点から、2番目のセル終点までの距離情報設定　dDistance[1] = x;</para>
        ///// <para>例：1番目のセル始点から、1番目のセル終点までの距離情報取得　y = dDistance[0];</para>
        ///// <para>例：1番目のセル始点から、2番目のセル終点までの距離情報取得　y = dDistance[1];</para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>double[] 最初のセル始点からの距離配列</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //double[] GetCellDistance();
        ///// <summary><para>method outline:</para>
        ///// <para>セル始点・終点緯度情報配列の取得</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>double[] dCellLat = GetCellLatitude()</para> 
        ///// <para>例：1番目のセル始点の緯度情報設定　dCellLat[0] = x;</para>
        ///// <para>例：1番目のセル終点の緯度情報設定　dCellLat[1] = x;</para>
        ///// <para>dCellLat[1]は同時に2番目のセル始点となる</para>
        ///// <para>例：1番目のセル始点の緯度情報取得　y = dCellLat[0];</para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>double[] セルの始点／終点の緯度情報配列</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //double[] GetCellLatitude();
        ///// <summary><para>method outline:</para>
        ///// <para>セル始点・終点経度情報配列の取得</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>double[] dCellLon = GetCellLongitude()</para> 
        ///// <para>例：1番目のセル始点の経度情報設定　dCellLon[0] = x;</para>
        ///// <para>例：1番目のセル終点の経度情報設定　dCellLon[1] = x;</para>
        ///// <para>dCellLon[1]は同時に2番目のセル始点となる</para>
        ///// <para>例：1番目のセル始点の経度情報取得　y = dCellLon[0];</para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>double[] セルの始点／終点の経度情報配列</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //double[] GetCellLongitude();
        ///// <summary><para>method outline:</para>
        ///// <para>代表点の緯度情報配列の取得</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>double[] dSpecificLat = GetSpecificLatitude()</para> 
        ///// <para>例：1番目のセルデータの緯度情報設定　dSpecificLat[0] = x;</para>
        ///// <para>例：1番目のセルデータの緯度情報取得　y = dSpecificLat[0];</para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>double[] 代表点の緯度情報配列</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //double[] GetSpecificLatitude();
        ///// <summary><para>method outline:</para>
        ///// <para>代表点の経度情報配列の取得</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>double[] dSpecificLon = GetSpecificLongitude()</para> 
        ///// <para>例：1番目のセルデータの経度情報設定　dSpecificLon[0] = x;</para>
        ///// <para>例：1番目のセルデータの経度情報取得　y = dSpecificLon[0];</para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>double[] 代表点の経度情報配列</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //double[] GetSpecificLongitude();
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳメッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDimension(ref lKind, ref lDim1, ref lDim2, ref lDim3, ref lDataDimInCell) </para>
        /// </example>
        /// <param name="lKind">保持するデータの形</param>
        /// <param name="lLonDim">経度方向のメッシュ分割数</param>
        /// <param name="lLatDim">緯度方向のメッシュ分割数</param>
        /// <param name="lAltDim">高度方向のメッシュ分割数</param>
        /// <param name="lCellDataDim">１メッシュ内のデータ配列数</param>
        /// <returns>
        /// long 次元数　1次元＝１、２次元＝２、３次元＝３が　返る。
        /// 　　　　　　　ＧＩＳ情報でない時には０が　返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetGISMeshDimension(ref HySGeoMesh.MESH_DATA_KIND lKind, ref long lLonDim, ref long lLatDim, ref long lAltDim, ref long lCellDataDim);


        /// <summary><para>method outline:</para>
        /// <para>地理的位置取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetLocation(ref dSWLat,ref dSWLon,ref dNELat,ref dNELon) </para>
        /// </example>
        /// <param name="dSWLat">南西頂点緯度（度単位）</param>
        /// <param name="dSWLon">南西頂点経度（度単位）</param>
        /// <param name="dNELat">北東頂点緯度（度単位）</param>
        /// <param name="dNELon">北東頂点経度（度単位）</param> 
        /// <returns>bool =true 引数値は有効、 = false 引数値は無効（伝送データはＧＩＳ系データではない）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool GetLocation(ref double dSWLat, ref double dSWLon, ref double dNELat, ref double dNELon);
        /// <summary><para>method outline:</para>
        /// <para>高度位置取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HGetAltitude(ref dUpAlt, ref dLwAlt) </para>
        /// </example>
        /// <param name="dUpAlt">上限高度（ｍ単位）</param>
        /// <param name="dLwAlt">下限高度（ｍ単位）</param>
        /// <returns>bool =true 引数値は有効、 = false 引数値は無効（伝送データはＧＩＳ系データではない）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool GetAltitude(ref double dUpAlt, ref double dLwAlt);

        /*
        /// <summary><para>method outline:</para>
        /// <para>内挿処理前直前受信値取得（１次元セル）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetReceivedCellD1() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData[] 内挿前の受信情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// </para>
        /// </remarks>
        HySCellData[] GetReceivedCellD1();
        /// <summary><para>method outline:</para>
        /// <para>内挿処理前直前受信値取得（２次元セル）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetReceivedCellD2() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData[,] 内挿前の受信情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD2CellArrayData,HySGeoDim2MeshSerialDataの時に使用
        /// </para>
        /// </remarks>
        HySCellData[,] GetReceivedCellD2();
        /// <summary><para>method outline:</para>
        /// <para>内挿処理前直前受信値取得（３次元セル）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetReceivedCellD3() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData[,,] 内挿前の受信情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD3CellArrayData,HySGeoDim3MeshSerialDataの時に使用
        /// </para>
        /// </remarks>
        HySCellData[, ,] GetReceivedCellD3();
        */


        // ========================================
        // その他
        // ========================================


        /*
        /// <summary><para>method outline:</para>
        /// <para>セルと識別子の対応管理情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csFile) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter);
        /// <summary><para>method outline:</para>
        /// <para>XMLからセルと識別子の対応管理情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csFile) </para>
        /// </example>
        /// <param name="csXml">入力XML</param>
        /// <returns>bool　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool XmlIN(HySXmlNode csXml);
        */
    }
}
